/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.KeymapFlagLifetimeKind;
import com.intellij.openapi.keymap.impl.KeymapFlagsStorageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="KeymapFlagsStorage", storages={@Storage(value="keymapFlags.xml", roamingType=RoamingType.DISABLED)}, category=SettingsCategory.KEYMAP, exportable=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003 !\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nJ&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ%\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0012*\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0012*\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u001f\u001a\u00020\fH\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapFlagsStorage;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/openapi/keymap/impl/KeymapFlagsStorage$State;", "<init>", "()V", "addFlag", "", "keymap", "Lcom/intellij/openapi/keymap/Keymap;", "actionId", "", "shortcut", "Lcom/intellij/openapi/actionSystem/Shortcut;", "flag", "lifetime", "Lcom/intellij/openapi/keymap/impl/KeymapFlagLifetimeKind;", "getFlags", "", "", "hasFlag", "", "removeOutdatedFlags", "fromSettings", "removeOutdatedFlags$intellij_platform_ide_impl", "removeFlagsForKeymap", "removeFlagsForKeymap$intellij_platform_ide_impl", "forKeymap", "", "Lcom/intellij/openapi/keymap/impl/KeymapFlagsStorage$FlagDescriptor;", "forAction", "forShortcut", "sc", "Companion", "FlagDescriptor", "State", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKeymapFlagsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeymapFlagsStorage.kt\ncom/intellij/openapi/keymap/impl/KeymapFlagsStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,116:1\n1563#2:117\n1634#2,3:118\n1563#2:121\n1634#2,3:122\n1563#2:125\n1634#2,3:126\n774#2:140\n865#2,2:141\n774#2:143\n865#2,2:144\n11561#3:129\n11896#3,3:130\n382#4,7:133\n*S KotlinDebug\n*F\n+ 1 KeymapFlagsStorage.kt\ncom/intellij/openapi/keymap/impl/KeymapFlagsStorage\n*L\n61#1:117\n61#1:118,3\n63#1:121\n63#1:122,3\n66#1:125\n66#1:126,3\n105#1:140\n105#1:141,2\n108#1:143\n108#1:144,2\n78#1:129\n78#1:130,3\n101#1:133,7\n*E\n"})
public final class KeymapFlagsStorage
extends SimplePersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String FLAG_MIGRATED_SHORTCUT = "MIGRATED_SHORTCUT";

    public KeymapFlagsStorage() {
        super((BaseState)new State());
    }

    public final void addFlag(@NotNull Keymap keymap2, @NotNull String actionId, @NotNull Shortcut shortcut, @NotNull String flag, @NotNull KeymapFlagLifetimeKind lifetime) {
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        Intrinsics.checkNotNullParameter((Object)((Object)lifetime), (String)"lifetime");
        this.forKeymap(keymap2).add(new FlagDescriptor(actionId, shortcut.toString(), flag, lifetime));
        KeymapFlagsStorageKt.access$getLOG$p().info("Added flag " + flag + " for keymap=" + keymap2.getName() + ";actionId=" + actionId + ";shortcut=" + shortcut + ";lifetime=" + lifetime);
        ((State)this.getState()).intIncrementModificationCount();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getFlags(@NotNull Keymap keymap2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        Iterable $this$map$iv = this.forKeymap(keymap2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FlagDescriptor flagDescriptor = (FlagDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFlag());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getFlags(@NotNull Keymap keymap2, @NotNull String actionId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Iterable $this$map$iv = this.forAction(this.forKeymap(keymap2), actionId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FlagDescriptor flagDescriptor = (FlagDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFlag());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getFlags(@NotNull Keymap keymap2, @NotNull String actionId, @NotNull Shortcut shortcut) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        Iterable $this$map$iv = this.forShortcut(this.forAction(this.forKeymap(keymap2), actionId), shortcut);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FlagDescriptor flagDescriptor = (FlagDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFlag());
        }
        return (List)destination$iv$iv;
    }

    public final boolean hasFlag(@NotNull Keymap keymap2, @NotNull String actionId, @NotNull String flag) {
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getFlags(keymap2, actionId).contains(flag);
    }

    public final boolean hasFlag(@NotNull Keymap keymap2, @NotNull String actionId, @NotNull Shortcut shortcut, @NotNull String flag) {
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        return this.getFlags(keymap2, actionId, shortcut).contains(flag);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeOutdatedFlags$intellij_platform_ide_impl(@NotNull Keymap keymap2, @NotNull String actionId, boolean fromSettings) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        if (_Assertions.ENABLED && !fromSettings) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Shortcut[] shortcutArray = keymap2.getShortcuts(actionId);
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        Object[] $this$map$iv = shortcutArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Shortcut shortcut = (Shortcut)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        List currentShortcuts = (List)destination$iv$iv;
        boolean result2 = this.forKeymap(keymap2).removeIf(arg_0 -> KeymapFlagsStorage.removeOutdatedFlags$lambda$2(arg_0 -> KeymapFlagsStorage.removeOutdatedFlags$lambda$1(actionId, currentShortcuts, arg_0), arg_0));
        if (result2) {
            KeymapFlagsStorageKt.access$getLOG$p().info("Several flags were deleted as a part of cleanup keymap=" + keymap2.getName() + ";actionId=" + actionId);
            ((State)this.getState()).intIncrementModificationCount();
        }
    }

    public final void removeFlagsForKeymap$intellij_platform_ide_impl(@NotNull Keymap keymap2) {
        Intrinsics.checkNotNullParameter((Object)keymap2, (String)"keymap");
        if (((State)this.getState()).getKeymapToDescriptor().remove(keymap2.getName()) != null) {
            KeymapFlagsStorageKt.access$getLOG$p().info("Flags were deleted for keymap=" + keymap2.getName());
            ((State)this.getState()).intIncrementModificationCount();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FlagDescriptor> forKeymap(Keymap keymap2) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, List<FlagDescriptor>> map2 = ((State)this.getState()).getKeymapToDescriptor();
        String key$iv = keymap2.getName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FlagDescriptor> forAction(List<FlagDescriptor> $this$forAction, String actionId) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$forAction;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FlagDescriptor it = (FlagDescriptor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getAction(), (Object)actionId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FlagDescriptor> forShortcut(List<FlagDescriptor> $this$forShortcut, Shortcut sc) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$forShortcut;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FlagDescriptor it = (FlagDescriptor)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getShortcut(), (Object)sc.toString())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final boolean removeOutdatedFlags$lambda$1(String $actionId, List $currentShortcuts, FlagDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getAction(), (Object)$actionId) && it.getLifetime() == KeymapFlagLifetimeKind.UNTIL_SHORTCUT_DELETED && !CollectionsKt.contains((Iterable)$currentShortcuts, (Object)it.getShortcut()) || it.getLifetime() == KeymapFlagLifetimeKind.UNTIL_ACTION_SHORTCUT_UPDATED;
    }

    private static final boolean removeOutdatedFlags$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapFlagsStorage$Companion;", "", "<init>", "()V", "FLAG_MIGRATED_SHORTCUT", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J9\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapFlagsStorage$FlagDescriptor;", "", "action", "", "shortcut", "flag", "lifetime", "Lcom/intellij/openapi/keymap/impl/KeymapFlagLifetimeKind;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/keymap/impl/KeymapFlagLifetimeKind;)V", "getAction", "()Ljava/lang/String;", "setAction", "(Ljava/lang/String;)V", "getShortcut", "setShortcut", "getFlag", "setFlag", "getLifetime", "()Lcom/intellij/openapi/keymap/impl/KeymapFlagLifetimeKind;", "setLifetime", "(Lcom/intellij/openapi/keymap/impl/KeymapFlagLifetimeKind;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    public static final class FlagDescriptor {
        @Nullable
        private String action;
        @Nullable
        private String shortcut;
        @Nullable
        private String flag;
        @Nullable
        private KeymapFlagLifetimeKind lifetime;

        public FlagDescriptor(@Nullable String action2, @Nullable String shortcut, @Nullable String flag, @Nullable KeymapFlagLifetimeKind lifetime) {
            this.action = action2;
            this.shortcut = shortcut;
            this.flag = flag;
            this.lifetime = lifetime;
        }

        @Nullable
        public final String getAction() {
            return this.action;
        }

        public final void setAction(@Nullable String string) {
            this.action = string;
        }

        @Nullable
        public final String getShortcut() {
            return this.shortcut;
        }

        public final void setShortcut(@Nullable String string) {
            this.shortcut = string;
        }

        @Nullable
        public final String getFlag() {
            return this.flag;
        }

        public final void setFlag(@Nullable String string) {
            this.flag = string;
        }

        @Nullable
        public final KeymapFlagLifetimeKind getLifetime() {
            return this.lifetime;
        }

        public final void setLifetime(@Nullable KeymapFlagLifetimeKind keymapFlagLifetimeKind) {
            this.lifetime = keymapFlagLifetimeKind;
        }

        @Nullable
        public final String component1() {
            return this.action;
        }

        @Nullable
        public final String component2() {
            return this.shortcut;
        }

        @Nullable
        public final String component3() {
            return this.flag;
        }

        @Nullable
        public final KeymapFlagLifetimeKind component4() {
            return this.lifetime;
        }

        @NotNull
        public final FlagDescriptor copy(@Nullable String action2, @Nullable String shortcut, @Nullable String flag, @Nullable KeymapFlagLifetimeKind lifetime) {
            return new FlagDescriptor(action2, shortcut, flag, lifetime);
        }

        public static /* synthetic */ FlagDescriptor copy$default(FlagDescriptor flagDescriptor, String string, String string2, String string3, KeymapFlagLifetimeKind keymapFlagLifetimeKind, int n, Object object) {
            if ((n & 1) != 0) {
                string = flagDescriptor.action;
            }
            if ((n & 2) != 0) {
                string2 = flagDescriptor.shortcut;
            }
            if ((n & 4) != 0) {
                string3 = flagDescriptor.flag;
            }
            if ((n & 8) != 0) {
                keymapFlagLifetimeKind = flagDescriptor.lifetime;
            }
            return flagDescriptor.copy(string, string2, string3, keymapFlagLifetimeKind);
        }

        @NotNull
        public String toString() {
            return "FlagDescriptor(action=" + this.action + ", shortcut=" + this.shortcut + ", flag=" + this.flag + ", lifetime=" + this.lifetime + ")";
        }

        public int hashCode() {
            int result2 = this.action == null ? 0 : this.action.hashCode();
            result2 = result2 * 31 + (this.shortcut == null ? 0 : this.shortcut.hashCode());
            result2 = result2 * 31 + (this.flag == null ? 0 : this.flag.hashCode());
            result2 = result2 * 31 + (this.lifetime == null ? 0 : this.lifetime.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlagDescriptor)) {
                return false;
            }
            FlagDescriptor flagDescriptor = (FlagDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.action, (Object)flagDescriptor.action)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shortcut, (Object)flagDescriptor.shortcut)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.flag, (Object)flagDescriptor.flag)) {
                return false;
            }
            return this.lifetime == flagDescriptor.lifetime;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003RO\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00058F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/keymap/impl/KeymapFlagsStorage$State;", "Lcom/intellij/openapi/components/BaseState;", "<init>", "()V", "<set-?>", "", "", "", "Lcom/intellij/openapi/keymap/impl/KeymapFlagsStorage$FlagDescriptor;", "keymapToDescriptor", "getKeymapToDescriptor", "()Ljava/util/Map;", "setKeymapToDescriptor", "(Ljava/util/Map;)V", "keymapToDescriptor$delegate", "Lkotlin/properties/ReadWriteProperty;", "intellij.platform.ide.impl"})
    public static final class State
    extends BaseState {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty keymapToDescriptor$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

        @NotNull
        public final Map<String, List<FlagDescriptor>> getKeymapToDescriptor() {
            return (Map)this.keymapToDescriptor$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setKeymapToDescriptor(@NotNull Map<String, List<FlagDescriptor>> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.keymapToDescriptor$delegate.setValue((Object)this, $$delegatedProperties[0], map2);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(State.class, "keymapToDescriptor", "getKeymapToDescriptor()Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

