/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.ProgressManagerListener;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CheckCanceledEvent;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOCancellationCallback;
import com.intellij.util.io.IOCancellationCallbackHolder;
import com.intellij.util.progress.JfrCancellationEventCallback;
import com.intellij.util.progress.JfrCancellationEventsCallbackHolder;
import com.intellij.util.ui.EDT;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import javax.swing.JFrame;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ProgressManagerImpl
extends CoreProgressManager
implements Disposable {
    private static final Key<Boolean> SAFE_PROGRESS_INDICATOR = Key.create((String)"SAFE_PROGRESS_INDICATOR");
    private final List<CoreProgressManager.CheckCanceledHook> myHooks = ContainerUtil.createEmptyCOWList();
    private volatile boolean myRunSleepHook;
    private static final Logger LOG = Logger.getInstance(ProgressManagerImpl.class);
    private static final ThrottledLogger THROTTLED_LOGGER = new ThrottledLogger(LOG, 100L);

    public ProgressManagerImpl() {
        ExtensionPointImpl.Companion.setCheckCanceledAction(ProgressManager::checkCanceled);
        IOCancellationCallbackHolder.INSTANCE.setIoCancellationCallback((IOCancellationCallback)new IdeIOCancellationCallback());
        JfrCancellationEventsCallbackHolder.INSTANCE.setCallback((JfrCancellationEventCallback)new IdeJfrCancellationCallback());
    }

    public boolean hasUnsafeProgressIndicator() {
        if (super.hasUnsafeProgressIndicator()) {
            return true;
        }
        List iterable = ProgressManagerImpl.getCurrentIndicators();
        for (ProgressIndicator t : iterable) {
            if (!ProgressManagerImpl.isUnsafeIndicator(t)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnsafeIndicator(@NotNull ProgressIndicator indicator2) {
        if (indicator2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(0);
        }
        return indicator2 instanceof ProgressIndicatorBase && ((ProgressIndicatorBase)indicator2).getUserData(SAFE_PROGRESS_INDICATOR) == null;
    }

    public void markProgressSafe(@NotNull UserDataHolder progress) {
        if (progress == null) {
            ProgressManagerImpl.$$$reportNull$$$0(1);
        }
        progress.putUserData(SAFE_PROGRESS_INDICATOR, (Object)true);
    }

    /*
     * Unable to fully structure code
     */
    public void executeProcessUnderProgress(@NotNull Runnable process, ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            ProgressManagerImpl.$$$reportNull$$$0(2);
        }
        if (!(progress instanceof PingProgress)) ** GOTO lbl-1000
        pingProgress = (PingProgress)progress;
        if (EDT.isCurrentThreadEdt()) {
            v0 = pingProgress;
        } else lbl-1000:
        // 2 sources

        {
            v0 = hook = null;
        }
        if (hook == null) {
            super.executeProcessUnderProgress(process, progress);
        } else {
            this.runWithHook((CoreProgressManager.CheckCanceledHook)hook, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$executeProcessUnderProgress$0(java.lang.Runnable com.intellij.openapi.progress.ProgressIndicator ), ()V)((ProgressManagerImpl)this, (Runnable)process, (ProgressIndicator)progress));
        }
    }

    public boolean runProcessWithProgressSynchronously(@NotNull Task task) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(3);
        }
        long start2 = System.currentTimeMillis();
        boolean result2 = super.runProcessWithProgressSynchronously(task);
        if (result2) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task.notifyFinished();
            long time = end - start2;
            if (notificationInfo != null && time > 5000L && (frame = WindowManager.getInstance().getFrame(task.getProject())) != null && !frame.hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
        }
        return result2;
    }

    protected void fireNonCancellableEvent() {
        ProgressManagerImpl.commitCheckCanceledJfrEvent(true, false, HasContextJob.NO, false, false, false);
    }

    protected void fireCanceledByJobEvent() {
        ProgressManagerImpl.commitCheckCanceledJfrEvent(false, false, HasContextJob.YES, false, false, true);
    }

    protected void fireCanceledByIndicatorEvent(@Nullable ProgressIndicator indicator2) {
        ProgressManagerImpl.commitCheckCanceledJfrEvent(false, indicator2 != null, HasContextJob.INFER, false, false, indicator2 != null && indicator2.isCanceled());
    }

    protected void fireCheckCanceledNone() {
        ProgressManagerImpl.commitCheckCanceledJfrEvent(false, false, HasContextJob.INFER, true, false, false);
    }

    protected void fireCheckCanceledOnlyHooks() {
        ProgressManagerImpl.commitCheckCanceledJfrEvent(false, false, HasContextJob.INFER, false, true, false);
    }

    private static void systemNotify(@NotNull Task.NotificationInfo info) {
        if (info == null) {
            ProgressManagerImpl.$$$reportNull$$$0(4);
        }
        SystemNotifications.getInstance().notify(info.getNotificationName(), info.getNotificationTitle(), info.getNotificationText());
    }

    private static boolean shouldFireCheckCanceledEvent() {
        ApplicationEx applicationManagerEx = ApplicationManagerEx.getApplicationEx();
        return applicationManagerEx != null && applicationManagerEx.isWriteActionPending() && applicationManagerEx.isReadAccessAllowed();
    }

    private static void commitCheckCanceledJfrEvent(boolean nonCancellable, boolean hasProgressIndicator, @NotNull HasContextJob hasContextJob, boolean hasNoneBehavior, boolean hasOnlyHooksBehavior, boolean cancelled) {
        if (hasContextJob == null) {
            ProgressManagerImpl.$$$reportNull$$$0(5);
        }
        if (!ProgressManagerImpl.shouldFireCheckCanceledEvent()) {
            return;
        }
        boolean hasContextJobValue = hasContextJob.value();
        THROTTLED_LOGGER.info(() -> "checkCancelled is invoked while write-action is pending. nonCancellable: " + nonCancellable + ", hasProgressIndicator: " + hasProgressIndicator + ", hasContextJob: " + hasContextJobValue + ", hasNoneBehavior: " + hasNoneBehavior + ", hasOnlyHooksBehavior: " + hasOnlyHooksBehavior + ", cancelled: " + cancelled);
        CheckCanceledEvent.commit(nonCancellable, hasProgressIndicator, hasContextJobValue, hasNoneBehavior, hasOnlyHooksBehavior, cancelled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTask(@NotNull Task task, @NotNull ProgressIndicator indicator2, @Nullable Runnable continuation) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(6);
        }
        if (indicator2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(7);
        }
        ProgressManagerListener listener2 = ProgressManagerImpl.getProjectManagerListener();
        try {
            listener2.beforeTaskStart(task, indicator2);
        }
        finally {
            try {
                super.startTask(task, indicator2, continuation);
            }
            finally {
                listener2.afterTaskStart(task, indicator2);
            }
        }
    }

    @NotNull
    protected ProgressIndicator createDefaultAsynchronousProgressIndicator(@NotNull Task.Backgroundable task) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return ProgressManagerImpl.shouldKeepTasksAsynchronousInHeadlessMode() ? new ProgressIndicatorBase() : new EmptyProgressIndicator();
        }
        Project project2 = task.getProject();
        return project2 != null && project2.isDisposed() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
    }

    @ApiStatus.Internal
    public void notifyTaskFinished(@NotNull Task.Backgroundable task, long elapsed) {
        Window window;
        Task.NotificationInfo notificationInfo;
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(9);
        }
        if ((notificationInfo = task.notifyFinished()) != null && elapsed > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
            ProgressManagerImpl.systemNotify(notificationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishTask(@NotNull Task task, boolean canceled, @Nullable Throwable error) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(10);
        }
        ProgressManagerListener listener2 = ProgressManagerImpl.getProjectManagerListener();
        try {
            listener2.beforeTaskFinished(task);
        }
        finally {
            try {
                super.finishTask(task, canceled, error);
            }
            finally {
                listener2.afterTaskFinished(task);
            }
        }
    }

    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2, @Nullable ProgressIndicator indicator2) {
        if (action2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(11);
        }
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)action2, (ProgressIndicator)indicator2);
    }

    @ApiStatus.Internal
    public AccessToken withCheckCanceledHook(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(12);
        }
        final CoreProgressManager.CheckCanceledHook hook = indicator2 -> {
            runnable2.run();
            return true;
        };
        this.addCheckCanceledHook(hook);
        return new AccessToken(){

            public void finish() {
                ProgressManagerImpl.this.removeCheckCanceledHook(hook);
            }
        };
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public boolean addCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook) {
        if (hook == null) {
            ProgressManagerImpl.$$$reportNull$$$0(13);
        }
        if (!this.myHooks.contains(hook)) {
            this.myHooks.add(hook);
            this.updateShouldCheckCanceled();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public void removeCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook) {
        if (hook == null) {
            ProgressManagerImpl.$$$reportNull$$$0(14);
        }
        if (this.myHooks.remove(hook)) {
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void runWithHook(@NotNull CoreProgressManager.CheckCanceledHook hook, @NotNull Runnable runnable2) {
        if (hook == null) {
            ProgressManagerImpl.$$$reportNull$$$0(15);
        }
        if (runnable2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(16);
        }
        boolean added = this.addCheckCanceledHook(hook);
        try {
            runnable2.run();
        }
        finally {
            if (added) {
                this.removeCheckCanceledHook(hook);
            }
        }
    }

    public boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator2) {
        boolean result2;
        if (!this.hasCheckCanceledHooks()) {
            return false;
        }
        boolean bl = result2 = this.myRunSleepHook && this.sleepIfNeededToGivePriorityToAnotherThread();
        if (this.myHooks.isEmpty()) {
            return result2;
        }
        for (CoreProgressManager.CheckCanceledHook hook : this.myHooks) {
            if (!hook.runHook(indicator2)) continue;
            result2 = true;
        }
        return result2;
    }

    protected boolean hasCheckCanceledHooks() {
        return this.myRunSleepHook || !this.myHooks.isEmpty();
    }

    protected void prioritizingStarted() {
        this.myRunSleepHook = true;
        this.updateShouldCheckCanceled();
    }

    protected void prioritizingFinished() {
        this.myRunSleepHook = false;
        this.updateShouldCheckCanceled();
    }

    @NotNull
    private static ProgressManagerListener getProjectManagerListener() {
        ProgressManagerListener progressManagerListener = (ProgressManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProgressManagerListener.TOPIC);
        if (progressManagerListener == null) {
            ProgressManagerImpl.$$$reportNull$$$0(17);
        }
        return progressManagerListener;
    }

    private /* synthetic */ void lambda$executeProcessUnderProgress$0(Runnable process2, ProgressIndicator progress) {
        super.executeProcessUnderProgress(process2, progress);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasContextJob";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hook";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/ProgressManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressManagerImpl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectManagerListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnsafeIndicator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "markProgressSafe";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "systemNotify";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commitCheckCanceledJfrEvent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startTask";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultAsynchronousProgressIndicator";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notifyTaskFinished";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "finishTask";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withCheckCanceledHook";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addCheckCanceledHook";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeCheckCanceledHook";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runWithHook";
                break;
            }
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17 -> new IllegalStateException(string);
        };
    }

    private static final class IdeIOCancellationCallback
    implements IOCancellationCallback {
        private IdeIOCancellationCallback() {
        }

        public void checkCancelled() throws ProcessCanceledException {
            ProgressManager.checkCanceled();
        }

        public void interactWithUI() {
            PingProgress.interactWithEdtProgress();
        }
    }

    private static final class IdeJfrCancellationCallback
    implements JfrCancellationEventCallback {
        private IdeJfrCancellationCallback() {
        }

        public void nonCanceledSectionInvoked() {
            ProgressManagerImpl.commitCheckCanceledJfrEvent(true, false, HasContextJob.INFER, false, false, false);
        }

        public void cancellableSectionInvoked(boolean wasCanceled) {
            ProgressManagerImpl.commitCheckCanceledJfrEvent(false, false, HasContextJob.INFER, false, false, wasCanceled);
        }
    }

    private static enum HasContextJob {
        YES,
        NO,
        INFER;


        boolean value() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> false;
                case 2 -> Cancellation.currentJob() != null;
            };
        }
    }
}

