/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.ListPluginModel;
import com.intellij.ide.plugins.PluginDependencyImpl;
import com.intellij.ide.plugins.PluginManagementPolicy;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerConfigurablePanel;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.enums.PluginsGroupType;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.MultiSelectionEventHandler;
import com.intellij.ide.plugins.newui.MyPluginModel;
import com.intellij.ide.plugins.newui.PluginDetailsPageComponent;
import com.intellij.ide.plugins.newui.PluginModelFacade;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.plugins.newui.PluginUiModelAdapter;
import com.intellij.ide.plugins.newui.PluginUpdatesService;
import com.intellij.ide.plugins.newui.PluginsGroup;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.ide.plugins.newui.UiPluginManager;
import com.intellij.ide.plugins.newui.UpdateDialogPluginDetailsPageCustomizationStrategy;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerFacade;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateOptions;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.ide.CoreUiCoroutineScopeHolder;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PluginUpdateDialog
extends DialogWrapper {
    private final MyPluginModel myPluginModel;
    private final PluginsGroupComponent myPluginsPanel;
    private final PluginsGroup myGroup;
    private final PluginDetailsPageComponent myDetailsPage;
    private final JLabel myTotalLabel;
    private final ActionLink myIgnoreAction;
    private final JBCheckBox myAutoUpdateOption;
    @Nullable
    private Runnable myFinishCallback;

    public PluginUpdateDialog(@Nullable Project project2, @NotNull Collection<PluginUiModel> updates, final @Nullable Collection<PluginUiModel> customRepositoryPlugins, final Map<PluginId, PluginUiModel> installedPlugins) {
        if (updates == null) {
            PluginUpdateDialog.$$$reportNull$$$0(0);
        }
        super(project2, true);
        this.myGroup = new PluginsGroup("", PluginsGroupType.UPDATE);
        this.myTotalLabel = new JLabel();
        this.myIgnoreAction = new ActionLink(IdeBundle.message((String)"updates.ignore.updates.button", (Object[])new Object[]{updates.size()}), e -> this.doIgnoreUpdateAction(e));
        this.myAutoUpdateOption = new JBCheckBox(IdeBundle.message((String)"updates.auto.update.title", (Object[])new Object[0]), UpdateSettings.getInstance().getState().isPluginsAutoUpdateEnabled());
        this.myPluginModel = new MyPluginModel(project2){

            @Override
            public void runRestartButton(@NotNull Component component2) {
                if (component2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                PluginUpdateDialog.this.doOKAction();
            }

            @Override
            @NotNull
            protected Collection<PluginUiModel> getCustomRepoPlugins() {
                Collection<PluginUiModel> collection = customRepositoryPlugins != null ? customRepositoryPlugins : super.getCustomRepoPlugins();
                if (collection == null) {
                    1.$$$reportNull$$$0(1);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCustomRepoPlugins";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "runRestartButton";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        this.myPluginModel.setTopController(Configurable.TopComponentController.EMPTY);
        this.myPluginModel.setPluginUpdatesService(new PluginUpdatesService(this){

            @Override
            public void finishUpdate() {
            }
        });
        this.myDetailsPage = new PluginDetailsPageComponent(new PluginModelFacade(this.myPluginModel), (LinkListener<Object>)LinkListener.NULL, true, UpdateDialogPluginDetailsPageCustomizationStrategy.INSTANCE);
        this.myDetailsPage.setOnlyUpdateMode();
        MultiSelectionEventHandler eventHandler = new MultiSelectionEventHandler();
        this.myPluginsPanel = new PluginsGroupComponent(eventHandler){

            @Override
            @NotNull
            protected ListPluginComponent createListComponent(@NotNull PluginUiModel model2, @NotNull PluginsGroup group2, @NotNull ListPluginModel listPluginModel) {
                if (model2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (group2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (listPluginModel == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (!model2.isFromMarketplace()) {
                    PluginNode node = new PluginNode(model2.getPluginId(), model2.getName(), "0");
                    node.setDescription(model2.getDescription());
                    node.setChangeNotes(model2.getChangeNotes());
                    node.setVersion(model2.getVersion());
                    node.setVendor(model2.getVendor());
                    node.setVendorDetails(model2.getOrganization());
                    List dependencies = ContainerUtil.map(model2.getDependencies(), it -> new PluginDependencyImpl(it.getPluginId(), null, it.isOptional()));
                    node.setDependencies(dependencies);
                    model2 = new PluginUiModelAdapter(node);
                }
                CoroutineScope scope = ((CoreUiCoroutineScopeHolder)ApplicationManager.getApplication().getService(CoreUiCoroutineScopeHolder.class)).coroutineScope;
                ListPluginComponent component2 = new ListPluginComponent(new PluginModelFacade(PluginUpdateDialog.this.myPluginModel), model2, group2, listPluginModel, (LinkListener<Object>)LinkListener.NULL, scope, true);
                PluginUiModel plugin = (PluginUiModel)installedPlugins.get(model2.getPluginId());
                component2.setOnlyUpdateMode(plugin);
                component2.getChooseUpdateButton().addActionListener(e -> PluginUpdateDialog.this.updateButtons());
                ListPluginComponent listPluginComponent = component2;
                if (listPluginComponent == null) {
                    3.$$$reportNull$$$0(3);
                }
                return listPluginComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "group";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listPluginModel";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$3";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createListComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createListComponent";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        };
        PluginManagerConfigurablePanel.registerCopyProvider(this.myPluginsPanel);
        this.myPluginsPanel.setSelectionListener(__ -> this.myDetailsPage.showPlugins(this.myPluginsPanel.getSelection()));
        for (PluginUiModel descriptor2 : updates) {
            this.myGroup.addModel(descriptor2);
        }
        this.myGroup.sortByName();
        this.myPluginsPanel.addGroup(this.myGroup);
        this.setOKButtonText(IdeBundle.message((String)"plugins.configurable.update.button", (Object[])new Object[0]));
        this.updateButtons();
        this.init();
        JRootPane rootPane = this.getPeer().getRootPane();
        if (rootPane != null) {
            rootPane.setPreferredSize((Dimension)new JBDimension(800, 600));
        }
        this.setTitle(IdeBundle.message((String)"dialog.title.plugin.updates", (Object[])new Object[0]));
    }

    public static boolean showDialogAndUpdate(@NotNull Collection<PluginDownloader> downloaders, @NotNull PluginUpdateDialog dialog2) {
        if (downloaders == null) {
            PluginUpdateDialog.$$$reportNull$$$0(1);
        }
        if (dialog2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(2);
        }
        if (dialog2.showAndGet()) {
            List<PluginUiModel> selectedPlugins = dialog2.getSelectedPluginModels();
            List<PluginDownloader> selectedDownloaders = PluginUpdateDialog.findDownloadersForPlugins(downloaders, selectedPlugins);
            PluginUpdateDialog.runUpdateAll(selectedDownloaders, dialog2.getContentPanel(), dialog2.myFinishCallback, null);
            return true;
        }
        return false;
    }

    public static List<PluginDownloader> getSelectedDownloaders(@NotNull Collection<PluginDownloader> downloaders, @NotNull PluginUpdateDialog dialog2) {
        if (downloaders == null) {
            PluginUpdateDialog.$$$reportNull$$$0(3);
        }
        if (dialog2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(4);
        }
        return PluginUpdateDialog.findDownloadersForPlugins(downloaders, dialog2.getSelectedPluginModels());
    }

    @NotNull
    private static List<PluginDownloader> findDownloadersForPlugins(@NotNull Collection<PluginDownloader> downloaders, @NotNull List<PluginUiModel> selectedPlugins) {
        if (downloaders == null) {
            PluginUpdateDialog.$$$reportNull$$$0(5);
        }
        if (selectedPlugins == null) {
            PluginUpdateDialog.$$$reportNull$$$0(6);
        }
        ArrayList<PluginDownloader> selectedDownloaders = new ArrayList<PluginDownloader>();
        Set selectedPluginIds = ContainerUtil.map2Set(selectedPlugins, PluginUiModel::getPluginId);
        for (PluginDownloader downloader : downloaders) {
            if (!selectedPluginIds.contains(downloader.getDescriptor().getPluginId())) continue;
            selectedDownloaders.add(downloader);
        }
        ArrayList<PluginDownloader> arrayList = selectedDownloaders;
        if (arrayList == null) {
            PluginUpdateDialog.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    protected void doIgnoreUpdateAction(ActionEvent e) {
        this.close(1);
        ((UpdateCheckerFacade)ApplicationManager.getApplication().getService(UpdateCheckerFacade.class)).ignorePlugins(ContainerUtil.map(this.myGroup.ui.plugins, ListPluginComponent::getPluginDescriptor));
    }

    private void updateButtons() {
        long total = 0L;
        int count = 0;
        for (ListPluginComponent plugin : this.myGroup.ui.plugins) {
            if (!plugin.getChooseUpdateButton().isSelected()) continue;
            ++count;
            IdeaPluginDescriptor descriptor2 = plugin.getPluginDescriptor();
            if (!(descriptor2 instanceof PluginNode)) continue;
            total += ((PluginNode)descriptor2).getIntegerSize();
        }
        this.myTotalLabel.setText(IdeBundle.message((String)"plugin.update.dialog.total.label", (Object[])new Object[]{StringUtilRt.formatFileSize((long)total).toUpperCase(Locale.ENGLISH)}));
        this.myTotalLabel.setVisible(total > 0L);
        this.getOKAction().setEnabled(count > 0);
    }

    public void setFinishCallback(@NotNull Runnable finishCallback) {
        if (finishCallback == null) {
            PluginUpdateDialog.$$$reportNull$$$0(8);
        }
        this.myFinishCallback = finishCallback;
    }

    @Nullable
    public Runnable getFinishCallback() {
        return this.myFinishCallback;
    }

    @NotNull
    public List<PluginUiModel> getSelectedPluginModels() {
        ArrayList<PluginUiModel> selectedPlugins = new ArrayList<PluginUiModel>();
        for (ListPluginComponent plugin : this.myGroup.ui.plugins) {
            if (!plugin.getChooseUpdateButton().isSelected()) continue;
            selectedPlugins.add(plugin.getPluginModel());
        }
        ArrayList<PluginUiModel> arrayList = selectedPlugins;
        if (arrayList == null) {
            PluginUpdateDialog.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    protected void doOKAction() {
        super.doOKAction();
        if (PluginManagementPolicy.getInstance().isPluginAutoUpdateAllowed()) {
            UpdateOptions state2 = UpdateSettings.getInstance().getState();
            boolean selected = this.myAutoUpdateOption.isSelected();
            if (state2.isPluginsAutoUpdateEnabled() != selected) {
                UiPluginManager.getInstance().setPluginsAutoUpdateEnabled(selected);
            }
        }
    }

    public static void runUpdateAll(final @NotNull Collection<PluginDownloader> toDownload, final @Nullable JComponent ownerComponent, final @Nullable Runnable finishCallback, final @Nullable Consumer<Boolean> customRestarter) {
        if (toDownload == null) {
            PluginUpdateDialog.$$$reportNull$$$0(10);
        }
        String message = IdeBundle.message((String)"updates.notification.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        new Task.Backgroundable(null, message, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator2) {
                List<PluginDownloader> downloaders;
                if (indicator2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if ((downloaders = PluginUpdateDialog.downloadPluginUpdates(toDownload, indicator2)).isEmpty()) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    boolean restartRequired;
                    List<IdeaPluginDescriptor> installedDescriptors = this.installPluginUpdates(downloaders);
                    boolean bl = restartRequired = downloaders.size() != installedDescriptors.size();
                    if (customRestarter != null) {
                        customRestarter.accept(restartRequired);
                        return;
                    }
                    if (PluginManagementPolicy.getInstance().isPluginAutoUpdateAllowed() && !UpdateSettings.getInstance().getState().isPluginsAutoUpdateEnabled()) {
                        Notification notification2 = ((UpdateCheckerFacade)ApplicationManager.getApplication().getService(UpdateCheckerFacade.class)).getNotificationGroupForPluginUpdateResults().createNotification(IdeBundle.message((String)"updates.plugins.notification.title", (Object[])new Object[0]), IdeBundle.message((String)"updates.plugins.autoupdate.notification.message", (Object[])new Object[0]), NotificationType.INFORMATION).addAction((AnAction)new NotificationAction(this, IdeBundle.message((String)"updates.auto.update.title", (Object[])new Object[0])){

                            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                                if (e == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                if (notification2 == null) {
                                    2.$$$reportNull$$$0(1);
                                }
                                UiPluginManager.getInstance().setPluginsAutoUpdateEnabled(true);
                                notification2.expire();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "e";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "notification";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$4$2";
                                objectArray[2] = "actionPerformed";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        }).addAction((AnAction)new NotificationAction(this, IdeBundle.message((String)"label.dont.show", (Object[])new Object[0])){

                            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                                if (e == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if (notification2 == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                notification2.setDoNotAskFor(null);
                                notification2.expire();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "e";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "notification";
                                        break;
                                    }
                                }
                                objectArray[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$4$1";
                                objectArray[2] = "actionPerformed";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                        notification2.configureDoNotAskOption("updates.plugins.autoupdate.notification", IdeBundle.message((String)"updates.plugins.autoupdate.notification.do.not.ask.display", (Object[])new Object[0]));
                        notification2.notify(this.myProject);
                    }
                    if (!restartRequired) {
                        ((UpdateCheckerFacade)ApplicationManager.getApplication().getService(UpdateCheckerFacade.class)).getNotificationGroupForPluginUpdateResults().createNotification(4.getUpdateNotificationMessage(installedDescriptors), NotificationType.INFORMATION).setDisplayId("plugins.updated.without.restart").notify(this.myProject);
                    } else if (WelcomeFrame.getInstance() == null) {
                        PluginManagerMain.notifyPluginsUpdated(null);
                    } else {
                        PluginManagerConfigurable.shutdownOrRestartApp();
                    }
                }, ownerComponent != null ? ModalityState.stateForComponent((Component)ownerComponent) : ModalityState.defaultModalityState());
            }

            public void onFinished() {
                if (finishCallback != null) {
                    finishCallback.run();
                }
            }

            @NotNull
            private List<IdeaPluginDescriptor> installPluginUpdates(@NotNull List<PluginDownloader> downloaders) {
                if (downloaders == null) {
                    4.$$$reportNull$$$0(1);
                }
                ArrayList<IdeaPluginDescriptor> installedDescriptors = new ArrayList<IdeaPluginDescriptor>();
                for (PluginDownloader downloader : downloaders) {
                    try {
                        if (!downloader.installDynamically(ownerComponent)) continue;
                        installedDescriptors.add(downloader.getDescriptor());
                    }
                    catch (Exception e) {
                        Logger.getInstance(PluginUpdateDialog.class).info((Throwable)e);
                    }
                }
                ArrayList<IdeaPluginDescriptor> arrayList = installedDescriptors;
                if (arrayList == null) {
                    4.$$$reportNull$$$0(2);
                }
                return arrayList;
            }

            @NotNull
            @Nls
            private static String getUpdateNotificationMessage(@NotNull List<? extends IdeaPluginDescriptor> descriptors2) {
                if (descriptors2 == null) {
                    4.$$$reportNull$$$0(3);
                }
                if (descriptors2.size() == 1) {
                    IdeaPluginDescriptor descriptor2 = descriptors2.get(0);
                    String string = IdeBundle.message((String)"notification.content.updated.plugin.to.version", (Object[])new Object[]{descriptor2.getName(), descriptor2.getVersion()});
                    if (string == null) {
                        4.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                String names = descriptors2.stream().map(PluginDescriptor::getName).collect(Collectors.joining(", "));
                String string = IdeBundle.message((String)"notification.content.updated.plugins", (Object[])new Object[]{names});
                if (string == null) {
                    4.$$$reportNull$$$0(5);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "downloaders";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$4";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptors";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog$4";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "installPluginUpdates";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUpdateNotificationMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "installPluginUpdates";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getUpdateNotificationMessage";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 4, 5 -> new IllegalStateException(string);
                };
            }
        }.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<PluginDownloader> downloadPluginUpdates(@NotNull Collection<PluginDownloader> toDownload, @NotNull ProgressIndicator indicator2) {
        if (toDownload == null) {
            PluginUpdateDialog.$$$reportNull$$$0(11);
        }
        if (indicator2 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(12);
        }
        LinkedHashSet<@Nls E> errors = new LinkedHashSet();
        List downloaders = ContainerUtil.map(toDownload, downloader -> downloader.withErrorsConsumer(errors::add));
        List<PluginDownloader> list2 = UpdateInstaller.downloadPluginUpdates(downloaders, indicator2);
        List<PluginDownloader> list3 = list2;
        if (list3 == null) {
            PluginUpdateDialog.$$$reportNull$$$0(13);
        }
        return list3;
        finally {
            if (!errors.isEmpty()) {
                String text2 = String.join((CharSequence)"\n\n", errors);
                PluginDownloader.showErrorDialog(text2);
            }
        }
    }

    public void doCancelAction() {
        this.close(1);
    }

    protected JPanel createSouthAdditionalPanel() {
        Wrapper panel2 = new Wrapper((JComponent)this.myIgnoreAction);
        panel2.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        return panel2;
    }

    @NotNull
    protected JPanel createButtonsPanel(@NotNull List<? extends JButton> buttons) {
        if (buttons == null) {
            PluginUpdateDialog.$$$reportNull$$$0(14);
        }
        JPanel panel2 = super.createButtonsPanel(buttons);
        if (PluginManagementPolicy.getInstance().isPluginAutoUpdateAllowed()) {
            NonOpaquePanel buttonsPanel = new NonOpaquePanel((LayoutManager)new BorderLayout(JBUI.scale((int)10), 0));
            buttonsPanel.add((Component)this.myAutoUpdateOption, "West");
            buttonsPanel.add(panel2);
            NonOpaquePanel nonOpaquePanel = buttonsPanel;
            if (nonOpaquePanel == null) {
                PluginUpdateDialog.$$$reportNull$$$0(15);
            }
            return nonOpaquePanel;
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            PluginUpdateDialog.$$$reportNull$$$0(16);
        }
        return jPanel;
    }

    protected String getHelpId() {
        return "plugin.update.dialog";
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            PluginUpdateDialog.$$$reportNull$$$0(17);
        }
        return dialogStyle;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.updateSettings.impl.PluginUpdateInfoDialog";
    }

    protected JComponent createCenterPanel() {
        OnePixelSplitter splitter2 = new OnePixelSplitter(false, 0.45f){

            protected Divider createDivider() {
                Divider divider = super.createDivider();
                divider.setBackground(PluginManagerConfigurable.SEARCH_FIELD_BORDER_COLOR);
                return divider;
            }
        };
        this.myGroup.ui.panel.getParent().remove(this.myGroup.ui.panel);
        this.myGroup.ui.panel.setPreferredSize(new Dimension());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add(PluginManagerConfigurablePanel.createScrollPane(this.myPluginsPanel, true));
        OpaquePanel titlePanel = new OpaquePanel((LayoutManager)new BorderLayout(), PluginManagerConfigurable.MAIN_BG_COLOR);
        titlePanel.setBorder((Border)JBUI.Borders.empty((int)13, (int)12));
        leftPanel.add((Component)titlePanel, "South");
        this.myTotalLabel.setForeground(PluginsGroupComponent.SECTION_HEADER_FOREGROUND);
        titlePanel.add((Component)this.myTotalLabel);
        splitter2.setFirstComponent((JComponent)leftPanel);
        splitter2.setSecondComponent((JComponent)this.myDetailsPage);
        return splitter2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 13, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updates";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloaders";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPlugins";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishCallback";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDownload";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttons";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/PluginUpdateDialog";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findDownloadersForPlugins";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPluginModels";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "downloadPluginUpdates";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createButtonsPanel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndUpdate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedDownloaders";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDownloadersForPlugins";
                break;
            }
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setFinishCallback";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runUpdateAll";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "downloadPluginUpdates";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createButtonsPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 13, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

