/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class EncodingUtil {
    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static Magic8 isSafeToReloadIn(@NotNull VirtualFile virtualFile, @NotNull CharSequence text2, byte @NotNull [] bytes, @NotNull Charset charset) {
        byte[] bytesToSave;
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            EncodingUtil.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            EncodingUtil.$$$reportNull$$$0(2);
        }
        if (bytes == null) {
            EncodingUtil.$$$reportNull$$$0(3);
        }
        byte[] bom = null;
        try {
            bom = EncodingUtil.getBOMFromBytes(virtualFile.contentsToByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bom != null && !CharsetToolkit.canHaveBom((Charset)charset, (byte[])bom)) {
            Magic8 magic8 = Magic8.NO_WAY;
            if (magic8 == null) {
                EncodingUtil.$$$reportNull$$$0(4);
            }
            return magic8;
        }
        byte[] mandatoryBom = CharsetToolkit.getMandatoryBom((Charset)charset);
        if (mandatoryBom != null && !ArrayUtil.startsWith((byte[])bytes, (byte[])mandatoryBom)) {
            Magic8 magic8 = Magic8.NO_WAY;
            if (magic8 == null) {
                EncodingUtil.$$$reportNull$$$0(5);
            }
            return magic8;
        }
        String loaded = LoadTextUtil.getTextByBinaryPresentation((byte[])bytes, (Charset)charset).toString();
        String separator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
        String toSave = StringUtil.convertLineSeparators((String)loaded, (String)separator);
        LoadTextUtil.AutoDetectionReason failReason = LoadTextUtil.getCharsetAutoDetectionReason((VirtualFile)virtualFile);
        if (failReason != null && StandardCharsets.UTF_8.equals(virtualFile.getCharset()) && !StandardCharsets.UTF_8.equals(charset)) {
            Magic8 magic8 = Magic8.NO_WAY;
            if (magic8 == null) {
                EncodingUtil.$$$reportNull$$$0(6);
            }
            return magic8;
        }
        try {
            bytesToSave = toSave.getBytes(charset);
        }
        catch (NullPointerException | UnsupportedOperationException e) {
            Magic8 magic8 = Magic8.NO_WAY;
            if (magic8 == null) {
                EncodingUtil.$$$reportNull$$$0(7);
            }
            return magic8;
        }
        if (bom != null && !ArrayUtil.startsWith((byte[])bytesToSave, (byte[])bom)) {
            bytesToSave = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytesToSave);
        }
        Magic8 magic8 = !Arrays.equals(bytesToSave, bytes) ? Magic8.NO_WAY : (StringUtil.equals((CharSequence)loaded, (CharSequence)text2) ? Magic8.ABSOLUTELY : Magic8.WELL_IF_YOU_INSIST);
        if (magic8 == null) {
            EncodingUtil.$$$reportNull$$$0(8);
        }
        return magic8;
    }

    private static byte[] getBOMFromBytes(byte @NotNull [] contents) {
        Charset charset;
        if (contents == null) {
            EncodingUtil.$$$reportNull$$$0(9);
        }
        if ((charset = CharsetToolkit.guessFromBOM((byte[])contents)) == null) {
            return null;
        }
        if (charset.equals(StandardCharsets.UTF_8)) {
            return CharsetToolkit.UTF8_BOM;
        }
        return CharsetToolkit.getMandatoryBom((Charset)charset);
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public static Magic8 isSafeToConvertTo(@NotNull VirtualFile virtualFile, @NotNull CharSequence text2, byte @NotNull [] bytesOnDisk, @NotNull Charset charset) {
        Magic8 magic8;
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(10);
        }
        if (text2 == null) {
            EncodingUtil.$$$reportNull$$$0(11);
        }
        if (charset == null) {
            EncodingUtil.$$$reportNull$$$0(12);
        }
        if (bytesOnDisk == null) {
            EncodingUtil.$$$reportNull$$$0(13);
        }
        try {
            String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
            CharSequence textToSave = lineSeparator.equals("\n") ? text2 : StringUtilRt.convertLineSeparators((CharSequence)text2, (String)lineSeparator);
            Pair.NonNull chosen2 = LoadTextUtil.chooseMostlyHarmlessCharset((Charset)virtualFile.getCharset(), (Charset)charset, (String)textToSave.toString());
            byte[] saved = (byte[])chosen2.second;
            CharSequence textLoadedBack = LoadTextUtil.getTextByBinaryPresentation((byte[])saved, (Charset)charset);
            magic8 = !StringUtil.equals((CharSequence)text2, (CharSequence)textLoadedBack) ? Magic8.NO_WAY : (Arrays.equals(saved, bytesOnDisk) ? Magic8.ABSOLUTELY : Magic8.WELL_IF_YOU_INSIST);
        }
        catch (UnsupportedOperationException e) {
            Magic8 magic82 = Magic8.NO_WAY;
            if (magic82 == null) {
                EncodingUtil.$$$reportNull$$$0(15);
            }
            return magic82;
        }
        if (magic8 == null) {
            EncodingUtil.$$$reportNull$$$0(14);
        }
        return magic8;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static void saveIn(@NotNull Project project2, @NotNull Document document2, Editor editor2, @NotNull VirtualFile virtualFile, @NotNull Charset charset) {
        if (project2 == null) {
            EncodingUtil.$$$reportNull$$$0(16);
        }
        if (document2 == null) {
            EncodingUtil.$$$reportNull$$$0(17);
        }
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(18);
        }
        if (charset == null) {
            EncodingUtil.$$$reportNull$$$0(19);
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        documentManager.saveDocument(document2);
        boolean writable = ReadonlyStatusHandler.ensureFilesWritable((Project)project2, (VirtualFile[])new VirtualFile[]{virtualFile});
        if (!writable) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)IdeBundle.message((String)"dialog.message.cannot.save.the.file.0", (Object[])new Object[]{virtualFile.getPresentableUrl()}), (String)IdeBundle.message((String)"dialog.title.unable.to.save", (Object[])new Object[0]), null);
            return;
        }
        EncodingProjectManagerImpl.suppressReloadDuring(() -> {
            EncodingProjectManager.getInstance((Project)project2).setEncoding(virtualFile, charset);
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    virtualFile.setCharset(charset);
                    LoadTextUtil.write((Project)project2, (VirtualFile)virtualFile, (Object)virtualFile, (String)document2.getText(), (long)document2.getModificationStamp());
                    return null;
                });
            }
            catch (IOException io) {
                Messages.showErrorDialog((Project)project2, (String)io.getMessage(), (String)IdeBundle.message((String)"dialog.title.error.writing.file", (Object[])new Object[0]));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @VisibleForTesting
    public static void reloadIn(final @NotNull VirtualFile virtualFile, @NotNull Charset charset, @NotNull Project project2) {
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(20);
        }
        if (charset == null) {
            EncodingUtil.$$$reportNull$$$0(21);
        }
        if (project2 == null) {
            EncodingUtil.$$$reportNull$$$0(22);
        }
        final Consumer<VirtualFile> setEncoding = file2 -> EncodingProjectManager.getInstance((Project)project2).setEncoding(file2, charset);
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.getCachedDocument(virtualFile) == null) {
            setEncoding.accept(virtualFile);
            return;
        }
        final Disposable disposable = Disposer.newDisposable();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(disposable);
        connection.subscribe(FileDocumentManagerListener.TOPIC, (Object)new FileDocumentManagerListener(){

            public void beforeFileContentReload(@NotNull VirtualFile file2, @NotNull Document document2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!file2.equals(virtualFile)) {
                    return;
                }
                Disposer.dispose((Disposable)disposable);
                setEncoding.accept(file2);
                LoadTextUtil.clearCharsetAutoDetectionReason((VirtualFile)file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/vfs/encoding/EncodingUtil$1";
                objectArray[2] = "beforeFileContentReload";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        try {
            VFileContentChangeEvent event = new VFileContentChangeEvent(null, virtualFile, 0L, 0L);
            EncodingProjectManagerImpl.suppressReloadDuring(() -> ((FileDocumentManagerImpl)documentManager).contentsChanged(event));
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    public static boolean canReload(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(23);
        }
        return EncodingUtil.checkCanReload(virtualFile, null) == null;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @Nullable
    public static FailReason checkCanReload(@NotNull VirtualFile virtualFile, @Nullable Ref<? super Charset> current) {
        FailReason result2;
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(24);
        }
        if (virtualFile.isDirectory()) {
            return FailReason.IS_DIRECTORY;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document2 = documentManager.getDocument(virtualFile);
        if (document2 == null) {
            return FailReason.IS_BINARY;
        }
        Charset charsetFromContent = EncodingManagerImpl.computeCharsetFromContent(virtualFile);
        Charset existing = virtualFile.getCharset();
        LoadTextUtil.AutoDetectionReason autoDetectedFrom = LoadTextUtil.getCharsetAutoDetectionReason((VirtualFile)virtualFile);
        if (autoDetectedFrom != null) {
            result2 = autoDetectedFrom == LoadTextUtil.AutoDetectionReason.FROM_BOM ? FailReason.BY_BOM : FailReason.BY_BYTES;
        } else if (charsetFromContent != null) {
            result2 = FailReason.BY_FILE;
            existing = charsetFromContent;
        } else {
            result2 = EncodingUtil.fileTypeDescriptionError(virtualFile);
        }
        if (current != null) {
            current.set((Object)existing);
        }
        return result2;
    }

    @Nullable
    private static FailReason fileTypeDescriptionError(@NotNull VirtualFile virtualFile) {
        FileType fileType2;
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(25);
        }
        if ((fileType2 = virtualFile.getFileType()).isBinary()) {
            return FailReason.IS_BINARY;
        }
        boolean hardcoded = fileType2.isCharsetHardcoded();
        return hardcoded ? FailReason.BY_FILETYPE : null;
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @Nullable(value="null means enabled, notnull means disabled and contains error message")
    public static @Nullable(value="null means enabled, notnull means disabled and contains error message") FailReason checkCanConvert(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            EncodingUtil.$$$reportNull$$$0(26);
        }
        if (virtualFile.isDirectory()) {
            return FailReason.IS_DIRECTORY;
        }
        Charset charsetFromContent = EncodingManagerImpl.computeCharsetFromContent(virtualFile);
        return charsetFromContent != null ? FailReason.BY_FILE : EncodingUtil.fileTypeDescriptionError(virtualFile);
    }

    @ApiStatus.Internal
    @Nullable
    public static FailReason checkCanConvertAndReload(@NotNull VirtualFile selectedFile) {
        FailReason result2;
        if (selectedFile == null) {
            EncodingUtil.$$$reportNull$$$0(27);
        }
        if ((result2 = EncodingUtil.checkCanConvert(selectedFile)) == null) {
            return null;
        }
        return EncodingUtil.checkCanReload(selectedFile, null);
    }

    @Nullable
    public static Pair<Charset, String> getCharsetAndTheReasonTooltip(@NotNull VirtualFile file2) {
        FailReason r1;
        if (file2 == null) {
            EncodingUtil.$$$reportNull$$$0(28);
        }
        if ((r1 = EncodingUtil.checkCanConvert(file2)) == null) {
            return null;
        }
        Ref current = Ref.create();
        FailReason r2 = EncodingUtil.checkCanReload(file2, (Ref<? super Charset>)current);
        if (r2 == null) {
            return null;
        }
        String errorDescription = r1 == r2 ? EncodingUtil.reasonToString(r1, file2) : EncodingUtil.reasonToString(r1, file2) + ", " + EncodingUtil.reasonToString(r2, file2);
        return Pair.create((Object)((Charset)current.get()), (Object)errorDescription);
    }

    @ApiStatus.Internal
    @NotNull
    @Nls
    public static String reasonToString(@NotNull FailReason reason, @NotNull VirtualFile file2) {
        if (reason == null) {
            EncodingUtil.$$$reportNull$$$0(29);
        }
        if (file2 == null) {
            EncodingUtil.$$$reportNull$$$0(30);
        }
        String string = switch (reason.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> IdeBundle.message((String)"no.charset.set.reason.disabled.for.directory", (Object[])new Object[0]);
            case 1 -> IdeBundle.message((String)"no.charset.set.reason.disabled.for.binary.file", (Object[])new Object[0]);
            case 2 -> IdeBundle.message((String)"no.charset.set.reason.charset.hard.coded.in.file", (Object[])new Object[0]);
            case 3 -> IdeBundle.message((String)"no.charset.set.reason.charset.auto.detected.by.bom", (Object[])new Object[0]);
            case 4 -> IdeBundle.message((String)"no.charset.set.reason.charset.auto.detected.from.content", (Object[])new Object[0]);
            case 5 -> IdeBundle.message((String)"no.charset.set.reason.disabled.for.file.type", (Object[])new Object[]{file2.getFileType().getDescription()});
        };
        if (string == null) {
            EncodingUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 14, 15, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 12: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytesOnDisk";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFile";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "isSafeToReloadIn";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "isSafeToConvertTo";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "reasonToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToReloadIn";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBOMFromBytes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSafeToConvertTo";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "saveIn";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reloadIn";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "canReload";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkCanReload";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fileTypeDescriptionError";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkCanConvert";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkCanConvertAndReload";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCharsetAndTheReasonTooltip";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "reasonToString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 14, 15, 31 -> new IllegalStateException(string);
        };
    }

    public static enum Magic8 {
        ABSOLUTELY,
        WELL_IF_YOU_INSIST,
        NO_WAY;

    }

    @ApiStatus.Internal
    public static enum FailReason {
        IS_DIRECTORY,
        IS_BINARY,
        BY_FILE,
        BY_BOM,
        BY_BYTES,
        BY_FILETYPE;

    }
}

