/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.local.CanonicalPathMap;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.openapi.vfs.impl.local.WatchRootsUtil;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.SystemIndependent;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class WatchRootsManager {
    private static final Logger LOG = Logger.getInstance(WatchRootsManager.class);
    private final FileWatcher myFileWatcher;
    private final NavigableMap<String, List<LocalFileSystem.WatchRequest>> myRecursiveWatchRoots;
    private final NavigableMap<String, List<LocalFileSystem.WatchRequest>> myFlatWatchRoots;
    private final NavigableSet<String> myOptimizedRecursiveWatchRoots;
    private final NavigableMap<String, SymlinkData> mySymlinksByPath;
    private final Int2ObjectMap<SymlinkData> mySymlinksById;
    private final NavigableSet<Pair<String, String>> myPathMappings;
    private boolean myWatcherRequiresUpdate;
    private final Object myLock;

    WatchRootsManager(@NotNull FileWatcher fileWatcher, @NotNull Disposable parent) {
        if (fileWatcher == null) {
            WatchRootsManager.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            WatchRootsManager.$$$reportNull$$$0(1);
        }
        this.myRecursiveWatchRoots = WatchRootsUtil.createFileNavigableMap();
        this.myFlatWatchRoots = WatchRootsUtil.createFileNavigableMap();
        this.myOptimizedRecursiveWatchRoots = WatchRootsUtil.createFileNavigableSet();
        this.mySymlinksByPath = WatchRootsUtil.createFileNavigableMap();
        this.mySymlinksById = new Int2ObjectOpenHashMap();
        this.myPathMappings = WatchRootsUtil.createMappingsNavigableSet();
        this.myLock = new Object();
        this.myFileWatcher = fileWatcher;
        ApplicationManager.getApplication().getMessageBus().connect(parent).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object object = WatchRootsManager.this.myLock;
                synchronized (object) {
                    if (WatchRootsManager.this.myWatcherRequiresUpdate) {
                        WatchRootsManager.this.updateFileWatcher();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/local/WatchRootsManager$1", "after"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Set<LocalFileSystem.WatchRequest> replaceWatchedRoots(@Unmodifiable @NotNull Collection<// Could not load outer class - annotation placement on inner may be incorrect
    LocalFileSystem.WatchRequest> requestsToRemove, @Unmodifiable @NotNull Collection<String> recursiveRootsToAdd, @Unmodifiable @NotNull Collection<String> flatRootsToAdd) {
        if (requestsToRemove == null) {
            WatchRootsManager.$$$reportNull$$$0(2);
        }
        if (recursiveRootsToAdd == null) {
            WatchRootsManager.$$$reportNull$$$0(3);
        }
        if (flatRootsToAdd == null) {
            WatchRootsManager.$$$reportNull$$$0(4);
        }
        HashSet<LocalFileSystem.WatchRequest> recursiveRequestsToRemove = new HashSet<LocalFileSystem.WatchRequest>();
        HashSet<LocalFileSystem.WatchRequest> flatRequestsToRemove = new HashSet<LocalFileSystem.WatchRequest>();
        requestsToRemove.forEach(req -> (req.isToWatchRecursively() ? recursiveRequestsToRemove : flatRequestsToRemove).add(req));
        HashSet<LocalFileSystem.WatchRequest> result2 = new HashSet<LocalFileSystem.WatchRequest>(recursiveRootsToAdd.size() + flatRootsToAdd.size());
        Object object = this.myLock;
        synchronized (object) {
            this.updateWatchRoots(recursiveRootsToAdd, recursiveRequestsToRemove, result2, this.myRecursiveWatchRoots, true);
            this.updateWatchRoots(flatRootsToAdd, flatRequestsToRemove, result2, this.myFlatWatchRoots, false);
            if (this.myWatcherRequiresUpdate) {
                this.updateFileWatcher();
            }
        }
        HashSet<LocalFileSystem.WatchRequest> hashSet = result2;
        if (hashSet == null) {
            WatchRootsManager.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myRecursiveWatchRoots.clear();
            this.myOptimizedRecursiveWatchRoots.clear();
            this.myFlatWatchRoots.clear();
            this.myPathMappings.clear();
            this.mySymlinksByPath.clear();
            this.mySymlinksById.values().forEach(SymlinkData::clear);
            this.mySymlinksById.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSymlink(int fileId, @NotNull String linkPath, @Nullable String linkTarget) {
        if (linkPath == null) {
            WatchRootsManager.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            SymlinkData oldDataById = (SymlinkData)this.mySymlinksById.get(fileId);
            SymlinkData oldDataByPath = (SymlinkData)this.mySymlinksByPath.get(linkPath);
            SymlinkData oldDataByOldPath = null;
            if (oldDataById != null) {
                if (FileUtil.pathsEqual((String)oldDataById.path, (String)linkPath) && FileUtil.pathsEqual((String)oldDataById.target, (String)linkTarget)) {
                    return;
                }
                this.mySymlinksById.remove(fileId);
                oldDataByOldPath = (SymlinkData)this.mySymlinksByPath.remove(oldDataById.path);
                oldDataById.removeRequest(this);
            }
            if (!WatchRootsManager.isDataConsistent(fileId, linkPath, linkTarget, oldDataById, oldDataByPath, oldDataByOldPath)) {
                if (oldDataByPath != null) {
                    this.mySymlinksByPath.remove(linkPath);
                    oldDataByPath.removeRequest(this);
                }
                return;
            }
            SymlinkData newData = new SymlinkData(fileId, linkPath, linkTarget);
            this.mySymlinksByPath.put(newData.path, newData);
            this.mySymlinksById.put(newData.id, (Object)newData);
            if (newData.hasValidTarget() && WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, newData.path)) {
                this.addWatchSymlinkRequest(newData.getWatchRequest());
            }
        }
    }

    private static boolean isDataConsistent(int fileId, @NotNull String linkPath, @Nullable String linkTarget, @Nullable SymlinkData oldDataById, @Nullable SymlinkData oldDataByNewPath, @Nullable SymlinkData oldDataByOldPath) {
        if (linkPath == null) {
            WatchRootsManager.$$$reportNull$$$0(7);
        }
        if (oldDataById != null && oldDataByNewPath == null) {
            if (!FileUtil.pathsEqual((String)oldDataById.path, (String)linkPath)) {
                LOG.error("Symlink update is inconsistent: likely missed move/rename. Existing symlink data by id: \n" + String.valueOf(oldDataById) + "\nexisting symlink data by new path[" + linkPath + "]: {null}\nexisting symlink data by old path[" + oldDataById.path + "]:\n" + String.valueOf(oldDataByOldPath) + "\nincoming symlink: \n{#" + fileId + ", " + linkPath + " -> " + linkTarget + "}, default caseSensitivity: " + SystemInfoRt.isFileSystemCaseSensitive);
            } else {
                assert (oldDataByOldPath == null) : "oldDataByOldPath(=" + String.valueOf(oldDataByOldPath) + ") must be null here";
                LOG.error("Symlink update is inconsistent: missed update? Existing symlink data by id: \n" + String.valueOf(oldDataById) + "\n != existing symlink data by new path[" + linkPath + "]: {null}\nexisting symlink data by old path[" + oldDataById.path + "]: {null}\nincoming symlink: \n{#" + fileId + ", " + linkPath + " -> " + linkTarget + "}, default caseSensitivity: " + SystemInfoRt.isFileSystemCaseSensitive);
            }
            return true;
        }
        if (oldDataById != oldDataByNewPath) {
            if (oldDataById == null) {
                LOG.error("Symlink update is inconsistent. Existing symlink data by id: {null}\n != existing symlink data by new path[" + linkPath + "]:\n" + String.valueOf(oldDataByNewPath) + "\nexisting symlink data by old path:\n" + String.valueOf(oldDataByOldPath) + "\nincoming symlink: \n{#" + fileId + ", " + linkPath + " -> " + linkTarget + "}, default caseSensitivity: " + SystemInfoRt.isFileSystemCaseSensitive);
            } else {
                LOG.error("Symlink update is inconsistent. Existing symlink data by id: \n" + String.valueOf(oldDataById) + "\n != existing symlink data by new path[" + linkPath + "]:\n" + String.valueOf(oldDataByNewPath) + "\nexisting symlink data by old path:\n" + String.valueOf(oldDataByOldPath) + "\nincoming symlink: \n{#" + fileId + ", " + linkPath + " -> " + linkTarget + "}, default caseSensitivity: " + SystemInfoRt.isFileSystemCaseSensitive);
            }
            return false;
        }
        if (oldDataByNewPath != null && !FileUtil.pathsEqual((String)oldDataByNewPath.path, (String)linkPath)) {
            LOG.error("Symlink update is inconsistent. Existing symlink data by id: \n" + String.valueOf(oldDataById) + "\n == existing symlink data by new path[" + linkPath + "]: \n" + String.valueOf(oldDataByNewPath) + "\nbut dataByPath.path != incoming linkPath.\nexisting symlink data by old path:\n" + String.valueOf(oldDataByOldPath) + "\nincoming symlink: \n{#" + fileId + ", " + linkPath + " -> " + linkTarget + "}, default caseSensitivity: " + SystemInfoRt.isFileSystemCaseSensitive);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSymlink(int fileId) {
        Object object = this.myLock;
        synchronized (object) {
            SymlinkData data2 = (SymlinkData)this.mySymlinksById.remove(fileId);
            if (data2 != null) {
                this.mySymlinksByPath.remove(data2.path);
                data2.removeRequest(this);
            }
        }
    }

    private void updateFileWatcher() {
        this.myFileWatcher.setWatchRoots(() -> {
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myWatcherRequiresUpdate) {
                    return null;
                }
                this.myWatcherRequiresUpdate = false;
                boolean convert = File.separatorChar == '\\';
                return WatchRootsManager.createCanonicalPathMap(this.myFlatWatchRoots.navigableKeySet(), this.myOptimizedRecursiveWatchRoots, this.myPathMappings, convert);
            }
        });
    }

    @VisibleForTesting
    @NotNull
    public static CanonicalPathMap createCanonicalPathMap(@NotNull Set<String> flatWatchRoots, @NotNull Set<String> optimizedRecursiveWatchRoots, @NotNull Collection<Pair<String, String>> pathMappings, boolean convertToForwardSlashes) {
        if (flatWatchRoots == null) {
            WatchRootsManager.$$$reportNull$$$0(8);
        }
        if (optimizedRecursiveWatchRoots == null) {
            WatchRootsManager.$$$reportNull$$$0(9);
        }
        if (pathMappings == null) {
            WatchRootsManager.$$$reportNull$$$0(10);
        }
        NavigableSet<@SystemDependent String> optimizedRecursiveWatchRootsCopy = WatchRootsUtil.createFileNavigableSet();
        ArrayList<Pair<@SystemDependent String, @SystemDependent String>> initialMappings = new ArrayList<Pair<String, String>>(pathMappings.size());
        if (!convertToForwardSlashes) {
            optimizedRecursiveWatchRootsCopy.addAll(optimizedRecursiveWatchRoots);
            initialMappings.addAll(pathMappings);
        } else {
            for (String string : optimizedRecursiveWatchRoots) {
                optimizedRecursiveWatchRootsCopy.add(string.replace('/', '\\'));
            }
            for (Pair pair : pathMappings) {
                initialMappings.add((Pair<String, String>)new Pair((Object)((String)pair.first).replace('/', '\\'), (Object)((String)pair.second).replace('/', '\\')));
            }
        }
        NavigableSet<@SystemDependent String> optimizedFlatWatchRoots = WatchRootsUtil.optimizeFlatRoots(flatWatchRoots, optimizedRecursiveWatchRootsCopy, convertToForwardSlashes);
        return new CanonicalPathMap(optimizedRecursiveWatchRootsCopy, optimizedFlatWatchRoots, initialMappings);
    }

    private void updateWatchRoots(@Unmodifiable Collection<String> rootsToAdd, Set<LocalFileSystem.WatchRequest> requestsToRemove, Set<LocalFileSystem.WatchRequest> result2, Map<String, List<LocalFileSystem.WatchRequest>> roots, boolean recursiveWatchRoots) {
        SmartList watchSymlinkRequestsToAdd = new SmartList();
        for (String root : rootsToAdd) {
            String watchRoot = WatchRootsManager.prepareWatchRoot(root);
            if (watchRoot == null) continue;
            List requests = roots.computeIfAbsent(watchRoot, __ -> new SmartList());
            boolean foundSameRequest = false;
            if (!requestsToRemove.isEmpty()) {
                for (LocalFileSystem.WatchRequest currentRequest : requests) {
                    if (!requestsToRemove.remove(currentRequest)) continue;
                    foundSameRequest = true;
                    result2.add(currentRequest);
                }
            }
            if (foundSameRequest) continue;
            WatchRequestImpl newRequest = new WatchRequestImpl(watchRoot, recursiveWatchRoots);
            requests.add(newRequest);
            result2.add(newRequest);
            if (recursiveWatchRoots) {
                this.collectSymlinkRequests(newRequest, (Collection<WatchSymlinkRequest>)watchSymlinkRequestsToAdd);
            }
            if (requests.size() != 1 || WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, watchRoot)) continue;
            this.myWatcherRequiresUpdate = true;
            if (!recursiveWatchRoots) continue;
            WatchRootsUtil.insertRecursivePath(this.myOptimizedRecursiveWatchRoots, watchRoot);
        }
        SmartList watchSymlinkRequestsToRemove = new SmartList();
        for (LocalFileSystem.WatchRequest request : requestsToRemove) {
            this.removeWatchRequest(request);
            if (!recursiveWatchRoots) continue;
            this.collectSymlinkRequests((WatchRequestImpl)request, (Collection<WatchSymlinkRequest>)watchSymlinkRequestsToRemove);
        }
        if (recursiveWatchRoots) {
            this.addWatchSymlinkRequests((List<WatchSymlinkRequest>)watchSymlinkRequestsToAdd);
            this.removeWatchSymlinkRequests((List<WatchSymlinkRequest>)watchSymlinkRequestsToRemove);
        }
    }

    @Nullable
    private static String prepareWatchRoot(String root) {
        int index = root.indexOf("!/");
        if (index >= 0) {
            root = root.substring(0, index);
        }
        try {
            Path rootPath = Path.of(FileUtil.toSystemDependentName((String)root), new String[0]);
            if (!rootPath.isAbsolute()) {
                throw new InvalidPathException(root, "Watch roots should be absolute");
            }
            WatchRootsManager.checkRootIsSane(rootPath);
            return FileUtil.toSystemIndependentName((String)rootPath.toString());
        }
        catch (InvalidPathException e) {
            LOG.warn("invalid watch root", (Throwable)e);
            return null;
        }
    }

    private static void checkRootIsSane(Path rootPath) {
        if (rootPath.startsWith("/proc")) {
            LOG.error("One shouldn't use [" + String.valueOf(rootPath) + "] as watch root");
        }
    }

    private void removeWatchRequest(LocalFileSystem.WatchRequest request) {
        String watchRoot = request.getRootPath();
        NavigableMap<String, List<LocalFileSystem.WatchRequest>> roots = request.isToWatchRecursively() ? this.myRecursiveWatchRoots : this.myFlatWatchRoots;
        List requests = (List)roots.get(watchRoot);
        if (requests != null) {
            requests.remove(request);
            if (requests.isEmpty()) {
                roots.remove(watchRoot);
                if (request.isToWatchRecursively()) {
                    if (WatchRootsUtil.removeRecursivePath(this.myOptimizedRecursiveWatchRoots, this.myRecursiveWatchRoots, watchRoot)) {
                        this.myWatcherRequiresUpdate = true;
                    }
                } else if (!WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, watchRoot)) {
                    this.myWatcherRequiresUpdate = true;
                }
            }
        }
    }

    private void addWatchSymlinkRequests(List<WatchSymlinkRequest> watchSymlinkRequestsToAdd) {
        for (WatchSymlinkRequest request : watchSymlinkRequestsToAdd) {
            if (request.getRootPath().isEmpty() || request.isRegistered()) continue;
            this.addWatchSymlinkRequest(request);
        }
    }

    private void addWatchSymlinkRequest(WatchSymlinkRequest request) {
        String watchRoot = request.getRootPath();
        NavigableMap<String, List<LocalFileSystem.WatchRequest>> roots = request.isToWatchRecursively() ? this.myRecursiveWatchRoots : this.myFlatWatchRoots;
        List requests = roots.computeIfAbsent(watchRoot, __ -> new SmartList());
        requests.add(request);
        if (requests.size() == 1 && !WatchRootsUtil.isCoveredRecursively(this.myOptimizedRecursiveWatchRoots, watchRoot) && request.isToWatchRecursively()) {
            WatchRootsUtil.insertRecursivePath(this.myOptimizedRecursiveWatchRoots, watchRoot);
        }
        if (request.setRegistered(true)) {
            this.myWatcherRequiresUpdate = true;
            this.myPathMappings.add((Pair<String, String>)new Pair((Object)watchRoot, (Object)request.getOriginalPath()));
        }
    }

    private void removeWatchSymlinkRequests(List<WatchSymlinkRequest> watchSymlinkRequestsToRemove) {
        for (WatchSymlinkRequest request : watchSymlinkRequestsToRemove) {
            Ref remove2 = new Ref((Object)true);
            WatchRootsUtil.forEachPathSegment(request.getOriginalPath(), '/', path -> {
                List requests = (List)this.myRecursiveWatchRoots.get(path);
                if (requests != null && ContainerUtil.findInstance((Iterable)requests, WatchRequestImpl.class) != null) {
                    remove2.set((Object)false);
                    return false;
                }
                return true;
            });
            if (!((Boolean)remove2.get()).booleanValue()) continue;
            this.removeWatchSymlinkRequest(request);
        }
    }

    private void removeWatchSymlinkRequest(WatchSymlinkRequest request) {
        if (!request.isRegistered()) {
            return;
        }
        this.removeWatchRequest(request);
        if (request.setRegistered(false)) {
            this.myPathMappings.remove(new Pair((Object)request.getRootPath(), (Object)request.getOriginalPath()));
            this.myWatcherRequiresUpdate = true;
        }
    }

    private void collectSymlinkRequests(WatchRequestImpl newRequest, Collection<WatchSymlinkRequest> watchSymlinkRequestsToAdd) {
        assert (newRequest.isToWatchRecursively()) : newRequest;
        WatchRootsUtil.collectByPrefix(this.mySymlinksByPath, newRequest.getRootPath(), e -> {
            if (((SymlinkData)e.getValue()).hasValidTarget()) {
                watchSymlinkRequestsToAdd.add(((SymlinkData)e.getValue()).getWatchRequest());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestsToRemove";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursiveRootsToAdd";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatRootsToAdd";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flatWatchRoots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optimizedRecursiveWatchRoots";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceWatchedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replaceWatchedRoots";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateSymlink";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDataConsistent";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCanonicalPathMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static final class SymlinkData {
        private final int id;
        private final @SystemIndependent String path;
        @Nullable
        private final @SystemIndependent String target;
        private WatchSymlinkRequest myWatchRequest;

        private SymlinkData(int id2, String path, @Nullable String target) {
            this.id = id2;
            this.path = FileUtil.toSystemIndependentName((String)path);
            this.target = target != null ? FileUtil.toSystemIndependentName((String)target) : null;
        }

        private WatchSymlinkRequest getWatchRequest() {
            assert (this.hasValidTarget());
            if (this.myWatchRequest == null) {
                this.myWatchRequest = new WatchSymlinkRequest(this, true);
            }
            return this.myWatchRequest;
        }

        private boolean hasValidTarget() {
            return this.target != null;
        }

        private void removeRequest(WatchRootsManager manager2) {
            if (this.myWatchRequest != null) {
                manager2.removeWatchSymlinkRequest(this.myWatchRequest);
                this.myWatchRequest = null;
            }
        }

        private void clear() {
            this.myWatchRequest = null;
        }

        public String toString() {
            return "SymlinkData{#" + this.id + ", " + this.path + " -> " + this.target + "}[" + (this.myWatchRequest == null ? "<empty>" : "<active>") + "]";
        }
    }

    private static final class WatchSymlinkRequest
    implements LocalFileSystem.WatchRequest {
        private final SymlinkData mySymlinkData;
        private final boolean myWatchRecursively;
        private boolean myRegistered = false;

        private WatchSymlinkRequest(SymlinkData data2, boolean watchRecursively) {
            this.mySymlinkData = data2;
            assert (this.mySymlinkData.hasValidTarget());
            this.myWatchRecursively = watchRecursively;
        }

        private boolean isRegistered() {
            return this.myRegistered;
        }

        private boolean setRegistered(boolean registered) {
            if (this.myRegistered != registered) {
                this.myRegistered = registered;
                return true;
            }
            return false;
        }

        @NotNull
        public @SystemIndependent String getRootPath() {
            String string = Objects.requireNonNull(this.mySymlinkData.target);
            if (string == null) {
                WatchSymlinkRequest.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isToWatchRecursively() {
            return this.myWatchRecursively;
        }

        String getOriginalPath() {
            return this.mySymlinkData.path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/local/WatchRootsManager$WatchSymlinkRequest", "getRootPath"));
        }
    }

    private static final class WatchRequestImpl
    implements LocalFileSystem.WatchRequest {
        private final String myFSRootPath;
        private final boolean myWatchRecursively;

        private WatchRequestImpl(@NotNull String rootPath, boolean watchRecursively) {
            if (rootPath == null) {
                WatchRequestImpl.$$$reportNull$$$0(0);
            }
            this.myFSRootPath = rootPath;
            this.myWatchRecursively = watchRecursively;
        }

        @NotNull
        public @SystemIndependent String getRootPath() {
            String string = this.myFSRootPath;
            if (string == null) {
                WatchRequestImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isToWatchRecursively() {
            return this.myWatchRecursively;
        }

        public String toString() {
            return this.getRootPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager$WatchRequestImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/local/WatchRootsManager$WatchRequestImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

