/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.dev;

import com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArray;
import com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayKt;
import java.io.Flushable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u001c\u0010\u000f\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArrayImpl;", "Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray;", "path", "Ljava/nio/file/Path;", "mode", "Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray$Companion$OpenMode;", "layoutHandler", "Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArrayImpl$Companion$LayoutHandler;", "storedInSecondInstance", "", "currentState", "", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArray$Companion$OpenMode;Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArrayImpl$Companion$LayoutHandler;Z[B)V", "getLastSnapshot", "commitChange", "modify", "Lkotlin/Function1;", "", "close", "toString", "", "Companion", "intellij.platform.ide.impl"})
final class DurablePersistentByteArrayImpl
implements DurablePersistentByteArray {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path path;
    @NotNull
    private final DurablePersistentByteArray.Companion.OpenMode mode;
    @NotNull
    private final Companion.LayoutHandler layoutHandler;
    private volatile boolean storedInSecondInstance;
    @Nullable
    private volatile byte[] currentState;
    public static final int LAYOUT_VERSION = 1;

    public DurablePersistentByteArrayImpl(@NotNull Path path, @NotNull DurablePersistentByteArray.Companion.OpenMode mode, @NotNull Companion.LayoutHandler layoutHandler, boolean storedInSecondInstance, @Nullable byte[] currentState) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)layoutHandler, (String)"layoutHandler");
        this.path = path;
        this.mode = mode;
        this.layoutHandler = layoutHandler;
        this.storedInSecondInstance = storedInSecondInstance;
        this.currentState = currentState;
    }

    @Override
    @NotNull
    public byte[] getLastSnapshot() {
        byte[] byArray;
        block3: {
            block2: {
                byArray = this.currentState;
                if (this.currentState == null) break block2;
                byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
                byArray = byArray2;
                if (byArray2 != null) break block3;
            }
            throw new IllegalStateException(this + " is already closed");
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] commitChange(@NotNull Function1<? super byte[], Unit> modify) {
        Intrinsics.checkNotNullParameter(modify, (String)"modify");
        DurablePersistentByteArrayImpl durablePersistentByteArrayImpl = this;
        synchronized (durablePersistentByteArrayImpl) {
            boolean bl = false;
            if (this.mode == DurablePersistentByteArray.Companion.OpenMode.Read) {
                throw new IllegalAccessError(this + " is opened in read-only mode");
            }
            Intrinsics.checkNotNull((Object)this.currentState);
            byte[] byArray = Arrays.copyOf(this.currentState, this.currentState.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            byte[] newState = byArray;
            modify.invoke((Object)newState);
            boolean useSecondInstanceForNewState = !this.storedInSecondInstance;
            this.layoutHandler.writeCheckSum(160159261748363264L, useSecondInstanceForNewState);
            this.layoutHandler.writeState(newState, useSecondInstanceForNewState);
            this.layoutHandler.flush();
            this.layoutHandler.writeCheckSum(DurablePersistentByteArrayKt.access$getCheckSum(newState), useSecondInstanceForNewState);
            this.layoutHandler.writeCurrentInstance(useSecondInstanceForNewState ? 0x2B2B2B2 : 0x1A1A1A1A);
            this.layoutHandler.flush();
            this.storedInSecondInstance = useSecondInstanceForNewState;
            this.currentState = newState;
            byte[] byArray2 = Arrays.copyOf(newState, newState.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
            byte[] byArray3 = byArray2;
            return byArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        DurablePersistentByteArrayImpl durablePersistentByteArrayImpl = this;
        synchronized (durablePersistentByteArrayImpl) {
            boolean bl = false;
            try {
                this.layoutHandler.close();
            }
            finally {
                this.currentState = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public String toString() {
        return "DurablePersistentByteArray(path=" + this.path + ", mode=" + this.mode + ", size=" + this.layoutHandler.getStateSize() + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u000e\u001a\u00020\u0005*\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u000f\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u0011\u001a\u00020\f*\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\u0012\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArrayImpl$Companion;", "", "<init>", "()V", "LAYOUT_VERSION", "", "readFully", "", "Ljava/nio/channels/FileChannel;", "buf", "Ljava/nio/ByteBuffer;", "offset", "", "writeFully", "readInt", "writeInt", "value", "readLong", "writeLong", "LayoutHandler", "CompactLayoutBuilder", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nDurablePersistentByteArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DurablePersistentByteArray.kt\ncom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArrayImpl$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,390:1\n1#2:391\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void readFully(FileChannel $this$readFully, ByteBuffer buf, long offset) {
            $this$readFully.position(offset);
            while (buf.hasRemaining()) {
                if ($this$readFully.read(buf) >= 0) continue;
                boolean bl = false;
                String string = $this$readFully + ": read has failed (EOF)";
                throw new IllegalStateException(string.toString());
            }
        }

        private final void writeFully(FileChannel $this$writeFully, ByteBuffer buf, long offset) {
            $this$writeFully.position(offset);
            while (buf.hasRemaining()) {
                $this$writeFully.write(buf);
            }
        }

        private final int readInt(FileChannel $this$readInt, long offset) {
            ByteBuffer $this$readInt_u24lambda_u240 = ByteBuffer.allocate(4);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$readInt_u24lambda_u240);
            Companion.readFully($this$readInt, $this$readInt_u24lambda_u240, offset);
            return $this$readInt_u24lambda_u240.getInt(0);
        }

        private final void writeInt(FileChannel $this$writeInt, int value, long offset) {
            ByteBuffer $this$writeInt_u24lambda_u240 = ByteBuffer.allocate(4);
            boolean bl = false;
            $this$writeInt_u24lambda_u240.putInt(0, value);
            Intrinsics.checkNotNull((Object)$this$writeInt_u24lambda_u240);
            Companion.writeFully($this$writeInt, $this$writeInt_u24lambda_u240, offset);
        }

        private final long readLong(FileChannel $this$readLong, long offset) {
            ByteBuffer $this$readLong_u24lambda_u240 = ByteBuffer.allocate(8);
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$readLong_u24lambda_u240);
            Companion.readFully($this$readLong, $this$readLong_u24lambda_u240, offset);
            return $this$readLong_u24lambda_u240.getLong(0);
        }

        private final void writeLong(FileChannel $this$writeLong, long value, long offset) {
            ByteBuffer $this$writeLong_u24lambda_u240 = ByteBuffer.allocate(8);
            boolean bl = false;
            $this$writeLong_u24lambda_u240.putLong(0, value);
            Intrinsics.checkNotNull((Object)$this$writeLong_u24lambda_u240);
            Companion.writeFully($this$writeLong, $this$writeLong_u24lambda_u240, offset);
        }

        public static final /* synthetic */ void access$writeFully(Companion $this, FileChannel $receiver, ByteBuffer buf, long offset) {
            $this.writeFully($receiver, buf, offset);
        }

        public static final /* synthetic */ void access$writeInt(Companion $this, FileChannel $receiver, int value, long offset) {
            $this.writeInt($receiver, value, offset);
        }

        public static final /* synthetic */ void access$writeLong(Companion $this, FileChannel $receiver, long value, long offset) {
            $this.writeLong($receiver, value, offset);
        }

        public static final /* synthetic */ int access$readInt(Companion $this, FileChannel $receiver, long offset) {
            return $this.readInt($receiver, offset);
        }

        public static final /* synthetic */ long access$readLong(Companion $this, FileChannel $receiver, long offset) {
            return $this.readLong($receiver, offset);
        }

        public static final /* synthetic */ void access$readFully(Companion $this, FileChannel $receiver, ByteBuffer buf, long offset) {
            $this.readFully($receiver, buf, offset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArrayImpl$Companion$CompactLayoutBuilder;", "", "<init>", "()V", "HEADER_OFFSET", "", "VERSION_OFFSET", "SIZE_OFFSET", "CURRENT_INSTANCE_OFFSET", "RESERVED_OFFSET__", "CHECKSUM_FIRST_OFFSET", "CHECKSUM_SECOND_OFFSET", "HEADER_SIZE", "maxStateSize", "getMaxStateSize", "()I", "getFullSize", "stateSize", "buildLayout", "Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArrayImpl$Companion$LayoutHandler;", "fileHandler", "Ljava/nio/channels/FileChannel;", "intellij.platform.ide.impl"})
        public static final class CompactLayoutBuilder {
            @NotNull
            public static final CompactLayoutBuilder INSTANCE = new CompactLayoutBuilder();
            public static final int HEADER_OFFSET = 0;
            public static final int VERSION_OFFSET = 0;
            public static final int SIZE_OFFSET = 4;
            public static final int CURRENT_INSTANCE_OFFSET = 8;
            public static final int RESERVED_OFFSET__ = 12;
            public static final int CHECKSUM_FIRST_OFFSET = 16;
            public static final int CHECKSUM_SECOND_OFFSET = 24;
            public static final int HEADER_SIZE = 64;

            private CompactLayoutBuilder() {
            }

            public final int getMaxStateSize() {
                return 0x3FFFFFDF;
            }

            public final int getFullSize(int stateSize) {
                return 64 + 2 * stateSize;
            }

            @NotNull
            public final LayoutHandler buildLayout(@NotNull FileChannel fileHandler, int stateSize) {
                Intrinsics.checkNotNullParameter((Object)fileHandler, (String)"fileHandler");
                return new LayoutHandler(stateSize, fileHandler){
                    private final int stateSize;
                    private final int fullSize;
                    final /* synthetic */ FileChannel $fileHandler;
                    {
                        this.$fileHandler = $fileHandler;
                        this.stateSize = $stateSize;
                        this.fullSize = CompactLayoutBuilder.INSTANCE.getFullSize($stateSize);
                    }

                    public int getStateSize() {
                        return this.stateSize;
                    }

                    public int getFullSize() {
                        return this.fullSize;
                    }

                    public int getLayoutVersion() {
                        return 1;
                    }

                    public void writeHeader(int version, int size2, int currentInstance, long checkSumFirst, long checkSumSecond) {
                        ByteBuffer buf = ByteBuffer.allocate(64);
                        buf.putInt(0, version);
                        buf.putInt(4, size2);
                        buf.putInt(8, currentInstance);
                        buf.putLong(16, checkSumFirst);
                        buf.putLong(24, checkSumSecond);
                        Intrinsics.checkNotNull((Object)buf);
                        com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayImpl$Companion.access$writeFully(DurablePersistentByteArrayImpl.Companion, this.$fileHandler, buf, 0L);
                    }

                    public void writeCurrentInstance(int currentInstance) {
                        com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayImpl$Companion.access$writeInt(DurablePersistentByteArrayImpl.Companion, this.$fileHandler, currentInstance, 8L);
                    }

                    public void writeCheckSum(long checkSum, boolean secondInstance) {
                        com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayImpl$Companion.access$writeLong(DurablePersistentByteArrayImpl.Companion, this.$fileHandler, checkSum, secondInstance ? 24 : 16);
                    }

                    public void writeState(byte[] state2, boolean secondInstance) {
                        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
                        ByteBuffer byteBuffer = ByteBuffer.wrap(state2);
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
                        com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayImpl$Companion.access$writeFully(DurablePersistentByteArrayImpl.Companion, this.$fileHandler, byteBuffer, 64L + (long)(secondInstance ? state2.length : 0));
                    }

                    public int readVersion() {
                        return com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayImpl$Companion.access$readInt(DurablePersistentByteArrayImpl.Companion, this.$fileHandler, 0L);
                    }

                    public int readSize() {
                        return com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayImpl$Companion.access$readInt(DurablePersistentByteArrayImpl.Companion, this.$fileHandler, 4L);
                    }

                    public int readCurrentInstance() {
                        return com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayImpl$Companion.access$readInt(DurablePersistentByteArrayImpl.Companion, this.$fileHandler, 8L);
                    }

                    public long readCheckSum(boolean secondInstance) {
                        return com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayImpl$Companion.access$readLong(DurablePersistentByteArrayImpl.Companion, this.$fileHandler, secondInstance ? 24 : 16);
                    }

                    public byte[] readState(int size2, boolean secondInstance) {
                        byte[] byArray = new byte[size2];
                        FileChannel fileChannel = this.$fileHandler;
                        byte[] $this$readState_u24lambda_u240 = byArray;
                        boolean bl = false;
                        ByteBuffer byteBuffer = ByteBuffer.wrap($this$readState_u24lambda_u240);
                        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
                        com.intellij.openapi.vfs.newvfs.persistent.dev.DurablePersistentByteArrayImpl$Companion.access$readFully(DurablePersistentByteArrayImpl.Companion, fileChannel, byteBuffer, 64L + (long)(secondInstance ? size2 : 0));
                        return $this$readState_u24lambda_u240;
                    }

                    public void flush() {
                        this.$fileHandler.force(true);
                    }

                    public void close() {
                        this.$fileHandler.close();
                    }
                };
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\b`\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H&J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005H&J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H&J\b\u0010\u001c\u001a\u00020\u0005H&J\b\u0010\u001d\u001a\u00020\u0005H&J\b\u0010\u001e\u001a\u00020\u0005H&J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0012\u0010\n\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006!\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vfs/newvfs/persistent/dev/DurablePersistentByteArrayImpl$Companion$LayoutHandler;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Ljava/io/Flushable;", "stateSize", "", "getStateSize", "()I", "fullSize", "getFullSize", "layoutVersion", "getLayoutVersion", "writeHeader", "", "version", "size", "currentInstance", "checkSumFirst", "", "checkSumSecond", "writeCurrentInstance", "writeCheckSum", "checkSum", "secondInstance", "", "writeState", "state", "", "readVersion", "readSize", "readCurrentInstance", "readCheckSum", "readState", "intellij.platform.ide.impl"})
        public static interface LayoutHandler
        extends AutoCloseable,
        Flushable {
            public int getStateSize();

            public int getFullSize();

            public int getLayoutVersion();

            public void writeHeader(int var1, int var2, int var3, long var4, long var6);

            public void writeCurrentInstance(int var1);

            public void writeCheckSum(long var1, boolean var3);

            public void writeState(@NotNull byte[] var1, boolean var2);

            public int readVersion();

            public int readSize();

            public int readCurrentInstance();

            public long readCheckSum(boolean var1);

            @NotNull
            public byte[] readState(int var1, boolean var2);
        }
    }
}

