/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.impl.FocusRequestInfo;
import com.intellij.platform.locking.impl.IntelliJLockingUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FocusManagerImpl
extends IdeFocusManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FocusManagerImpl.class);
    public static final Logger FOCUS_REQUESTS_LOG = Logger.getInstance((String)"jb.focus.requests");
    private final List<FocusRequestInfo> myRequests = new LinkedList<FocusRequestInfo>();
    private final Map<Window, Component> myLastFocused = ContainerUtil.createWeakKeyWeakValueMap();
    private final Map<Window, Component> myLastFocusedAtDeactivation = ContainerUtil.createWeakKeyWeakValueMap();
    private DataContext myRunContext;
    private IdeFrame myLastFocusedFrame;

    public FocusManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().simpleConnect().subscribe(ApplicationActivationListener.TOPIC, (Object)new AppListener());
        StartupUiUtil.addAwtListener((long)68L, (Disposable)this, e -> {
            if (e instanceof FocusEvent) {
                FocusEvent fe = (FocusEvent)e;
                Component c = fe.getComponent();
                if (c instanceof Window || c == null) {
                    return;
                }
                Component parent = ComponentUtil.findUltimateParent((Component)c);
                if (parent instanceof IdeFrame) {
                    LOG.assertTrue(parent instanceof Window);
                    this.myLastFocused.put((Window)parent, c);
                }
            } else if (e instanceof WindowEvent) {
                Window window1 = ((WindowEvent)e).getWindow();
                if (e.getID() == 202 && window1 instanceof IdeFrame) {
                    this.myLastFocused.remove(window1);
                    this.myLastFocusedAtDeactivation.remove(window1);
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusedWindow", event -> {
            Object value = event.getNewValue();
            if (value instanceof IdeFrame) {
                LOG.assertTrue(value instanceof Window);
                this.myLastFocusedFrame = (IdeFrame)value;
            } else {
                Window window = this.getLastFocusedIdeWindow();
                if (window != null && !window.isVisible()) {
                    this.myLastFocusedFrame = null;
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(event -> {
            if (FOCUS_REQUESTS_LOG.isDebugEnabled()) {
                FOCUS_REQUESTS_LOG.debug(event.getPropertyName() + "=" + String.valueOf(event.getNewValue()));
            }
        });
    }

    public IdeFrame getLastFocusedFrame() {
        return this.myLastFocusedFrame;
    }

    @Nullable
    public Window getLastFocusedIdeWindow() {
        return (Window)this.myLastFocusedFrame;
    }

    @DirtyUI
    public ActionCallback requestFocusInProject(@NotNull Component c, @Nullable Project project2) {
        Project activeProject;
        if (c == null) {
            FocusManagerImpl.$$$reportNull$$$0(0);
        }
        if ((activeProject = ProjectUtil.getActiveProject()) != null) {
            if (project2 == null) {
                project2 = ProjectUtil.getProjectForComponent(c);
            }
            if (project2 == activeProject) {
                FocusManagerImpl.logFocusRequest(c, project2, false);
                this.toFrontImpl(c);
                c.requestFocus();
                return ActionCallback.DONE;
            }
        }
        FocusManagerImpl.logFocusRequest(c, project2, true);
        c.requestFocusInWindow();
        return ActionCallback.DONE;
    }

    @NotNull
    public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
        if (c == null) {
            FocusManagerImpl.$$$reportNull$$$0(1);
        }
        FocusManagerImpl.logFocusRequest(c, null, false);
        c.requestFocus();
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            FocusManagerImpl.$$$reportNull$$$0(2);
        }
        return actionCallback;
    }

    @NotNull
    public List<FocusRequestInfo> getRequests() {
        List<FocusRequestInfo> list2 = this.myRequests;
        if (list2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void recordFocusRequest(Component c, boolean forced) {
        this.myRequests.add(new FocusRequestInfo(c, new Throwable(), forced));
        if (this.myRequests.size() > 200) {
            this.myRequests.remove(0);
        }
    }

    public static IdeFocusManager getInstance() {
        return (IdeFocusManager)ApplicationManager.getApplication().getService(IdeFocusManager.class);
    }

    @DirtyUI
    public void dispose() {
    }

    public void doWhenFocusSettlesDown(@NotNull ExpirableRunnable runnable2) {
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(4);
        }
        this.doWhenFocusSettlesDown((Runnable)runnable2);
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(5);
        }
        this.doWhenFocusSettlesDown(runnable2, ModalityState.defaultModalityState());
    }

    public void doWhenFocusSettlesDown(@NotNull Runnable runnable2, @NotNull ModalityState modality) {
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(6);
        }
        if (modality == null) {
            FocusManagerImpl.$$$reportNull$$$0(7);
        }
        AtomicBoolean immediate = new AtomicBoolean(true);
        EdtInvocationManager.invokeLaterIfNeeded((Runnable)((ContextAwareRunnable)() -> {
            if (immediate.get()) {
                boolean expired;
                boolean bl = expired = runnable2 instanceof ExpirableRunnable && ((ExpirableRunnable)runnable2).isExpired();
                if (!expired) {
                    IntelliJLockingUtil.getGlobalThreadingSupport().runPreventiveWriteIntentReadAction(() -> {
                        runnable2.run();
                        return null;
                    });
                }
            } else {
                ApplicationManager.getApplication().invokeLater((Runnable)((ContextAwareRunnable)() -> this.doWhenFocusSettlesDown(runnable2, modality)), modality);
            }
        }));
        immediate.set(false);
    }

    @DirtyUI
    public Component getFocusOwner() {
        FocusManagerImpl.assertDispatchThread();
        Component result2 = null;
        if (!ApplicationManager.getApplication().isActive()) {
            IdeFrame frame = this.getLastFocusedFrame();
            if (frame != null) {
                LOG.assertTrue(frame instanceof Window);
                result2 = this.myLastFocusedAtDeactivation.get(frame);
            }
        } else if (this.myRunContext != null) {
            result2 = (Component)this.myRunContext.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        }
        if (result2 == null) {
            result2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (result2 == null) {
            Component permOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (permOwner != null) {
                result2 = permOwner;
            }
            if (ComponentUtil.isMeaninglessFocusOwner((Component)result2)) {
                result2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            }
        }
        return result2;
    }

    @DirtyUI
    public void runOnOwnContext(@NotNull DataContext context, @NotNull Runnable runnable2) {
        if (context == null) {
            FocusManagerImpl.$$$reportNull$$$0(8);
        }
        if (runnable2 == null) {
            FocusManagerImpl.$$$reportNull$$$0(9);
        }
        FocusManagerImpl.assertDispatchThread();
        this.myRunContext = context;
        try {
            runnable2.run();
        }
        finally {
            this.myRunContext = null;
        }
    }

    public Component getLastFocusedFor(@Nullable Window frame) {
        FocusManagerImpl.assertDispatchThread();
        if (frame == null) {
            return null;
        }
        return this.myLastFocused.get(frame);
    }

    public void setLastFocusedAtDeactivation(@NotNull Window frame, @NotNull Component c) {
        if (frame == null) {
            FocusManagerImpl.$$$reportNull$$$0(10);
        }
        if (c == null) {
            FocusManagerImpl.$$$reportNull$$$0(11);
        }
        this.myLastFocusedAtDeactivation.put(frame, c);
    }

    public void toFront(JComponent c) {
        this.toFrontImpl(c);
    }

    private void toFrontImpl(Component c) {
        FocusManagerImpl.assertDispatchThread();
        if (c == null) {
            return;
        }
        Window window = (Window)ComponentUtil.getParentOfType(Window.class, (Component)c);
        if (window != null && window.isShowing()) {
            this.doWhenFocusSettlesDown(() -> {
                if (ApplicationManager.getApplication().isActive()) {
                    if (window instanceof JFrame && ((JFrame)window).getState() == 1) {
                        ((JFrame)window).setState(0);
                    } else {
                        window.toFront();
                    }
                }
            });
        }
    }

    public JComponent getFocusTargetFor(@NotNull JComponent comp) {
        if (comp == null) {
            FocusManagerImpl.$$$reportNull$$$0(12);
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(comp);
    }

    public Component getFocusedDescendantFor(@NotNull Component comp) {
        Component focused;
        if (comp == null) {
            FocusManagerImpl.$$$reportNull$$$0(13);
        }
        if ((focused = this.getFocusOwner()) == null) {
            return null;
        }
        if (focused == comp || SwingUtilities.isDescendingFrom(focused, comp)) {
            return focused;
        }
        List<JBPopup> popups = AbstractPopup.getChildPopups(comp);
        for (JBPopup each : popups) {
            if (!each.isFocused()) continue;
            return focused;
        }
        return null;
    }

    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        Component toFocus = null;
        IdeFrame lastFocusedFrame = this.myLastFocusedFrame;
        if (lastFocusedFrame == null) {
            for (Window window : Window.getWindows()) {
                if (!(window instanceof RootPaneContainer) || ((RootPaneContainer)((Object)window)).getRootPane() == null || !window.isActive()) continue;
                JComponent toFocusOptional = this.getFocusTargetFor(((RootPaneContainer)((Object)window)).getRootPane());
                if (toFocusOptional != null) {
                    toFocus = toFocusOptional;
                }
                break;
            }
        } else {
            LOG.assertTrue(lastFocusedFrame instanceof Window);
            toFocus = this.myLastFocused.get(lastFocusedFrame);
            if (toFocus == null || !toFocus.isShowing()) {
                toFocus = this.getFocusTargetFor(lastFocusedFrame.getComponent());
            }
        }
        if (toFocus != null) {
            ActionCallback actionCallback = this.requestFocusInProject(toFocus, null);
            if (actionCallback == null) {
                FocusManagerImpl.$$$reportNull$$$0(14);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            FocusManagerImpl.$$$reportNull$$$0(15);
        }
        return actionCallback;
    }

    public boolean isFocusTransferEnabled() {
        return Registry.is((String)"focus.fix.lost.cursor", (boolean)false) || ApplicationManager.getApplication().isActive() || !Registry.is((String)"actionSystem.suspendFocusTransferIfApplicationInactive", (boolean)true);
    }

    private static void assertDispatchThread() {
        if (Registry.is((String)"actionSystem.assertFocusAccessFromEdt", (boolean)true)) {
            EDT.assertIsEdt();
        }
    }

    private static void logFocusRequest(@NotNull Component c, @Nullable Project project2, boolean inWindow) {
        if (c == null) {
            FocusManagerImpl.$$$reportNull$$$0(16);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("inWindow = %s, project = %s, component = %s", inWindow, project2, c), new Throwable());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/FocusManagerImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/FocusManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "requestFocus";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequests";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "requestDefaultFocus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestFocusInProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "requestFocus";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doWhenFocusSettlesDown";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runOnOwnContext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setLastFocusedAtDeactivation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFocusTargetFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFocusedDescendantFor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logFocusRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 14, 15 -> new IllegalStateException(string);
        };
    }

    private final class AppListener
    implements ApplicationActivationListener {
        private AppListener() {
        }

        public void delayedApplicationDeactivated(@NotNull Window ideFrame) {
            Component owner;
            if (ideFrame == null) {
                AppListener.$$$reportNull$$$0(0);
            }
            if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null && ComponentUtil.findUltimateParent((Component)owner) == ideFrame) {
                FocusManagerImpl.this.myLastFocusedAtDeactivation.put(ideFrame, owner);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/openapi/wm/impl/FocusManagerImpl$AppListener", "delayedApplicationDeactivated"));
        }
    }
}

