/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.help.impl.HelpManagerImpl;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.wm.impl.status.AnalyzingBannerDecoratorKt;
import com.intellij.openapi.wm.impl.status.ProcessPopup;
import com.intellij.openapi.wm.impl.status.ProgressComponent;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.InlineBanner;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0011J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/wm/impl/status/AnalyzingBannerDecorator;", "", "panel", "Ljavax/swing/JPanel;", "onBannerClose", "Ljava/lang/Runnable;", "<init>", "(Ljavax/swing/JPanel;Ljava/lang/Runnable;)V", "analyzingComponent", "Ljava/awt/Component;", "banner", "indicatorAdded", "", "indicator", "Lcom/intellij/openapi/wm/impl/status/ProgressComponent;", "indicatorRemoved", "isShowing", "", "handlePopupClose", "getBannerHeight", "", "isBannerPresent", "createBanner", "revalidatePanel", "intellij.platform.ide.impl"})
public final class AnalyzingBannerDecorator {
    @NotNull
    private final JPanel panel;
    @Nullable
    private Component analyzingComponent;
    @NotNull
    private final Component banner;

    public AnalyzingBannerDecorator(@NotNull JPanel panel2, @NotNull Runnable onBannerClose) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)onBannerClose, (String)"onBannerClose");
        this.panel = panel2;
        this.banner = this.createBanner(onBannerClose);
    }

    public final void indicatorAdded(@NotNull ProgressComponent indicator2) {
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        if (AnalyzingBannerDecoratorKt.access$userClosedBanner()) {
            return;
        }
        if (this.analyzingComponent == null && AnalyzingBannerDecoratorKt.access$isAnalyzingIndicator(indicator2)) {
            this.analyzingComponent = indicator2.getComponent();
            this.panel.add(this.analyzingComponent, 0, 0);
            this.panel.add(this.banner, 1, 1);
        }
    }

    public final void indicatorRemoved(@NotNull ProgressComponent indicator2, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        if (AnalyzingBannerDecoratorKt.access$userClosedBanner()) {
            return;
        }
        if (Intrinsics.areEqual((Object)indicator2.getComponent(), (Object)this.analyzingComponent)) {
            this.analyzingComponent = null;
            if (!isShowing) {
                this.panel.remove(this.banner);
            }
        }
    }

    public final void handlePopupClose() {
        if (this.analyzingComponent != null) {
            return;
        }
        this.panel.remove(this.banner);
    }

    public final int getBannerHeight() {
        Serializable serializable = this.analyzingComponent;
        return this.banner.getPreferredSize().height + (serializable != null && (serializable = serializable.getPreferredSize()) != null ? ((Dimension)serializable).height : 0) + JBUI.scale((int)28);
    }

    public final boolean isBannerPresent() {
        Component[] componentArray = this.panel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        return ArraysKt.contains((Object[])componentArray, (Object)this.banner);
    }

    private final Component createBanner(Runnable revalidatePanel) {
        BorderLayoutPanel borderLayoutPanel;
        InlineBanner inlineBanner;
        InlineBanner $this$createBanner_u24lambda_u240 = inlineBanner = new InlineBanner(null, null, 3, null);
        boolean bl = false;
        String string = IndexingBundle.message((String)"progress.indexing.banner.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createBanner_u24lambda_u240.setMessage(string);
        String string2 = IdeBundle.message((String)"link.learn.more", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$createBanner_u24lambda_u240.addAction(string2, AnalyzingBannerDecorator::createBanner$lambda$0$0);
        if (ExperimentalUI.Companion.isNewUI()) {
            $this$createBanner_u24lambda_u240.setOpaque(false);
        }
        $this$createBanner_u24lambda_u240.setCloseAction(() -> AnalyzingBannerDecorator.createBanner$lambda$0$1(this, revalidatePanel));
        InlineBanner banner = inlineBanner;
        BorderLayoutPanel $this$createBanner_u24lambda_u241 = borderLayoutPanel = JBUI.Panels.simplePanel((Component)((Component)banner));
        boolean bl2 = false;
        $this$createBanner_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        ProcessPopup.hideSeparator((Component)$this$createBanner_u24lambda_u241);
        if (ExperimentalUI.Companion.isNewUI()) {
            $this$createBanner_u24lambda_u241.setOpaque(false);
        }
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel;
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"apply(...)");
        BorderLayoutPanel panel2 = borderLayoutPanel2;
        return (Component)panel2;
    }

    private static final void createBanner$lambda$0$0() {
        String url = HelpManagerImpl.getHelpUrl("Indexing");
        if (url != null) {
            BrowserUtil.browse((String)url);
        }
    }

    private static final void createBanner$lambda$0$1(AnalyzingBannerDecorator this$0, Runnable $revalidatePanel) {
        this$0.panel.remove(this$0.banner);
        PropertiesComponent.getInstance().setValue("USER_CLOSED_ANALYZING_BANNER_KEY", true);
        $revalidatePanel.run();
    }
}

