/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.EditorGotoLineNumberDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.TextWidgetPresentation;
import com.intellij.openapi.wm.WidgetPresentationDataContext;
import com.intellij.openapi.wm.impl.status.CodePointCountTask;
import com.intellij.openapi.wm.impl.status.EditorBasedWidgetHelper;
import com.intellij.ui.UIBundle;
import java.awt.event.MouseEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 &2\u00020\u0001:\u0001&B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0011\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00140\u0012H\u0016J\u000e\u0010\u001c\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u000e0 H\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0002J\u0015\u0010%\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lcom/intellij/openapi/wm/impl/status/PositionPanel;", "Lcom/intellij/openapi/wm/TextWidgetPresentation;", "dataContext", "Lcom/intellij/openapi/wm/WidgetPresentationDataContext;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "helper", "Lcom/intellij/openapi/wm/impl/status/EditorBasedWidgetHelper;", "<init>", "(Lcom/intellij/openapi/wm/WidgetPresentationDataContext;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/wm/impl/status/EditorBasedWidgetHelper;)V", "getHelper", "()Lcom/intellij/openapi/wm/impl/status/EditorBasedWidgetHelper;", "updateTextRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "charCountRequests", "Lcom/intellij/openapi/wm/impl/status/CodePointCountTask;", "text", "Lkotlinx/coroutines/flow/Flow;", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "alignment", "", "getAlignment", "()F", "gotoShortcutText", "getGotoShortcutText", "()Ljava/lang/String;", "getTooltipText", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getShortcutText", "getClickConsumer", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "updatePosition", "editor", "Lcom/intellij/openapi/editor/Editor;", "getPositionText", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPositionPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionPanel.kt\ncom/intellij/openapi/wm/impl/status/PositionPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public class PositionPanel
implements TextWidgetPresentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WidgetPresentationDataContext dataContext;
    @NotNull
    private final EditorBasedWidgetHelper helper;
    @NotNull
    private final MutableSharedFlow<Unit> updateTextRequests;
    @NotNull
    private final MutableSharedFlow<CodePointCountTask> charCountRequests;
    @JvmField
    @NotNull
    public static final Key<Object> DISABLE_FOR_EDITOR = new Key("positionPanel.disableForEditor");
    @NotNull
    public static final String SPACE = "     ";
    @NotNull
    public static final String SEPARATOR = ":";
    private static final int CHAR_COUNT_SYNC_LIMIT = 500000;
    @NotNull
    private static final String CHAR_COUNT_UNKNOWN = "...";

    /*
     * WARNING - void declaration
     */
    public PositionPanel(@NotNull WidgetPresentationDataContext dataContext2, @NotNull CoroutineScope scope, @NotNull EditorBasedWidgetHelper helper) {
        void it;
        MutableSharedFlow mutableSharedFlow;
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        this.dataContext = dataContext2;
        this.helper = helper;
        MutableSharedFlow mutableSharedFlow2 = mutableSharedFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        PositionPanel positionPanel = this;
        boolean bl = false;
        it.tryEmit((Object)Unit.INSTANCE);
        positionPanel.updateTextRequests = mutableSharedFlow;
        this.charCountRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        EditorEventMulticaster editorEventMulticaster = EditorFactory.getInstance().getEventMulticaster();
        Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"getEventMulticaster(...)");
        EditorEventMulticaster multicaster = editorEventMulticaster;
        multicaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Editor editor2 = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                Editor editor3 = editor2;
                if (editor3.getCaretModel().getCaretCount() == 1) {
                    this.updatePosition(editor3);
                }
            }

            public void caretAdded(CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Editor editor2 = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                this.updatePosition(editor2);
            }

            public void caretRemoved(CaretEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Editor editor2 = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                this.updatePosition(editor2);
            }
        }, disposable2);
        multicaster.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Editor editor2 = e.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                this.updatePosition(editor2);
            }
        }, disposable2);
        multicaster.addDocumentListener((DocumentListener)new BulkAwareDocumentListener.Simple(){

            /*
             * WARNING - void declaration
             */
            public void afterDocumentChange(Document document2) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
                Stream stream = EditorFactory.getInstance().editors(document2);
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"editors(...)");
                Sequence sequence = StreamsKt.asSequence((Stream)stream);
                PositionPanel positionPanel = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Editor p0 = (Editor)element$iv;
                    boolean bl = false;
                    positionPanel.updatePosition(p0);
                }
            }
        }, disposable2);
        JobKt.getJob((CoroutineContext)scope.getCoroutineContext()).invokeOnCompletion(arg_0 -> PositionPanel._init_$lambda$0(disposable2, arg_0));
        if (!this.charCountRequests.tryEmit((Object)new CodePointCountTask("", 0, 0))) {
            throw new IllegalStateException("Check failed.");
        }
    }

    public /* synthetic */ PositionPanel(WidgetPresentationDataContext widgetPresentationDataContext, CoroutineScope coroutineScope, EditorBasedWidgetHelper editorBasedWidgetHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            editorBasedWidgetHelper = new EditorBasedWidgetHelper(widgetPresentationDataContext.getProject());
        }
        this(widgetPresentationDataContext, coroutineScope, editorBasedWidgetHelper);
    }

    @NotNull
    protected final EditorBasedWidgetHelper getHelper() {
        return this.helper;
    }

    @NotNull
    public Flow<String> text() {
        return FlowKt.flowCombine((Flow)FlowKt.mapLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)FlowKt.combine((Flow)((Flow)this.updateTextRequests), (Flow)((Flow)this.dataContext.getCurrentFileEditor()), (Function3)((Function3)new Function3<Unit, FileEditor, Continuation<? super Editor>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                FileEditor fileEditor = (FileEditor)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void fileEditor2;
                        ResultKt.throwOnFailure((Object)$result);
                        TextEditor textEditor = fileEditor2 instanceof TextEditor ? (TextEditor)fileEditor2 : null;
                        return textEditor != null ? textEditor.getEditor() : null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(Unit p1, FileEditor p2, Continuation<? super Editor> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        })), (long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<Editor, Continuation<? super String>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ PositionPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (Editor)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (editor != null && !PositionPanel.DISABLE_FOR_EDITOR.isIn((UserDataHolder)editor)) ** GOTO lbl9
                        v0 = null;
                        ** GOTO lbl19
lbl9:
                        // 1 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)editor);
                        this.label = 1;
                        v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.wm.impl.status.PositionPanel com.intellij.openapi.editor.Editor ), ()Ljava/lang/String;)((PositionPanel)this.this$0, (Editor)editor), (Continuation)((Continuation)this));
                        if (v1 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl18:
                        // 2 sources

                        v0 = (String)v1;
lbl19:
                        // 2 sources

                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Editor p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(PositionPanel this$0, Editor $editor) {
                return PositionPanel.access$getPositionText(this$0, $editor);
            }
        })), (Flow)FlowKt.mapLatest((Flow)((Flow)this.charCountRequests), (Function2)((Function2)new Function2<CodePointCountTask, Continuation<? super String>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CodePointCountTask codePointCountTask = (CodePointCountTask)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void task;
                        ResultKt.throwOnFailure((Object)$result);
                        return String.valueOf(Character.codePointCount(task.text, task.startOffset, task.endOffset));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CodePointCountTask p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (Function3)((Function3)new Function3<String, String, Continuation<? super String>, Object>(null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                String string = (String)this.L$0;
                String string2 = (String)this.L$1;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void charCount;
                        void text2;
                        ResultKt.throwOnFailure((Object)$result);
                        void v0 = text2;
                        return v0 != null ? StringsKt.replaceFirst$default((String)v0, (String)"...", (String)charCount, (boolean)false, (int)4, null) : null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(String p1, String p2, Continuation<? super String> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public float getAlignment() {
        return 0.5f;
    }

    private final String getGotoShortcutText() {
        String string = KeymapUtil.getFirstKeyboardShortcutText((String)"GotoLine");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFirstKeyboardShortcutText(...)");
        return string;
    }

    @Nullable
    public Object getTooltipText(@NotNull Continuation<? super String> $completion) {
        return PositionPanel.getTooltipText$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object getTooltipText$suspendImpl(PositionPanel $this, Continuation<? super String> $completion) {
        String string = UIBundle.message((String)"go.to.line.command.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String toolTip = string;
        String shortcut = $this.getGotoShortcutText();
        return ((CharSequence)shortcut).length() > 0 && !UISettings.Companion.isIdeHelpTooltipEnabled() ? toolTip + " (" + shortcut + ")" : toolTip;
    }

    @Nullable
    public Object getShortcutText(@NotNull Continuation<? super String> $completion) {
        return this.getGotoShortcutText();
    }

    @NotNull
    public Function1<MouseEvent, Unit> getClickConsumer() {
        return arg_0 -> PositionPanel.getClickConsumer$lambda$0(this, arg_0);
    }

    private final void updatePosition(Editor editor2) {
        Editor ourEditor;
        Object object = this.dataContext.getCurrentFileEditor().getValue();
        TextEditor textEditor = object instanceof TextEditor ? (TextEditor)object : null;
        Object object2 = ourEditor = textEditor != null ? textEditor.getEditor() : null;
        if (editor2 == ourEditor && !this.updateTextRequests.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    private final String getPositionText(Editor editor2) {
        if (editor2.isDisposed()) {
            return "";
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        int caretCount = caretModel2.getCaretCount();
        if (caretCount > 1) {
            Object[] objectArray = new Object[]{caretCount};
            String string = UIBundle.message((String)"position.panel.caret.count", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        StringBuilder message = new StringBuilder();
        Caret caret = caretModel2.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCurrentCaret(...)");
        Caret caret2 = caret;
        LogicalPosition logicalPosition = caret2.getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        message.append(logicalPosition2.line + 1).append(SEPARATOR).append(logicalPosition2.column + 1);
        if (!caret2.hasSelection()) {
            String string = message.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        int selectionStart = caret2.getSelectionStart();
        int selectionEnd = caret2.getSelectionEnd();
        if (selectionEnd <= selectionStart) {
            String string = message.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        message.append(" (");
        if (selectionEnd - selectionStart < 500000) {
            int charCount = Character.codePointCount(editor2.getDocument().getImmutableCharSequence(), selectionStart, selectionEnd);
            Object[] objectArray = new Object[]{charCount};
            message.append(charCount).append(' ').append(UIBundle.message((String)"position.panel.selected.chars.count", (Object[])objectArray));
        } else {
            Object[] charCount = new Object[]{2};
            message.append(CHAR_COUNT_UNKNOWN).append(' ').append(UIBundle.message((String)"position.panel.selected.chars.count", (Object[])charCount));
            CharSequence charSequence = editor2.getDocument().getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            if (!this.charCountRequests.tryEmit((Object)new CodePointCountTask(charSequence, selectionStart, selectionEnd))) {
                throw new IllegalStateException("Check failed.");
            }
        }
        int selectionStartLine = editor2.getDocument().getLineNumber(selectionStart);
        int selectionEndLine = editor2.getDocument().getLineNumber(selectionEnd);
        if (selectionEndLine > selectionStartLine) {
            message.append(", ");
            Object[] objectArray = new Object[]{selectionEndLine - selectionStartLine};
            message.append(UIBundle.message((String)"position.panel.selected.line.breaks.count", (Object[])objectArray));
        }
        message.append(')');
        String string = message.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit _init_$lambda$0(Disposable $disposable, Throwable it) {
        Disposer.dispose((Disposable)$disposable);
        return Unit.INSTANCE;
    }

    private static final Unit getClickConsumer$lambda$0(PositionPanel this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Project project2 = this$0.helper.getProject();
        Object object = this$0.dataContext.getCurrentFileEditor().getValue();
        TextEditor textEditor = object instanceof TextEditor ? (TextEditor)object : null;
        if (textEditor == null || (textEditor = textEditor.getEditor()) == null) {
            return Unit.INSTANCE;
        }
        TextEditor editor2 = textEditor;
        CommandProcessor.getInstance().executeCommand(project2, () -> PositionPanel.getClickConsumer$lambda$0$0(project2, (Editor)editor2), UIBundle.message((String)"go.to.line.command.name", (Object[])new Object[0]), null);
        return Unit.INSTANCE;
    }

    private static final void getClickConsumer$lambda$0$0(Project $project, Editor $editor) {
        EditorGotoLineNumberDialog dialog2 = new EditorGotoLineNumberDialog($project, $editor);
        dialog2.show();
        IdeDocumentHistory.getInstance($project).includeCurrentCommandAsNavigation();
    }

    public static final /* synthetic */ String access$getPositionText(PositionPanel $this, Editor editor2) {
        return $this.getPositionText(editor2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/wm/impl/status/PositionPanel$Companion;", "", "<init>", "()V", "DISABLE_FOR_EDITOR", "Lcom/intellij/openapi/util/Key;", "SPACE", "", "SEPARATOR", "CHAR_COUNT_SYNC_LIMIT", "", "CHAR_COUNT_UNKNOWN", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

