/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.MemoryUsagePanel;
import com.intellij.openapi.wm.impl.status.StatusBarUI;
import com.intellij.openapi.wm.impl.status.WidgetEffectRendererKt;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/wm/impl/status/WidgetEffectRenderer;", "", "statusBar", "Lcom/intellij/openapi/wm/impl/status/IdeStatusBarImpl;", "<init>", "(Lcom/intellij/openapi/wm/impl/status/IdeStatusBarImpl;)V", "effectComponent", "Ljavax/swing/JComponent;", "applyEffect", "", "component", "widgetEffect", "Lcom/intellij/openapi/wm/impl/status/IdeStatusBarImpl$WidgetEffect;", "paintBackground", "g", "Ljava/awt/Graphics;", "clearIfMatches", "getEffectWidgetId", "", "Companion", "intellij.platform.ide.impl"})
public final class WidgetEffectRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdeStatusBarImpl statusBar;
    @Nullable
    private JComponent effectComponent;
    @NotNull
    private static final Key<String> WIDGET_ID;

    public WidgetEffectRenderer(@NotNull IdeStatusBarImpl statusBar) {
        Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
        this.statusBar = statusBar;
    }

    public final void applyEffect(@Nullable JComponent component2, @Nullable IdeStatusBarImpl.WidgetEffect widgetEffect) {
        if (this.effectComponent == component2 && (this.effectComponent == null || ClientProperty.get((Component)this.effectComponent, WidgetEffectRendererKt.getWIDGET_EFFECT_KEY()) == widgetEffect)) {
            return;
        }
        if (this.effectComponent != null) {
            JComponent jComponent = this.effectComponent;
            Intrinsics.checkNotNull((Object)jComponent);
            ClientProperty.put((JComponent)jComponent, WidgetEffectRendererKt.getWIDGET_EFFECT_KEY(), null);
            this.statusBar.repaint(new RelativeRectangle(this.effectComponent).getRectangleOn((Component)this.statusBar));
        }
        this.effectComponent = component2;
        JComponent jComponent = component2;
        if (jComponent == null) {
            return;
        }
        JComponent target = jComponent;
        target.setBackground(null);
        ClientProperty.put((JComponent)target, WidgetEffectRendererKt.getWIDGET_EFFECT_KEY(), (Object)((Object)widgetEffect));
        if (target.isEnabled() && widgetEffect != null) {
            target.setBackground(widgetEffect == IdeStatusBarImpl.WidgetEffect.HOVER ? JBUI.CurrentTheme.StatusBar.Widget.HOVER_BACKGROUND : JBUI.CurrentTheme.StatusBar.Widget.PRESSED_BACKGROUND);
        }
        this.statusBar.repaint(new RelativeRectangle(target).getRectangleOn((Component)this.statusBar));
    }

    public final void paintBackground(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        JComponent jComponent = this.effectComponent;
        if (jComponent == null) {
            return;
        }
        JComponent component2 = jComponent;
        if (!component2.isEnabled() || !UIUtil.isAncestor((Component)this.statusBar, (Component)component2) || MemoryUsagePanel.isInstance(component2)) {
            return;
        }
        Rectangle highlightBounds = component2.getBounds();
        Point point = new RelativePoint((Component)component2.getParent(), highlightBounds.getLocation()).getPoint((Component)this.statusBar);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        Point point2 = point;
        highlightBounds.setLocation(point2);
        IdeStatusBarImpl.WidgetEffect widgetEffect = (IdeStatusBarImpl.WidgetEffect)((Object)ClientProperty.get((Component)component2, WidgetEffectRendererKt.getWIDGET_EFFECT_KEY()));
        Color bg = widgetEffect == IdeStatusBarImpl.WidgetEffect.PRESSED ? JBUI.CurrentTheme.StatusBar.Widget.PRESSED_BACKGROUND : JBUI.CurrentTheme.StatusBar.Widget.HOVER_BACKGROUND;
        Intrinsics.checkNotNull((Object)highlightBounds);
        Intrinsics.checkNotNull((Object)bg);
        Companion.paintHover(g, component2, highlightBounds, bg, this.statusBar);
    }

    public final void clearIfMatches(@NotNull JComponent component2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            JComponent jComponent = this.effectComponent;
            if (jComponent == null) break block1;
            JComponent it = jComponent;
            boolean bl = false;
            if (UIUtil.isAncestor((Component)component2, (Component)it)) {
                ClientProperty.put((JComponent)it, WidgetEffectRendererKt.getWIDGET_EFFECT_KEY(), null);
                this.effectComponent = null;
            }
        }
    }

    @Nullable
    public final String getEffectWidgetId() {
        return (String)ClientProperty.get((Component)this.effectComponent, WIDGET_ID);
    }

    @JvmStatic
    public static final void paintHover(@NotNull Graphics g, @NotNull JComponent component2, @NotNull Rectangle highlightBounds, @NotNull Color bg, @NotNull StatusBar statusBar) {
        Companion.paintHover(g, component2, highlightBounds, bg, statusBar);
    }

    static {
        Key key = Key.create((String)"STATUS_BAR_WIDGET_ID");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        WIDGET_ID = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/wm/impl/status/WidgetEffectRenderer$Companion;", "", "<init>", "()V", "WIDGET_ID", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "paintHover", "", "g", "Ljava/awt/Graphics;", "component", "Ljavax/swing/JComponent;", "highlightBounds", "Ljava/awt/Rectangle;", "bg", "Ljava/awt/Color;", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "calcHoverInsetsCorrection", "Ljava/awt/Insets;", "effectComponent", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void paintHover(@NotNull Graphics g, @NotNull JComponent component2, @NotNull Rectangle highlightBounds, @NotNull Color bg, @NotNull StatusBar statusBar) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)highlightBounds, (String)"highlightBounds");
            Intrinsics.checkNotNullParameter((Object)bg, (String)"bg");
            Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
            if (!ExperimentalUI.Companion.isNewUI()) {
                JComponent jComponent = statusBar instanceof JComponent ? (JComponent)statusBar : null;
                if ((jComponent != null ? jComponent.getUI() : null) instanceof StatusBarUI) {
                    highlightBounds.y += StatusBarUI.BORDER_WIDTH.get();
                    highlightBounds.height -= StatusBarUI.BORDER_WIDTH.get();
                }
            }
            g.setColor(bg);
            if (ExperimentalUI.Companion.isNewUI()) {
                JBInsets.removeFrom((Rectangle)highlightBounds, (Insets)this.calcHoverInsetsCorrection(component2));
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D g2 = (Graphics2D)graphics;
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                    float arc = JBUIScale.scale((int)4);
                    RoundRectangle2D shape = new RoundRectangle2D.Float(highlightBounds.x, highlightBounds.y, highlightBounds.width, highlightBounds.height, arc, arc);
                    g2.fill(shape);
                }
                finally {
                    g2.dispose();
                }
            } else {
                g.fillRect(highlightBounds.x, highlightBounds.y, highlightBounds.width, highlightBounds.height);
            }
        }

        private final Insets calcHoverInsetsCorrection(JComponent effectComponent) {
            Insets comp = effectComponent.getInsets();
            Insets insets = JBUI.CurrentTheme.StatusBar.hoverInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"hoverInsets(...)");
            Insets hover = insets;
            return new Insets(Math.max(0, comp.top - hover.top), Math.max(0, comp.left - hover.left), Math.max(0, comp.bottom - hover.bottom), Math.max(0, comp.right - hover.right));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

