/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.CommonBundle;
import com.intellij.filename.UniqueNameBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.BottomLineBorder;
import com.intellij.openapi.wm.impl.welcomeScreen.FlatWelcomeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScreenColors;
import com.intellij.ui.ClickListener;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.ListUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class RecentProjectPanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(RecentProjectPanel.class);
    private static final Supplier<@Nls String> RECENT_PROJECTS_LABEL = IdeUICustomization.getInstance().projectMessagePointer("popup.title.recent.projects", new Object[0]);
    protected final JBList<AnAction> myList;
    final Set<ReopenProjectAction> projectsWithLongPaths;
    protected final FilePathChecker myChecker;
    private int myHoverIndex;

    RecentProjectPanel(@NotNull Disposable parentDisposable, boolean withSpeedSearch) {
        if (parentDisposable == null) {
            RecentProjectPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.projectsWithLongPaths = new HashSet<ReopenProjectAction>();
        this.myHoverIndex = -1;
        List<AnAction> recentProjectActions = RecentProjectListActionProvider.getInstance().getActions(false, this.isUseGroups());
        UniqueNameBuilder pathShortener = new UniqueNameBuilder(SystemProperties.getUserHome(), File.separator);
        HashSet<String> pathsToCheck = new HashSet<String>();
        for (AnAction action2 : recentProjectActions) {
            if (!(action2 instanceof ReopenProjectAction)) continue;
            ReopenProjectAction item = (ReopenProjectAction)action2;
            pathShortener.addPath((Object)item, item.getProjectPath());
            pathsToCheck.add(item.getProjectPath());
        }
        this.myList = this.createList(recentProjectActions.toArray(AnAction.EMPTY_ARRAY), this.getPreferredScrollableViewportSize());
        this.myList.setCellRenderer(this.createRenderer((UniqueNameBuilder<ReopenProjectAction>)pathShortener));
        if (Registry.is((String)"autocheck.availability.welcome.screen.projects")) {
            this.myChecker = new FilePathChecker(() -> {
                if (this.myList.isShowing()) {
                    this.myList.revalidate();
                    this.myList.repaint();
                }
            }, pathsToCheck);
            Disposer.register((Disposable)parentDisposable, (Disposable)this.myChecker);
        } else {
            this.myChecker = null;
        }
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                AnAction selectedAction;
                AnAction selection;
                Rectangle cellBounds;
                int selectedIndex;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((selectedIndex = RecentProjectPanel.this.myList.getSelectedIndex()) >= 0 && (cellBounds = RecentProjectPanel.this.myList.getCellBounds(selectedIndex, selectedIndex)).contains(event.getPoint()) && (selection = (AnAction)RecentProjectPanel.this.myList.getSelectedValue()) != null && (selectedAction = RecentProjectPanel.this.performSelectedAction(event, selection)) instanceof ReopenProjectAction && ((ReopenProjectAction)selectedAction).isRemoved()) {
                    ListUtil.removeSelectedItems(RecentProjectPanel.this.myList);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$1", "onClick"));
            }
        }.installOn(this.myList);
        this.myList.registerKeyboardAction(e -> {
            List selectedValues = this.myList.getSelectedValuesList();
            if (selectedValues != null) {
                for (AnAction selectedAction : selectedValues) {
                    if (selectedAction == null) continue;
                    KeyEvent event = new KeyEvent((Component)this.myList, 401, e.getWhen(), e.getModifiers(), 10, '\r');
                    this.performSelectedAction(event, selectedAction);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
        AnAction removeRecentProjectAction = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                RecentProjectPanel.this.removeRecentProject();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(true);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        removeRecentProjectAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"DELETE", "BACK_SPACE"}), this.myList, parentDisposable);
        this.addMouseMotionListener();
        this.myList.setSelectedIndex(0);
        JBScrollPane scroll = new JBScrollPane(this.myList, 20, 31);
        scroll.setBorder((Border)JBUI.Borders.empty());
        boolean wrapListWithFiltered = !recentProjectActions.isEmpty() && withSpeedSearch;
        JBScrollPane list2 = wrapListWithFiltered ? ListWithFilter.wrap(this.myList, (JScrollPane)scroll, RecentProjectPanel.createProjectNameFunction()) : this.myList;
        this.add((Component)(wrapListWithFiltered ? list2 : scroll), "Center");
        JPanel title2 = this.createTitle();
        if (title2 != null) {
            this.add((Component)title2, "North");
        }
        this.setBorder(new LineBorder(WelcomeScreenColors.BORDER_COLOR));
    }

    private static Function<? super AnAction, String> createProjectNameFunction() {
        return o -> {
            if (o instanceof ReopenProjectAction) {
                return RecentProjectPanel.getProjectName((ReopenProjectAction)o);
            }
            if (o instanceof ProjectGroupActionGroup) {
                return ((ProjectGroupActionGroup)((Object)o)).getGroup().getName();
            }
            return o.toString();
        };
    }

    @NotNull
    private static String getProjectName(@NotNull ReopenProjectAction projectItem) {
        if (projectItem == null) {
            RecentProjectPanel.$$$reportNull$$$0(1);
        }
        String home = SystemProperties.getUserHome();
        String path = projectItem.getProjectPath();
        if (FileUtil.startsWith((String)path, (String)home)) {
            path = path.substring(home.length());
        }
        String string = projectItem.getProjectNameToDisplay() + " " + path;
        if (string == null) {
            RecentProjectPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private AnAction performSelectedAction(@NotNull InputEvent event, AnAction selection) {
        if (event == null) {
            RecentProjectPanel.$$$reportNull$$$0(3);
        }
        String actionPlace = UIUtil.uiParents(this.myList, (boolean)true).filter(FlatWelcomeFrame.class).isEmpty() ? "popup" : "WelcomeScreen";
        DataContext dataContext2 = DataManager.getInstance().getDataContext(this.myList);
        AnActionEvent actionEvent = AnActionEvent.createEvent((DataContext)dataContext2, (Presentation)selection.getTemplatePresentation().clone(), (String)actionPlace, (ActionUiKind)ActionUiKind.NONE, (InputEvent)event);
        ActionUtil.performAction((AnAction)selection, (AnActionEvent)actionEvent);
        AnAction anAction = selection;
        if (anAction == null) {
            RecentProjectPanel.$$$reportNull$$$0(4);
        }
        return anAction;
    }

    private void removeRecentProject() {
        List selection = this.myList.getSelectedValuesList();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        int rc = Messages.showOkCancelDialog((Component)this, (String)IdeBundle.message((String)"dialog.message.remove.0.from.recent.projects.list", (Object[])new Object[]{StringUtil.join((Collection)selection, action2 -> action2.getTemplatePresentation().getText(), (String)"'\n'")}), (String)IdeBundle.message((String)"dialog.title.remove.recent.project", (Object[])new Object[0]), (String)CommonBundle.getOkButtonText(), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
        if (rc == 0) {
            for (AnAction projectAction : selection) {
                RecentProjectPanel.removeRecentProjectElement(projectAction);
            }
            ListUtil.removeSelectedItems(this.myList);
        }
    }

    boolean isPathValid(String path) {
        return this.myChecker == null || this.myChecker.isValid(path);
    }

    private static void removeRecentProjectElement(@NotNull Object element) {
        if (element == null) {
            RecentProjectPanel.$$$reportNull$$$0(5);
        }
        RecentProjectsManager manager2 = RecentProjectsManager.getInstance();
        if (element instanceof ReopenProjectAction) {
            manager2.removePath(((ReopenProjectAction)element).getProjectPath());
        } else if (element instanceof ProjectGroupActionGroup) {
            manager2.removeGroup(((ProjectGroupActionGroup)((Object)element)).getGroup());
        }
    }

    protected boolean isUseGroups() {
        return false;
    }

    protected Dimension getPreferredScrollableViewportSize() {
        return JBUI.size((int)250, (int)400);
    }

    protected void addMouseMotionListener() {
        MouseAdapter mouseAdapter2 = new MouseAdapter(){
            boolean myIsEngaged;

            @Override
            public void mouseMoved(MouseEvent e) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (focusOwner == null) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(RecentProjectPanel.this.myList, true));
                }
                if (RecentProjectPanel.this.myList.getSelectedIndices().length > 1) {
                    return;
                }
                if (!this.myIsEngaged || UIUtil.isSelectionButtonDown((MouseEvent)e) || focusOwner instanceof JRootPane) {
                    this.myIsEngaged = true;
                    return;
                }
                Point point = e.getPoint();
                int index = RecentProjectPanel.this.myList.locationToIndex(point);
                RecentProjectPanel.this.myList.setSelectedIndex(index);
                Rectangle cellBounds = RecentProjectPanel.this.myList.getCellBounds(index, index);
                if (cellBounds != null && cellBounds.contains(point)) {
                    UIUtil.setCursor(RecentProjectPanel.this.myList, (Cursor)Cursor.getPredefinedCursor(12));
                    RecentProjectPanel.this.myHoverIndex = index;
                    RecentProjectPanel.this.myList.repaint(cellBounds);
                } else {
                    UIUtil.setCursor(RecentProjectPanel.this.myList, (Cursor)Cursor.getPredefinedCursor(0));
                    RecentProjectPanel.this.myHoverIndex = -1;
                    RecentProjectPanel.this.myList.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RecentProjectPanel.this.myHoverIndex = -1;
                RecentProjectPanel.this.myList.repaint();
            }
        };
        this.myList.addMouseMotionListener((MouseMotionListener)mouseAdapter2);
        this.myList.addMouseListener((MouseListener)mouseAdapter2);
    }

    protected JBList<AnAction> createList(AnAction[] recentProjectActions, Dimension size2) {
        return new MyList(size2, recentProjectActions);
    }

    protected ListCellRenderer<AnAction> createRenderer(UniqueNameBuilder<ReopenProjectAction> pathShortener) {
        return new RecentProjectItemRenderer();
    }

    @Nullable
    protected JPanel createTitle() {
        JPanel title2 = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, JBUIScale.scale((int)28));
            }
        };
        title2.setBorder(new BottomLineBorder());
        JLabel titleLabel = new JLabel(RECENT_PROJECTS_LABEL.get());
        title2.add(titleLabel);
        titleLabel.setHorizontalAlignment(0);
        titleLabel.setForeground(WelcomeScreenColors.CAPTION_FOREGROUND);
        title2.setBackground(WelcomeScreenColors.CAPTION_BACKGROUND);
        return title2;
    }

    private static boolean isPathAvailable(String pathStr) {
        Path path = Paths.get(pathStr, new String[0]);
        Path pathRoot = path.getRoot();
        if (pathRoot == null) {
            return false;
        }
        if (SystemInfo.isWindows && pathRoot.toString().startsWith("\\\\")) {
            return true;
        }
        return ContainerUtil.find(pathRoot.getFileSystem().getRootDirectories(), (Object)pathRoot) != null && Files.exists(path, new LinkOption[0]);
    }

    @NotNull
    private static Icon toSize(@NotNull Icon icon2) {
        if (icon2 == null) {
            RecentProjectPanel.$$$reportNull$$$0(6);
        }
        Icon icon3 = IconUtil.toSize((Icon)icon2, (int)((int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.getWidth()), (int)((int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.getHeight()));
        if (icon3 == null) {
            RecentProjectPanel.$$$reportNull$$$0(7);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectItem";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "performSelectedAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectName";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performSelectedAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeRecentProjectElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toSize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7 -> new IllegalStateException(string);
        };
    }

    public static final class FilePathChecker
    implements Disposable,
    PowerSaveMode.Listener {
        private static final int MIN_AUTO_UPDATE_MILLIS = 2500;
        private ScheduledExecutorService service;
        private final Set<String> invalidPaths = Collections.synchronizedSet(new HashSet());
        private final Runnable callback;
        private final Collection<String> paths;

        public FilePathChecker(Runnable callback, Collection<String> paths) {
            this.callback = callback;
            this.paths = paths;
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.onAppStateChanged();
                }

                public void delayedApplicationDeactivated(@NotNull Window ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.onAppStateChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "ideFrame";
                    objectArray2[1] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$FilePathChecker$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applicationActivated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "delayedApplicationDeactivated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            connection.subscribe(PowerSaveMode.TOPIC, (Object)this);
            this.onAppStateChanged();
        }

        public boolean isValid(String path) {
            return !this.invalidPaths.contains(path);
        }

        public void powerSaveStateChanged() {
            this.onAppStateChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onAppStateChanged() {
            boolean settingsAreOK = Registry.is((String)"autocheck.availability.welcome.screen.projects") && !PowerSaveMode.isEnabled();
            boolean everythingIsOK = settingsAreOK && ApplicationManager.getApplication().isActive();
            FilePathChecker filePathChecker = this;
            synchronized (filePathChecker) {
                if (this.service == null && everythingIsOK) {
                    this.service = AppExecutorUtil.createBoundedScheduledExecutorService((String)"CheckRecentProjectPaths Service", (int)2);
                    for (String path : this.paths) {
                        this.scheduleCheck(path, 0L);
                    }
                    ApplicationManager.getApplication().invokeLater(this.callback);
                }
                if (this.service != null && !everythingIsOK) {
                    if (!settingsAreOK) {
                        this.invalidPaths.clear();
                    }
                    this.shutdown(false);
                    ApplicationManager.getApplication().invokeLater(this.callback);
                }
            }
        }

        private synchronized void shutdown(boolean now) {
            if (this.service != null) {
                if (now) {
                    this.service.shutdownNow();
                } else {
                    this.service.shutdown();
                }
                this.service = null;
            }
        }

        public void dispose() {
            this.shutdown(true);
        }

        private synchronized void scheduleCheck(String path, long delay) {
            if (this.service == null || this.service.isShutdown()) {
                return;
            }
            this.service.schedule(() -> {
                boolean pathIsValid;
                long startTime = System.currentTimeMillis();
                try {
                    pathIsValid = !RecentProjectsManagerBase.Companion.isFileSystemPath(path) || RecentProjectPanel.isPathAvailable(path);
                }
                catch (Exception e) {
                    pathIsValid = false;
                }
                if (this.invalidPaths.contains(path) == pathIsValid) {
                    if (pathIsValid) {
                        this.invalidPaths.remove(path);
                    } else {
                        this.invalidPaths.add(path);
                    }
                    ApplicationManager.getApplication().invokeLater(this.callback);
                }
                this.scheduleCheck(path, Math.max(2500L, 10L * (System.currentTimeMillis() - startTime)));
            }, delay, TimeUnit.MILLISECONDS);
        }
    }

    private final class MyList
    extends JBList<AnAction> {
        private final Dimension mySize;
        private Point myMousePoint;

        private MyList(@NotNull Dimension size2, AnAction[] listData) {
            if (listData == null) {
                MyList.$$$reportNull$$$0(0);
            }
            super((Object[])listData);
            this.mySize = size2;
            this.setExpandableItemsEnabled(false);
            this.setEmptyText(IdeBundle.message((String)"empty.text.no.project.open.yet", (Object[])new Object[0]));
            this.setSelectionMode(2);
            this.getAccessibleContext().setAccessibleName(RECENT_PROJECTS_LABEL.get());
            MyPopupMouseHandler handler = new MyPopupMouseHandler();
            this.addMouseListener((MouseListener)((Object)handler));
            this.addMouseMotionListener((MouseMotionListener)((Object)handler));
        }

        Rectangle getCloseIconRect(int index) {
            Rectangle bounds = this.getCellBounds(index, index);
            Icon icon2 = RecentProjectPanel.toSize(AllIcons.Ide.Notification.Gear);
            return new Rectangle(bounds.width - icon2.getIconWidth() - JBUIScale.scale((int)10), bounds.y + (bounds.height - icon2.getIconHeight()) / 2, icon2.getIconWidth(), icon2.getIconHeight());
        }

        public void paint(Graphics g) {
            int index;
            super.paint(g);
            if (this.myMousePoint != null && (index = this.locationToIndex(this.myMousePoint)) != -1) {
                Rectangle iconRect = this.getCloseIconRect(index);
                Icon actionIcon = this.detectActionIcon(index, iconRect.contains(this.myMousePoint));
                Icon icon2 = RecentProjectPanel.toSize(actionIcon);
                icon2.paintIcon((Component)((Object)this), g, iconRect.x, iconRect.y);
            }
        }

        private Icon detectActionIcon(int rowIndex, boolean hovered) {
            if (this.isProjectInvalid(rowIndex)) {
                return hovered ? AllIcons.Welcome.RecentProjects.RemoveHover : AllIcons.Welcome.RecentProjects.Remove;
            }
            return hovered ? AllIcons.Ide.Notification.GearHover : AllIcons.Ide.Notification.Gear;
        }

        private boolean isProjectInvalid(int listIndex) {
            AnAction action2 = (AnAction)RecentProjectPanel.this.myList.getModel().getElementAt(listIndex);
            if (action2 instanceof ReopenProjectAction) {
                return !RecentProjectPanel.this.isPathValid(((ReopenProjectAction)action2).getProjectPath());
            }
            return false;
        }

        public String getToolTipText(MouseEvent event) {
            String path;
            boolean valid;
            Object elem;
            int i2;
            int n = i2 = event != null ? this.locationToIndex(event.getPoint()) : -1;
            if (i2 != -1 && (elem = this.getModel().getElementAt(i2)) instanceof ReopenProjectAction && (!(valid = RecentProjectPanel.this.isPathValid(path = ((ReopenProjectAction)elem).getProjectPath())) || RecentProjectPanel.this.projectsWithLongPaths.contains(elem))) {
                String suffix = valid ? "" : " " + IdeBundle.message((String)"recent.project.unavailable", (Object[])new Object[0]);
                return PathUtil.toSystemDependentName((String)path) + suffix;
            }
            return super.getToolTipText(event);
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.mySize == null ? super.getPreferredScrollableViewportSize() : this.mySize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listData", "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$MyList", "<init>"));
        }

        final class MyPopupMouseHandler
        extends PopupHandler {
            MyPopupMouseHandler() {
            }

            public void mouseEntered(MouseEvent e) {
                MyList.this.myMousePoint = e != null ? e.getPoint() : null;
            }

            public void mouseExited(MouseEvent e) {
                MyList.this.myMousePoint = null;
            }

            public void mouseMoved(MouseEvent e) {
                MyList.this.myMousePoint = e != null ? e.getPoint() : null;
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (e.isConsumed()) {
                    return;
                }
                Point point = e.getPoint();
                int index = MyList.this.locationToIndex(point);
                if (index == -1 || !MyList.this.getCloseIconRect(index).contains(point)) {
                    return;
                }
                if (MyList.this.isProjectInvalid(index)) {
                    RecentProjectPanel.removeRecentProjectElement(MyList.this.getModel().getElementAt(index));
                    ListUtil.removeItem((ListModel)MyList.this.getModel(), (int)index);
                } else {
                    this.invokePopup(e.getComponent(), e.getX(), e.getY());
                }
                e.consume();
            }

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup group2;
                int index = MyList.this.locationToIndex(new Point(x, y));
                if (index != -1 && Arrays.binarySearch(MyList.this.getSelectedIndices(), index) < 0) {
                    MyList.this.setSelectedIndex(index);
                }
                if ((group2 = (ActionGroup)ActionManager.getInstance().getAction("WelcomeScreenRecentProjectActionGroup")) != null) {
                    ActionManager.getInstance().createActionPopupMenu("WelcomeScreen", group2).getComponent().show(comp, x, y);
                }
            }
        }
    }

    protected class RecentProjectItemRenderer
    extends JPanel
    implements ListCellRenderer<AnAction> {
        protected final JLabel myName;
        protected final JLabel myPath;
        boolean myHovered;

        RecentProjectItemRenderer() {
            super((LayoutManager)new VerticalFlowLayout());
            this.myName = new JLabel();
            this.myPath = ComponentPanelBuilder.createNonWrappingCommentComponent((String)"");
            this.setFocusable(true);
            this.layoutComponents();
        }

        protected void layoutComponents() {
            this.add(this.myName);
            this.add(this.myPath);
        }

        protected Color getListBackground(boolean isSelected, boolean hasFocus) {
            return UIUtil.getListBackground((boolean)isSelected, (boolean)true);
        }

        protected Color getListForeground(boolean isSelected, boolean hasFocus) {
            return UIUtil.getListForeground((boolean)isSelected, (boolean)true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AnAction> list2, AnAction value, int index, boolean selected, boolean focused) {
            this.myHovered = RecentProjectPanel.this.myHoverIndex == index;
            Color fore = this.getListForeground(selected, list2.hasFocus());
            Color back = this.getListBackground(selected, list2.hasFocus());
            this.myName.setForeground(fore);
            this.myPath.setForeground(NamedColorUtil.getInactiveTextColor());
            this.setBackground(back);
            if (value instanceof ReopenProjectAction) {
                ReopenProjectAction item = (ReopenProjectAction)value;
                this.myName.setText(item.getTemplatePresentation().getText());
                this.myPath.setText(this.getTitle2Text(item, this.myPath, JBUIScale.scale((int)40)));
            } else if (value instanceof ProjectGroupActionGroup) {
                ProjectGroupActionGroup group2 = (ProjectGroupActionGroup)value;
                this.myName.setText(group2.getGroup().getName());
                this.myPath.setText("");
            }
            AccessibleContextUtil.setCombinedName((Component)this, (Component)this.myName, (String)" - ", (Component)this.myPath);
            AccessibleContextUtil.setCombinedDescription((Component)this, (Component)this.myName, (String)" - ", (Component)this.myPath);
            return this;
        }

        @NlsSafe
        String getTitle2Text(ReopenProjectAction action2, JComponent pathLabel, int leftOffset) {
            String fullText = action2.getProjectPath();
            if (fullText.isEmpty()) {
                return " ";
            }
            fullText = FileUtil.getLocationRelativeToUserHome((String)PathUtil.toSystemDependentName((String)fullText), (boolean)false);
            try {
                FontMetrics fm = pathLabel.getFontMetrics(pathLabel.getFont());
                int maxWidth = RecentProjectPanel.this.getWidth() - leftOffset - (int)ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.getWidth() - JBUIScale.scale((int)10);
                if (maxWidth > 0 && fm.stringWidth(fullText) > maxWidth) {
                    return RecentProjectItemRenderer.truncateDescription(fullText, fm, maxWidth, RecentProjectItemRenderer.isTutorial(action2));
                }
            }
            catch (Exception e) {
                LOG.error("Path label font: " + String.valueOf(pathLabel.getFont()));
                LOG.error("Panel width: " + RecentProjectPanel.this.getWidth());
                LOG.error((Throwable)e);
            }
            return fullText;
        }

        private static boolean isTutorial(ReopenProjectAction action2) {
            List groups = RecentProjectsManager.getInstance().getGroups();
            for (ProjectGroup group2 : groups) {
                if (!group2.isTutorials()) continue;
                for (String project2 : group2.getProjects()) {
                    if (!project2.contains(action2.getProjectPath())) continue;
                    return true;
                }
            }
            return false;
        }

        @NotNull
        private static String truncateDescription(String fullText, FontMetrics fm, int maxWidth, boolean isTutorial) {
            if (isTutorial) {
                String tutorialTruncated = fullText;
                while (fm.stringWidth(tutorialTruncated) > maxWidth) {
                    tutorialTruncated = tutorialTruncated.substring(0, tutorialTruncated.length() - 1);
                }
                String string = tutorialTruncated + "...";
                if (string == null) {
                    RecentProjectItemRenderer.$$$reportNull$$$0(0);
                }
                return string;
            }
            int left = 1;
            int right = 1;
            int center = fullText.length() / 2;
            String s = fullText.substring(0, center - left) + "..." + fullText.substring(center + right);
            while (fm.stringWidth(s) > maxWidth) {
                if (left == right) {
                    ++left;
                } else {
                    ++right;
                }
                if (center - left < 0 || center + right >= fullText.length()) {
                    return "";
                }
                s = fullText.substring(0, center - left) + "..." + fullText.substring(center + right);
            }
            String string = s;
            if (string == null) {
                RecentProjectItemRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size2 = super.getPreferredSize();
            return new Dimension(Math.min(size2.width, JBUIScale.scale((int)245)), size2.height);
        }

        @Override
        @NotNull
        public Dimension getSize() {
            Dimension dimension = this.getPreferredSize();
            if (dimension == null) {
                RecentProjectItemRenderer.$$$reportNull$$$0(2);
            }
            return dimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/wm/impl/welcomeScreen/RecentProjectPanel$RecentProjectItemRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "truncateDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSize";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

