/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.productInfo;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.buildData.productInfo.ProductInfoData;
import com.intellij.platform.ide.productInfo.IdeProductInfo;
import com.intellij.util.system.OS;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/ide/impl/productInfo/IdeProductInfoImpl;", "Lcom/intellij/platform/ide/productInfo/IdeProductInfo;", "<init>", "()V", "json", "Lkotlinx/serialization/json/Json;", "currentProductInfo", "Lcom/intellij/platform/buildData/productInfo/ProductInfoData;", "getCurrentProductInfo", "()Lcom/intellij/platform/buildData/productInfo/ProductInfoData;", "currentProductInfo$delegate", "Lkotlin/Lazy;", "loadProductInfo", "ideHome", "Ljava/nio/file/Path;", "tryLoadingProductInfo", "createProductInfoFromApplicationInfo", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nIdeProductInfoImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeProductInfoImpl.kt\ncom/intellij/platform/ide/impl/productInfo/IdeProductInfoImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n13#2:84\n*S KotlinDebug\n*F\n+ 1 IdeProductInfoImpl.kt\ncom/intellij/platform/ide/impl/productInfo/IdeProductInfoImpl\n*L\n44#1:84\n*E\n"})
public final class IdeProductInfoImpl
implements IdeProductInfo {
    @NotNull
    private final Json json = JsonKt.Json$default(null, IdeProductInfoImpl::json$lambda$0, (int)1, null);
    @NotNull
    private final Lazy currentProductInfo$delegate = LazyKt.lazy(() -> IdeProductInfoImpl.currentProductInfo_delegate$lambda$0(this));

    @Override
    @NotNull
    public ProductInfoData getCurrentProductInfo() {
        Lazy lazy = this.currentProductInfo$delegate;
        return (ProductInfoData)lazy.getValue();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public ProductInfoData loadProductInfo(@NotNull Path ideHome) {
        Intrinsics.checkNotNullParameter((Object)ideHome, (String)"ideHome");
        try {
            if (OS.CURRENT != OS.macOS || Intrinsics.areEqual((Object)PathsKt.getName((Path)ideHome), (Object)"Contents")) ** GOTO lbl-1000
            v0 = ideHome.resolve("Contents");
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"resolve(...)");
            var2_2 /* !! */  = v0;
            var3_3 = new LinkOption[]{};
            if (Files.isDirectory((Path)var2_2 /* !! */ , Arrays.copyOf(var3_3, var3_3.length))) {
                v1 = ideHome.resolve("Contents");
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"resolve(...)");
                v2 = this.tryLoadingProductInfo(v1);
            } else lbl-1000:
            // 2 sources

            {
                v2 = this.tryLoadingProductInfo(ideHome);
            }
            var2_2 /* !! */  = v2;
        }
        catch (Exception e) {
            $i$f$logger = false;
            v3 = Logger.getInstance(IdeProductInfoImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
            v3.warn("Cannot load product info from " + ideHome, (Throwable)e);
            var2_2 /* !! */  = null;
        }
        return var2_2 /* !! */ ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ProductInfoData tryLoadingProductInfo(Path ideHome) {
        if (OS.CURRENT != OS.macOS) ** GOTO lbl-1000
        v0 = ideHome.resolve("Resources/product-info.json");
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"resolve(...)");
        var3_2 = v0;
        var4_3 /* !! */  = new LinkOption[]{};
        if (Files.exists(var3_2, Arrays.copyOf(var4_3 /* !! */ , var4_3 /* !! */ .length))) {
            v1 = "Resources/product-info.json";
        } else lbl-1000:
        // 2 sources

        {
            v1 = "product-info.json";
        }
        productInfoRelativePath = v1;
        productInfoPath = ideHome.resolve(productInfoRelativePath);
        Intrinsics.checkNotNull((Object)productInfoPath);
        v2 = new OpenOption[]{};
        v3 = Files.newInputStream(productInfoPath, Arrays.copyOf(v2, v2.length));
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"newInputStream(...)");
        var4_3 /* !! */  = v3;
        var5_5 = 8192;
        var4_3 /* !! */  = var4_3 /* !! */  instanceof BufferedInputStream != false ? (BufferedInputStream)var4_3 /* !! */  : new BufferedInputStream((InputStream)var4_3 /* !! */ , var5_5);
        var5_6 = null;
        try {
            it = (BufferedInputStream)var4_3 /* !! */ ;
            $i$a$-use-IdeProductInfoImpl$tryLoadingProductInfo$1 = false;
            var6_7 = (ProductInfoData)JvmStreamsKt.decodeFromStream((Json)this.json, (DeserializationStrategy)((DeserializationStrategy)ProductInfoData.Companion.serializer()), (InputStream)it);
        }
        catch (Throwable var7_9) {
            var5_6 = var7_9;
            throw var7_9;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var4_3 /* !! */ , (Throwable)var5_6);
        }
        return var6_7;
    }

    private final ProductInfoData createProductInfoFromApplicationInfo() {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        String string = appInfo.getFullApplicationName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullApplicationName(...)");
        String string2 = appInfo.getFullVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFullVersion(...)");
        String string3 = appInfo.getBuild().asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asStringWithoutProductCode(...)");
        String string4 = appInfo.getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProductCode(...)");
        String string5 = appInfo.getShortCompanyName();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getShortCompanyName(...)");
        return ProductInfoData.Companion.create(string, string2, null, string3, string4, "UNKNOWN", "UNKNOWN", null, string5, appInfo.getMajorReleaseBuildDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final ProductInfoData currentProductInfo_delegate$lambda$0(IdeProductInfoImpl this$0) {
        ProductInfoData productInfoData;
        if (PluginManagerCore.isRunningFromSources() || AppMode.isRunningFromDevBuild()) {
            productInfoData = this$0.createProductInfoFromApplicationInfo();
        } else {
            Path path = PathManager.getHomeDir();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getHomeDir(...)");
            productInfoData = this$0.tryLoadingProductInfo(path);
        }
        return productInfoData;
    }
}

