/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.icons.ImageDataByPathLoaderKt;
import com.intellij.util.ui.EmptyIcon;
import java.lang.ref.WeakReference;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u001a+\u0010\u0000\u001a\u000f\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0000\u00a8\u0006\u0012"}, d2={"getStripeTitleSupplier", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "id", "project", "Lcom/intellij/openapi/project/Project;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "findIconFromBean", "Ljavax/swing/Icon;", "bean", "Lcom/intellij/openapi/wm/ToolWindowEP;", "factory", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "isUltrawideLayout", "", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\ntoolwindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 toolwindow.kt\ncom/intellij/toolWindow/ToolwindowKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n13#2:123\n13#2:125\n1#3:124\n*S KotlinDebug\n*F\n+ 1 toolwindow.kt\ncom/intellij/toolWindow/ToolwindowKt\n*L\n84#1:123\n68#1:125\n*E\n"})
public final class ToolwindowKt {
    @Nullable
    public static final Supplier<String> getStripeTitleSupplier(@NotNull String id2, @NotNull Project project2, @NotNull PluginDescriptor pluginDescriptor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        if (Intrinsics.areEqual((Object)id2, (Object)"Project")) {
            WeakReference<Project> weakProjectRef = new WeakReference<Project>(project2);
            return () -> ToolwindowKt.getStripeTitleSupplier$lambda$0(weakProjectRef);
        }
        ClassLoader classLoader = pluginDescriptor.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        ClassLoader classLoader2 = classLoader;
        if (Intrinsics.areEqual((Object)pluginDescriptor.getPluginId(), (Object)PluginManagerCore.CORE_ID)) {
            string = "messages.IdeBundle";
        } else {
            string = pluginDescriptor.getResourceBundleBaseName();
            if (string == null) {
                return null;
            }
        }
        String bundleName = string;
        return () -> ToolwindowKt.getStripeTitleSupplier$lambda$1(classLoader2, bundleName, id2);
    }

    @Nullable
    public static final Icon findIconFromBean(@NotNull ToolWindowEP bean, @NotNull ToolWindowFactory factory2, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
        Icon icon2 = factory2.getIcon();
        if (icon2 != null) {
            Icon it = icon2;
            boolean bl = false;
            return it;
        }
        try {
            String string = bean.icon;
            if (string == null) {
                return null;
            }
            ClassLoader classLoader = pluginDescriptor.getClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
            return ImageDataByPathLoaderKt.findIconByPath$default((String)string, (ClassLoader)classLoader, null, null, (int)8, null);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ToolWindowManagerImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
            return EmptyIcon.ICON_13;
        }
    }

    public static final boolean isUltrawideLayout(@NotNull ToolWindowAnchor $this$isUltrawideLayout) {
        Intrinsics.checkNotNullParameter((Object)$this$isUltrawideLayout, (String)"<this>");
        return !$this$isUltrawideLayout.isHorizontal() && !$this$isUltrawideLayout.isSplitVertically();
    }

    private static final String getStripeTitleSupplier$lambda$0(WeakReference $weakProjectRef) {
        Object object;
        block3: {
            block2: {
                Project project2;
                object = (Project)$weakProjectRef.get();
                if (object == null) break block2;
                Project it = project2 = object;
                boolean bl = false;
                object = !it.isDisposed() ? project2 : null;
                if (object != null) break block3;
            }
            return "";
        }
        Project unwrappedProject = object;
        return IdeUICustomization.getInstance().getProjectViewTitle(unwrappedProject);
    }

    private static final String getStripeTitleSupplier$lambda$1(ClassLoader $classLoader, String $bundleName, String $id) {
        String string;
        try {
            ResourceBundle resourceBundle = DynamicBundle.getResourceBundle((ClassLoader)$classLoader, (String)$bundleName);
            Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"getResourceBundle(...)");
            ResourceBundle bundle = resourceBundle;
            String key = StringsKt.replace$default((String)("toolwindow.stripe." + $id), (String)" ", (String)"_", (boolean)false, (int)4, null);
            string = BundleBase.messageOrDefault((ResourceBundle)bundle, (String)key, (String)$id, (Object[])new Object[0]);
        }
        catch (MissingResourceException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ToolWindowManagerImpl.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Missing bundle " + $bundleName + " at " + $classLoader, (Throwable)e);
            string = "";
        }
        return string;
    }
}

