/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.application.Topics;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.concurrency.ContextAwareRunnable;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltip;
import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.PopupLocationTracker;
import com.intellij.ide.ui.ScreenAreaConsumer;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.internal.statistic.collectors.fus.ui.BalloonUsageCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.impl.ShadowBorderPainter;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonListener;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.WeakFocusStackManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.DrawUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.jcef.HwFacadeJPanel;
import com.intellij.ui.jcef.HwFacadeNonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.MenuElement;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BalloonImpl
implements Balloon,
IdeTooltip.Ui,
ScreenAreaConsumer {
    private static final Logger LOG = Logger.getInstance(BalloonImpl.class);
    public static final Key<Boolean> FORCED_NO_SHADOW = Key.create((String)"BALLOON_FORCED_NO_SHADOW");
    private static final JBValue DIALOG_ARC = new JBValue.Float(6.0f);
    public static final JBValue ARC = new JBValue.UIInteger("ToolTip.arc", 4);
    private static final JBValue DIALOG_TOPBOTTOM_POINTER_WIDTH = new JBValue.Float(24.0f);
    public static final JBValue DIALOG_POINTER_WIDTH = new JBValue.Float(17.0f);
    private static final JBValue TOPBOTTOM_POINTER_WIDTH = new JBValue.Float(14.0f);
    private static final JBValue POINTER_WIDTH = new JBValue.Float(11.0f);
    private static final JBValue DIALOG_TOPBOTTOM_POINTER_LENGTH = new JBValue.Float(16.0f);
    private static final JBValue DIALOG_POINTER_LENGTH = new JBValue.Float(14.0f);
    private static final JBValue TOPBOTTOM_POINTER_LENGTH = new JBValue.Float(10.0f);
    public static final JBValue POINTER_LENGTH = new JBValue.Float(8.0f);
    private static final JBValue BORDER_STROKE_WIDTH = new JBValue.Float(1.0f);
    private final Alarm myFadeoutAlarm;
    private long myFadeoutRequestMillis;
    private int myFadeoutRequestDelay;
    private boolean mySmartFadeout;
    private boolean isSmartFadeoutPaused;
    private int mySmartFadeoutDelay;
    private MyComponent component;
    private JLayeredPane layeredPane;
    private AbstractPosition myPosition;
    private Point myTargetPoint;
    private final boolean myHideOnFrameResize;
    private final boolean myHideOnLinkClick;
    private boolean myZeroPositionInLayer;
    private final Color myBorderColor;
    private final Insets myBorderInsets;
    private Color myFillColor;
    private Color myPointerColor;
    private final Insets myContainerInsets;
    private boolean myLastMoveWasInsideBalloon;
    private Rectangle myForcedBounds;
    private ActionProvider myActionProvider;
    private List<ActionButton> myActionButtons;
    private boolean invalidateShadow;
    private String myId;
    private final AWTEventListener myAwtActivityListener;
    private final long myFadeoutTime;
    private Dimension myDefaultPrefSize;
    private final ActionListener myClickHandler;
    private final boolean myCloseOnClick;
    private final int myShadowSize;
    private ShadowBorderProvider myShadowBorderProvider;
    private final Collection<JBPopupListener> myListeners;
    private boolean myVisible;
    private PositionTracker<Balloon> myTracker;
    private final int myAnimationCycle;
    private boolean myFadedIn;
    private boolean myFadedOut;
    private final int myCalloutShift;
    private final int myPositionChangeXShift;
    private final int myPositionChangeYShift;
    private boolean myDialogMode;
    private IdeFocusManager myFocusManager;
    private @NlsContexts.PopupTitle String myTitle;
    private JLabel myTitleLabel;
    private boolean myAnimationEnabled;
    private final boolean myShadow;
    private final Balloon.Layer myLayer;
    private boolean myBlockClicks;
    private RelativePoint myPrevMousePoint;
    private final ComponentAdapter myComponentListener;
    private Animator animator;
    private boolean myShowPointer;
    private boolean isDisposed;
    private final JComponent myContent;
    private boolean myHideOnMouse;
    private Runnable myHideListener;
    private final boolean myHideOnKey;
    private final boolean myHideOnAction;
    private final boolean myHideOnCloseClick;
    private final boolean myRequestFocus;
    private Component myOriginalFocusOwner;
    private final boolean myEnableButtons;
    private final Dimension myPointerSize;
    private boolean myPointerShiftedToStart;
    private final int myCornerToPointerDistance;
    private int myCornerRadius;
    private int myClipY;
    private boolean myTopClip;
    static final AbstractPosition BELOW = new Below();
    static final AbstractPosition ABOVE = new Above();
    static final AbstractPosition AT_RIGHT = new AtRight();
    static final AbstractPosition AT_LEFT = new AtLeft();

    private boolean isWithinChildWindow(@NotNull MouseEvent event) {
        Container child;
        Window owner;
        if (event == null) {
            BalloonImpl.$$$reportNull$$$0(0);
        }
        if ((owner = ComponentUtil.getWindow((Component)this.myContent)) != null && (child = ComponentUtil.getWindow((Component)event.getComponent())) != owner) {
            while (child != null) {
                if (child == owner) {
                    return true;
                }
                child = child.getParent();
            }
        }
        return false;
    }

    public void setFillColor(Color fillColor) {
        this.myFillColor = fillColor;
    }

    public void setPointerColor(Color pointerColor) {
        this.myPointerColor = pointerColor;
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
    }

    private boolean isInsideBalloon(@NotNull MouseEvent me) {
        if (me == null) {
            BalloonImpl.$$$reportNull$$$0(1);
        }
        return this.isInside(new RelativePoint(me));
    }

    @Override
    public boolean isInside(@NotNull RelativePoint target) {
        if (target == null) {
            BalloonImpl.$$$reportNull$$$0(2);
        }
        if (this.component == null) {
            return false;
        }
        Component cmp = target.getOriginalComponent();
        if (!cmp.isShowing()) {
            return true;
        }
        if (cmp instanceof MenuElement) {
            return false;
        }
        if (this.myActionButtons != null && this.myActionButtons.contains(cmp)) {
            return true;
        }
        if (UIUtil.isDescendingFrom((Component)cmp, (Component)((Object)this.component))) {
            return true;
        }
        if (this.component == null || !this.component.isShowing()) {
            return false;
        }
        Point point = target.getScreenPoint();
        SwingUtilities.convertPointFromScreen(point, (Component)((Object)this.component));
        return this.component.contains(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMovingForward(@NotNull RelativePoint target) {
        if (target == null) {
            BalloonImpl.$$$reportNull$$$0(3);
        }
        try {
            if (this.component == null || !this.component.isShowing()) {
                boolean bl = false;
                return bl;
            }
            if (this.myPrevMousePoint == null) {
                boolean bl = true;
                return bl;
            }
            if (this.myPrevMousePoint.getComponent() != target.getComponent()) {
                boolean bl = false;
                return bl;
            }
            Rectangle rectangleOnScreen = new Rectangle(this.component.getLocationOnScreen(), this.component.getSize());
            boolean bl = ScreenUtil.isMovementTowards((Point)this.myPrevMousePoint.getScreenPoint(), (Point)target.getScreenPoint(), (Rectangle)rectangleOnScreen);
            return bl;
        }
        finally {
            this.myPrevMousePoint = target;
        }
    }

    /*
     * WARNING - void declaration
     */
    public BalloonImpl(@NotNull JComponent content2, @NotNull Color borderColor, Insets borderInsets, @NotNull Color fillColor, boolean hideOnMouse, boolean hideOnKey, boolean hideOnAction, boolean hideOnCloseClick, boolean showPointer, boolean enableButtons, long fadeoutTime, boolean hideOnFrameResize, boolean hideOnLinkClick, ActionListener clickHandler, boolean closeOnClick, int animationCycle, int calloutShift, int positionChangeXShift, int positionChangeYShift, boolean dialogMode, @NlsContexts.PopupTitle String title2, Insets contentInsets, boolean shadow, boolean smallVariant, boolean blockClicks, Balloon.Layer layer, boolean requestFocus, Dimension pointerSize, int n) {
        void cornerToPointerDistance;
        if (content2 == null) {
            BalloonImpl.$$$reportNull$$$0(4);
        }
        if (borderColor == null) {
            BalloonImpl.$$$reportNull$$$0(5);
        }
        if (fillColor == null) {
            BalloonImpl.$$$reportNull$$$0(6);
        }
        this.myFadeoutAlarm = new Alarm((Disposable)this);
        this.myZeroPositionInLayer = true;
        this.myAwtActivityListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent e) {
                if (BalloonImpl.this.mySmartFadeoutDelay > 0) {
                    BalloonImpl.this.startFadeoutTimer(BalloonImpl.this.mySmartFadeoutDelay);
                    BalloonImpl.this.mySmartFadeoutDelay = 0;
                }
                int id2 = e.getID();
                if (e instanceof MouseEvent) {
                    boolean forcedExit;
                    MouseEvent me = (MouseEvent)e;
                    boolean insideBalloon = BalloonImpl.this.isInsideBalloon(me);
                    boolean bl = forcedExit = id2 == 505 && me.getButton() != 0 && !BalloonImpl.this.myBlockClicks;
                    if (BalloonImpl.this.myHideOnMouse && (id2 == 501 || forcedExit)) {
                        if (!(insideBalloon && !forcedExit || BalloonImpl.this.isWithinChildWindow(me))) {
                            if (BalloonImpl.this.myHideListener == null) {
                                BalloonImpl.this.hide();
                                if (forcedExit) {
                                    int[] ids;
                                    for (int id_ : ids = new int[]{504, 501, 502, 500}) {
                                        IdeEventQueue.getInstance().dispatchEvent(new MouseEvent(me.getComponent(), id_, me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton()));
                                    }
                                }
                            } else {
                                Runnable runnable2 = BalloonImpl.this.myHideListener;
                                if (runnable2 instanceof HideListenerWithMouse) {
                                    HideListenerWithMouse listener2 = (HideListenerWithMouse)runnable2;
                                    listener2.run(me);
                                } else {
                                    BalloonImpl.this.myHideListener.run();
                                }
                            }
                        }
                        return;
                    }
                    if (BalloonImpl.this.myClickHandler != null && id2 == 500 && !(me.getComponent() instanceof CloseButton) && insideBalloon) {
                        BalloonImpl.this.myClickHandler.actionPerformed(new ActionEvent(me, 1001, "click", me.getModifiersEx()));
                        if (BalloonImpl.this.myCloseOnClick) {
                            BalloonImpl.this.hide();
                            return;
                        }
                    }
                    if (BalloonImpl.this.myEnableButtons && id2 == 503) {
                        boolean moveChanged = insideBalloon != BalloonImpl.this.myLastMoveWasInsideBalloon;
                        BalloonImpl.this.myLastMoveWasInsideBalloon = insideBalloon;
                        if (moveChanged) {
                            if (insideBalloon && !BalloonImpl.this.myFadeoutAlarm.isEmpty()) {
                                BalloonImpl.this.myFadeoutAlarm.cancelAllRequests();
                                BalloonImpl.this.myFadeoutRequestDelay = (int)((long)BalloonImpl.this.myFadeoutRequestDelay - (System.currentTimeMillis() - BalloonImpl.this.myFadeoutRequestMillis));
                            }
                            if (!insideBalloon && BalloonImpl.this.myFadeoutRequestDelay > 0) {
                                BalloonImpl.this.startFadeoutTimer(BalloonImpl.this.myFadeoutRequestDelay);
                            }
                            BalloonImpl.this.component.repaintButton();
                        }
                    }
                    if (BalloonImpl.this.myHideOnCloseClick && UIUtil.isCloseClick((MouseEvent)me)) {
                        if (BalloonImpl.this.isInsideBalloon(me)) {
                            BalloonImpl.this.hide();
                            me.consume();
                        }
                        return;
                    }
                }
                if ((BalloonImpl.this.myHideOnKey || BalloonImpl.this.myHideListener != null) && e instanceof KeyEvent) {
                    KeyEvent ke = (KeyEvent)e;
                    if (id2 == 401) {
                        if (BalloonImpl.this.myHideListener != null) {
                            if (ke.getKeyCode() == 27) {
                                BalloonImpl.this.myHideListener.run();
                            }
                            return;
                        }
                        if (ke.getKeyCode() != 16 && ke.getKeyCode() != 17 && ke.getKeyCode() != 18 && ke.getKeyCode() != 157 && ke.getKeyCode() != 524) {
                            boolean doHide = false;
                            if (ke.getKeyCode() == 27 && SwingUtilities.isDescendingFrom(ke.getComponent(), (Component)((Object)BalloonImpl.this.component))) {
                                doHide = true;
                            }
                            if (BalloonImpl.this.myHideOnKey && !SwingUtilities.isDescendingFrom(ke.getComponent(), (Component)((Object)BalloonImpl.this.component))) {
                                doHide = true;
                            }
                            if (doHide) {
                                BalloonImpl.this.hide();
                            }
                        }
                    }
                }
            }
        };
        this.myListeners = new CopyOnWriteArraySet<JBPopupListener>();
        this.myAnimationEnabled = true;
        this.myComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (BalloonImpl.this.myHideOnFrameResize) {
                    BalloonImpl.this.hide();
                }
            }
        };
        this.myCornerRadius = -1;
        this.myClipY = -1;
        this.myBorderColor = borderColor;
        this.myBorderInsets = borderInsets != null ? borderInsets : JBInsets.create((int)5, (int)8);
        this.myFillColor = fillColor;
        this.myContent = content2;
        this.myHideOnMouse = hideOnMouse;
        this.myHideOnKey = hideOnKey;
        this.myHideOnAction = hideOnAction;
        this.myHideOnCloseClick = hideOnCloseClick;
        this.myShowPointer = showPointer;
        this.myEnableButtons = enableButtons;
        this.myHideOnFrameResize = hideOnFrameResize;
        this.myHideOnLinkClick = hideOnLinkClick;
        this.myClickHandler = clickHandler;
        this.myCloseOnClick = closeOnClick;
        this.myCalloutShift = calloutShift;
        this.myPositionChangeXShift = positionChangeXShift;
        this.myPositionChangeYShift = positionChangeYShift;
        this.myDialogMode = dialogMode;
        this.myTitle = title2;
        this.myLayer = layer != null ? layer : Balloon.Layer.normal;
        this.myBlockClicks = blockClicks;
        this.myRequestFocus = requestFocus;
        MnemonicHelper.init((Component)content2);
        if (!this.myDialogMode) {
            for (Component component2 : UIUtil.uiTraverser((Component)this.myContent)) {
                JCheckBox checkBox;
                if (component2 instanceof JLabel) {
                    JLabel label2 = (JLabel)component2;
                    if (label2.getDisplayedMnemonic() == 0 && label2.getDisplayedMnemonicIndex() < 0) continue;
                    this.myDialogMode = true;
                    break;
                }
                if (!(component2 instanceof JCheckBox) || (checkBox = (JCheckBox)component2).getMnemonic() < 0 && checkBox.getDisplayedMnemonicIndex() < 0) continue;
                this.myDialogMode = true;
                break;
            }
        }
        this.myShadow = shadow;
        this.myShadowSize = Registry.intValue((String)"ide.balloon.shadow.size");
        this.myContainerInsets = contentInsets;
        this.myFadeoutTime = fadeoutTime;
        this.myAnimationCycle = animationCycle;
        this.myPointerSize = pointerSize;
        this.myCornerToPointerDistance = cornerToPointerDistance;
        if (smallVariant) {
            for (Component component2 : UIUtil.uiTraverser((Component)this.myContent)) {
                UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)component2);
            }
        }
    }

    public void show(RelativePoint target, Balloon.Position position) {
        this.show(target, BalloonImpl.getAbstractPositionFor(position));
    }

    public int getLayer() {
        return switch (this.myLayer) {
            default -> throw new MatchException(null, null);
            case Balloon.Layer.normal -> JLayeredPane.POPUP_LAYER;
            case Balloon.Layer.top -> JLayeredPane.DRAG_LAYER;
        };
    }

    public static AbstractPosition getAbstractPositionFor(@NotNull Balloon.Position position) {
        if (position == null) {
            BalloonImpl.$$$reportNull$$$0(7);
        }
        return switch (position) {
            default -> throw new MatchException(null, null);
            case Balloon.Position.atLeft -> AT_LEFT;
            case Balloon.Position.atRight -> AT_RIGHT;
            case Balloon.Position.above -> ABOVE;
            case Balloon.Position.below -> BELOW;
        };
    }

    public void show(PositionTracker<Balloon> tracker2, Balloon.Position position) {
        this.show(tracker2, BalloonImpl.getAbstractPositionFor(position));
    }

    private Insets getInsetsCopy() {
        return JBInsets.create((Insets)this.myBorderInsets);
    }

    private void show(RelativePoint target, AbstractPosition position) {
        this.show((PositionTracker<Balloon>)new PositionTracker.Static(target), position);
    }

    private void show(PositionTracker<Balloon> tracker2, AbstractPosition position) {
        JEditorPane editorPane2;
        RelativePoint locationToShow;
        boolean mnemonicsFix;
        assert (!this.isDisposed) : "Balloon is already disposed";
        if (this.isVisible()) {
            return;
        }
        Component comp = tracker2.getComponent();
        if (!comp.isShowing()) {
            return;
        }
        this.myTracker = tracker2;
        this.myTracker.init((PositionTracker.Client)this);
        JRootPane root = Objects.requireNonNull(UIUtil.getRootPane((Component)comp));
        this.myVisible = true;
        this.layeredPane = root.getLayeredPane();
        this.myPosition = position;
        UIUtil.setFutureRootPane((JComponent)this.myContent, (JRootPane)root);
        this.myFocusManager = IdeFocusManager.findInstanceByComponent((Component)this.layeredPane);
        final Ref originalFocusOwner = new Ref();
        Ref proxyFocusRequest = new Ref((Object)ActionCallback.DONE);
        boolean bl = mnemonicsFix = this.myDialogMode && SystemInfo.isMac && Registry.is((String)"ide.mac.inplaceDialogMnemonicsFix");
        if (mnemonicsFix) {
            proxyFocusRequest.set((Object)new ActionCallback());
            this.myFocusManager.doWhenFocusSettlesDown(new ExpirableRunnable(){

                public boolean isExpired() {
                    return BalloonImpl.this.isDisposed();
                }

                public void run() {
                    IdeEventQueue.getInstance().disableInputMethods(BalloonImpl.this);
                    originalFocusOwner.set((Object)BalloonImpl.this.myFocusManager.getFocusOwner());
                }
            });
        }
        if ((locationToShow = this.myTracker.recalculateLocation((Object)this)) == null) {
            this.hideImmediately();
            return;
        }
        this.layeredPane.addComponentListener(this.myComponentListener);
        this.myTargetPoint = this.myPosition.getShiftedPoint(locationToShow.getPoint((Component)this.layeredPane), this.myCalloutShift);
        if (this.isDisposed) {
            return;
        }
        int positionChangeFix = 0;
        if (this.myShowPointer) {
            Rectangle rec = this.getRecForPosition(this.myPosition, true);
            JBInsets.removeFrom((Rectangle)rec, (Insets)this.getShadowBorderInsets());
            if (!this.myPosition.isOkToHavePointer(this.myTargetPoint, rec, this.getPointerLength(this.myPosition), this.getPointerWidth(this.myPosition), this.getArc())) {
                rec = this.getRecForPosition(this.myPosition, false);
                Rectangle lp = new Rectangle(new Point(this.myContainerInsets.left, this.myContainerInsets.top), this.layeredPane.getSize());
                lp.width -= this.myContainerInsets.right;
                lp.height -= this.myContainerInsets.bottom;
                if (!lp.contains(rec) || !PopupLocationTracker.canRectangleBeUsed(this.layeredPane, rec, this)) {
                    Rectangle2D currentSquare = lp.createIntersection(rec);
                    double maxSquare = currentSquare.getWidth() * currentSquare.getHeight();
                    AbstractPosition targetPosition = this.myPosition;
                    for (AbstractPosition eachPosition : this.myPosition.getOtherPositions()) {
                        Rectangle2D eachIntersection = lp.createIntersection(this.getRecForPosition(eachPosition, false));
                        double eachSquare = eachIntersection.getWidth() * eachIntersection.getHeight();
                        if (!(maxSquare < eachSquare)) continue;
                        maxSquare = eachSquare;
                        targetPosition = eachPosition;
                    }
                    this.myPosition = targetPosition;
                    positionChangeFix = this.myPosition.getChangeShift(position, this.myPositionChangeXShift, this.myPositionChangeYShift);
                }
            }
        }
        if (this.myPosition != position) {
            locationToShow = this.myTracker.recalculateLocation((Object)this);
            if (locationToShow == null) {
                this.hideImmediately();
                return;
            }
            this.myTargetPoint = this.myPosition.getShiftedPoint(locationToShow.getPoint((Component)this.layeredPane), this.myCalloutShift > 0 ? this.myCalloutShift + positionChangeFix : positionChangeFix);
            position = this.myPosition;
        }
        this.createComponent();
        Rectangle r = this.getRecForPosition(this.myPosition, false);
        Point location = r.getLocation();
        SwingUtilities.convertPointToScreen(location, this.layeredPane);
        r.setLocation(location);
        if (!PopupLocationTracker.canRectangleBeUsed(this.layeredPane, r, this)) {
            for (AbstractPosition eachPosition : this.myPosition.getOtherPositions()) {
                r = this.getRecForPosition(eachPosition, false);
                location = r.getLocation();
                SwingUtilities.convertPointToScreen(location, this.layeredPane);
                r.setLocation(location);
                if (!PopupLocationTracker.canRectangleBeUsed(this.layeredPane, r, this)) continue;
                this.myPosition = eachPosition;
                positionChangeFix = this.myPosition.getChangeShift(position, this.myPositionChangeXShift, this.myPositionChangeYShift);
                locationToShow = this.myTracker.recalculateLocation((Object)this);
                if (locationToShow == null) {
                    this.hideImmediately();
                    return;
                }
                this.myTargetPoint = this.myPosition.getShiftedPoint(locationToShow.getPoint((Component)this.layeredPane), this.myCalloutShift > 0 ? this.myCalloutShift + positionChangeFix : positionChangeFix);
                this.myPosition.updateBounds(this);
                break;
            }
        }
        this.component.validate();
        Rectangle rec = this.component.getContentBounds();
        if (this.myShowPointer && !this.myPosition.isOkToHavePointer(this.myTargetPoint, rec, this.getPointerLength(this.myPosition), this.getPointerWidth(this.myPosition), this.getArc())) {
            this.myShowPointer = false;
            this.component.removeAll();
            this.layeredPane.remove((Component)((Object)this.component));
            this.createComponent();
            Dimension availSpace = this.layeredPane.getSize();
            Dimension reqSpace = this.component.getSize();
            if (!new Rectangle(availSpace).contains(new Rectangle(reqSpace))) {
                LOG.warn("Not enough space to show: required [" + reqSpace.width + " x " + reqSpace.height + "], available [" + availSpace.width + " x " + availSpace.height + "]");
                this.component.removeAll();
                this.layeredPane.remove((Component)((Object)this.component));
                this.layeredPane = null;
                this.hide();
                return;
            }
        }
        for (JBPopupListener each : this.myListeners) {
            each.beforeShown(new LightweightWindowEvent((LightweightWindow)this));
        }
        if (this.isAnimationEnabled()) {
            this.runAnimation(true, this.layeredPane, null);
        }
        this.layeredPane.revalidate();
        this.layeredPane.repaint();
        if (this.myRequestFocus) {
            this.myFocusManager.doWhenFocusSettlesDown(new ExpirableRunnable(){

                public boolean isExpired() {
                    return BalloonImpl.this.isDisposed();
                }

                public void run() {
                    BalloonImpl.this.myOriginalFocusOwner = BalloonImpl.this.myFocusManager.getFocusOwner();
                    AccessibleContextUtil.setParent((Component)BalloonImpl.this.myContent, (Component)BalloonImpl.this.myOriginalFocusOwner);
                    BalloonImpl.this.myFocusManager.requestFocus(BalloonImpl.this.getContentToFocus(), true);
                }
            });
        }
        if (mnemonicsFix) {
            ((ActionCallback)proxyFocusRequest.get()).doWhenDone(() -> this.myFocusManager.requestFocus((Component)originalFocusOwner.get(), true));
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myAwtActivityListener, 56L);
        if (ApplicationManager.getApplication() != null) {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

                public void beforeActionPerformed(@NotNull AnAction action2, @NotNull AnActionEvent event) {
                    if (action2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    if (BalloonImpl.this.myHideOnAction && !HintManagerImpl.isActionToIgnore(action2)) {
                        BalloonImpl.this.hide();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "action";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/ui/BalloonImpl$5";
                    objectArray[2] = "beforeActionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        if (this.myHideOnLinkClick && (editorPane2 = (JEditorPane)UIUtil.uiTraverser((Component)this.myContent).traverse().filter(JEditorPane.class).first()) != null) {
            editorPane2.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                    if (e == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    BalloonImpl.this.hide();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/BalloonImpl$6", "hyperlinkActivated"));
                }
            });
        }
        if (this.myId != null) {
            BalloonUsageCollector.BALLOON_SHOWN.log((Object)this.myId);
        }
        BalloonImpl.getBalloonListener().balloonShown((Balloon)this);
    }

    private static BalloonListener getBalloonListener() {
        return (BalloonListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BalloonListener.TOPIC);
    }

    public AbstractPosition getPosition() {
        return this.myPosition;
    }

    @NotNull
    private Component getContentToFocus() {
        Component child;
        JViewport viewport;
        Component focusComponent2 = this.myContent;
        FocusTraversalPolicy policy = this.myContent.getFocusTraversalPolicy();
        if (policy instanceof SortingFocusTraversalPolicy && ((SortingFocusTraversalPolicy)policy).getImplicitDownCycleTraversal()) {
            focusComponent2 = policy.getDefaultComponent(this.myContent);
        }
        while (focusComponent2 instanceof JScrollPane && (viewport = ((JScrollPane)focusComponent2).getViewport()) != null && (child = viewport.getView()) != null) {
            focusComponent2 = child;
        }
        JComponent jComponent = focusComponent2;
        if (jComponent == null) {
            BalloonImpl.$$$reportNull$$$0(8);
        }
        return jComponent;
    }

    private Rectangle getRecForPosition(AbstractPosition position, boolean adjust) {
        Dimension size2 = this.getContentSizeFor(position);
        Rectangle rec = new Rectangle(new Point(0, 0), size2);
        position.setRecToRelativePosition(rec, this.myTargetPoint);
        if (adjust) {
            rec = this.myPosition.getUpdatedBounds(this, rec.getSize(), this.getShadowBorderInsets());
        } else {
            JBInsets.addTo((Rectangle)rec, (Insets)this.getShadowBorderInsets());
        }
        return rec;
    }

    private Dimension getContentSizeFor(AbstractPosition position) {
        Dimension size2 = this.myContent.getPreferredSize();
        if (this.myShadowBorderProvider == null) {
            JBInsets.addTo((Dimension)size2, (Insets)position.createBorder(this).getBorderInsets());
        }
        return size2;
    }

    private void disposeButton(ActionButton button2) {
        if (button2 != null && button2.getParent() != null) {
            Container parent = button2.getParent();
            parent.remove((Component)((Object)button2));
            ((JComponent)parent).revalidate();
            parent.repaint();
        }
    }

    public JComponent getContent() {
        return this.myContent;
    }

    public JComponent getComponent() {
        return this.component;
    }

    private void createComponent() {
        this.component = new MyComponent(this.myContent, this, this.myShadowBorderProvider != null ? null : (this.myShowPointer ? this.myPosition.createBorder(this) : this.getPointlessBorder()));
        if (this.myActionProvider == null) {
            final Consumer listener2 = event -> SwingUtilities.invokeLater(() -> this.hide());
            this.myActionProvider = new ActionProvider(){
                private ActionButton myCloseButton;

                @Override
                @NotNull
                public List<ActionButton> createActions() {
                    this.myCloseButton = new CloseButton((Consumer<? super MouseEvent>)listener2);
                    List<ActionButton> list2 = Collections.singletonList(this.myCloseButton);
                    if (list2 == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                @Override
                public void layout(@NotNull Rectangle lpBounds) {
                    if (lpBounds == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    if (this.myCloseButton == null || !this.myCloseButton.isVisible()) {
                        return;
                    }
                    Icon icon2 = BalloonImpl.this.getCloseButton();
                    int iconWidth = icon2.getIconWidth();
                    int iconHeight = icon2.getIconHeight();
                    Insets borderInsets = BalloonImpl.this.getShadowBorderInsets();
                    this.myCloseButton.setBounds(lpBounds.x + lpBounds.width - iconWidth - borderInsets.right - JBUIScale.scale((int)8), lpBounds.y + borderInsets.top + JBUIScale.scale((int)6), iconWidth, iconHeight);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ui/BalloonImpl$7";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "lpBounds";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createActions";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ui/BalloonImpl$7";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "layout";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1 -> new IllegalArgumentException(string);
                    };
                }
            };
        }
        this.component.clear();
        this.component.myAlpha = this.isAnimationEnabled() ? 0.0f : -1.0f;
        this.createComponentBorder();
        this.layeredPane.add((Component)((Object)this.component));
        if (this.myZeroPositionInLayer) {
            this.layeredPane.setLayer((Component)((Object)this.component), this.getLayer(), 0);
        }
        this.myPosition.updateBounds(this);
        PopupLocationTracker.register(this);
        if (this.myBlockClicks) {
            this.component.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    e.consume();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    e.consume();
                }
            });
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(LafManagerListener.TOPIC, source -> this.updateComponent());
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> this.updateComponent());
    }

    private void createComponentBorder() {
        if (this.component == null) {
            return;
        }
        this.component.setBorder(new EmptyBorder(this.getShadowBorderInsets()));
    }

    private void updateComponent() {
        this.createComponentBorder();
    }

    @Override
    @NotNull
    public Rectangle getConsumedScreenBounds() {
        Rectangle bounds = this.component.getBounds();
        Point location = bounds.getLocation();
        SwingUtilities.convertPointToScreen(location, this.layeredPane);
        bounds.setLocation(location);
        Rectangle rectangle = bounds;
        if (rectangle == null) {
            BalloonImpl.$$$reportNull$$$0(9);
        }
        return rectangle;
    }

    @Override
    public Window getUnderlyingWindow() {
        return ComponentUtil.getWindow((Component)this.layeredPane);
    }

    @NotNull
    private EmptyBorder getPointlessBorder() {
        return new EmptyBorder(this.myBorderInsets);
    }

    public void revalidate() {
        if (!this.isDisposed && this.myTracker != null) {
            this.revalidate(this.myTracker);
        }
    }

    public void revalidate(@NotNull PositionTracker<Balloon> tracker2) {
        if (tracker2 == null) {
            BalloonImpl.$$$reportNull$$$0(10);
        }
        if (this.isDisposed || ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        RelativePoint newPosition = tracker2.recalculateLocation((Object)this);
        if (newPosition != null) {
            Point newPoint = this.myPosition.getShiftedPoint(newPosition.getPoint((Component)this.layeredPane), this.myCalloutShift);
            this.invalidateShadow = !Objects.equals(this.myTargetPoint, newPoint);
            this.myTargetPoint = newPoint;
            this.myPosition.updateBounds(this);
        }
    }

    @Nullable
    public ShadowBorderProvider getShadowBorderProvider() {
        return this.myShadowBorderProvider;
    }

    public void setShadowBorderProvider(@NotNull ShadowBorderProvider provider) {
        if (provider == null) {
            BalloonImpl.$$$reportNull$$$0(11);
        }
        this.myShadowBorderProvider = provider;
    }

    private int getShadowBorderSize() {
        return this.hasShadow() ? this.myShadowSize : 0;
    }

    @NotNull
    public Insets getShadowBorderInsets() {
        if (this.myShadowBorderProvider != null) {
            Insets insets = this.myShadowBorderProvider.getInsets();
            if (insets == null) {
                BalloonImpl.$$$reportNull$$$0(12);
            }
            return insets;
        }
        JBInsets jBInsets = JBUI.insets((int)this.getShadowBorderSize());
        if (jBInsets == null) {
            BalloonImpl.$$$reportNull$$$0(13);
        }
        return jBInsets;
    }

    public boolean hasShadow() {
        return this.myShadowBorderProvider != null || this.myShadow && Registry.is((String)"ide.balloon.shadowEnabled");
    }

    public void show(JLayeredPane pane2) {
        this.show(pane2, null);
    }

    public void showInCenterOf(JComponent component2) {
        Dimension size2 = component2.getSize();
        this.show(new RelativePoint((Component)component2, new Point(size2.width / 2, size2.height / 2)), Balloon.Position.above);
    }

    public void show(JLayeredPane pane2, @Nullable Rectangle bounds) {
        if (bounds != null) {
            this.myForcedBounds = bounds;
        }
        this.show(new RelativePoint((Component)pane2, new Point(0, 0)), Balloon.Position.above);
    }

    private void runAnimation(boolean forward, final JLayeredPane layeredPane2, final @Nullable Runnable onDone) {
        if (this.animator != null) {
            this.animator.dispose();
        }
        this.animator = new Animator("Balloon", 8, this.isAnimationEnabled() ? this.myAnimationCycle : 0, false, forward){

            public void paintNow(int frame, int totalFrames, int cycle) {
                if (BalloonImpl.this.component == null || BalloonImpl.this.component.getParent() == null || !BalloonImpl.this.isAnimationEnabled()) {
                    return;
                }
                BalloonImpl.this.component.setAlpha((float)frame / (float)totalFrames);
            }

            protected void paintCycleEnd() {
                if (BalloonImpl.this.component == null || BalloonImpl.this.component.getParent() == null) {
                    return;
                }
                if (this.isForward()) {
                    BalloonImpl.this.component.clear();
                    BalloonImpl.this.component.repaint();
                    BalloonImpl.this.myFadedIn = true;
                    if (!BalloonImpl.this.myFadeoutAlarm.isDisposed()) {
                        BalloonImpl.this.startFadeoutTimer((int)BalloonImpl.this.myFadeoutTime);
                    }
                } else {
                    layeredPane2.remove((Component)((Object)BalloonImpl.this.component));
                    layeredPane2.revalidate();
                    layeredPane2.repaint();
                }
                this.dispose();
            }

            public void dispose() {
                super.dispose();
                BalloonImpl.this.animator = null;
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        this.animator.resume();
    }

    void runWithSmartFadeoutPause(@NotNull Runnable handler) {
        if (handler == null) {
            BalloonImpl.$$$reportNull$$$0(14);
        }
        if (this.mySmartFadeout) {
            this.isSmartFadeoutPaused = true;
            handler.run();
            if (this.isSmartFadeoutPaused) {
                this.isSmartFadeoutPaused = false;
            } else {
                this.setAnimationEnabled(true);
                this.hide();
            }
        } else {
            handler.run();
        }
    }

    public void startSmartFadeoutTimer(int delay) {
        this.mySmartFadeout = true;
        this.mySmartFadeoutDelay = delay;
        Topics.subscribe((Topic)ApplicationActivationListener.TOPIC, (Disposable)this, (Object)new ApplicationActivationListener(){

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (!BalloonImpl.this.myFadeoutAlarm.isEmpty()) {
                    BalloonImpl.this.myFadeoutAlarm.cancelAllRequests();
                    BalloonImpl.this.mySmartFadeoutDelay = BalloonImpl.this.myFadeoutRequestDelay - (int)(System.currentTimeMillis() - BalloonImpl.this.myFadeoutRequestMillis);
                    if (BalloonImpl.this.mySmartFadeoutDelay <= 0) {
                        BalloonImpl.this.mySmartFadeoutDelay = 1;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/ui/BalloonImpl$10", "applicationDeactivated"));
            }
        });
    }

    public void startFadeoutTimer(int fadeoutDelay) {
        if (fadeoutDelay > 0) {
            this.myFadeoutAlarm.cancelAllRequests();
            this.myFadeoutRequestMillis = System.currentTimeMillis();
            this.myFadeoutRequestDelay = fadeoutDelay;
            this.myFadeoutAlarm.addRequest((Runnable)((ContextAwareRunnable)() -> {
                if (this.mySmartFadeout) {
                    this.setAnimationEnabled(true);
                }
                this.hide(true);
            }), fadeoutDelay, null);
        }
    }

    public void setCornerRadius(int radius) {
        this.myCornerRadius = radius;
    }

    private int getArc() {
        if (this.myCornerRadius != -1) {
            return this.myCornerRadius;
        }
        return this.myDialogMode ? DIALOG_ARC.get() : ARC.get();
    }

    private int getPointerWidth(AbstractPosition position) {
        if (this.myPointerSize == null || this.myPointerSize.width <= 0) {
            if (this.myDialogMode) {
                return position.isTopBottomPointer() ? DIALOG_TOPBOTTOM_POINTER_WIDTH.get() : DIALOG_POINTER_WIDTH.get();
            }
            return position.isTopBottomPointer() ? TOPBOTTOM_POINTER_WIDTH.get() : POINTER_WIDTH.get();
        }
        return this.myPointerSize.width;
    }

    public static int getNormalInset() {
        return 3;
    }

    private int getPointerLength(AbstractPosition position) {
        return this.myPointerSize == null || this.myPointerSize.height <= 0 ? BalloonImpl.getPointerLength(position, this.myDialogMode) : this.myPointerSize.height;
    }

    private static int getPointerLength(AbstractPosition position, boolean dialogMode) {
        if (dialogMode) {
            return position.isTopBottomPointer() ? DIALOG_TOPBOTTOM_POINTER_LENGTH.get() : DIALOG_POINTER_LENGTH.get();
        }
        return position.isTopBottomPointer() ? TOPBOTTOM_POINTER_LENGTH.get() : POINTER_LENGTH.get();
    }

    public static int getPointerLength(@NotNull Balloon.Position position, boolean dialogMode) {
        if (position == null) {
            BalloonImpl.$$$reportNull$$$0(15);
        }
        return BalloonImpl.getPointerLength(BalloonImpl.getAbstractPositionFor(position), dialogMode);
    }

    public void hide() {
        this.hide(false);
    }

    public void hide(boolean ok) {
        this.hideAndDispose(ok, false);
    }

    public void dispose() {
        this.hideAndDispose(false, false);
    }

    public void hideImmediately() {
        this.setAnimationEnabled(false);
        this.hideAndDispose(false, true);
    }

    private void hideAndDispose(boolean ok, boolean force) {
        if (this.isDisposed) {
            if (force) {
                this.disposeAnimationAndRemoveComponent();
            }
            return;
        }
        if (this.isSmartFadeoutPaused) {
            this.isSmartFadeoutPaused = false;
            return;
        }
        this.isDisposed = true;
        this.hideComboBoxPopups();
        Runnable disposeRunnable = () -> {
            this.myFadedOut = true;
            if (this.myRequestFocus && this.myOriginalFocusOwner != null) {
                this.myFocusManager.requestFocus(this.myOriginalFocusOwner, false);
            }
            for (JBPopupListener each : this.myListeners) {
                each.onClosed(new LightweightWindowEvent((LightweightWindow)this, ok));
            }
            Disposer.dispose((Disposable)this);
            this.onDisposed();
        };
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAwtActivityListener);
        if (this.layeredPane == null) {
            disposeRunnable.run();
        } else {
            this.layeredPane.removeComponentListener(this.myComponentListener);
            if (this.isAnimationEnabled()) {
                this.runAnimation(false, this.layeredPane, disposeRunnable);
            } else {
                this.disposeAnimationAndRemoveComponent();
                disposeRunnable.run();
            }
        }
        this.myVisible = false;
        this.myTracker = null;
    }

    private void disposeAnimationAndRemoveComponent() {
        if (this.animator != null) {
            this.animator.dispose();
        }
        if (this.component != null) {
            this.layeredPane.remove((Component)((Object)this.component));
            this.layeredPane.revalidate();
            this.layeredPane.repaint();
            this.component = null;
        }
    }

    private void hideComboBoxPopups() {
        for (JComboBox box : ComponentUtil.findComponentsOfType((JComponent)((Object)this.component), JComboBox.class)) {
            box.hidePopup();
        }
    }

    private void onDisposed() {
    }

    public void addListener(@NotNull JBPopupListener listener2) {
        if (listener2 == null) {
            BalloonImpl.$$$reportNull$$$0(16);
        }
        this.myListeners.add(listener2);
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setHideOnClickOutside(boolean hideOnMouse) {
        this.myHideOnMouse = hideOnMouse;
    }

    public void setHideListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            BalloonImpl.$$$reportNull$$$0(17);
        }
        this.myHideListener = listener2;
        this.myHideOnMouse = true;
    }

    public void setZeroPositionInLayer(boolean zeroPositionInLayer) {
        this.myZeroPositionInLayer = zeroPositionInLayer;
    }

    public void setShowPointer(boolean show2) {
        this.myShowPointer = show2;
    }

    public void setPointerShiftedToStart(boolean pointerShiftedToStart) {
        this.myPointerShiftedToStart = pointerShiftedToStart;
    }

    public Icon getCloseButton() {
        return AllIcons.Ide.Notification.Close;
    }

    public void setBounds(Rectangle bounds) {
        this.myForcedBounds = bounds;
        if (this.myPosition != null) {
            this.myPosition.updateBounds(this);
        }
    }

    public Dimension getPreferredSize() {
        if (this.component != null) {
            return this.component.getPreferredSize();
        }
        if (this.myDefaultPrefSize == null) {
            EmptyBorder border = this.myShadowBorderProvider == null ? this.getPointlessBorder() : null;
            MyComponent c = new MyComponent(this.myContent, this, border);
            c.setBorder(new EmptyBorder(this.getShadowBorderInsets()));
            this.myDefaultPrefSize = c.getPreferredSize();
        }
        return this.myDefaultPrefSize;
    }

    @NotNull
    private static RoundRectangle2D.Double getPointlessShape(BalloonImpl balloon, Rectangle bounds) {
        return new RoundRectangle2D.Double(bounds.x, bounds.y, bounds.width - JBUIScale.scale((int)1), bounds.height - JBUIScale.scale((int)1), balloon.getArc(), balloon.getArc());
    }

    public boolean wasFadedIn() {
        return this.myFadedIn;
    }

    public boolean wasFadedOut() {
        return this.myFadedOut;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@NlsContexts.NotificationTitle String title2) {
        this.myTitle = title2;
        this.myTitleLabel.setText(title2);
    }

    public void setActionProvider(@NotNull ActionProvider actionProvider) {
        if (actionProvider == null) {
            BalloonImpl.$$$reportNull$$$0(18);
        }
        this.myActionProvider = actionProvider;
    }

    @Override
    public RelativePoint getShowingPoint() {
        Point p = this.myPosition.getShiftedPoint(this.myTargetPoint, this.myCalloutShift * -1);
        return new RelativePoint((Component)this.layeredPane, p);
    }

    public void setAnimationEnabled(boolean enabled2) {
        this.myAnimationEnabled = enabled2;
    }

    public boolean isAnimationEnabled() {
        return this.myAnimationEnabled && this.myAnimationCycle > 0 && !RemoteDesktopService.isRemoteSession();
    }

    public void setBlockClicks(boolean blockClicks) {
        this.myBlockClicks = blockClicks;
    }

    public boolean isBlockClicks() {
        return this.myBlockClicks;
    }

    public boolean isClickProcessor() {
        return this.myClickHandler != null || !this.myCloseOnClick || this.isBlockClicks();
    }

    public String getId() {
        return this.myId;
    }

    public void setId(String id2) {
        this.myId = id2;
    }

    public int getClipY() {
        return this.myClipY;
    }

    public void setTopClip(boolean value) {
        this.myTopClip = value;
    }

    public void setClipY(int clipY) {
        int oldClip = this.myClipY;
        this.myClipY = clipY;
        if (oldClip != clipY) {
            this.component.repaint();
        }
    }

    public void setActionButtonsVisible(boolean aFlag) {
        if (this.myActionButtons != null) {
            for (ActionButton button2 : this.myActionButtons) {
                button2.setVisible(aFlag);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "borderColor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fillColor";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/BalloonImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/BalloonImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentToFocus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumedScreenBounds";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowBorderInsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isWithinChildWindow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInsideBalloon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInside";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMovingForward";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAbstractPositionFor";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "revalidate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setShadowBorderProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runWithSmartFadeoutPause";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPointerLength";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setHideListener";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setActionProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 12, 13 -> new IllegalStateException(string);
        };
    }

    private final class MyComponent
    extends HwFacadeJPanel
    implements ComponentWithMnemonics {
        private BufferedImage myImage;
        private float myAlpha;
        private final BalloonImpl myBalloon;
        private final JComponent myContent;
        private ShadowBorderPainter.Shadow myShadow;

        public void setVisible(boolean aFlag) {
            BalloonImpl.this.setActionButtonsVisible(aFlag);
            super.setVisible(aFlag);
        }

        private MyComponent(JComponent content2, BalloonImpl balloon, EmptyBorder shapeBorder) {
            this.setOpaque(false);
            this.setLayout(null);
            this.putClientProperty(UIUtil.TEXT_COPY_ROOT, Boolean.TRUE);
            this.myBalloon = balloon;
            if (!ScreenReader.isActive()) {
                this.setFocusCycleRoot(true);
            }
            this.putClientProperty("Balloon.property", BalloonImpl.this);
            this.myContent = new JPanel(new BorderLayout(2, 2));
            Wrapper contentWrapper = new Wrapper(content2);
            if (BalloonImpl.this.myTitle != null) {
                BalloonImpl.this.myTitleLabel = new JLabel(BalloonImpl.this.myTitle, 0);
                BalloonImpl.this.myTitleLabel.setForeground(UIUtil.getListBackground());
                BalloonImpl.this.myTitleLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
                this.myContent.add((Component)BalloonImpl.this.myTitleLabel, "North");
                contentWrapper.setBorder(JBUI.Borders.empty((int)1));
            }
            this.myContent.add((Component)contentWrapper, "Center");
            this.myContent.setBorder(shapeBorder);
            this.myContent.setOpaque(false);
            this.add(this.myContent);
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container aContainer, Component aComponent) {
                    return WeakFocusStackManager.getInstance().getLastFocusedOutside((Container)((Object)MyComponent.this));
                }

                @Override
                public Component getComponentBefore(Container aContainer, Component aComponent) {
                    return WeakFocusStackManager.getInstance().getLastFocusedOutside((Container)((Object)MyComponent.this));
                }

                @Override
                public Component getFirstComponent(Container aContainer) {
                    return WeakFocusStackManager.getInstance().getLastFocusedOutside((Container)((Object)MyComponent.this));
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    return WeakFocusStackManager.getInstance().getLastFocusedOutside((Container)((Object)MyComponent.this));
                }

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return WeakFocusStackManager.getInstance().getLastFocusedOutside((Container)((Object)MyComponent.this));
                }
            });
        }

        @NotNull
        Rectangle getContentBounds() {
            Rectangle bounds = this.getBounds();
            JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
            Rectangle rectangle = bounds;
            if (rectangle == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            return rectangle;
        }

        public void clear() {
            this.myImage = null;
            this.myAlpha = -1.0f;
        }

        public void doLayout() {
            Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
            this.myContent.setBounds(bounds);
        }

        public Dimension getPreferredSize() {
            return this.addInsets(this.myContent.getPreferredSize());
        }

        public Dimension getMinimumSize() {
            return this.addInsets(this.myContent.getMinimumSize());
        }

        private Dimension addInsets(Dimension size2) {
            JBInsets.addTo((Dimension)size2, (Insets)this.getInsets());
            return size2;
        }

        protected void paintChildren(Graphics g) {
            if (this.myImage == null || this.myAlpha == -1.0f) {
                super.paintChildren(g);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintChildrenImpl(Graphics g) {
            BufferedImage image2 = ImageUtil.createImage((Graphics)g, (int)this.getWidth(), (int)this.getHeight(), (int)1);
            UIUtil.useSafely((Graphics)image2.createGraphics(), imageGraphics -> {
                imageGraphics.setPaint(new Color(BalloonImpl.this.myFillColor.getRGB()));
                imageGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintChildren((Graphics)imageGraphics);
            });
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                if (JreHiDpiUtil.isJreHiDPI((Graphics2D)g2d)) {
                    float s = 1.0f / JBUIScale.sysScale((Graphics2D)g2d);
                    g2d.scale(s, s);
                }
                StartupUiUtil.drawImage((Graphics)g2d, (Image)MyComponent.makeColorTransparent(image2, BalloonImpl.this.myFillColor), (int)0, (int)0, null);
            }
            finally {
                g2d.dispose();
            }
        }

        private static Image makeColorTransparent(Image image2, Color color) {
            final int markerRGB = color.getRGB() | 0xFF000000;
            RGBImageFilter filter2 = new RGBImageFilter(){

                @Override
                public int filterRGB(int x, int y, int rgb) {
                    if ((rgb | 0xFF000000) == markerRGB) {
                        return 0xFFFFFF & rgb;
                    }
                    return rgb;
                }
            };
            return ImageUtil.filter((Image)image2, (ImageFilter)filter2);
        }

        protected void paintComponent(Graphics g) {
            if (BalloonImpl.this.myClipY != -1) {
                if (BalloonImpl.this.myTopClip) {
                    g.setClip(0, BalloonImpl.this.myClipY, this.getWidth(), this.getHeight() - BalloonImpl.this.myClipY);
                } else {
                    g.setClip(0, 0, this.getWidth(), BalloonImpl.this.myClipY);
                }
            }
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            Point pointTarget = SwingUtilities.convertPoint(BalloonImpl.this.layeredPane, this.myBalloon.myTargetPoint, (Component)((Object)this));
            Rectangle shapeBounds = this.myContent.getBounds();
            if (!DrawUtil.isSimplifiedUI()) {
                int shadowSize = this.myBalloon.getShadowBorderSize();
                if (shadowSize > 0 && this.myShadow == null && BalloonImpl.this.myShadowBorderProvider == null) {
                    this.initComponentImage(pointTarget, shapeBounds);
                    this.myShadow = ShadowBorderPainter.createShadow(this.myImage, 0, 0, false, shadowSize / 2);
                }
                if (this.myImage == null && this.myAlpha != -1.0f) {
                    this.initComponentImage(pointTarget, shapeBounds);
                }
                if (this.myImage != null && this.myAlpha != -1.0f) {
                    g2d.setComposite(AlphaComposite.getInstance(3, this.myAlpha));
                }
                if (BalloonImpl.this.myShadowBorderProvider != null) {
                    BalloonImpl.this.myShadowBorderProvider.paintShadow((JComponent)((Object)this), g);
                }
            }
            if (this.myImage != null && this.myAlpha != -1.0f) {
                this.paintShadow(g);
                StartupUiUtil.drawImage((Graphics)g2d, (Image)this.myImage, (int)0, (int)0, null);
            } else {
                this.paintShadow(g);
                this.myBalloon.myPosition.paintComponent(this.myBalloon, shapeBounds, (Graphics2D)g, pointTarget);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintShadow(Graphics graphics) {
            if (this.myShadow != null) {
                Graphics2D g2d = (Graphics2D)graphics;
                try {
                    if (JreHiDpiUtil.isJreHiDPI((Graphics2D)g2d)) {
                        g2d = (Graphics2D)graphics.create();
                        float s = 1.0f / JBUIScale.sysScale((Component)((Object)this));
                        g2d.scale(s, s);
                    }
                    StartupUiUtil.drawImage((Graphics)g2d, (Image)this.myShadow.getImage(), (int)this.myShadow.getX(), (int)this.myShadow.getY(), null);
                }
                finally {
                    if (g2d != graphics) {
                        g2d.dispose();
                    }
                }
            }
        }

        public boolean contains(int x, int y) {
            Point pointTarget = SwingUtilities.convertPoint(BalloonImpl.this.layeredPane, this.myBalloon.myTargetPoint, (Component)((Object)this));
            Rectangle bounds = this.myContent.getBounds();
            Shape shape = BalloonImpl.this.myShowPointer ? this.myBalloon.myPosition.getPointingShape(bounds, pointTarget, this.myBalloon) : BalloonImpl.getPointlessShape(this.myBalloon, bounds);
            return shape.contains(x, y);
        }

        private void initComponentImage(Point pointTarget, Rectangle shapeBounds) {
            if (this.myImage != null) {
                return;
            }
            this.myImage = UIUtil.createImage((Component)((Object)BalloonImpl.this.component), (int)this.getWidth(), (int)this.getHeight(), (int)2);
            UIUtil.useSafely((Graphics)this.myImage.getGraphics(), imageGraphics -> {
                this.myBalloon.myPosition.paintComponent(this.myBalloon, shapeBounds, (Graphics2D)imageGraphics, pointTarget);
                this.paintChildrenImpl((Graphics)imageGraphics);
            });
        }

        public void removeNotify() {
            super.removeNotify();
            if (!ScreenUtil.isStandardAddRemoveNotify((Component)((Object)this))) {
                return;
            }
            List<ActionButton> buttons = BalloonImpl.this.myActionButtons;
            BalloonImpl.this.myActionButtons = null;
            if (buttons != null) {
                SwingUtilities.invokeLater(() -> {
                    for (ActionButton button2 : buttons) {
                        BalloonImpl.this.disposeButton(button2);
                    }
                });
            }
        }

        public void setAlpha(float alpha) {
            this.myAlpha = alpha;
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
        }

        void _setBounds(@NotNull Rectangle bounds) {
            Rectangle currentBounds;
            if (bounds == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            if (!(currentBounds = this.getBounds()).equals(bounds) || BalloonImpl.this.invalidateShadow) {
                this.invalidateShadowImage();
                BalloonImpl.this.invalidateShadow = false;
            }
            this.setBounds(bounds);
            this.doLayout();
            if (this.getParent() != null) {
                if (BalloonImpl.this.myActionButtons == null) {
                    BalloonImpl.this.myActionButtons = BalloonImpl.this.myActionProvider.createActions();
                }
                for (ActionButton button2 : BalloonImpl.this.myActionButtons) {
                    if (button2.getParent() != null) continue;
                    BalloonImpl.this.layeredPane.add((Component)((Object)button2));
                    BalloonImpl.this.layeredPane.setLayer((Component)((Object)button2), JLayeredPane.DRAG_LAYER);
                }
            }
            if (this.isVisible()) {
                Rectangle lpBounds = SwingUtilities.convertRectangle(this.getParent(), bounds, BalloonImpl.this.layeredPane);
                lpBounds = BalloonImpl.this.myPosition.getPointlessContentRec(lpBounds, this.myBalloon.myShadowBorderProvider == null ? this.myBalloon.getPointerLength(BalloonImpl.this.myPosition) : 0);
                BalloonImpl.this.myActionProvider.layout(lpBounds);
            }
            if (this.isVisible()) {
                this.revalidate();
                this.repaint();
            }
        }

        private void invalidateShadowImage() {
            this.myImage = null;
            this.myShadow = null;
        }

        void repaintButton() {
            if (BalloonImpl.this.myActionButtons != null) {
                for (ActionButton button2 : BalloonImpl.this.myActionButtons) {
                    button2.repaint();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$MyComponent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentBounds";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$MyComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "_setBounds";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static abstract class AbstractPosition {
        abstract EmptyBorder createBorder(BalloonImpl var1);

        abstract void setRecToRelativePosition(Rectangle var1, Point var2);

        abstract int getChangeShift(AbstractPosition var1, int var2, int var3);

        public void updateBounds(@NotNull BalloonImpl balloon) {
            if (balloon == null) {
                AbstractPosition.$$$reportNull$$$0(0);
            }
            if (balloon.layeredPane == null || balloon.component == null) {
                return;
            }
            Insets shadow = balloon.component.getInsets();
            Dimension prefSize = balloon.component.getPreferredSize();
            JBInsets.removeFrom((Dimension)prefSize, (Insets)shadow);
            Rectangle bounds = this.getUpdatedBounds(balloon, prefSize, shadow);
            if (balloon.myShadowBorderProvider == null && balloon.myForcedBounds != null) {
                bounds = new Rectangle(this.getShiftedPoint(bounds.getLocation(), balloon.getShadowBorderInsets()), bounds.getSize());
            }
            balloon.component._setBounds(bounds);
        }

        @NotNull
        Rectangle getUpdatedBounds(BalloonImpl balloon, Dimension contentSize, Insets shadowInsets) {
            Dimension layeredPaneSize = balloon.layeredPane.getSize();
            Point point = balloon.myTargetPoint;
            Rectangle bounds = balloon.myForcedBounds;
            if (bounds == null) {
                Point location;
                int distance = this.getDistance(balloon, contentSize);
                Point point2 = location = balloon.myShowPointer ? this.getLocation(layeredPaneSize, point, contentSize, distance) : new Point(point.x - contentSize.width / 2, point.y - contentSize.height / 2);
                if (balloon.myShowPointer && balloon.myPointerShiftedToStart) {
                    int offset = JBUI.scale((int)20);
                    if (this == ABOVE || this == BELOW) {
                        if (contentSize.width / 2 > offset) {
                            location.x = point.x - offset;
                        }
                    } else if ((this == AT_LEFT || this == AT_RIGHT) && contentSize.height / 2 > offset) {
                        location.y = point.y - offset;
                    }
                }
                bounds = new Rectangle(location.x, location.y, contentSize.width, contentSize.height);
                JBInsets.addTo((Rectangle)bounds, (Insets)shadowInsets);
                ScreenUtil.moveToFit((Rectangle)bounds, (Rectangle)new Rectangle(0, 0, layeredPaneSize.width, layeredPaneSize.height), (Insets)balloon.myContainerInsets, (boolean)true);
            }
            Rectangle rectangle = bounds;
            if (rectangle == null) {
                AbstractPosition.$$$reportNull$$$0(1);
            }
            return rectangle;
        }

        private int getDistance(@NotNull BalloonImpl balloon, @NotNull Dimension size2) {
            if (balloon == null) {
                AbstractPosition.$$$reportNull$$$0(2);
            }
            if (size2 == null) {
                AbstractPosition.$$$reportNull$$$0(3);
            }
            if (balloon.myCornerToPointerDistance < 0) {
                return -1;
            }
            int indent = balloon.getArc() + balloon.getPointerWidth(this) / 2;
            if (balloon.myCornerToPointerDistance < indent) {
                return indent;
            }
            int limit = this == ABOVE || this == BELOW ? size2.width - indent : size2.height - indent;
            return Math.min(balloon.myCornerToPointerDistance, limit);
        }

        abstract Point getLocation(Dimension var1, Point var2, Dimension var3, int var4);

        void paintComponent(BalloonImpl balloon, Rectangle bounds, Graphics2D g, Point pointTarget) {
            GraphicsConfig cfg = new GraphicsConfig((Graphics)g);
            cfg.setAntialiasing(true);
            if (balloon.myShadowBorderProvider != null) {
                balloon.myShadowBorderProvider.paintBorder(bounds, g);
                if (balloon.myShowPointer) {
                    Balloon.Position position = this == ABOVE ? Balloon.Position.above : (this == BELOW ? Balloon.Position.below : (this == AT_LEFT ? Balloon.Position.atLeft : Balloon.Position.atRight));
                    balloon.myShadowBorderProvider.paintPointingShape(bounds, pointTarget, position, g);
                }
                cfg.restore();
                return;
            }
            Shape shape = balloon.myShowPointer ? this.getPointingShape(bounds, pointTarget, balloon) : BalloonImpl.getPointlessShape(balloon, bounds);
            g.setPaint(balloon.myFillColor);
            g.fill(shape);
            if (balloon.myShowPointer && balloon.myPointerColor != null) {
                Rectangle balloonShape = this.getPointlessContentRec(bounds, BalloonImpl.getPointerLength(this, balloon.myDialogMode) + 1);
                Area area = new Area(shape);
                area.subtract(new Area(balloonShape));
                g.setColor(balloon.myPointerColor);
                g.fill(area);
            }
            g.setColor(balloon.myBorderColor);
            if (balloon.myTitleLabel != null) {
                Rectangle titleBounds = balloon.myTitleLabel.getBounds();
                Insets inset = this.getTitleInsets(BalloonImpl.getNormalInset() - 1, balloon.getPointerLength(this) + 50);
                Insets borderInsets = balloon.getShadowBorderInsets();
                inset.top += borderInsets.top;
                inset.bottom += borderInsets.bottom;
                inset.left += borderInsets.left;
                inset.right += borderInsets.right;
                titleBounds.x -= inset.left + JBUIScale.scale((int)1);
                titleBounds.width += inset.left + inset.right + JBUIScale.scale((int)50);
                titleBounds.y -= inset.top + JBUIScale.scale((int)1);
                titleBounds.height += inset.top + inset.bottom + JBUIScale.scale((int)1);
                Area area = new Area(shape);
                area.intersect(new Area(titleBounds));
                Color fgColor = UIManager.getColor("Label.foreground");
                fgColor = ColorUtil.toAlpha((Color)fgColor, (int)140);
                g.setColor(fgColor);
                g.fill(area);
                g.setColor(balloon.myBorderColor);
                g.draw(area);
            }
            g.setStroke(new BasicStroke(BORDER_STROKE_WIDTH.get()));
            g.draw(shape);
            cfg.restore();
        }

        protected abstract Insets getTitleInsets(int var1, int var2);

        protected abstract Shape getPointingShape(Rectangle var1, Point var2, BalloonImpl var3);

        boolean isOkToHavePointer(@NotNull Point targetPoint, @NotNull Rectangle bounds, int pointerLength, int pointerWidth, int arc) {
            UnfairTextRange pointerRange;
            UnfairTextRange balloonRange;
            if (targetPoint == null) {
                AbstractPosition.$$$reportNull$$$0(4);
            }
            if (bounds == null) {
                AbstractPosition.$$$reportNull$$$0(5);
            }
            if (bounds.x < targetPoint.x && bounds.x + bounds.width > targetPoint.x && bounds.y < targetPoint.y && bounds.y + bounds.height > targetPoint.y) {
                return false;
            }
            Rectangle pointless = this.getPointlessContentRec(bounds, pointerLength);
            int distance = this.getDistanceToTarget(pointless, targetPoint);
            if (distance < pointerLength - 1 || distance > 2 * pointerLength) {
                return false;
            }
            if (this.isTopBottomPointer()) {
                balloonRange = new UnfairTextRange(bounds.x + arc - 1, bounds.x + bounds.width - arc + 1);
                pointerRange = new UnfairTextRange(targetPoint.x - pointerWidth / 2, targetPoint.x + pointerWidth / 2);
            } else {
                balloonRange = new UnfairTextRange(bounds.y + arc - 1, bounds.y + bounds.height - arc + 1);
                pointerRange = new UnfairTextRange(targetPoint.y - pointerWidth / 2, targetPoint.y + pointerWidth / 2);
            }
            return balloonRange.contains((TextRange)pointerRange);
        }

        protected abstract int getDistanceToTarget(Rectangle var1, Point var2);

        boolean isTopBottomPointer() {
            return this instanceof Below || this instanceof Above;
        }

        protected abstract Rectangle getPointlessContentRec(Rectangle var1, int var2);

        @NotNull
        Set<AbstractPosition> getOtherPositions() {
            LinkedHashSet<AbstractPosition> all = new LinkedHashSet<AbstractPosition>();
            all.add(BELOW);
            all.add(ABOVE);
            all.add(AT_RIGHT);
            all.add(AT_LEFT);
            all.remove(this);
            LinkedHashSet<AbstractPosition> linkedHashSet = all;
            if (linkedHashSet == null) {
                AbstractPosition.$$$reportNull$$$0(6);
            }
            return linkedHashSet;
        }

        @NotNull
        public abstract Point getShiftedPoint(@NotNull Point var1, int var2);

        @NotNull
        public abstract Point getShiftedPoint(@NotNull Point var1, @NotNull Insets var2);

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "balloon";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$AbstractPosition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "size";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$AbstractPosition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUpdatedBounds";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOtherPositions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updateBounds";
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDistance";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isOkToHavePointer";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static interface ShadowBorderProvider {
        @NotNull
        public Insets getInsets();

        public void paintShadow(@NotNull JComponent var1, @NotNull Graphics var2);

        public void paintBorder(@NotNull Rectangle var1, @NotNull Graphics2D var2);

        public void paintPointingShape(@NotNull Rectangle var1, @NotNull Point var2, @NotNull Balloon.Position var3, @NotNull Graphics2D var4);
    }

    public class ActionButton
    extends HwFacadeNonOpaquePanel
    implements IdeGlassPane.TopComponent {
        private final Icon myIcon;
        private final Icon myHoverIcon;
        private final Consumer<? super MouseEvent> myListener;
        protected final BaseButtonBehavior myButton;

        public ActionButton(@Nullable Icon icon2, @NlsContexts.Tooltip @Nullable Icon hoverIcon, @NotNull String hint, Consumer<? super MouseEvent> listener2) {
            if (icon2 == null) {
                ActionButton.$$$reportNull$$$0(0);
            }
            if (listener2 == null) {
                ActionButton.$$$reportNull$$$0(1);
            }
            this.myIcon = icon2;
            this.myHoverIcon = hoverIcon;
            this.myListener = listener2;
            this.setToolTipText(hint);
            this.myButton = new BaseButtonBehavior((JComponent)((Object)this), TimedDeadzone.NULL, null){

                protected void execute(MouseEvent e) {
                    ActionButton.this.myListener.consume((Object)e);
                }
            };
            this.myButton.setupListeners();
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.myIcon.getIconWidth(), this.myIcon.getIconHeight());
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.hasPaint()) {
                this.paintIcon(g, this.myHoverIcon != null && this.myButton.isHovered() ? this.myHoverIcon : this.myIcon);
            }
        }

        boolean hasPaint() {
            return this.getWidth() > 0 && BalloonImpl.this.myLastMoveWasInsideBalloon;
        }

        protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon2) {
            if (g == null) {
                ActionButton.$$$reportNull$$$0(2);
            }
            if (icon2 == null) {
                ActionButton.$$$reportNull$$$0(3);
            }
            icon2.paintIcon((Component)((Object)this), g, 0, 0);
        }

        public boolean canBePreprocessed(@NotNull MouseEvent e) {
            if (e == null) {
                ActionButton.$$$reportNull$$$0(4);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/BalloonImpl$ActionButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canBePreprocessed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ActionProvider {
        @NotNull
        public List<ActionButton> createActions();

        public void layout(@NotNull Rectangle var1);
    }

    private static final class Below
    extends AbstractPosition {
        private Below() {
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, int shift) {
            if (targetPoint == null) {
                Below.$$$reportNull$$$0(0);
            }
            return new Point(targetPoint.x, targetPoint.y + shift);
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, @NotNull Insets shift) {
            if (targetPoint == null) {
                Below.$$$reportNull$$$0(1);
            }
            if (shift == null) {
                Below.$$$reportNull$$$0(2);
            }
            Point point = this.getShiftedPoint(targetPoint, -shift.top);
            if (point == null) {
                Below.$$$reportNull$$$0(3);
            }
            return point;
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == ABOVE ? yShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return rectangle.y - targetPoint.y;
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x, bounds.y + pointerLength, bounds.width, bounds.height - pointerLength);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.top += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(new Point(targetPoint.x - rec.width / 2, targetPoint.y));
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance) {
            if (distance > 0) {
                return new Point(targetPoint.x - distance, targetPoint.y);
            }
            Point center = StartupUiUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(center.x, targetPoint.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(pointerLength, JBUIScale.scale((int)normalInset), JBUIScale.scale((int)normalInset), JBUIScale.scale((int)normalInset));
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            pointTarget = new Point(pointTarget.x, Math.min(bounds.y, pointTarget.y));
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 1);
            shaper.line(balloon.getPointerWidth(this) / 2, balloon.getPointerLength(this)).toRightCurve().roundRightDown().toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().lineTo(pointTarget.x - balloon.getPointerWidth(this) / 2, shaper.getCurrent().y).lineTo(pointTarget.x, pointTarget.y);
            shaper.close();
            return shaper.getShape();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shift";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$Below";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$Below";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShiftedPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getShiftedPoint";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Above
    extends AbstractPosition {
        private Above() {
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, int shift) {
            if (targetPoint == null) {
                Above.$$$reportNull$$$0(0);
            }
            return new Point(targetPoint.x, targetPoint.y - shift);
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, @NotNull Insets shift) {
            if (targetPoint == null) {
                Above.$$$reportNull$$$0(1);
            }
            if (shift == null) {
                Above.$$$reportNull$$$0(2);
            }
            Point point = this.getShiftedPoint(targetPoint, -shift.top);
            if (point == null) {
                Above.$$$reportNull$$$0(3);
            }
            return point;
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == BELOW ? -yShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return targetPoint.y - (int)rectangle.getMaxY();
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height - pointerLength);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.bottom += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x - rec.width / 2, targetPoint.y - rec.height);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance) {
            if (distance > 0) {
                return new Point(targetPoint.x - distance, targetPoint.y - balloonSize.height);
            }
            Point center = StartupUiUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(center.x, targetPoint.y - balloonSize.height);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return JBUI.insets((int)normalInset, (int)normalInset, (int)normalInset, (int)normalInset);
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            pointTarget = new Point(pointTarget.x, Math.max((int)bounds.getMaxY(), pointTarget.y));
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 3);
            shaper.line(-balloon.getPointerWidth(this) / 2, -balloon.getPointerLength(this) + JBUIScale.scale((int)1));
            shaper.toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().toRightCurve().roundRightDown().toBottomCurve().line(0, 2).roundLeftDown().lineTo(pointTarget.x + balloon.getPointerWidth(this) / 2, shaper.getCurrent().y).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shift";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$Above";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$Above";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShiftedPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getShiftedPoint";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class AtRight
    extends AbstractPosition {
        private AtRight() {
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, int shift) {
            if (targetPoint == null) {
                AtRight.$$$reportNull$$$0(0);
            }
            return new Point(targetPoint.x + shift, targetPoint.y);
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, @NotNull Insets shift) {
            if (targetPoint == null) {
                AtRight.$$$reportNull$$$0(1);
            }
            if (shift == null) {
                AtRight.$$$reportNull$$$0(2);
            }
            Point point = this.getShiftedPoint(targetPoint, -shift.left);
            if (point == null) {
                AtRight.$$$reportNull$$$0(3);
            }
            return point;
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == AT_LEFT ? xShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return rectangle.x - targetPoint.x;
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x + pointerLength, bounds.y, bounds.width - pointerLength, bounds.height);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.left += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x, targetPoint.y - rec.height / 2);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance) {
            if (distance > 0) {
                return new Point(targetPoint.x, targetPoint.y - distance);
            }
            Point center = StartupUiUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(targetPoint.x, center.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(JBUIScale.scale((int)normalInset), pointerLength, JBUIScale.scale((int)normalInset), JBUIScale.scale((int)normalInset));
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            pointTarget = new Point(Math.min(bounds.x, pointTarget.y), pointTarget.y);
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 2);
            shaper.line(balloon.getPointerLength(this), -balloon.getPointerWidth(this) / 2).toTopCurve().roundUpRight().toRightCurve().roundRightDown().toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().lineTo(shaper.getCurrent().x, pointTarget.y + balloon.getPointerWidth(this) / 2).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shift";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$AtRight";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$AtRight";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShiftedPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getShiftedPoint";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class AtLeft
    extends AbstractPosition {
        private AtLeft() {
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, int shift) {
            if (targetPoint == null) {
                AtLeft.$$$reportNull$$$0(0);
            }
            return new Point(targetPoint.x - shift, targetPoint.y);
        }

        @Override
        @NotNull
        public Point getShiftedPoint(@NotNull Point targetPoint, @NotNull Insets shift) {
            if (targetPoint == null) {
                AtLeft.$$$reportNull$$$0(1);
            }
            if (shift == null) {
                AtLeft.$$$reportNull$$$0(2);
            }
            Point point = this.getShiftedPoint(targetPoint, -shift.left);
            if (point == null) {
                AtLeft.$$$reportNull$$$0(3);
            }
            return point;
        }

        @Override
        int getChangeShift(AbstractPosition original, int xShift, int yShift) {
            return original == AT_RIGHT ? -xShift : 0;
        }

        @Override
        protected int getDistanceToTarget(Rectangle rectangle, Point targetPoint) {
            return targetPoint.x - (int)rectangle.getMaxX();
        }

        @Override
        protected Rectangle getPointlessContentRec(Rectangle bounds, int pointerLength) {
            return new Rectangle(bounds.x, bounds.y, bounds.width - pointerLength, bounds.height);
        }

        @Override
        EmptyBorder createBorder(BalloonImpl balloon) {
            Insets insets = balloon.getInsetsCopy();
            insets.right += balloon.getPointerLength(this);
            return new EmptyBorder(insets);
        }

        @Override
        void setRecToRelativePosition(Rectangle rec, Point targetPoint) {
            rec.setLocation(targetPoint.x - rec.width, targetPoint.y - rec.height / 2);
        }

        @Override
        Point getLocation(Dimension containerSize, Point targetPoint, Dimension balloonSize, int distance) {
            if (distance > 0) {
                return new Point(targetPoint.x - balloonSize.width, targetPoint.y - distance);
            }
            Point center = StartupUiUtil.getCenterPoint((Rectangle)new Rectangle(targetPoint, (Dimension)JBUI.emptySize()), (Dimension)balloonSize);
            return new Point(targetPoint.x - balloonSize.width, center.y);
        }

        @Override
        protected Insets getTitleInsets(int normalInset, int pointerLength) {
            return new Insets(JBUIScale.scale((int)normalInset), pointerLength, JBUIScale.scale((int)normalInset), JBUIScale.scale((int)normalInset));
        }

        @Override
        protected Shape getPointingShape(Rectangle bounds, Point pointTarget, BalloonImpl balloon) {
            pointTarget = new Point(Math.max((int)bounds.getMaxX(), pointTarget.x), pointTarget.y);
            Shaper shaper = new Shaper(balloon, bounds, pointTarget, 4);
            shaper.lineTo((int)bounds.getMaxX() - shaper.getTargetDelta(4) - JBUIScale.scale((int)1), pointTarget.y + balloon.getPointerWidth(this) / 2);
            shaper.toBottomCurve().roundLeftDown().toLeftCurve().roundLeftUp().toTopCurve().roundUpRight().toRightCurve().roundRightDown().lineTo(shaper.getCurrent().x, pointTarget.y - balloon.getPointerWidth(this) / 2).lineTo(pointTarget.x, pointTarget.y).close();
            return shaper.getShape();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetPoint";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "shift";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/BalloonImpl$AtLeft";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/BalloonImpl$AtLeft";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShiftedPoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getShiftedPoint";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static interface HideListenerWithMouse
    extends Runnable {
        public void run(MouseEvent var1);
    }

    private static final class Shaper {
        private final GeneralPath myPath = new GeneralPath();
        Rectangle myBounds;
        @JdkConstants.TabPlacement
        private final int myTargetSide;
        private final BalloonImpl myBalloon;

        Shaper(BalloonImpl balloon, Rectangle bounds, Point targetPoint, @JdkConstants.TabPlacement int targetSide) {
            this.myBalloon = balloon;
            this.myBounds = bounds;
            this.myTargetSide = targetSide;
            this.start(targetPoint);
        }

        private void start(Point start2) {
            this.myPath.moveTo(start2.x, start2.y);
        }

        @NotNull
        Shaper roundUpRight() {
            this.myPath.quadTo(this.getCurrent().x, this.getCurrent().y - this.myBalloon.getArc(), this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y - this.myBalloon.getArc());
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(0);
            }
            return shaper;
        }

        @NotNull
        Shaper roundRightDown() {
            this.myPath.quadTo(this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y, this.getCurrent().x + this.myBalloon.getArc(), this.getCurrent().y + this.myBalloon.getArc());
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(1);
            }
            return shaper;
        }

        @NotNull
        Shaper roundLeftUp() {
            this.myPath.quadTo(this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y, this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y - this.myBalloon.getArc());
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(2);
            }
            return shaper;
        }

        @NotNull
        Shaper roundLeftDown() {
            this.myPath.quadTo(this.getCurrent().x, this.getCurrent().y + this.myBalloon.getArc(), this.getCurrent().x - this.myBalloon.getArc(), this.getCurrent().y + this.myBalloon.getArc());
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(3);
            }
            return shaper;
        }

        public Point getCurrent() {
            return new Point((int)this.myPath.getCurrentPoint().getX(), (int)this.myPath.getCurrentPoint().getY());
        }

        public Shaper line(int deltaX, int deltaY) {
            this.myPath.lineTo(this.getCurrent().x + deltaX, this.getCurrent().y + deltaY);
            return this;
        }

        public Shaper lineTo(int x, int y) {
            this.myPath.lineTo(x, y);
            return this;
        }

        private int getTargetDelta(@JdkConstants.TabPlacement int effectiveSide) {
            return effectiveSide == this.myTargetSide ? this.myBalloon.getPointerLength(this.myBalloon.myPosition) : 0;
        }

        @NotNull
        Shaper toRightCurve() {
            this.myPath.lineTo((int)this.myBounds.getMaxX() - this.myBalloon.getArc() - this.getTargetDelta(4) - JBUIScale.scale((int)1), this.getCurrent().y);
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(4);
            }
            return shaper;
        }

        @NotNull
        Shaper toBottomCurve() {
            this.myPath.lineTo(this.getCurrent().x, (int)this.myBounds.getMaxY() - this.myBalloon.getArc() - this.getTargetDelta(3) - JBUIScale.scale((int)1));
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(5);
            }
            return shaper;
        }

        @NotNull
        Shaper toLeftCurve() {
            this.myPath.lineTo((int)this.myBounds.getX() + this.myBalloon.getArc() + this.getTargetDelta(2), this.getCurrent().y);
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(6);
            }
            return shaper;
        }

        @NotNull
        Shaper toTopCurve() {
            this.myPath.lineTo(this.getCurrent().x, (int)this.myBounds.getY() + this.myBalloon.getArc() + this.getTargetDelta(1));
            Shaper shaper = this;
            if (shaper == null) {
                Shaper.$$$reportNull$$$0(7);
            }
            return shaper;
        }

        public void close() {
            this.myPath.closePath();
        }

        public Shape getShape() {
            return this.myPath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ui/BalloonImpl$Shaper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roundUpRight";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roundRightDown";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roundLeftUp";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "roundLeftDown";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toRightCurve";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toBottomCurve";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toLeftCurve";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toTopCurve";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private final class CloseButton
    extends ActionButton {
        private CloseButton(Consumer<? super MouseEvent> listener2) {
            if (listener2 == null) {
                CloseButton.$$$reportNull$$$0(0);
            }
            super(BalloonImpl.this.getCloseButton(), null, null, listener2);
            this.setVisible(BalloonImpl.this.myEnableButtons);
        }

        @Override
        protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon2) {
            if (g == null) {
                CloseButton.$$$reportNull$$$0(1);
            }
            if (icon2 == null) {
                CloseButton.$$$reportNull$$$0(2);
            }
            if (BalloonImpl.this.myEnableButtons) {
                icon2.paintIcon((Component)((Object)this), g, 0, 0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/BalloonImpl$CloseButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintIcon";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

