/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.ide.ui.laf.darcula.ui.DarculaEditorTextFieldBorder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.zoomIndicator.ZoomIndicatorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.AbstractDelegatingToRootTraversalPolicy;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextComponent;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.LineSeparator;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTextField
extends NonOpaquePanel
implements EditorTextComponent,
DocumentListener,
UiCompatibleDataProvider,
TextAccessor,
FocusListener,
MouseListener {
    public static final Key<Boolean> SUPPLEMENTARY_KEY = Key.create((String)"Supplementary");
    private static final Key<LineSeparator> LINE_SEPARATOR_KEY = Key.create((String)"ETF_LINE_SEPARATOR");
    private static final Key<Boolean> MANAGED_BY_FIELD = Key.create((String)"MANAGED_BY_FIELD");
    private static final Logger LOG = Logger.getInstance(EditorTextField.class);
    private Document myDocument;
    private final Project myProject;
    private FileType myFileType;
    private EditorEx myEditor;
    private final Set<Editor> myEditorsToBeReleased;
    private Component myNextFocusable;
    @NotNull
    private DeferredSelection deferredSelection;
    private final List<DocumentListener> myDocumentListeners;
    private final List<FocusListener> myFocusListeners;
    private final List<MouseListener> myMouseListeners;
    private boolean myIsListenerInstalled;
    private boolean myIsViewer;
    private boolean myIsSupplementary;
    private boolean myInheritSwingFont;
    private boolean myIgnoreSetBgColor;
    private Color myEnforcedBgColor;
    private boolean myOneLineMode;
    private boolean myShowPlaceholderWhenFocused;
    private boolean myEnsureWillComputePreferredSize;
    private Dimension myPassivePreferredSize;
    @Nls
    private CharSequence myHintText;
    private boolean myIsRendererWithSelection;
    private Color myRendererBg;
    private Color myRendererFg;
    private int myPreferredWidth;
    private int myCaretPosition;
    private final List<EditorSettingsProvider> mySettingsProviders;
    private Disposable myDisposable;
    private Disposable myManualDisposable;
    private boolean myInHierarchy;
    @Nls
    private String myAccessibleName;

    public EditorTextField() {
        this("");
    }

    public EditorTextField(@NotNull String text2) {
        if (text2 == null) {
            EditorTextField.$$$reportNull$$$0(0);
        }
        this(text2, null, (FileType)FileTypes.PLAIN_TEXT);
    }

    public EditorTextField(@NotNull String text2, Project project2, FileType fileType2) {
        if (text2 == null) {
            EditorTextField.$$$reportNull$$$0(1);
        }
        this(EditorFactory.getInstance().createDocument((CharSequence)StringUtil.convertLineSeparators((String)text2)), project2, fileType2);
        LINE_SEPARATOR_KEY.set((UserDataHolder)this.myDocument, (Object)EditorTextField.detectLineSeparators(this.myDocument, text2));
    }

    public EditorTextField(Document document2, Project project2, FileType fileType2) {
        this(document2, project2, fileType2, false);
    }

    public EditorTextField(Project project2, FileType fileType2) {
        this((Document)null, project2, fileType2);
    }

    public EditorTextField(Document document2, Project project2, FileType fileType2, boolean isViewer) {
        this(document2, project2, fileType2, isViewer, true);
    }

    public EditorTextField(Document document2, Project project2, FileType fileType2, boolean isViewer, boolean oneLineMode) {
        this.myEditorsToBeReleased = new HashSet<Editor>();
        this.deferredSelection = DeferredSelection.None.getInstance();
        this.myDocumentListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myFocusListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myInheritSwingFont = true;
        this.myPreferredWidth = -1;
        this.myCaretPosition = -1;
        this.mySettingsProviders = new ArrayList<EditorSettingsProvider>();
        this.myOneLineMode = oneLineMode;
        this.myIsViewer = isViewer;
        this.setDocument(document2);
        this.myProject = project2;
        this.myFileType = fileType2;
        this.setLayout(new BorderLayout());
        this.enableEvents(8L);
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new Jdk7DelegatingToRootTraversalPolicy());
        this.setFont(UIManager.getFont("TextField.font"));
        this.addHierarchyListener(e -> {
            if ((e.getChangeFlags() & 4L) != 0L && e.getChanged().isShowing() && this.myEditor == null) {
                this.initEditor();
            }
        });
        this.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGapsKt.UnscaledGaps((int)3));
        this.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.BOTH);
    }

    @Nullable
    private Project getProjectIfValid() {
        return this.myProject == null || this.myProject.isDisposed() ? null : this.myProject;
    }

    public void setDisposedWith(@NotNull Disposable disposable) {
        if (disposable == null) {
            EditorTextField.$$$reportNull$$$0(2);
        }
        assert (this.myManualDisposable == null);
        Disposer.register((Disposable)disposable, () -> {
            this.myManualDisposable = null;
            this.deInitEditor();
        });
        this.myManualDisposable = disposable;
    }

    public void setSupplementary(boolean supplementary) {
        this.myIsSupplementary = supplementary;
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            editor2.putUserData(SUPPLEMENTARY_KEY, (Object)supplementary);
        }
    }

    public void setFontInheritedFromLAF(boolean b) {
        this.myInheritSwingFont = b;
        this.setDocument(this.myDocument);
    }

    public void setShowPlaceholderWhenFocused(boolean b) {
        this.myShowPlaceholderWhenFocused = b;
        EditorEx editor2 = this.getEditor(false);
        if (editor2 != null) {
            editor2.setShowPlaceholderWhenFocused(this.myShowPlaceholderWhenFocused);
        }
    }

    @NotNull
    public String getText() {
        Document document2 = this.getDocument();
        String text2 = document2.getText();
        LineSeparator separator = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)document2);
        if (separator != null) {
            String string = StringUtil.convertLineSeparators((String)text2, (String)separator.getSeparatorString());
            if (string == null) {
                EditorTextField.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            EditorTextField.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void updateUI() {
        try {
            this.myIgnoreSetBgColor = this.myEnforcedBgColor == null;
            super.updateUI();
        }
        finally {
            this.myIgnoreSetBgColor = false;
        }
    }

    public void setBackground(Color bg) {
        if (this.myIgnoreSetBgColor) {
            bg = this.getBackground();
            super.setBackground(bg);
        } else {
            super.setBackground(bg);
            this.myEnforcedBgColor = bg;
        }
        EditorEx editor2 = this.getEditor(false);
        if (editor2 != null) {
            editor2.setBackgroundColor(bg);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public void addDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            EditorTextField.$$$reportNull$$$0(5);
        }
        this.myDocumentListeners.add(listener2);
        this.installDocumentListener();
    }

    public void removeDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            EditorTextField.$$$reportNull$$$0(6);
        }
        this.myDocumentListeners.remove(listener2);
        this.uninstallDocumentListener(false);
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (event == null) {
            EditorTextField.$$$reportNull$$$0(7);
        }
        for (DocumentListener documentListener2 : this.myDocumentListeners) {
            documentListener2.beforeDocumentChange(event);
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            EditorTextField.$$$reportNull$$$0(8);
        }
        for (DocumentListener documentListener2 : this.myDocumentListeners) {
            documentListener2.documentChanged(event);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Document getDocument() {
        if (this.myDocument == null) {
            this.myDocument = this.createDocument();
        }
        Document document2 = this.myDocument;
        if (document2 == null) {
            EditorTextField.$$$reportNull$$$0(9);
        }
        return document2;
    }

    public void setDocument(Document document2) {
        if (this.myDocument != null) {
            this.uninstallDocumentListener(true);
        }
        this.myDocument = document2;
        this.installDocumentListener();
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            boolean wasFocused = this.isFocusOwner();
            EditorEx newEditor = this.createEditor();
            this.scheduleEditorRelease();
            this.myEditor = newEditor;
            this.add(newEditor.getComponent(), "Center");
            if (this.myNextFocusable != null) {
                newEditor.getContentComponent().setNextFocusableComponent(this.myNextFocusable);
                this.myNextFocusable = null;
            }
            if (wasFocused) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> this.requestFocus());
            }
            this.releaseScheduledEditors();
            this.validate();
        }
    }

    private void installDocumentListener() {
        if (this.myDocument != null && !this.myDocumentListeners.isEmpty() && !this.myIsListenerInstalled) {
            this.myIsListenerInstalled = true;
            this.myDocument.addDocumentListener((DocumentListener)this);
        }
    }

    private void uninstallDocumentListener(boolean force) {
        if (this.myDocument != null && this.myIsListenerInstalled && (force || this.myDocumentListeners.isEmpty())) {
            this.myIsListenerInstalled = false;
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }

    public void setText(@Nullable String text2) {
        WriteIntentReadAction.run(() -> CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
            CaretModel caretModel;
            LineSeparator separator = (LineSeparator)LINE_SEPARATOR_KEY.get((UserDataHolder)this.myDocument);
            if (separator == null) {
                separator = EditorTextField.detectLineSeparators(this.myDocument, text2);
            }
            LINE_SEPARATOR_KEY.set((UserDataHolder)this.myDocument, (Object)separator);
            this.myDocument.replaceString(0, this.myDocument.getTextLength(), (CharSequence)EditorTextField.normalize(text2, separator));
            Editor editor2 = this.getEditor();
            if (editor2 != null && (caretModel = editor2.getCaretModel()).getOffset() >= this.myDocument.getTextLength()) {
                caretModel.moveToOffset(this.myDocument.getTextLength());
            }
        }), null, null, UndoConfirmationPolicy.DEFAULT, this.getDocument()));
    }

    @NotNull
    private static String normalize(@Nullable String text2, @Nullable LineSeparator separator) {
        if (text2 == null || separator == null) {
            String string = StringUtil.notNullize((String)text2);
            if (string == null) {
                EditorTextField.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = StringUtil.convertLineSeparators((String)text2);
        if (string == null) {
            EditorTextField.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static LineSeparator detectLineSeparators(@Nullable Document document2, @Nullable String text2) {
        boolean doNotNormalizeDetect;
        if (text2 == null) {
            return null;
        }
        boolean bl = doNotNormalizeDetect = document2 instanceof DocumentImpl && ((DocumentImpl)document2).acceptsSlashR();
        if (doNotNormalizeDetect) {
            return null;
        }
        return StringUtil.detectSeparators((CharSequence)text2);
    }

    public void setPlaceholder(@Nls @Nullable CharSequence text2) {
        this.myHintText = text2;
        EditorEx editor2 = this.getEditor(false);
        if (editor2 != null) {
            editor2.setPlaceholder(text2);
        }
    }

    public void select(@NotNull TextRange range) {
        Editor editor2;
        if (range == null) {
            EditorTextField.$$$reportNull$$$0(12);
        }
        if ((editor2 = this.getEditor()) != null) {
            EditorTextField.doSelect(editor2, range);
        } else {
            this.deferredSelection = new DeferredSelection.Custom(range);
        }
    }

    public void selectAll() {
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            EditorTextField.doSelect(editor2, TextRange.create((int)0, (int)editor2.getDocument().getTextLength()));
        } else {
            this.deferredSelection = DeferredSelection.All.getInstance();
        }
    }

    private static void doSelect(@NotNull Editor editor2, @NotNull TextRange range) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(13);
        }
        if (range == null) {
            EditorTextField.$$$reportNull$$$0(14);
        }
        editor2.getCaretModel().removeSecondaryCarets();
        editor2.getCaretModel().getPrimaryCaret().setSelection(range.getStartOffset(), range.getEndOffset(), false);
    }

    public void removeSelection() {
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            editor2.getSelectionModel().removeSelection();
        } else {
            this.deferredSelection = DeferredSelection.None.getInstance();
        }
    }

    public void setCaretPosition(int position) {
        Document document2 = this.getDocument();
        if (position > document2.getTextLength() || position < 0) {
            throw new IllegalArgumentException("bad position: " + position);
        }
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            editor2.getCaretModel().moveToOffset(position);
        } else {
            this.myCaretPosition = position;
        }
    }

    public CaretModel getCaretModel() {
        EditorEx editor2 = this.getEditor(true);
        return editor2 == null ? null : editor2.getCaretModel();
    }

    public boolean isFocusOwner() {
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            return IJSwingUtilities.hasFocus(editor2.getContentComponent());
        }
        return super.isFocusOwner();
    }

    protected void onEditorAdded(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(15);
        }
    }

    private void initEditorDisposables() {
        Disposable uiDisposable = (Disposable)PlatformDataKeys.UI_DISPOSABLE.getData(DataManager.getInstance().getDataContext((Component)((Object)this)));
        if (uiDisposable != null) {
            Disposer.register((Disposable)uiDisposable, this::releaseEditorNow);
        }
        this.myDisposable = Disposer.newDisposable((String)"ETF dispose");
        Disposer.register((Disposable)this.myDisposable, this::releaseEditorLater);
        final Project project2 = this.getProjectIfValid();
        if (project2 != null) {
            project2.getMessageBus().connect(this.myDisposable).subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

                public void projectClosing(@NotNull Project p) {
                    if (p == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (p == project2) {
                        EditorTextField.this.releaseEditorNow();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/ui/EditorTextField$1", "projectClosing"));
                }
            });
        }
        Disposer.register((Disposable)this.myDisposable, () -> WriteIntentReadAction.run(() -> {
            Document document2 = this.myDocument;
            if (document2 != null) {
                if (project2 != null && !project2.isDisposed()) {
                    ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).clearDocumentReferences(document2);
                }
                ((UndoManagerImpl)UndoManager.getGlobalInstance()).clearDocumentReferences(document2);
            }
        }));
    }

    private EditorEx initEditor() {
        if (this.myDisposable == null) {
            this.initEditorDisposables();
        }
        if (this.myEditor != null) {
            this.releaseEditorLater();
        }
        boolean isFocused = this.isFocusOwner();
        EditorEx editor2 = this.initEditorInner();
        this.onEditorAdded(editor2);
        if (this.myNextFocusable != null) {
            editor2.getContentComponent().setNextFocusableComponent(this.myNextFocusable);
            this.myNextFocusable = null;
        }
        this.revalidate();
        if (isFocused) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> this.requestFocus());
        }
        return editor2;
    }

    private EditorEx initEditorInner() {
        String tooltip;
        EditorEx editor2 = this.createEditor();
        editor2.getContentComponent().setEnabled(this.isEnabled());
        if (this.myCaretPosition >= 0) {
            EditorThreading.run(() -> editor2.getCaretModel().moveToOffset(this.myCaretPosition));
            editor2.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        if (StringUtil.isNotEmpty((String)(tooltip = this.getToolTipText()))) {
            editor2.getContentComponent().setToolTipText(tooltip);
        }
        this.myEditor = editor2;
        this.add(editor2.getComponent(), "Center");
        return editor2;
    }

    public void removeNotify() {
        this.myInHierarchy = false;
        super.removeNotify();
        InternalDecoratorImpl.componentWithEditorBackgroundRemoved((Component)((Object)this));
        if (this.myManualDisposable == null) {
            this.deInitEditor();
        }
    }

    private void deInitEditor() {
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    private void releaseEditor(@NotNull Editor editor2) {
        PsiFile psiFile;
        Project project2;
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(16);
        }
        if ((project2 = this.getProjectIfValid()) != null && this.myIsViewer && (psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor2.getDocument())) != null) {
            DaemonCodeAnalyzer.getInstance((Project)project2).setHighlightingEnabled(psiFile, true);
        }
        this.remove(editor2.getComponent());
        editor2.getContentComponent().removeFocusListener(this);
        editor2.getContentComponent().removeMouseListener(this);
        if (!editor2.isDisposed()) {
            EditorFactory.getInstance().releaseEditor(editor2);
        }
    }

    private void releaseEditorNow() {
        this.scheduleEditorRelease();
        this.releaseScheduledEditors();
    }

    private boolean scheduleEditorRelease() {
        EditorEx editor2 = this.myEditor;
        if (editor2 == null) {
            return false;
        }
        this.myEditorsToBeReleased.add(editor2);
        this.myEditor = null;
        return true;
    }

    void releaseEditorLater() {
        if (this.scheduleEditorRelease()) {
            ApplicationManager.getApplication().invokeLater(this::releaseScheduledEditors, ModalityState.stateForComponent((Component)((Object)this)));
        }
    }

    private void releaseScheduledEditors() {
        for (Editor editorToRelease : this.myEditorsToBeReleased) {
            this.releaseEditor(editorToRelease);
        }
        this.myEditorsToBeReleased.clear();
    }

    public void setFont(Font font) {
        super.setFont(font);
        EditorEx editor2 = this.getEditor(false);
        if (editor2 != null) {
            this.setupEditorFont(editor2);
        }
    }

    protected boolean isOneLineMode() {
        return this.myOneLineMode;
    }

    private void initOneLineMode(EditorEx editor2) {
        boolean isOneLineMode = this.isOneLineMode();
        editor2.setOneLineMode(isOneLineMode);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme customGlobalScheme = colorsManager.getSchemeForCurrentUITheme();
        editor2.setColorsScheme(editor2.createBoundColorSchemeDelegate((EditorColorsScheme)(isOneLineMode ? customGlobalScheme : null)));
        editor2.getSettings().setCaretRowShown(false);
        editor2.getSettings().setDndEnabled(false);
        this.setupEditorFont(editor2);
        this.updateBorder(editor2);
        editor2.setBackgroundColor(this.getBackground());
    }

    public void setOneLineMode(boolean oneLineMode) {
        this.myOneLineMode = oneLineMode;
    }

    protected Document createDocument() {
        Project project2 = this.getProjectIfValid();
        PsiFileFactory factory2 = PsiFileFactory.getInstance((Project)project2);
        long stamp = LocalTimeCounter.currentTime();
        if (this.myFileType == null) {
            LOG.error("Provide not-null FileType");
            this.myFileType = FileTypes.PLAIN_TEXT;
        }
        PsiFile psiFile = factory2.createFileFromText("Dummy." + this.myFileType.getDefaultExtension(), this.myFileType, (CharSequence)"", stamp, true, false);
        return PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
    }

    @NotNull
    protected EditorEx createEditor() {
        EditorHighlighterFactory highlighterFactory;
        VirtualFile virtualFile;
        EditorHighlighter highlighter;
        PsiFile psiFile;
        Project project2 = this.getProjectIfValid();
        Document document2 = this.getDocument();
        EditorFactory factory2 = EditorFactory.getInstance();
        EditorEx editor2 = (EditorEx)(this.myIsViewer ? factory2.createViewer(document2, project2) : factory2.createEditor(document2, project2));
        editor2.putUserData(MANAGED_BY_FIELD, Boolean.TRUE);
        EditorTextField.setupTextFieldEditor(editor2);
        editor2.setCaretEnabled(!this.myIsViewer);
        if (project2 != null && (psiFile = (PsiFile)EditorThreading.compute(() -> PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)editor2.getDocument()))) != null) {
            DaemonCodeAnalyzer.getInstance((Project)project2).setHighlightingEnabled(psiFile, !this.myIsViewer);
        }
        if (project2 != null && (highlighter = (EditorHighlighter)EditorThreading.compute(() -> this.lambda$createEditor$11(virtualFile = this.myDocument == null ? null : FileDocumentManager.getInstance().getFile(this.myDocument), highlighterFactory = EditorHighlighterFactory.getInstance(), project2))) != null) {
            editor2.setHighlighter(highlighter);
        }
        WriteIntentReadAction.run(() -> {
            Accessible a;
            AccessibleContext ac;
            Object label2;
            editor2.getSettings().setCaretRowShown(false);
            editor2.setOneLineMode(this.myOneLineMode);
            editor2.getCaretModel().moveToOffset(document2.getTextLength());
            if (!this.shouldHaveBorder()) {
                editor2.setBorder(null);
            }
            if (this.myIsViewer) {
                editor2.getSelectionModel().removeSelection();
            } else {
                this.deferredSelection.execute(editor2);
                this.deferredSelection = DeferredSelection.None.getInstance();
            }
            editor2.putUserData(SUPPLEMENTARY_KEY, this.myIsSupplementary);
            editor2.getContentComponent().setFocusCycleRoot(false);
            editor2.getContentComponent().addFocusListener(this);
            editor2.getContentComponent().addMouseListener(this);
            editor2.setPlaceholder(this.myHintText);
            editor2.setShowPlaceholderWhenFocused(this.myShowPlaceholderWhenFocused);
            String accessibleName = this.myAccessibleName;
            if (accessibleName == null && (label2 = this.getClientProperty("labeledBy")) instanceof Accessible && (ac = (a = (Accessible)label2).getAccessibleContext()) != null) {
                accessibleName = ac.getAccessibleName();
            }
            if (accessibleName != null) {
                editor2.getContentComponent().getAccessibleContext().setAccessibleName(accessibleName);
            }
            this.initOneLineMode(editor2);
            if (this.myIsRendererWithSelection) {
                ((EditorImpl)editor2).setPaintSelection(true);
                editor2.getColorsScheme().setColor(EditorColors.SELECTION_BACKGROUND_COLOR, this.myRendererBg);
                editor2.getColorsScheme().setColor(EditorColors.SELECTION_FOREGROUND_COLOR, this.myRendererFg);
                editor2.getSelectionModel().setSelection(0, document2.getTextLength());
                editor2.setBackgroundColor(this.myRendererBg);
            }
            for (EditorSettingsProvider provider : this.mySettingsProviders) {
                provider.customizeSettings(editor2);
            }
        });
        EditorEx editorEx = editor2;
        if (editorEx == null) {
            EditorTextField.$$$reportNull$$$0(17);
        }
        return editorEx;
    }

    public static boolean managesEditor(@NotNull Editor editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(18);
        }
        return editor2.getUserData(MANAGED_BY_FIELD) == Boolean.TRUE;
    }

    public static void setupTextFieldEditor(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(19);
        }
        EditorSettings settings = editor2.getSettings();
        settings.setAdditionalLinesCount(0);
        settings.setAdditionalColumnsCount(1);
        settings.setRightMarginShown(false);
        settings.setRightMargin(-1);
        settings.setFoldingOutlineShown(false);
        settings.setLineNumbersShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setVirtualSpace(false);
        settings.setWheelFontChangeEnabled(false);
        settings.setAdditionalPageAtBottom(false);
        editor2.setHorizontalScrollbarVisible(false);
        editor2.setVerticalScrollbarVisible(false);
        settings.setLineCursorWidth(1);
    }

    protected void updateBorder(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(20);
        }
        if (editor2.isOneLineMode() && !Boolean.TRUE.equals(this.getClientProperty("JComboBox.isTableCellEditor")) && (SwingUtilities.getAncestorOfClass(JTable.class, (Component)((Object)this)) == null || Boolean.TRUE.equals(this.getClientProperty("JBListTable.isTableCellEditor")))) {
            Container parent = this.getParent();
            if (parent instanceof JTable || parent instanceof CellRendererPane) {
                return;
            }
            this.setupBorder(editor2);
        }
    }

    protected void setupBorder(@NotNull EditorEx editor2) {
        if (editor2 == null) {
            EditorTextField.$$$reportNull$$$0(21);
        }
        editor2.setBorder(new DarculaEditorTextFieldBorder(this, editor2));
    }

    private void setupEditorFont(EditorEx editor2) {
        if (this.myInheritSwingFont) {
            ((EditorImpl)editor2).setUseEditorAntialiasing(false);
            editor2.getColorsScheme().setEditorFontName(this.getFont().getFontName());
            editor2.getColorsScheme().setEditorFontSize(this.getFont().getSize());
            return;
        }
        float currentEditorFontSize = UISettingsUtils.getInstance().getScaledEditorFontSize();
        if (editor2.getColorsScheme().getEditorFontSize2D() != currentEditorFontSize) {
            editor2.putUserData(ZoomIndicatorManager.SUPPRESS_ZOOM_INDICATOR_ONCE, true);
            editor2.setFontSize(currentEditorFontSize);
        }
    }

    protected boolean shouldHaveBorder() {
        return true;
    }

    public void setEnabled(boolean enabled2) {
        if (this.isEnabled() != enabled2) {
            super.setEnabled(enabled2);
            this.setFocusTraversalPolicyProvider(enabled2);
            this.setViewerEnabled(enabled2);
            this.resetEditor();
        }
    }

    protected void setViewerEnabled(boolean enabled2) {
        this.myIsViewer = !enabled2;
    }

    private void resetEditor() {
        EditorEx editor2 = this.myEditor;
        if (editor2 != null) {
            this.scheduleEditorRelease();
            this.initEditorInner();
            this.releaseScheduledEditors();
            this.revalidate();
        }
    }

    public boolean isViewer() {
        return this.myIsViewer;
    }

    public void setViewer(boolean viewer) {
        if (this.myIsViewer != viewer) {
            this.myIsViewer = viewer;
            this.resetEditor();
        }
    }

    public Color getBackground() {
        Color color = this.myEnforcedBgColor != null ? this.myEnforcedBgColor : UIUtil.getTextFieldBackground();
        return color != null ? color : super.getBackground();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.myEditor == null || comp != this.myEditor.getComponent()) assert (false) : "You are not allowed to add anything to EditorTextField";
        super.addImpl(comp, constraints, index);
    }

    public void validate() {
        this.getEditor(true);
        super.validate();
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        EditorEx editor2 = this.getEditor(true);
        boolean toReleaseEditor = false;
        if (editor2 == null && this.myEnsureWillComputePreferredSize) {
            this.myEnsureWillComputePreferredSize = false;
            editor2 = this.initEditorInner();
            toReleaseEditor = true;
        }
        Object size2 = JBUI.size((int)100, (int)10);
        if (editor2 != null) {
            Dimension preferredSize = editor2.getComponent().getPreferredSize();
            JBInsets.addTo((Dimension)preferredSize, (Insets)this.getInsets());
            size2 = preferredSize;
        } else if (this.myPassivePreferredSize != null) {
            size2 = this.myPassivePreferredSize;
        }
        if (toReleaseEditor) {
            this.releaseEditorNow();
            this.myPassivePreferredSize = size2;
        }
        if (this.myPreferredWidth != -1) {
            size2.width = this.myPreferredWidth;
        }
        return size2;
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        JBDimension size2 = JBUI.size((int)1, (int)10);
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            size2.height = editor2.getLineHeight();
            if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
                size2.height = Math.max(size2.height, JBUIScale.scale((int)16));
            }
            JBInsets.addTo((Dimension)size2, (Insets)this.getInsets());
            JBInsets.addTo((Dimension)size2, (Insets)editor2.getInsets());
        }
        return size2;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.myPreferredWidth = preferredWidth;
    }

    public Component getNextFocusableComponent() {
        Editor editor2 = this.getEditor();
        if (editor2 == null && this.myNextFocusable == null) {
            return super.getNextFocusableComponent();
        }
        if (editor2 == null) {
            return this.myNextFocusable;
        }
        return editor2.getContentComponent().getNextFocusableComponent();
    }

    public void setNextFocusableComponent(Component aComponent) {
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            editor2.getContentComponent().setNextFocusableComponent(aComponent);
            return;
        }
        this.myNextFocusable = aComponent;
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        EditorEx editor2 = this.getEditor(false);
        if (e.isConsumed() || editor2 != null && !editor2.processKeyTyped(e)) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return true;
    }

    public final void addNotify() {
        this.myInHierarchy = true;
        if (this.myManualDisposable == null && this.myEditor == null && !Registry.is((String)"editor.text.field.init.on.shown")) {
            this.initEditor();
        }
        super.addNotify();
        InternalDecoratorImpl.componentWithEditorBackgroundAdded((Component)((Object)this));
    }

    @Nullable
    public EditorEx getEditor(boolean initializeIfSafe) {
        EditorEx editor2 = this.myEditor;
        if (editor2 == null && initializeIfSafe && (this.myInHierarchy || this.myManualDisposable != null)) {
            return this.initEditor();
        }
        return editor2;
    }

    public void requestFocus() {
        EditorEx editor2 = this.getEditor(true);
        if (editor2 != null) {
            IdeFocusManager.getGlobalInstance().requestFocus((Component)editor2.getContentComponent(), true);
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        } else {
            super.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        Editor editor2 = this.getEditor();
        if (editor2 != null) {
            boolean b = editor2.getContentComponent().requestFocusInWindow();
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            return b;
        }
        return super.requestFocusInWindow();
    }

    @Nullable
    public Editor getEditor() {
        return this.getEditor(false);
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    @NotNull
    public JComponent getFocusTarget() {
        Editor editor2 = this.getEditor();
        Object object = editor2 == null ? this : editor2.getContentComponent();
        if (object == null) {
            EditorTextField.$$$reportNull$$$0(22);
        }
        return object;
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.myFocusListeners.add(l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.myFocusListeners.remove(l);
    }

    @Override
    public void focusGained(FocusEvent e) {
        for (FocusListener listener2 : this.myFocusListeners) {
            listener2.focusGained(e);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        for (FocusListener listener2 : this.myFocusListeners) {
            listener2.focusLost(e);
        }
    }

    public void addMouseListener(MouseListener l) {
        this.myMouseListeners.add(l);
    }

    public void removeMouseListener(MouseListener l) {
        this.myMouseListeners.remove(l);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseClicked(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseReleased(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (MouseListener listener2 : this.myMouseListeners) {
            listener2.mouseExited(e);
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        EditorEx editor2;
        if (sink == null) {
            EditorTextField.$$$reportNull$$$0(23);
        }
        if ((editor2 = this.getEditor(false)) != null && editor2.isRendererMode()) {
            sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)editor2.getCopyProvider());
        }
        if (editor2 == null) {
            sink.setNull(CommonDataKeys.EDITOR);
        } else {
            sink.set(CommonDataKeys.EDITOR, (Object)editor2);
        }
    }

    public void setFileType(@NotNull FileType fileType2) {
        if (fileType2 == null) {
            EditorTextField.$$$reportNull$$$0(24);
        }
        this.setNewDocumentAndFileType(fileType2, this.getDocument());
    }

    public void setNewDocumentAndFileType(@NotNull FileType fileType2, Document document2) {
        if (fileType2 == null) {
            EditorTextField.$$$reportNull$$$0(25);
        }
        this.myFileType = fileType2;
        this.setDocument(document2);
    }

    public void ensureWillComputePreferredSize() {
        this.myEnsureWillComputePreferredSize = true;
    }

    public void setAsRendererWithSelection(Color backgroundColor, Color foregroundColor) {
        this.myIsRendererWithSelection = true;
        this.myRendererBg = backgroundColor;
        this.myRendererFg = foregroundColor;
    }

    public void addSettingsProvider(@NotNull EditorSettingsProvider provider) {
        if (provider == null) {
            EditorTextField.$$$reportNull$$$0(26);
        }
        this.mySettingsProviders.add(provider);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JPanel.AccessibleJPanel(){

                @Override
                public String getAccessibleName() {
                    return null;
                }

                @Override
                public void setAccessibleName(@Nls String s) {
                    EditorTextField.this.myAccessibleName = s;
                    EditorEx editor2 = EditorTextField.this.getEditor(false);
                    if (editor2 != null) {
                        editor2.getContentComponent().getAccessibleContext().setAccessibleName(s);
                    }
                }
            };
        }
        return this.accessibleContext;
    }

    private /* synthetic */ EditorHighlighter lambda$createEditor$11(VirtualFile virtualFile, EditorHighlighterFactory highlighterFactory, Project project2) throws RuntimeException {
        return virtualFile != null ? highlighterFactory.createEditorHighlighter(project2, virtualFile) : (this.myFileType != null ? highlighterFactory.createEditorHighlighter(project2, this.myFileType) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9, 10, 11, 17, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/EditorTextField";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/EditorTextField";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDisposedWith";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 22: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doSelect";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onEditorAdded";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "releaseEditor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "managesEditor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupTextFieldEditor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateBorder";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setupBorder";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setFileType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setNewDocumentAndFileType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9, 10, 11, 17, 22 -> new IllegalStateException(string);
        };
    }

    private static sealed interface DeferredSelection {
        public void execute(@NotNull Editor var1);

        public record Custom(@NotNull TextRange range) implements DeferredSelection
        {
            @NotNull
            private final TextRange range;

            public Custom(@NotNull TextRange range) {
                if (range == null) {
                    Custom.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void execute(@NotNull Editor editor2) {
                if (editor2 == null) {
                    Custom.$$$reportNull$$$0(1);
                }
                EditorTextField.doSelect(editor2, this.range);
            }

            @NotNull
            public TextRange range() {
                TextRange textRange = this.range;
                if (textRange == null) {
                    Custom.$$$reportNull$$$0(2);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/EditorTextField$DeferredSelection$Custom";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/EditorTextField$DeferredSelection$Custom";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "range";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }

        public static final class None
        implements DeferredSelection {
            @NotNull
            private static final None INSTANCE = new None();

            private None() {
            }

            @Override
            public void execute(@NotNull Editor editor2) {
                if (editor2 == null) {
                    None.$$$reportNull$$$0(0);
                }
            }

            @NotNull
            public static None getInstance() {
                None none = INSTANCE;
                if (none == null) {
                    None.$$$reportNull$$$0(1);
                }
                return none;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/EditorTextField$DeferredSelection$None";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/EditorTextField$DeferredSelection$None";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInstance";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        public static final class All
        implements DeferredSelection {
            @NotNull
            private static final All INSTANCE = new All();

            private All() {
            }

            @Override
            public void execute(@NotNull Editor editor2) {
                if (editor2 == null) {
                    All.$$$reportNull$$$0(0);
                }
                EditorTextField.doSelect(editor2, TextRange.create((int)0, (int)editor2.getDocument().getTextLength()));
            }

            @NotNull
            public static All getInstance() {
                All all = INSTANCE;
                if (all == null) {
                    All.$$$reportNull$$$0(1);
                }
                return all;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/EditorTextField$DeferredSelection$All";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/EditorTextField$DeferredSelection$All";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInstance";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static final class Jdk7DelegatingToRootTraversalPolicy
    extends AbstractDelegatingToRootTraversalPolicy {
        private boolean invokedFromBeforeOrAfter;

        private Jdk7DelegatingToRootTraversalPolicy() {
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return this.getDefaultComponent(aContainer);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return this.getDefaultComponent(aContainer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            Component after;
            int count;
            if (aContainer instanceof EditorTextField && (count = aContainer.getComponentCount()) > 1 && aComponent != aContainer.getComponent(count - 1)) {
                return this.getDefaultComponent(aContainer);
            }
            this.invokedFromBeforeOrAfter = true;
            try {
                after = super.getComponentAfter(aContainer, aComponent);
            }
            finally {
                this.invokedFromBeforeOrAfter = false;
            }
            return after != aComponent ? after : null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            Component before = super.getComponentBefore(aContainer, aComponent);
            return before != aComponent ? before : null;
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            Editor editor2;
            if (this.invokedFromBeforeOrAfter) {
                return null;
            }
            if (!aContainer.isVisible() || !aContainer.isDisplayable()) {
                return null;
            }
            Editor editor3 = editor2 = aContainer instanceof EditorTextField ? ((EditorTextField)((Object)aContainer)).getEditor() : null;
            if (editor2 != null) {
                return editor2.getContentComponent();
            }
            return aContainer;
        }
    }
}

