/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Cell;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class TableSpeedSearchBase<Comp extends JTable>
extends SpeedSearchBase<Comp> {
    private static final Key<Cell> SELECTION_BEFORE_KEY = Key.create((String)"SpeedSearch.selectionBeforeSearch");
    private boolean myFilteringMode;

    protected TableSpeedSearchBase(Comp component2, Void sig) {
        super(component2, sig);
    }

    @Deprecated(forRemoval=true)
    public TableSpeedSearchBase(Comp component2) {
        super(component2);
    }

    public void setFilteringMode(boolean filteringMode) {
        this.myFilteringMode = filteringMode;
    }

    @Override
    protected void onSearchFieldUpdated(final String pattern) {
        super.onSearchFieldUpdated(pattern);
        if (!this.myFilteringMode) {
            return;
        }
        RowSorter<? extends TableModel> sorter0 = ((JTable)this.myComponent).getRowSorter();
        if (!(sorter0 instanceof TableRowSorter)) {
            return;
        }
        TableRowSorter sorter = (TableRowSorter)sorter0;
        if (StringUtil.isNotEmpty((String)pattern)) {
            if (sorter.getRowFilter() == null) {
                UIUtil.putClientProperty((JComponent)this.myComponent, SELECTION_BEFORE_KEY, (Object)new Cell(((JTable)this.myComponent).getSelectedRow(), ((JTable)this.myComponent).getSelectedColumn()));
            }
            sorter.setRowFilter(new RowFilter<TableModel, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                    return TableSpeedSearchBase.this.isMatchingRow(entry.getIdentifier(), pattern);
                }
            });
        } else {
            UIUtil.putClientProperty((JComponent)this.myComponent, SELECTION_BEFORE_KEY, null);
            sorter.setRowFilter(null);
        }
    }

    @Override
    protected boolean isStickySearch() {
        return this.myFilteringMode;
    }

    @Override
    public void hidePopup() {
        super.hidePopup();
        if (!this.myFilteringMode) {
            return;
        }
        Cell prev = (Cell)UIUtil.getClientProperty((Object)this.myComponent, SELECTION_BEFORE_KEY);
        int viewRow = ((JTable)this.myComponent).getSelectedRow();
        if (viewRow <= -1) {
            if (prev != null && prev.row > -1 && prev.row < ((JTable)this.myComponent).getRowCount()) {
                int col = Math.min(prev.column, ((JTable)this.myComponent).getColumnCount());
                ((JTable)this.myComponent).setRowSelectionInterval(prev.row, prev.row);
                ((JTable)this.myComponent).setColumnSelectionInterval(col, col);
            } else if (((JTable)this.myComponent).getRowCount() > 0) {
                ((JTable)this.myComponent).setRowSelectionInterval(0, 0);
                ((JTable)this.myComponent).setColumnSelectionInterval(0, 0);
            }
        }
        TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
    }

    @Override
    @NotNull
    protected SpeedSearchBase.SearchPopup createPopup(String s) {
        final boolean ignoreSpaceTyped = ((JTable)this.myComponent).getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0)) != null;
        return new SpeedSearchBase.SearchPopup(s){

            @Override
            public void processKeyEvent(KeyEvent e) {
                if (ignoreSpaceTyped && e.getModifiersEx() == 0 && e.getID() == 400 && e.getKeyChar() == ' ') {
                    return;
                }
                super.processKeyEvent(e);
            }
        };
    }

    protected boolean isMatchingRow(int modelRow, String pattern) {
        return true;
    }
}

