/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.FullScreenSupport;
import com.intellij.ui.JBColor;
import com.intellij.ui.ToolbarService;
import com.intellij.ui.ToolbarServiceImplKt;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.border.AbstractBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bH\u0016J<\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/ToolbarServiceImpl;", "Lcom/intellij/ui/ToolbarService;", "<init>", "()V", "setCustomTitleBar", "", "window", "Ljava/awt/Window;", "rootPane", "Ljavax/swing/JRootPane;", "onDispose", "Lkotlin/Function1;", "Ljava/lang/Runnable;", "setTransparentTitleBar", "handlerProvider", "Lkotlin/Function0;", "Lcom/intellij/ui/FullScreenSupport;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public class ToolbarServiceImpl
implements ToolbarService {
    public void setCustomTitleBar(@NotNull Window window, @NotNull JRootPane rootPane, @NotNull Function1<? super Runnable, Unit> onDispose) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)rootPane, (String)"rootPane");
        Intrinsics.checkNotNullParameter(onDispose, (String)"onDispose");
        if (!SystemInfoRt.isMac) {
            return;
        }
        if (ExperimentalUI.Companion.isNewUI()) {
            ToolbarServiceImplKt.access$setCustomTitleForToolbar(window, rootPane, onDispose);
        } else {
            this.setTransparentTitleBar(window, rootPane, onDispose);
        }
    }

    public void setTransparentTitleBar(@NotNull Window window, @NotNull JRootPane rootPane, @Nullable Function0<? extends FullScreenSupport> handlerProvider, @NotNull Function1<? super Runnable, Unit> onDispose) {
        FullScreenSupport handler;
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)rootPane, (String)"rootPane");
        Intrinsics.checkNotNullParameter(onDispose, (String)"onDispose");
        if (!SystemInfoRt.isMac) {
            return;
        }
        Function0<? extends FullScreenSupport> function0 = handlerProvider;
        FullScreenSupport fullScreenSupport = handler = function0 != null ? (FullScreenSupport)function0.invoke() : null;
        if (fullScreenSupport != null) {
            fullScreenSupport.addListener(window);
        }
        Insets topWindowInset = new Insets(UIUtil.getTransparentTitleBarHeight((JRootPane)rootPane), 0, 0, 0);
        AbstractBorder customBorder2 = new AbstractBorder(handler, topWindowInset, window){
            final /* synthetic */ FullScreenSupport $handler;
            final /* synthetic */ Insets $topWindowInset;
            final /* synthetic */ Window $window;
            {
                this.$handler = $handler;
                this.$topWindowInset = $topWindowInset;
                this.$window = $window;
            }

            public Insets getBorderInsets(Component c) {
                Insets insets;
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                if (this.$handler != null && this.$handler.isFullScreen()) {
                    JBInsets jBInsets = JBInsets.emptyInsets();
                    Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
                    insets = (Insets)jBInsets;
                } else {
                    insets = this.$topWindowInset;
                }
                return insets;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                if (this.$handler != null && this.$handler.isFullScreen()) {
                    return;
                }
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D it = (Graphics2D)graphics;
                boolean bl = false;
                Graphics2D graphics2D = c instanceof JComponent ? JBSwingUtilities.runGlobalCGTransform((JComponent)((JComponent)c), (Graphics)it) : it;
                Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"let(...)");
                Graphics2D graphics2 = graphics2D;
                try {
                    Rectangle headerRectangle = new Rectangle(0, 0, c.getWidth(), this.$topWindowInset.top);
                    graphics2.setColor(JBColor.PanelBackground);
                    graphics2.fill(headerRectangle);
                    if (this.$window instanceof RootPaneContainer) {
                        Window window = this.$window;
                        Intrinsics.checkNotNull((Object)window, (String)"null cannot be cast to non-null type javax.swing.RootPaneContainer");
                        JRootPane pane2 = ((RootPaneContainer)((Object)window)).getRootPane();
                        if (pane2 == null || Intrinsics.areEqual((Object)pane2.getClientProperty(""), (Object)false)) {
                            graphics2.setColor(JBUI.CurrentTheme.CustomFrameDecorations.separatorForeground());
                            LinePainter2D.paint((Graphics2D)graphics2, (double)0.0, (double)(this.$topWindowInset.top - 1), (double)c.getWidth(), (double)(this.$topWindowInset.top - 1), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)1.0);
                        }
                    }
                    JBColor color = this.$window.isActive() ? JBColor.black : JBColor.gray;
                    graphics2.setColor((Color)color);
                }
                finally {
                    graphics2.dispose();
                }
            }
        };
        Function1 onDispose2 = onDispose;
        if (handler != null) {
            Function1 onDisposeOld = onDispose2;
            onDispose2 = arg_0 -> ToolbarServiceImpl.setTransparentTitleBar$lambda$0(onDisposeOld, handler, window, arg_0);
        }
        ToolbarServiceImplKt.access$doSetCustomTitleBar(window, rootPane, onDispose2, customBorder2);
    }

    private static final Unit setTransparentTitleBar$lambda$0(Function1 $onDisposeOld, FullScreenSupport $handler, Window $window, Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        $onDisposeOld.invoke(() -> ToolbarServiceImpl.setTransparentTitleBar$lambda$0$0(runnable2, $handler, $window));
        return Unit.INSTANCE;
    }

    private static final void setTransparentTitleBar$lambda$0$0(Runnable $runnable, FullScreenSupport $handler, Window $window) {
        $runnable.run();
        $handler.removeListener($window);
    }
}

