/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.colorpicker.ColorPickerBuilderKt;
import com.intellij.ui.colorpicker.RecentColorsPaletteKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ui/colorpicker/ColorButton;", "Ljavax/swing/JButton;", "color", "Ljava/awt/Color;", "<init>", "(Ljava/awt/Color;)V", "getColor", "()Ljava/awt/Color;", "setColor", "FOCUS_BORDER_WIDTH", "", "ROUND_CORNER_ARC", "status", "Lcom/intellij/ui/colorpicker/ColorButton$Status;", "getStatus", "()Lcom/intellij/ui/colorpicker/ColorButton$Status;", "setStatus", "(Lcom/intellij/ui/colorpicker/ColorButton$Status;)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "Status", "intellij.platform.ide.impl"})
public final class ColorButton
extends JButton {
    @NotNull
    private Color color;
    private final int FOCUS_BORDER_WIDTH;
    private final int ROUND_CORNER_ARC;
    @NotNull
    private Status status;

    public ColorButton(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.color = color;
        this.FOCUS_BORDER_WIDTH = JBUI.scale((int)3);
        this.ROUND_CORNER_ARC = JBUI.scale((int)5);
        this.status = Status.NORMAL;
        this.setPreferredSize((Dimension)JBUI.size((int)28));
        this.setBorder(JBUI.Borders.empty((int)6));
        this.setRolloverEnabled(true);
        this.setHideActionText(true);
        this.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setStatus(Status.HOVER);
                this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setStatus(Status.NORMAL);
                this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setStatus(Status.PRESSED);
                this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.setStatus(WhenMappings.$EnumSwitchMapping$0[this.getStatus().ordinal()] == 1 ? Status.HOVER : Status.NORMAL);
                this.repaint();
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[Status.values().length];
                    try {
                        nArray[Status.PRESSED.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        });
        InputMap $this$_init__u24lambda_u240 = this.getInputMap(0);
        boolean bl = false;
        $this$_init__u24lambda_u240.put(KeyStroke.getKeyStroke(10, 0, false), "pressed");
        $this$_init__u24lambda_u240.put(KeyStroke.getKeyStroke(10, 0, true), "released");
    }

    public /* synthetic */ ColorButton(Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
            color = color2;
        }
        this(color);
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.color = color;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull Status status2) {
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"<set-?>");
        this.status = status2;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        Object originalAntialiasing = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Color originalColor = ((Graphics2D)g).getColor();
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.status == Status.HOVER || this.status == Status.PRESSED) {
            l = this.getInsets().left / 2;
            t = this.getInsets().top / 2;
            w = this.getWidth() - l - this.getInsets().right / 2;
            h = this.getHeight() - t - this.getInsets().bottom / 2;
            Color color = UIUtil.getFocusedBoundsColor();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getFocusedBoundsColor(...)");
            Color focusColor = color;
            ((Graphics2D)g).setColor(this.status == Status.HOVER ? focusColor : focusColor.darker());
            g2d.fillRoundRect(l, t, w, h, 7, 7);
        } else if (this.isFocusOwner()) {
            l = this.getInsets().left - this.FOCUS_BORDER_WIDTH;
            t = this.getInsets().top - this.FOCUS_BORDER_WIDTH;
            w = this.getWidth() - l - this.getInsets().right + this.FOCUS_BORDER_WIDTH;
            h = this.getHeight() - t - this.getInsets().bottom + this.FOCUS_BORDER_WIDTH;
            ((Graphics2D)g).setColor(UIUtil.getFocusedFillColor());
            g2d.fillRoundRect(l, t, w, h, 7, 7);
        }
        int left = this.getInsets().left;
        int top = this.getInsets().top;
        int brickWidth = this.getWidth() - this.getInsets().left - this.getInsets().right;
        int brickHeight = this.getHeight() - this.getInsets().top - this.getInsets().bottom;
        ((Graphics2D)g).setColor(this.color);
        g2d.fillRoundRect(left, top, brickWidth, brickHeight, this.ROUND_CORNER_ARC, this.ROUND_CORNER_ARC);
        ((Graphics2D)g).setColor((Color)RecentColorsPaletteKt.access$getCOLOR_BUTTON_INNER_BORDER_COLOR$p());
        g2d.drawRoundRect(left, top, brickWidth, brickHeight, this.ROUND_CORNER_ARC, this.ROUND_CORNER_ARC);
        ((Graphics2D)g).setColor(originalColor);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, originalAntialiasing);
    }

    public ColorButton() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ui/colorpicker/ColorButton$Status;", "", "<init>", "(Ljava/lang/String;I)V", "NORMAL", "HOVER", "PRESSED", "intellij.platform.ide.impl"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status NORMAL = new Status();
        public static final /* enum */ Status HOVER = new Status();
        public static final /* enum */ Status PRESSED = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.NORMAL, Status.HOVER, Status.PRESSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

