/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.colorpicker.ColorPipette;
import com.intellij.ui.colorpicker.GraphicalColorPipetteKt;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u0016\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015H\u0002J\u0006\u0010\"\u001a\u00020#J \u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J8\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020(2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020(H\u0016J\b\u00101\u001a\u00020#H\u0002J\b\u00102\u001a\u00020#H\u0002J\b\u00103\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/ui/colorpicker/PickerDialog;", "Ljava/awt/image/ImageObserver;", "parent", "Ljavax/swing/JComponent;", "callback", "Lcom/intellij/ui/colorpicker/ColorPipette$Callback;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/ui/colorpicker/ColorPipette$Callback;)V", "getParent", "()Ljavax/swing/JComponent;", "getCallback", "()Lcom/intellij/ui/colorpicker/ColorPipette$Callback;", "timer", "Ljavax/swing/Timer;", "center", "Ljava/awt/Point;", "zoomRect", "Ljava/awt/Rectangle;", "captureRect", "disposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "newDisposable", "maskImage", "Ljava/awt/image/BufferedImage;", "magnifierImage", "image", "robot", "Ljava/awt/Robot;", "previousColor", "Ljava/awt/Color;", "previousLoc", "picker", "Ljava/awt/Dialog;", "pick", "", "moveMouse", "e", "Ljava/awt/event/KeyEvent;", "x", "", "y", "imageUpdate", "", "img", "Ljava/awt/Image;", "flags", "width", "height", "cancelPipette", "pickDone", "updatePipette", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nGraphicalColorPipette.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphicalColorPipette.kt\ncom/intellij/ui/colorpicker/PickerDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1#2:294\n*E\n"})
final class PickerDialog
implements ImageObserver {
    @NotNull
    private final JComponent parent;
    @NotNull
    private final ColorPipette.Callback callback;
    @NotNull
    private final Timer timer;
    @NotNull
    private final Point center;
    @NotNull
    private final Rectangle zoomRect;
    @NotNull
    private final Rectangle captureRect;
    @NotNull
    private Disposable disposable;
    @NotNull
    private final BufferedImage maskImage;
    @NotNull
    private final BufferedImage magnifierImage;
    @NotNull
    private final BufferedImage image;
    @NotNull
    private final Robot robot;
    @Nullable
    private Color previousColor;
    @Nullable
    private Point previousLoc;
    @NotNull
    private final Dialog picker;

    public PickerDialog(@NotNull JComponent parent, @NotNull ColorPipette.Callback callback) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.parent = parent;
        this.callback = callback;
        this.timer = new Timer(33, arg_0 -> PickerDialog.timer$lambda$0(this, arg_0));
        this.center = new Point(GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p() / 2, GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p() / 2);
        this.zoomRect = new Rectangle(0, 0, GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p(), GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p());
        this.captureRect = new Rectangle();
        this.disposable = this.newDisposable();
        BufferedImage bufferedImage = ImageUtil.createImage((int)GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p(), (int)GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        this.maskImage = bufferedImage;
        BufferedImage bufferedImage2 = ImageUtil.createImage((int)GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p(), (int)GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"createImage(...)");
        this.magnifierImage = bufferedImage2;
        PickerDialog pickerDialog = this;
        PickerDialog pickerDialog2 = this;
        boolean bl = false;
        BufferedImage image2 = this.parent.getGraphicsConfiguration().createCompatibleImage(GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p(), GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p(), 3);
        Graphics graphics = image2.getGraphics();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D graphics2d = (Graphics2D)graphics;
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BufferedImage bufferedImage3 = image2;
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage3, (String)"let(...)");
        pickerDialog2.image = bufferedImage3;
        this.robot = new Robot();
        PickerDialog pickerDialog3 = this;
        pickerDialog2 = this;
        boolean bl2 = false;
        Window owner = SwingUtilities.getWindowAncestor(this.parent);
        JDialog pickerFrame = owner instanceof Dialog ? new JDialog((Dialog)owner) : (owner instanceof Frame ? new JDialog((Frame)owner) : new JDialog(new JFrame()));
        pickerFrame.setUndecorated(true);
        pickerFrame.setAlwaysOnTop(true);
        pickerFrame.setSize(new Dimension(GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p(), GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p()));
        pickerFrame.setDefaultCloseOperation(2);
        JRootPane rootPane = pickerFrame.getRootPane();
        rootPane.putClientProperty("Window.shadow", false);
        rootPane.setBorder((Border)JBUI.Borders.empty());
        MouseAdapter mouseAdapter2 = new MouseAdapter(this){
            final /* synthetic */ PickerDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseReleased(MouseEvent e) {
                block1: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        e.consume();
                        if (!SwingUtilities.isLeftMouseButton(e)) break block0;
                        PickerDialog.access$pickDone(this.this$0);
                        break block1;
                    }
                    if (!SwingUtilities.isRightMouseButton(e)) break block1;
                    PickerDialog.access$cancelPipette(this.this$0);
                }
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PickerDialog.access$updatePipette(this.this$0);
            }
        };
        pickerFrame.addMouseListener(mouseAdapter2);
        pickerFrame.addMouseMotionListener(mouseAdapter2);
        pickerFrame.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ PickerDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (e.getKeyCode()) {
                    case 27: {
                        PickerDialog.access$cancelPipette(this.this$0);
                        break;
                    }
                    case 10: {
                        PickerDialog.access$pickDone(this.this$0);
                    }
                }
            }
        });
        pickerDialog2.picker = pickerFrame;
        Graphics2D maskG = this.maskImage.createGraphics();
        maskG.setColor(Color.BLUE);
        maskG.fillRect(0, 0, GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p(), GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p());
        maskG.setColor(Color.RED);
        maskG.setComposite(AlphaComposite.SrcOut);
        maskG.fillRect(0, 0, GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p(), GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p());
        maskG.dispose();
    }

    @NotNull
    public final JComponent getParent() {
        return this.parent;
    }

    @NotNull
    public final ColorPipette.Callback getCallback() {
        return this.callback;
    }

    private final Disposable newDisposable() {
        Disposable disposable = Disposer.newDisposable((String)"Color Pipette");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        return disposable;
    }

    public final void pick() {
        if (Registry.Companion.is("ide.color.picker.new.pipette")) {
            this.timer.start();
            this.disposable = this.newDisposable();
            ApplicationManager.getApplication().invokeLater(() -> PickerDialog.pick$lambda$0(this));
        } else {
            this.picker.setVisible(true);
            this.timer.start();
            WindowManager.getInstance().setAlphaModeRatio((Window)this.picker, SystemInfo.isMac ? 0.95f : 0.99f);
        }
    }

    private final void moveMouse(KeyEvent e, int x, int y) {
        Point p = MouseInfo.getPointerInfo().getLocation();
        this.robot.mouseMove(p.x + x, p.y + y);
        e.consume();
    }

    @Override
    public boolean imageUpdate(@NotNull Image img, int flags, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return false;
    }

    private final void cancelPipette() {
        this.timer.stop();
        this.picker.setVisible(false);
        this.picker.dispose();
        Disposer.dispose((Disposable)this.disposable);
        this.callback.cancel();
    }

    private final void pickDone() {
        this.timer.stop();
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Point location = pointerInfo.getLocation();
        Color pickedColor = this.robot.getPixelColor(location.x, location.y);
        this.picker.setVisible(false);
        Disposer.dispose((Disposable)this.disposable);
        Intrinsics.checkNotNull((Object)pickedColor);
        this.callback.picked(pickedColor);
    }

    private final void updatePipette() {
        if (Registry.Companion.is("ide.color.picker.new.pipette")) {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            Point mouseLoc = pointerInfo.getLocation();
            Color pickedColor = this.robot.getPixelColor(mouseLoc.x, mouseLoc.y);
            if (!Intrinsics.areEqual((Object)this.previousLoc, (Object)mouseLoc) || !Intrinsics.areEqual((Object)this.previousColor, (Object)pickedColor)) {
                this.previousLoc = mouseLoc;
                this.previousColor = pickedColor;
                Intrinsics.checkNotNull((Object)pickedColor);
                this.callback.update(pickedColor);
            }
        } else if (this.picker.isShowing()) {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            Point mouseLoc = pointerInfo.getLocation();
            this.picker.setLocation(mouseLoc.x - this.picker.getWidth() / 2, mouseLoc.y - this.picker.getHeight() / 2);
            Color pickedColor = this.robot.getPixelColor(mouseLoc.x, mouseLoc.y);
            if (!Intrinsics.areEqual((Object)this.previousLoc, (Object)mouseLoc) || !Intrinsics.areEqual((Object)this.previousColor, (Object)pickedColor)) {
                this.previousLoc = mouseLoc;
                this.previousColor = pickedColor;
                int halfPixelNumber = 5;
                this.captureRect.setBounds(mouseLoc.x - halfPixelNumber, mouseLoc.y - halfPixelNumber, 11, 11);
                BufferedImage capture = this.robot.createScreenCapture(this.captureRect);
                Graphics graphics = this.image.getGraphics();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                Graphics2D graphics2 = (Graphics2D)graphics;
                graphics2.setComposite(AlphaComposite.Src);
                graphics2.setColor(GraphicalColorPipetteKt.access$getTRANSPARENT_COLOR$p());
                graphics2.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
                graphics2.drawImage(capture, this.zoomRect.x, this.zoomRect.y, this.zoomRect.width, this.zoomRect.height, this);
                graphics2.setComposite(AlphaComposite.DstOut);
                graphics2.drawImage(this.maskImage, this.zoomRect.x, this.zoomRect.y, this.zoomRect.width, this.zoomRect.height, this);
                graphics2.setComposite(AlphaComposite.SrcOver);
                graphics2.drawImage((Image)this.magnifierImage, 0, 0, this);
                graphics2.setComposite(AlphaComposite.SrcOver);
                graphics2.setColor(GraphicalColorPipetteKt.access$getPIPETTE_BORDER_COLOR$p());
                graphics2.drawRect(0, 0, GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p() - 1, GraphicalColorPipetteKt.access$getZOOM_RECTANGLE_SIZE$p() - 1);
                graphics2.setColor(GraphicalColorPipetteKt.access$getINDICATOR_BOUND_COLOR$p());
                graphics2.drawRect(GraphicalColorPipetteKt.access$getINDICATOR_BOUND_START$p(), GraphicalColorPipetteKt.access$getINDICATOR_BOUND_START$p(), GraphicalColorPipetteKt.access$getINDICATOR_BOUND_SIZE$p(), GraphicalColorPipetteKt.access$getINDICATOR_BOUND_SIZE$p());
                this.picker.setCursor(this.parent.getToolkit().createCustomCursor(this.image, this.center, "GraphicalColorPicker"));
                Intrinsics.checkNotNull((Object)pickedColor);
                this.callback.update(pickedColor);
            }
        }
    }

    private static final void timer$lambda$0(PickerDialog this$0, ActionEvent it) {
        this$0.updatePipette();
    }

    private static final void pick$lambda$0(PickerDialog this$0) {
        IdeEventQueue.Companion.getInstance().addDispatcher(arg_0 -> PickerDialog.pick$lambda$0$0(this$0, arg_0), this$0.disposable);
    }

    private static final boolean pick$lambda$0$0(PickerDialog this$0, AWTEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof MouseEvent) {
            if (((MouseEvent)it).getClickCount() > 0) {
                ((MouseEvent)it).consume();
                if (SwingUtilities.isLeftMouseButton((MouseEvent)it)) {
                    this$0.pickDone();
                } else if (SwingUtilities.isRightMouseButton((MouseEvent)it)) {
                    this$0.cancelPipette();
                }
            } else if (((MouseEvent)it).getID() == 503) {
                this$0.updatePipette();
            }
        }
        if (it instanceof KeyEvent && ((KeyEvent)it).getID() == 401) {
            switch (((KeyEvent)it).getKeyCode()) {
                case 27: {
                    Unit unit;
                    ((KeyEvent)it).consume();
                    Unit it2 = unit = Unit.INSTANCE;
                    boolean bl = false;
                    this$0.cancelPipette();
                    break;
                }
                case 10: {
                    Unit unit;
                    ((KeyEvent)it).consume();
                    Unit it3 = unit = Unit.INSTANCE;
                    boolean bl = false;
                    this$0.pickDone();
                    break;
                }
                case 38: {
                    this$0.moveMouse((KeyEvent)it, 0, -1);
                    break;
                }
                case 40: {
                    this$0.moveMouse((KeyEvent)it, 0, 1);
                    break;
                }
                case 37: {
                    this$0.moveMouse((KeyEvent)it, -1, 0);
                    break;
                }
                case 39: {
                    this$0.moveMouse((KeyEvent)it, 1, 0);
                }
            }
        }
        return false;
    }

    public static final /* synthetic */ void access$pickDone(PickerDialog $this) {
        $this.pickDone();
    }

    public static final /* synthetic */ void access$cancelPipette(PickerDialog $this) {
        $this.cancelPipette();
    }

    public static final /* synthetic */ void access$updatePipette(PickerDialog $this) {
        $this.updatePipette();
    }
}

