/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.docking.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.toolWindow.ToolWindowButtonManager;
import com.intellij.toolWindow.ToolWindowPane;
import com.intellij.toolWindow.ToolWindowPaneNewButtonManager;
import com.intellij.toolWindow.ToolWindowPaneOldButtonManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.docking.impl.DockWindow;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\b\u00100\u001a\u00020.H\u0002J\u0006\u00101\u001a\u00020.J\u0019\u00102\u001a\u0004\u0018\u00010\u001b2\b\u00103\u001a\u0004\u0018\u00010\u0005H\u0010\u00a2\u0006\u0002\b4J\u0010\u00105\u001a\u00020.2\u0006\u00106\u001a\u00020\nH\u0002J\u000e\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020\nJ\b\u00109\u001a\u00020.H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0014J\u0010\u0010>\u001a\u00020?2\u0006\u0010<\u001a\u00020=H\u0014J\u0010\u0010@\u001a\u00020.2\u0006\u0010A\u001a\u00020BH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u001aj\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0013\u00a8\u0006C"}, d2={"Lcom/intellij/ui/docking/impl/DockWindow;", "Lcom/intellij/openapi/ui/FrameWrapper;", "dockManager", "Lcom/intellij/ui/docking/impl/DockManagerImpl;", "dimensionKey", "", "id", "container", "Lcom/intellij/ui/docking/DockContainer;", "isDialog", "", "supportReopen", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/ui/docking/impl/DockManagerImpl;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ui/docking/DockContainer;ZZLkotlinx/coroutines/CoroutineScope;)V", "getId", "()Ljava/lang/String;", "getSupportReopen", "()Z", "value", "northPanelAvailable", "getNorthPanelAvailable", "northPanel", "Lcom/intellij/ui/components/panels/VerticalBox;", "northExtensions", "Ljava/util/LinkedHashMap;", "Ljavax/swing/JComponent;", "Lkotlin/collections/LinkedHashMap;", "uiContainer", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "getUiContainer", "()Lcom/intellij/ui/components/panels/NonOpaquePanel;", "centerPanel", "Ljavax/swing/JPanel;", "dockContentUiContainer", "getDockContentUiContainer", "()Ljavax/swing/JPanel;", "toolWindowPane", "Lcom/intellij/toolWindow/ToolWindowPane;", "getToolWindowPane", "()Lcom/intellij/toolWindow/ToolWindowPane;", "setToolWindowPane", "(Lcom/intellij/toolWindow/ToolWindowPane;)V", "isDockWindow", "setupToolWindowPane", "", "replaceContainer", "closeIfEmpty", "setupNorthPanel", "getNorthExtension", "key", "getNorthExtension$intellij_platform_ide_impl", "updateNorthPanel", "visible", "setTransparent", "transparent", "dispose", "createJFrame", "Ljavax/swing/JFrame;", "parent", "Lcom/intellij/openapi/wm/IdeFrame;", "createJDialog", "Ljavax/swing/JDialog;", "installListeners", "frame", "Ljava/awt/Window;", "intellij.platform.ide.impl"})
public final class DockWindow
extends FrameWrapper {
    @NotNull
    private final DockManagerImpl dockManager;
    @NotNull
    private final String id;
    @NotNull
    private DockContainer container;
    private final boolean supportReopen;
    private boolean northPanelAvailable;
    @NotNull
    private final VerticalBox northPanel;
    @NotNull
    private final LinkedHashMap<String, JComponent> northExtensions;
    @NotNull
    private final NonOpaquePanel uiContainer;
    @NotNull
    private final JPanel centerPanel;
    @NotNull
    private final JPanel dockContentUiContainer;
    @Nullable
    private ToolWindowPane toolWindowPane;

    public DockWindow(@NotNull DockManagerImpl dockManager, @Nullable String dimensionKey, @NotNull String id2, @NotNull DockContainer container, boolean isDialog, boolean supportReopen, @NotNull CoroutineScope coroutineScope) {
        Window frame;
        StatusBar mainStatusBar;
        Intrinsics.checkNotNullParameter((Object)((Object)dockManager), (String)"dockManager");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Project project2 = dockManager.project;
        Object object = dimensionKey;
        if (object == null) {
            object = "dock-window-" + id2;
        }
        super(project2, (String)object, isDialog, null, null, coroutineScope, 24, null);
        this.dockManager = dockManager;
        this.id = id2;
        this.container = container;
        this.supportReopen = supportReopen;
        this.northPanel = new VerticalBox();
        this.northExtensions = new LinkedHashMap();
        this.uiContainer = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.centerPanel = new JPanel(new BorderLayout(0, 2));
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !(this.container instanceof DockContainer.Dialog) && (mainStatusBar = WindowManager.getInstance().getStatusBar(this.dockManager.project)) != null && (frame = this.getFrame()) instanceof IdeFrame) {
            DockContainer dockContainer = this.container;
            StateFlow<FileEditor> currentFileEditorFlow = dockContainer instanceof DockableEditorTabbedContainer ? ((DockableEditorTabbedContainer)dockContainer).splitters.currentFileEditorFlow : (StateFlow<FileEditor>)StateFlowKt.MutableStateFlow(null);
            this.statusBar = mainStatusBar.createChild(CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)("DockWindow " + this.id), null, (boolean)false, (int)6, null), (IdeFrame)frame, currentFileEditorFlow);
        }
        this.centerPanel.setOpaque(false);
        this.dockContentUiContainer = new JPanel(new BorderLayout());
        this.dockContentUiContainer.setOpaque(false);
        this.dockContentUiContainer.add((Component)this.container.getContainerComponent(), "Center");
        this.centerPanel.add((Component)this.dockContentUiContainer, "Center");
        this.uiContainer.add((Component)this.centerPanel, (Object)"Center");
        StatusBar statusBar = this.statusBar;
        if (statusBar != null) {
            StatusBar it = statusBar;
            boolean bl = false;
            JComponent jComponent = it.getComponent();
            Intrinsics.checkNotNull((Object)jComponent);
            this.uiContainer.add((Component)jComponent, (Object)"South");
        }
        this.setComponent((JComponent)this.uiContainer);
        IdeEventQueue.Companion.getInstance().addPostprocessor(arg_0 -> DockWindow._init_$lambda$1(this, arg_0), coroutineScope);
        this.container.addListener(new DockContainer.Listener(){

            public void contentRemoved(Object key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                dockManager.getReady$intellij_platform_ide_impl().doWhenDone(() -> DockWindow.access$closeIfEmpty(this));
            }
        }, (Disposable)this);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final boolean getSupportReopen() {
        return this.supportReopen;
    }

    public final boolean getNorthPanelAvailable() {
        return this.northPanelAvailable;
    }

    @NotNull
    public final NonOpaquePanel getUiContainer() {
        return this.uiContainer;
    }

    @NotNull
    public final JPanel getDockContentUiContainer() {
        return this.dockContentUiContainer;
    }

    @Nullable
    public final ToolWindowPane getToolWindowPane() {
        return this.toolWindowPane;
    }

    public final void setToolWindowPane(@Nullable ToolWindowPane toolWindowPane2) {
        this.toolWindowPane = toolWindowPane2;
    }

    @Override
    protected boolean isDockWindow() {
        return true;
    }

    public final void setupToolWindowPane() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Window window = this.getFrame();
        JFrame jFrame = window instanceof JFrame ? (JFrame)window : null;
        if (jFrame == null) {
            return;
        }
        JFrame frame = jFrame;
        if (this.toolWindowPane != null) {
            return;
        }
        String string = this.getDimensionKey();
        Intrinsics.checkNotNull((Object)string);
        String paneId = string;
        ToolWindowButtonManager buttonManager = null;
        if (ExperimentalUI.Companion.isNewUI()) {
            buttonManager = new ToolWindowPaneNewButtonManager(paneId, false);
            ((ToolWindowPaneNewButtonManager)buttonManager).initMoreButton(this.dockManager.project);
            ((ToolWindowPaneNewButtonManager)buttonManager).updateResizeState(null);
        } else {
            buttonManager = new ToolWindowPaneOldButtonManager(paneId);
        }
        JComponent jComponent = this.container.getContainerComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContainerComponent(...)");
        JComponent containerComponent = jComponent;
        CoroutineScope coroutineScope = this.coroutineScope;
        Intrinsics.checkNotNull((Object)coroutineScope);
        this.toolWindowPane = ToolWindowPane.Companion.create$intellij_platform_ide_impl(frame, CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)("DockWindow.toolWindowPane " + this.id), null, (boolean)false, (int)6, null), paneId, buttonManager);
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.dockManager.project);
        Intrinsics.checkNotNull((Object)toolWindowManager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
        ToolWindowManagerImpl toolWindowManagerImpl = (ToolWindowManagerImpl)toolWindowManager;
        ToolWindowPane toolWindowPane2 = this.toolWindowPane;
        Intrinsics.checkNotNull((Object)toolWindowPane2);
        toolWindowManagerImpl.addToolWindowPane$intellij_platform_ide_impl(toolWindowPane2, this);
        ToolWindowPane toolWindowPane3 = this.toolWindowPane;
        Intrinsics.checkNotNull((Object)toolWindowPane3);
        toolWindowPane3.setDocumentComponent(containerComponent);
        this.dockContentUiContainer.remove(containerComponent);
        ToolWindowPane toolWindowPane4 = this.toolWindowPane;
        Intrinsics.checkNotNull((Object)toolWindowPane4);
        JComponent toolWindowsComponent = buttonManager.wrapWithControls(toolWindowPane4);
        this.dockContentUiContainer.add((Component)toolWindowsComponent, "Center");
        SimpleMessageBusConnection simpleMessageBusConnection = this.dockManager.project.getMessageBus().connect(this.coroutineScope);
        Topic<ToolWindowManagerListener> topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(this){
            final /* synthetic */ DockWindow this$0;
            {
                this.this$0 = $receiver;
            }

            public void stateChanged(ToolWindowManager toolWindowManager, ToolWindowManagerListener.ToolWindowManagerEventType eventType) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
                if (eventType == ToolWindowManagerListener.ToolWindowManagerEventType.HideToolWindow || eventType == ToolWindowManagerListener.ToolWindowManagerEventType.SetSideToolAndAnchor || eventType == ToolWindowManagerListener.ToolWindowManagerEventType.SetToolWindowType || eventType == ToolWindowManagerListener.ToolWindowManagerEventType.ToolWindowUnavailable || eventType == ToolWindowManagerListener.ToolWindowManagerEventType.UnregisterToolWindow) {
                    DockWindow.access$getDockManager$p(this.this$0).getReady$intellij_platform_ide_impl().doWhenDone(() -> DockWindow.access$closeIfEmpty(this.this$0));
                }
            }
        });
    }

    @NotNull
    public final DockContainer replaceContainer(@NotNull DockContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        JComponent jComponent = container.getContainerComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContainerComponent(...)");
        JComponent newContainerComponent = jComponent;
        if (this.toolWindowPane != null) {
            ToolWindowPane toolWindowPane2 = this.toolWindowPane;
            Intrinsics.checkNotNull((Object)toolWindowPane2);
            toolWindowPane2.setDocumentComponent(newContainerComponent);
        } else {
            this.dockContentUiContainer.remove(this.container.getContainerComponent());
            this.dockContentUiContainer.add(newContainerComponent);
        }
        DockContainer oldContainer = this.container;
        this.container = container;
        if (container instanceof Activatable && this.getFrame().isVisible()) {
            ((Activatable)container).showNotify();
        }
        return oldContainer;
    }

    private final void closeIfEmpty() {
        block2: {
            block3: {
                if (!this.container.isEmpty()) break block2;
                if (this.toolWindowPane == null) break block3;
                ToolWindowPane toolWindowPane2 = this.toolWindowPane;
                Intrinsics.checkNotNull((Object)toolWindowPane2);
                if (toolWindowPane2.buttonManager.hasButtons()) break block2;
            }
            this.close();
            this.dockManager.removeContainer$intellij_platform_ide_impl(this.container);
        }
    }

    public final void setupNorthPanel() {
        if (this.northPanelAvailable) {
            return;
        }
        this.centerPanel.add((Component)this.northPanel, "North");
        this.northPanelAvailable = true;
        MessageBus messageBus = this.dockManager.project.getMessageBus();
        CoroutineScope coroutineScope = this.coroutineScope;
        Intrinsics.checkNotNull((Object)coroutineScope);
        SimpleMessageBusConnection simpleMessageBusConnection = messageBus.connect(coroutineScope);
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, arg_0 -> DockWindow.setupNorthPanel$lambda$0(this, arg_0));
        this.updateNorthPanel(DockManagerImpl.Companion.isNorthPanelVisible(UISettings.Companion.getInstance()));
    }

    @Override
    @Nullable
    public JComponent getNorthExtension$intellij_platform_ide_impl(@Nullable String key) {
        return (JComponent)((Map)this.northExtensions).get(key);
    }

    private final void updateNorthPanel(boolean visible) {
        if (ApplicationManager.getApplication().isUnitTestMode() || !this.northPanelAvailable) {
            return;
        }
        this.northPanel.removeAll();
        this.northExtensions.clear();
        this.northPanel.setVisible(visible && !(this.container instanceof DockContainer.Dialog));
        for (IdeRootPaneNorthExtension extension : IdeRootPaneNorthExtension.EP_NAME.getExtensionList()) {
            JComponent component2;
            if (extension.createComponent(this.dockManager.project, true) == null) continue;
            this.northExtensions.put(extension.getKey(), component2);
            this.northPanel.add((Component)component2);
        }
        this.northPanel.revalidate();
        this.northPanel.repaint();
    }

    public final void setTransparent(boolean transparent) {
        WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
        if (transparent) {
            windowManager.setAlphaModeEnabled(this.getFrame(), true);
            windowManager.setAlphaModeRatio(this.getFrame(), 0.5f);
        } else {
            windowManager.setAlphaModeEnabled(this.getFrame(), true);
            windowManager.setAlphaModeRatio(this.getFrame(), 0.0f);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.container instanceof Disposable) {
            DockContainer dockContainer = this.container;
            Intrinsics.checkNotNull((Object)dockContainer, (String)"null cannot be cast to non-null type com.intellij.openapi.Disposable");
            Disposer.dispose((Disposable)((Disposable)dockContainer));
        }
        this.northExtensions.clear();
    }

    @Override
    @NotNull
    protected JFrame createJFrame(@NotNull IdeFrame parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        JFrame frame = super.createJFrame(parent);
        this.installListeners(frame);
        return frame;
    }

    @Override
    @NotNull
    protected JDialog createJDialog(@NotNull IdeFrame parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        JDialog frame = super.createJDialog(parent);
        this.installListeners(frame);
        return frame;
    }

    private final void installListeners(Window frame) {
        UiNotifyConnector uiNotifyConnector;
        if (this.container instanceof Activatable) {
            Intrinsics.checkNotNull((Object)frame, (String)"null cannot be cast to non-null type javax.swing.RootPaneContainer");
            Container container = ((RootPaneContainer)((Object)frame)).getContentPane();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getContentPane(...)");
            Component component2 = container;
            DockContainer dockContainer = this.container;
            Intrinsics.checkNotNull((Object)dockContainer, (String)"null cannot be cast to non-null type com.intellij.util.ui.update.Activatable");
            uiNotifyConnector = UiNotifyConnector.Companion.installOn(component2, (Activatable)dockContainer);
        } else {
            uiNotifyConnector = null;
        }
        UiNotifyConnector uiNotifyConnector2 = uiNotifyConnector;
        frame.addWindowListener(new WindowAdapter(this, uiNotifyConnector2){
            final /* synthetic */ DockWindow this$0;
            final /* synthetic */ UiNotifyConnector $uiNotifyConnector;
            {
                this.this$0 = $receiver;
                this.$uiNotifyConnector = $uiNotifyConnector;
            }

            public void windowClosing(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                WriteIntentReadAction.run(() -> installListeners.1.windowClosing$lambda$0(this.this$0, this.$uiNotifyConnector));
            }

            private static final void windowClosing$lambda$0(DockWindow this$0, UiNotifyConnector $uiNotifyConnector) {
                DockWindow.access$getContainer$p(this$0).closeAll();
                if ($uiNotifyConnector != null) {
                    Disposer.dispose((Disposable)((Disposable)$uiNotifyConnector));
                }
            }
        });
    }

    private static final boolean _init_$lambda$1(DockWindow this$0, AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof KeyEvent) {
            this$0.dockManager.stopCurrentDragSession();
        }
        return false;
    }

    private static final void setupNorthPanel$lambda$0(DockWindow this$0, UISettings uiSettings) {
        Intrinsics.checkNotNullParameter((Object)uiSettings, (String)"uiSettings");
        boolean visible = DockManagerImpl.Companion.isNorthPanelVisible(uiSettings);
        if (this$0.northPanel.isVisible() != visible) {
            this$0.updateNorthPanel(visible);
        }
    }

    public static final /* synthetic */ void access$closeIfEmpty(DockWindow $this) {
        $this.closeIfEmpty();
    }

    public static final /* synthetic */ DockContainer access$getContainer$p(DockWindow $this) {
        return $this.container;
    }
}

