/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.dsl.ValidationError;
import com.intellij.ui.dsl.ValidationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0007\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "catchValidationException", "", "block", "Lkotlin/Function0;", "stringToInt", "", "string", "", "validateIntInRange", "value", "range", "Lkotlin/ranges/IntRange;", "intellij.platform.ide.impl"})
public final class ValidationExceptionKt {
    @NotNull
    private static final Logger LOG;

    @ApiStatus.Internal
    public static final void catchValidationException(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        try {
            block.invoke();
        }
        catch (ValidationException e) {
            LOG.debug(e.toString());
        }
    }

    public static final int stringToInt(@NotNull String string) throws ValidationException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Integer n = StringsKt.toIntOrNull((String)string);
        if (n == null) {
            Object[] objectArray = new Object[]{string};
            throw new ValidationException(ValidationError.STRING_TO_INT, objectArray);
        }
        return n;
    }

    public static final void validateIntInRange(int value, @NotNull IntRange range) throws ValidationException {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int n = range.getFirst();
        if (!(value <= range.getLast() ? n <= value : false)) {
            Object[] objectArray = new Object[]{value, range};
            throw new ValidationException(ValidationError.INT_IN_RANGE, objectArray);
        }
    }

    static {
        Logger logger = Logger.getInstance(ValidationException.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

