/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.builder.components;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.observable.util.ListenerUiUtil;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.EmptySpacingConfiguration;
import com.intellij.ui.dsl.builder.SegmentedButton;
import com.intellij.ui.dsl.builder.SpacingConfiguration;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.dsl.builder.components.SegmentedButton;
import com.intellij.ui.dsl.builder.components.SegmentedButtonAction;
import com.intellij.ui.dsl.builder.components.SegmentedButtonBorder;
import com.intellij.ui.dsl.builder.components.SegmentedButtonComponent;
import com.intellij.ui.dsl.builder.components.SegmentedButtonToolbarKt;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.UnscaledGapsKt;
import com.intellij.ui.dsl.gridLayout.builders.RowsGridBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 3*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003:\u000234B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0016J\u0006\u0010'\u001a\u00020\u001dJ\u001f\u0010(\u001a\u00020\u001d2\b\u0010)\u001a\u0004\u0018\u00018\u00002\u0006\u0010*\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u001d2\u0006\u00100\u001a\u000201H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R*\u0010\u0016\u001a\u0004\u0018\u00018\u00002\b\u0010\t\u001a\u0004\u0018\u00018\u0000@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00065"}, d2={"Lcom/intellij/ui/dsl/builder/components/SegmentedButtonComponent;", "T", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/UserActivityProviderComponent;", "presentation", "Lkotlin/Function1;", "Lcom/intellij/ui/dsl/builder/SegmentedButton$ItemPresentation;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "value", "", "items", "getItems", "()Ljava/util/Collection;", "setItems", "(Ljava/util/Collection;)V", "Lcom/intellij/ui/dsl/builder/SpacingConfiguration;", "spacing", "getSpacing", "()Lcom/intellij/ui/dsl/builder/SpacingConfiguration;", "setSpacing", "(Lcom/intellij/ui/dsl/builder/SpacingConfiguration;)V", "selectedItem", "getSelectedItem", "()Ljava/lang/Object;", "setSelectedItem", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "addModelListener", "", "l", "Lcom/intellij/ui/dsl/builder/components/SegmentedButtonComponent$ModelListener;", "removeModelListener", "setEnabled", "enabled", "", "paint", "g", "Ljava/awt/Graphics;", "rebuild", "setSelectedState", "item", "selectedState", "(Ljava/lang/Object;Z)V", "moveSelection", "step", "", "addChangeListener", "changeListener", "Ljavax/swing/event/ChangeListener;", "removeChangeListener", "Companion", "ModelListener", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class SegmentedButtonComponent<T>
extends JPanel
implements UserActivityProviderComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<T, SegmentedButton.ItemPresentation> presentation;
    @NotNull
    private Collection<? extends T> items;
    @NotNull
    private SpacingConfiguration spacing;
    @Nullable
    private T selectedItem;

    public SegmentedButtonComponent(@NotNull Function1<? super T, ? extends SegmentedButton.ItemPresentation> presentation2) {
        Intrinsics.checkNotNullParameter(presentation2, (String)"presentation");
        super((LayoutManager)new GridLayout());
        this.presentation = presentation2;
        this.items = CollectionsKt.emptyList();
        this.spacing = (SpacingConfiguration)new EmptySpacingConfiguration();
        this.setFocusable(true);
        this.setBorder(new SegmentedButtonBorder());
        this.putClientProperty(DslComponentProperty.VISUAL_PADDINGS, UnscaledGapsKt.UnscaledGaps((int)MathKt.roundToInt((float)DarculaUIUtil.BW.getUnscaled())));
        this.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.BOTH);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.repaint();
            }
        });
        DumbAwareAction dumbAwareAction = DumbAwareAction.create(arg_0 -> SegmentedButtonComponent._init_$lambda$1(arg_0 -> SegmentedButtonComponent._init_$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        DumbAwareAction actionLeft = dumbAwareAction;
        actionLeft.registerCustomShortcutSet(ActionUtil.getShortcutSet((String)"SegmentedButton-left"), (JComponent)this);
        DumbAwareAction dumbAwareAction2 = DumbAwareAction.create(arg_0 -> SegmentedButtonComponent._init_$lambda$3(arg_0 -> SegmentedButtonComponent._init_$lambda$2(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction2, (String)"create(...)");
        DumbAwareAction actionRight = dumbAwareAction2;
        actionRight.registerCustomShortcutSet(ActionUtil.getShortcutSet((String)"SegmentedButton-right"), (JComponent)this);
        this.rebuild();
    }

    @NotNull
    public final Collection<T> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull Collection<? extends T> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.items = value;
        this.rebuild();
    }

    @NotNull
    public final SpacingConfiguration getSpacing() {
        return this.spacing;
    }

    public final void setSpacing(@NotNull SpacingConfiguration value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.spacing = value;
        this.rebuild();
    }

    @Nullable
    public final T getSelectedItem() {
        return this.selectedItem;
    }

    public final void setSelectedItem(@Nullable T value) {
        if (!Intrinsics.areEqual(this.selectedItem, value)) {
            this.setSelectedState(this.selectedItem, false);
            this.setSelectedState(value, true);
            this.selectedItem = value;
            EventListener[] eventListenerArray = this.listenerList.getListeners(ModelListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)eventListenerArray, (String)"getListeners(...)");
            for (ModelListener modelListener : (ModelListener[])eventListenerArray) {
                modelListener.onItemSelected();
            }
            EventListener[] eventListenerArray2 = this.listenerList.getListeners(ChangeListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)eventListenerArray2, (String)"getListeners(...)");
            for (EventListener eventListener : (ChangeListener[])eventListenerArray2) {
                eventListener.stateChanged(new ChangeEvent(this));
            }
            this.repaint();
        }
    }

    public final void addModelListener(@NotNull ModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listenerList.add(ModelListener.class, (EventListener)l);
    }

    public final void removeModelListener(@NotNull ModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listenerList.remove(ModelListener.class, (EventListener)l);
    }

    @Override
    public void setEnabled(boolean enabled2) {
        super.setEnabled(enabled2);
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component2 : componentArray) {
            component2.setEnabled(enabled2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paint(g);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.setPaint(SegmentedButtonToolbarKt.getSegmentedButtonBorderPaint(this, true));
            Component[] componentArray = this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Component selectedButton = (Component)ArraysKt.getOrNull((Object[])componentArray, (int)CollectionsKt.indexOf((Iterable)this.items, this.selectedItem));
            if (selectedButton != null) {
                Rectangle r = selectedButton.getBounds();
                JBInsets.addTo((Rectangle)r, (Insets)((Insets)JBUI.insets((int)((int)DarculaUIUtil.LW.getUnscaled()))));
                Intrinsics.checkNotNull((Object)r);
                SegmentedButtonToolbarKt.paintBorder(g2, r);
            }
        }
        finally {
            g2.dispose();
        }
    }

    public final void rebuild() {
        this.removeAll();
        PresentationFactory presentationFactory = new PresentationFactory();
        RowsGridBuilder builder = new RowsGridBuilder((JComponent)this, null, 2, null);
        for (T item : this.items) {
            SegmentedButton.ItemPresentation presentation2 = (SegmentedButton.ItemPresentation)this.presentation.invoke(item);
            SegmentedButtonAction<T> action2 = new SegmentedButtonAction<T>(this, item, presentation2.getText(), presentation2.getToolTipText(), presentation2.getIcon(), presentation2.getEnabled());
            Presentation presentation3 = presentationFactory.getPresentation((AnAction)action2);
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"getPresentation(...)");
            SegmentedButton<T> button2 = new SegmentedButton<T>(action2, presentation3, this.spacing);
            button2.setEnabled(this.isEnabled());
            RowsGridBuilder.cell$default((RowsGridBuilder)builder, (JComponent)button2, (int)0, (HorizontalAlign)HorizontalAlign.FILL, null, (boolean)false, (boolean)true, null, null, null, null, (int)986, null);
        }
        EventListener[] eventListenerArray = this.listenerList.getListeners(ModelListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventListenerArray, (String)"getListeners(...)");
        for (ModelListener listener2 : (ModelListener[])eventListenerArray) {
            listener2.onRebuild();
        }
    }

    private final void setSelectedState(T item, boolean selectedState) {
        block1: {
            SegmentedButton segmentedButton;
            if (item == null) {
                return;
            }
            int componentIndex = CollectionsKt.indexOf((Iterable)this.items, item);
            Component[] componentArray = this.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            Object object = ArraysKt.getOrNull((Object[])componentArray, (int)componentIndex);
            SegmentedButton segmentedButton2 = segmentedButton = object instanceof SegmentedButton ? (SegmentedButton)object : null;
            if (segmentedButton2 == null) break block1;
            segmentedButton2.setSelectedState(selectedState);
        }
    }

    private final void moveSelection(int step2) {
        if (this.items.isEmpty()) {
            return;
        }
        int selectedIndex = CollectionsKt.indexOf((Iterable)this.items, this.selectedItem);
        int newSelectedIndex = selectedIndex < 0 ? 0 : RangesKt.coerceIn((int)(selectedIndex + step2), (int)0, (int)(this.items.size() - 1));
        this.setSelectedItem(CollectionsKt.elementAt((Iterable)this.items, (int)newSelectedIndex));
    }

    public void addChangeListener(@NotNull ChangeListener changeListener) {
        Intrinsics.checkNotNullParameter((Object)changeListener, (String)"changeListener");
        this.listenerList.add(ChangeListener.class, (EventListener)changeListener);
    }

    public void removeChangeListener(@NotNull ChangeListener changeListener) {
        Intrinsics.checkNotNullParameter((Object)changeListener, (String)"changeListener");
        this.listenerList.remove(ChangeListener.class, (EventListener)changeListener);
    }

    private static final Unit _init_$lambda$0(SegmentedButtonComponent this$0, AnActionEvent it) {
        this$0.moveSelection(-1);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$2(SegmentedButtonComponent this$0, AnActionEvent it) {
        this$0.moveSelection(1);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\tJ6\u0010\n\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u000eJ(\u0010\u000f\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J*\u0010\u0011\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0012J8\u0010\u0013\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u000eH\u0007J,\u0010\u0014\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J(\u0010\u0015\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J0\u0010\u0016\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ui/dsl/builder/components/SegmentedButtonComponent$Companion;", "", "<init>", "()V", "bind", "", "T", "Lcom/intellij/ui/dsl/builder/components/SegmentedButtonComponent;", "property", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "whenItemSelected", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function1;", "whenRebuild", "Lkotlin/Function0;", "addModelListener", "Lcom/intellij/ui/dsl/builder/components/SegmentedButtonComponent$ModelListener;", "whenItemSelectedFromUi", "fireItemSelectedFromUi", "whenButtonsTouchedFromUi", "whenButtonTouchedFromUi", "button", "Ljava/awt/Component;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nSegmentedButtonComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SegmentedButtonComponent.kt\ncom/intellij/ui/dsl/builder/components/SegmentedButtonComponent$Companion\n+ 2 BindUtil.kt\ncom/intellij/openapi/observable/util/BindUtil\n*L\n1#1,335:1\n32#2,8:336\n32#2,8:344\n*S KotlinDebug\n*F\n+ 1 SegmentedButtonComponent.kt\ncom/intellij/ui/dsl/builder/components/SegmentedButtonComponent$Companion\n*L\n184#1:336,8\n189#1:344,8\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final <T> void bind(@NotNull SegmentedButtonComponent<T> $this$bind, @NotNull ObservableMutableProperty<T> property) {
            Intrinsics.checkNotNullParameter($this$bind, (String)"<this>");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            AtomicBoolean mutex = new AtomicBoolean();
            property.afterChange(arg_0 -> Companion.bind$lambda$0(mutex, $this$bind, arg_0));
            com.intellij.ui.dsl.builder.components.SegmentedButtonComponent$Companion.whenItemSelected$default(this, $this$bind, null, arg_0 -> Companion.bind$lambda$1(mutex, property, arg_0), 1, null);
        }

        public final <T> void whenItemSelected(@NotNull SegmentedButtonComponent<T> $this$whenItemSelected, @Nullable Disposable parentDisposable, @NotNull Function1<? super T, Unit> listener2) {
            Intrinsics.checkNotNullParameter($this$whenItemSelected, (String)"<this>");
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.addModelListener($this$whenItemSelected, parentDisposable, new ModelListener($this$whenItemSelected, listener2){
                final /* synthetic */ SegmentedButtonComponent<T> $this_whenItemSelected;
                final /* synthetic */ Function1<T, Unit> $listener;
                {
                    this.$this_whenItemSelected = $receiver;
                    this.$listener = $listener;
                }

                public void onItemSelected() {
                    block0: {
                        T t = this.$this_whenItemSelected.getSelectedItem();
                        if (t == null) break block0;
                        T t2 = t;
                        this.$listener.invoke(t2);
                    }
                }
            });
        }

        public static /* synthetic */ void whenItemSelected$default(Companion companion, SegmentedButtonComponent segmentedButtonComponent, Disposable disposable, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                disposable = null;
            }
            companion.whenItemSelected(segmentedButtonComponent, disposable, function1);
        }

        private final void whenRebuild(SegmentedButtonComponent<?> $this$whenRebuild, Disposable parentDisposable, Function0<Unit> listener2) {
            this.addModelListener($this$whenRebuild, parentDisposable, new ModelListener(listener2){
                final /* synthetic */ Function0<Unit> $listener;
                {
                    this.$listener = $listener;
                }

                public void onRebuild() {
                    this.$listener.invoke();
                }
            });
        }

        public final <T> void addModelListener(@NotNull SegmentedButtonComponent<T> $this$addModelListener, @Nullable Disposable parentDisposable, @NotNull ModelListener listener2) {
            block0: {
                Intrinsics.checkNotNullParameter($this$addModelListener, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
                $this$addModelListener.addModelListener(listener2);
                Disposable disposable = parentDisposable;
                if (disposable == null) break block0;
                DisposerUtilKt.whenDisposed((Disposable)disposable, () -> Companion.addModelListener$lambda$0($this$addModelListener, listener2));
            }
        }

        public static /* synthetic */ void addModelListener$default(Companion companion, SegmentedButtonComponent segmentedButtonComponent, Disposable disposable, ModelListener modelListener, int n, Object object) {
            if ((n & 1) != 0) {
                disposable = null;
            }
            companion.addModelListener(segmentedButtonComponent, disposable, modelListener);
        }

        @ApiStatus.Experimental
        public final <T> void whenItemSelectedFromUi(@NotNull SegmentedButtonComponent<T> $this$whenItemSelectedFromUi, @Nullable Disposable parentDisposable, @NotNull Function1<? super T, Unit> listener2) {
            Intrinsics.checkNotNullParameter($this$whenItemSelectedFromUi, (String)"<this>");
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            ListenerUiUtil.whenKeyReleased((Component)$this$whenItemSelectedFromUi, (Disposable)parentDisposable, arg_0 -> Companion.whenItemSelectedFromUi$lambda$0($this$whenItemSelectedFromUi, listener2, arg_0));
            this.whenButtonsTouchedFromUi($this$whenItemSelectedFromUi, parentDisposable, (Function0<Unit>)((Function0)() -> Companion.whenItemSelectedFromUi$lambda$1($this$whenItemSelectedFromUi, listener2)));
            this.whenRebuild($this$whenItemSelectedFromUi, parentDisposable, (Function0<Unit>)((Function0)() -> Companion.whenItemSelectedFromUi$lambda$2($this$whenItemSelectedFromUi, parentDisposable, listener2)));
        }

        public static /* synthetic */ void whenItemSelectedFromUi$default(Companion companion, SegmentedButtonComponent segmentedButtonComponent, Disposable disposable, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                disposable = null;
            }
            companion.whenItemSelectedFromUi(segmentedButtonComponent, disposable, function1);
        }

        private final <T> void fireItemSelectedFromUi(SegmentedButtonComponent<T> $this$fireItemSelectedFromUi, Function1<? super T, Unit> listener2) {
            ActionsKt.invokeLater((ModalityState)ModalityState.stateForComponent((Component)$this$fireItemSelectedFromUi), () -> Companion.fireItemSelectedFromUi$lambda$0($this$fireItemSelectedFromUi, listener2));
        }

        private final void whenButtonsTouchedFromUi(SegmentedButtonComponent<?> $this$whenButtonsTouchedFromUi, Disposable parentDisposable, Function0<Unit> listener2) {
            Component[] componentArray = $this$whenButtonsTouchedFromUi.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            for (Component button2 : componentArray) {
                Intrinsics.checkNotNull((Object)button2);
                this.whenButtonTouchedFromUi($this$whenButtonsTouchedFromUi, button2, parentDisposable, listener2);
            }
        }

        private final void whenButtonTouchedFromUi(SegmentedButtonComponent<?> $this$whenButtonTouchedFromUi, Component button2, Disposable parentDisposable, Function0<Unit> listener2) {
            MouseAdapter mouseListener2 = new MouseAdapter(listener2){
                final /* synthetic */ Function0<Unit> $listener;
                {
                    this.$listener = $listener;
                }

                public void mouseReleased(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$listener.invoke();
                }
            };
            RevertOnDisposeUtilKt.addMouseListener((Component)button2, (Disposable)parentDisposable, (MouseListener)mouseListener2);
            this.whenRebuild($this$whenButtonTouchedFromUi, parentDisposable, (Function0<Unit>)((Function0)() -> Companion.whenButtonTouchedFromUi$lambda$0(button2, mouseListener2)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit bind$lambda$0(AtomicBoolean $mutex, SegmentedButtonComponent $this_bind, Object it) {
            AtomicBoolean $this$lockOrSkip$iv = $mutex;
            boolean $i$f$lockOrSkip = false;
            if ($this$lockOrSkip$iv.compareAndSet(false, true)) {
                try {
                    boolean bl = false;
                    $this_bind.setSelectedItem(it);
                }
                finally {
                    $this$lockOrSkip$iv.set(false);
                }
            }
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit bind$lambda$1(AtomicBoolean $mutex, ObservableMutableProperty $property, Object it) {
            AtomicBoolean $this$lockOrSkip$iv = $mutex;
            boolean $i$f$lockOrSkip = false;
            if ($this$lockOrSkip$iv.compareAndSet(false, true)) {
                try {
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)$property.get(), (Object)it)) {
                        Unit unit = Unit.INSTANCE;
                        return unit;
                    }
                    $property.set(it);
                }
                finally {
                    $this$lockOrSkip$iv.set(false);
                }
            }
            return Unit.INSTANCE;
        }

        private static final Unit addModelListener$lambda$0(SegmentedButtonComponent $this_addModelListener, ModelListener $listener) {
            $this_addModelListener.removeModelListener($listener);
            return Unit.INSTANCE;
        }

        private static final Unit whenItemSelectedFromUi$lambda$0(SegmentedButtonComponent $this_whenItemSelectedFromUi, Function1 $listener, KeyEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Companion.fireItemSelectedFromUi($this_whenItemSelectedFromUi, $listener);
            return Unit.INSTANCE;
        }

        private static final Unit whenItemSelectedFromUi$lambda$1(SegmentedButtonComponent $this_whenItemSelectedFromUi, Function1 $listener) {
            Companion.fireItemSelectedFromUi($this_whenItemSelectedFromUi, $listener);
            return Unit.INSTANCE;
        }

        private static final Unit whenItemSelectedFromUi$lambda$2(SegmentedButtonComponent $this_whenItemSelectedFromUi, Disposable $parentDisposable, Function1 $listener) {
            Companion.whenButtonsTouchedFromUi($this_whenItemSelectedFromUi, $parentDisposable, (Function0<Unit>)((Function0)() -> Companion.whenItemSelectedFromUi$lambda$2$0($this_whenItemSelectedFromUi, $listener)));
            return Unit.INSTANCE;
        }

        private static final Unit whenItemSelectedFromUi$lambda$2$0(SegmentedButtonComponent $this_whenItemSelectedFromUi, Function1 $listener) {
            Companion.fireItemSelectedFromUi($this_whenItemSelectedFromUi, $listener);
            return Unit.INSTANCE;
        }

        private static final Unit fireItemSelectedFromUi$lambda$0(SegmentedButtonComponent $this_fireItemSelectedFromUi, Function1 $listener) {
            block0: {
                Object t = $this_fireItemSelectedFromUi.getSelectedItem();
                if (t == null) break block0;
                $listener.invoke(t);
            }
            return Unit.INSTANCE;
        }

        private static final Unit whenButtonTouchedFromUi$lambda$0(Component $button, whenButtonTouchedFromUi.mouseListener.1 $mouseListener) {
            $button.removeMouseListener($mouseListener);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0003H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ui/dsl/builder/components/SegmentedButtonComponent$ModelListener;", "Ljava/util/EventListener;", "onItemSelected", "", "onRebuild", "intellij.platform.ide.impl"})
    @ApiStatus.Internal
    public static interface ModelListener
    extends EventListener {
        default public void onItemSelected() {
        }

        default public void onRebuild() {
        }
    }
}

