/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.ExitActionType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.WindowRoundedCornersManager;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.messages.AlertDialog;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SingleTextSelectionHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.HTMLEditorKit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b7\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001L\b\u0000\u0018\u00002\u00020\u0001:\u0001_B\u0089\u0001\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0001\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n\u00a2\u0006\u0004\b\u0016\u0010\u0017J\b\u00108\u001a\u00020&H\u0016J\u0016\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<H\u0014J\b\u0010>\u001a\u00020:H\u0016J\b\u0010?\u001a\u000207H\u0016J\b\u0010@\u001a\u000207H\u0002J\u0010\u0010A\u001a\u00020:2\u0006\u0010B\u001a\u00020\fH\u0002J\b\u0010C\u001a\u00020DH\u0014J\b\u0010E\u001a\u00020FH\u0014J\b\u0010G\u001a\u00020,H\u0014J\u0010\u0010H\u001a\u00020,2\u0006\u0010I\u001a\u00020JH\u0002J\u0015\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020,H\u0002\u00a2\u0006\u0002\u0010NJ\u001f\u0010O\u001a\u00020J2\u0006\u0010P\u001a\u00020J2\r\u0010Q\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\bRH\u0002J\u0013\u0010S\u001a\b\u0012\u0004\u0012\u00020=0\nH\u0014\u00a2\u0006\u0002\u0010TJ\u0010\u0010U\u001a\u0002032\u0006\u0010V\u001a\u00020=H\u0014J\n\u0010W\u001a\u0004\u0018\u00010,H\u0014J\n\u0010X\u001a\u0004\u0018\u00010,H\u0016J\b\u0010Y\u001a\u00020:H\u0016J\u0010\u0010Z\u001a\u0002032\u0006\u0010[\u001a\u00020\\H\u0014J\n\u0010]\u001a\u0004\u0018\u00010\u0007H\u0014J\b\u0010^\u001a\u00020&H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\u0019\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n\u00a2\u0006\n\n\u0002\u0010$\u001a\u0004\b\"\u0010#R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u00060(R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00101\u001a\u0012\u0012\u0004\u0012\u00020302j\b\u0012\u0004\u0012\u000203`4X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/intellij/ui/messages/AlertDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "myMessage", "", "myTitle", "myOptions", "", "myDefaultOptionIndex", "", "myFocusedOptionIndex", "icon", "Ljavax/swing/Icon;", "doNotAskOption", "Lcom/intellij/openapi/ui/DoNotAskOption;", "myHelpId", "invocationPlace", "exitActionTypes", "Lcom/intellij/openapi/ui/ExitActionType;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;IILjavax/swing/Icon;Lcom/intellij/openapi/ui/DoNotAskOption;Ljava/lang/String;Ljava/lang/String;[Lcom/intellij/openapi/ui/ExitActionType;)V", "getMyMessage", "()Ljava/lang/String;", "getMyTitle", "getMyOptions", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getMyDefaultOptionIndex", "()I", "getMyFocusedOptionIndex", "getMyHelpId", "getExitActionTypes", "()[Lcom/intellij/openapi/ui/ExitActionType;", "[Lcom/intellij/openapi/ui/ExitActionType;", "myIsTitleComponent", "", "myRootLayout", "Lcom/intellij/ui/messages/AlertDialog$RootLayout;", "myIconComponent", "Ljavax/swing/JLabel;", "myMessageComponent", "Ljavax/swing/JComponent;", "mySouthPanel", "Ljavax/swing/JPanel;", "myButtonsPanel", "myCloseButton", "myButtons", "Ljava/util/ArrayList;", "Ljavax/swing/JButton;", "Lkotlin/collections/ArrayList;", "myHelpButton", "myInitSize", "Ljava/awt/Dimension;", "setSizeDuringPack", "sortActionsOnMac", "", "actions", "", "Ljavax/swing/Action;", "beforeShowCallback", "getInitialSize", "calculateInitialSize", "configureMessageWidth", "width", "createContentPaneBorder", "Ljavax/swing/border/Border;", "createRootLayout", "Ljava/awt/LayoutManager;", "createCenterPanel", "wrapToScrollPaneIfNeeded", "messageComponent", "Ljavax/swing/JEditorPane;", "wrapWithMinWidth", "com/intellij/ui/messages/AlertDialog$wrapWithMinWidth$1", "scrollPane", "(Ljavax/swing/JComponent;)Lcom/intellij/ui/messages/AlertDialog$wrapWithMinWidth$1;", "createTextComponent", "component", "message", "Lorg/jetbrains/annotations/Nls;", "createActions", "()[Ljavax/swing/Action;", "createJButtonForAction", "action", "createDoNotAskCheckbox", "getPreferredFocusedComponent", "doCancelAction", "createHelpButton", "insets", "Ljava/awt/Insets;", "getHelpId", "toBeShown", "RootLayout", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAlertMessagesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertMessagesManager.kt\ncom/intellij/ui/messages/AlertDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,581:1\n1869#2,2:582\n1#3:584\n37#4,2:585\n*S KotlinDebug\n*F\n+ 1 AlertMessagesManager.kt\ncom/intellij/ui/messages/AlertDialog\n*L\n424#1:582,2\n516#1:585,2\n*E\n"})
public final class AlertDialog
extends DialogWrapper {
    @Nullable
    private final String myMessage;
    @Nullable
    private final String myTitle;
    @NotNull
    private final String[] myOptions;
    private final int myDefaultOptionIndex;
    private final int myFocusedOptionIndex;
    @Nullable
    private final String myHelpId;
    @NotNull
    private final ExitActionType[] exitActionTypes;
    private final boolean myIsTitleComponent;
    @NotNull
    private final RootLayout myRootLayout;
    @NotNull
    private final JLabel myIconComponent;
    @Nullable
    private JComponent myMessageComponent;
    @NotNull
    private final JPanel mySouthPanel;
    @NotNull
    private final JPanel myButtonsPanel;
    @Nullable
    private final JComponent myCloseButton;
    @NotNull
    private final ArrayList<JButton> myButtons;
    @Nullable
    private JButton myHelpButton;
    @Nullable
    private Dimension myInitSize;

    public AlertDialog(@Nullable Project project2, @Nullable Component parentComponent, @NlsContexts.DialogMessage @Nullable String myMessage, @NlsContexts.DialogTitle @Nullable String myTitle, @NotNull String[] myOptions, int myDefaultOptionIndex, int myFocusedOptionIndex, @NotNull Icon icon2, @Nullable DoNotAskOption doNotAskOption, @Nullable String myHelpId, @Nullable String invocationPlace, @NotNull ExitActionType[] exitActionTypes) {
        JButton helpButton;
        Object object;
        Intrinsics.checkNotNullParameter((Object)myOptions, (String)"myOptions");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)exitActionTypes, (String)"exitActionTypes");
        super(project2, parentComponent, false, DialogWrapper.IdeModalityType.IDE, false);
        this.myMessage = myMessage;
        this.myTitle = myTitle;
        this.myOptions = myOptions;
        this.myDefaultOptionIndex = myDefaultOptionIndex;
        this.myFocusedOptionIndex = myFocusedOptionIndex;
        this.myHelpId = myHelpId;
        this.exitActionTypes = exitActionTypes;
        this.myIsTitleComponent = SystemInfoRt.isMac || !Registry.Companion.is("ide.message.dialogs.as.swing.alert.show.title.bar", false);
        this.myRootLayout = new RootLayout();
        this.myIconComponent = new JLabel(icon2);
        this.mySouthPanel = new JPanel(new BorderLayout());
        this.myButtonsPanel = new JPanel();
        this.myButtons = new ArrayList();
        this.setTitle(this.myTitle);
        this.setDoNotAskOption(doNotAskOption);
        this.setInvocationPlace(invocationPlace);
        if (this.myIsTitleComponent && !SystemInfoRt.isMac) {
            IconButton iconButton = new IconButton(null, AllIcons.Windows.CloseActive, null, null);
            object = arg_0 -> AlertDialog._init_$lambda$0(this, arg_0);
            this.myCloseButton = (JComponent)new InplaceButton(iconButton, (ActionListener)object){

                protected void paintHover(Graphics g) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    this.paintHover(g, false);
                }
            };
            ((Object)this.myCloseButton).setPreferredSize((Dimension)new JBDimension(22, 22));
            ((Object)this.myCloseButton).getAccessibleContext().setAccessibleName(CommonBundle.message((String)"button.without.mnemonic.close", (Object[])new Object[0]));
        } else {
            this.myCloseButton = null;
        }
        if (SystemInfoRt.isMac) {
            this.setInitialLocationCallback(() -> AlertDialog._init_$lambda$1(this));
        }
        this.init();
        if (this.myHelpButton != null) {
            JButton jButton = this.myHelpButton;
            Intrinsics.checkNotNull((Object)jButton);
            helpButton = jButton;
            helpButton.getParent().remove(helpButton);
            this.myRootLayout.addAdditionalComponent(helpButton);
        }
        if (this.myCloseButton != null) {
            this.myRootLayout.addAdditionalComponent(this.myCloseButton);
        }
        if (this.myIsTitleComponent) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            this.getRootPane().setBorder((Border)PopupBorder.Factory.create((boolean)true, (boolean)true));
            helpButton = this.myDisposable;
            object = this.getContentPane();
            new MouseDragHelper<JComponent>((Disposable)helpButton, (Container)object){
                private Point myLocation;
                {
                    Intrinsics.checkNotNull((Object)$super_call_param$2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                    super($super_call_param$1, (JComponent)$super_call_param$2);
                }

                public final Point getMyLocation() {
                    return this.myLocation;
                }

                public final void setMyLocation(Point point) {
                    this.myLocation = point;
                }

                protected boolean canStartDragging(JComponent dragComponent, Point dragComponentPoint) {
                    Intrinsics.checkNotNullParameter((Object)dragComponent, (String)"dragComponent");
                    Intrinsics.checkNotNullParameter((Object)dragComponentPoint, (String)"dragComponentPoint");
                    Component target = dragComponent.findComponentAt(dragComponentPoint);
                    return target == null || Intrinsics.areEqual((Object)target, (Object)dragComponent) || target instanceof JPanel;
                }

                protected void processDrag(MouseEvent event, Point dragToScreenPoint, Point startScreenPoint) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
                    Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
                    if (this.myLocation == null) {
                        this.myLocation = this.getWindow().getLocation();
                    }
                    Window window = this.getWindow();
                    Point point = this.myLocation;
                    Intrinsics.checkNotNull((Object)point);
                    int n = point.x + dragToScreenPoint.x - startScreenPoint.x;
                    Point point2 = this.myLocation;
                    Intrinsics.checkNotNull((Object)point2);
                    window.setLocation(new Point(n, point2.y + dragToScreenPoint.y - startScreenPoint.y));
                }

                protected void processDragCancel() {
                    this.myLocation = null;
                }

                protected void processDragFinish(MouseEvent event, boolean willDragOutStart) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.myLocation = null;
                }

                protected void processDragOutFinish(MouseEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.myLocation = null;
                }

                protected void processDragOutCancel() {
                    this.myLocation = null;
                }

                protected void processDragOut(MouseEvent event, Point dragToScreenPoint, Point startScreenPoint, boolean justStarted) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)dragToScreenPoint, (String)"dragToScreenPoint");
                    Intrinsics.checkNotNullParameter((Object)startScreenPoint, (String)"startScreenPoint");
                    super.processDragOut(event, dragToScreenPoint, startScreenPoint, justStarted);
                    this.myLocation = null;
                }
            }.start();
        }
        WindowRoundedCornersManager.configure(this);
        JBColor jBColor = JBColor.namedColor((String)"AlertDialog.background", (Color)JBColor.PanelBackground);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        JBColor alertBackground = jBColor;
        UIUtil.uiTraverser((Component)this.getWindow()).traverse().consumeEach(arg_0 -> AlertDialog._init_$lambda$3(arg_0 -> AlertDialog._init_$lambda$2(alertBackground, arg_0), arg_0));
    }

    public /* synthetic */ AlertDialog(Project project2, Component component2, String string, String string2, String[] stringArray, int n, int n2, Icon icon2, DoNotAskOption doNotAskOption, String string3, String string4, ExitActionType[] exitActionTypeArray, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x400) != 0) {
            string4 = null;
        }
        if ((n3 & 0x800) != 0) {
            exitActionTypeArray = new ExitActionType[]{};
        }
        this(project2, component2, string, string2, stringArray, n, n2, icon2, doNotAskOption, string3, string4, exitActionTypeArray);
    }

    @Nullable
    public final String getMyMessage() {
        return this.myMessage;
    }

    @Nullable
    public final String getMyTitle() {
        return this.myTitle;
    }

    @NotNull
    public final String[] getMyOptions() {
        return this.myOptions;
    }

    public final int getMyDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }

    public final int getMyFocusedOptionIndex() {
        return this.myFocusedOptionIndex;
    }

    @Nullable
    public final String getMyHelpId() {
        return this.myHelpId;
    }

    @NotNull
    public final ExitActionType[] getExitActionTypes() {
        return this.exitActionTypes;
    }

    public boolean setSizeDuringPack() {
        return false;
    }

    protected void sortActionsOnMac(@NotNull List<Action> actions) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        CollectionsKt.reverse(actions);
    }

    public void beforeShowCallback() {
        if (SystemInfoRt.isMac) {
            Dimension dimension = this.myInitSize;
            Intrinsics.checkNotNull((Object)dimension);
            Dimension initSize = dimension;
            if (!this.getSize().equals(initSize)) {
                this.setSize(initSize.width, initSize.height);
                Point location = this.getInitialLocation();
                if (location != null) {
                    this.setLocation(location.x, location.y);
                }
            }
        }
    }

    @NotNull
    public Dimension getInitialSize() {
        if (this.myInitSize == null) {
            this.myInitSize = this.calculateInitialSize();
        }
        Dimension dimension = this.myInitSize;
        Intrinsics.checkNotNull((Object)dimension);
        return dimension;
    }

    private final Dimension calculateInitialSize() {
        int buttonsWidth = this.myButtonsPanel.getPreferredSize().width;
        if (buttonsWidth > JBUI.scale((int)348)) {
            this.configureMessageWidth(Math.min(buttonsWidth, JBUI.scale((int)450)));
            Dimension dimension = this.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            return dimension;
        }
        int width = JBUI.scale((int)(buttonsWidth <= JBUI.scale((int)278) && StringUtil.length((CharSequence)this.myMessage) <= 130 ? 370 : 440));
        this.configureMessageWidth(width - this.myRootLayout.getWidthWithoutMessageComponent());
        return new Dimension(width, this.getPreferredSize().height);
    }

    private final void configureMessageWidth(int width) {
        if (this.myMessageComponent == null) {
            return;
        }
        JScrollPane scrollPane = ComponentUtil.getScrollPane((Component)this.myMessageComponent);
        if (scrollPane == null) {
            JComponent jComponent = this.myMessageComponent;
            Intrinsics.checkNotNull((Object)jComponent);
            jComponent.putClientProperty("parent.width", width);
        } else {
            scrollPane.setPreferredSize(new Dimension(width, scrollPane.getPreferredSize().height));
        }
    }

    @NotNull
    protected Border createContentPaneBorder() {
        Insets insets = new JButton().getInsets();
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)(this.myIsTitleComponent ? 20 : 14), (int)20, (int)(20 - insets.bottom), (int)(20 - insets.right));
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(...)");
        return (Border)jBEmptyBorder;
    }

    @NotNull
    protected LayoutManager createRootLayout() {
        return this.myRootLayout;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Object wrapper2;
        Insets buttonInsets;
        Object object;
        Object object2;
        Object titleComponent2;
        JPanel dialogPanel = new JPanel(new BorderLayout(JBUI.scale((int)12), 0));
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.add((Component)this.myIconComponent, "North");
        dialogPanel.add((Component)iconPanel, "West");
        JPanel textPanel = new JPanel(new BorderLayout(0, JBUI.scale((int)8)));
        dialogPanel.add(textPanel);
        SingleTextSelectionHandler singleSelectionHandler = new SingleTextSelectionHandler();
        if (this.myIsTitleComponent && !StringUtil.isEmpty((String)this.myTitle)) {
            String string = this.myTitle;
            Intrinsics.checkNotNull((Object)string);
            String string2 = UIUtil.replaceMnemonicAmpersand((String)string);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replaceMnemonicAmpersand(...)");
            String title2 = StringsKt.replace$default((String)string2, (String)"\u001b", (String)"", (boolean)false, (int)4, null);
            titleComponent2 = this.createTextComponent(new JEditorPane(){

                public Dimension getPreferredSize() {
                    Dimension size2 = super.getPreferredSize();
                    return new Dimension(Math.min(size2.width, JBUI.scale((int)450)), size2.height);
                }
            }, StringUtil.trimLog((String)title2, (int)100));
            ((JComponent)titleComponent2).setFont((Font)JBFont.h4());
            textPanel.add((Component)((Object)this.wrapWithMinWidth((JComponent)titleComponent2)), "North");
            singleSelectionHandler.add((JTextComponent)titleComponent2, false);
        }
        if (!StringUtil.isEmpty((String)this.myMessage)) {
            JEditorPane jEditorPane = new JEditorPane(){

                public Dimension getPreferredSize() {
                    Object parentWidth = this.getClientProperty("parent.width");
                    if (parentWidth instanceof Integer) {
                        View view2 = this.getUI().getRootView(this);
                        view2.setSize(((Number)parentWidth).intValue(), 2.1474836E9f);
                        return new Dimension(((Number)parentWidth).intValue(), (int)view2.getPreferredSpan(1));
                    }
                    Dimension dimension = super.getPreferredSize();
                    Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
                    return dimension;
                }

                public AccessibleContext getAccessibleContext() {
                    if (this.accessibleContext == null) {
                        this.accessibleContext = new JEditorPane.AccessibleJEditorPane(this){

                            public AccessibleRole getAccessibleRole() {
                                return AccessibleRole.LABEL;
                            }
                        };
                    }
                    return this.accessibleContext;
                }
            };
            String string = this.myMessage;
            Intrinsics.checkNotNull((Object)string);
            titleComponent2 = string;
            object2 = new Regex("(\r\n|\n)");
            object = "<br/>";
            JEditorPane messageComponent2 = this.createTextComponent(jEditorPane, object2.replace((CharSequence)titleComponent2, (String)object));
            messageComponent2.setFont((Font)JBFont.regular());
            this.myMessageComponent = messageComponent2;
            singleSelectionHandler.add((JTextComponent)messageComponent2, false);
            textPanel.add((Component)((Object)this.wrapWithMinWidth(this.wrapToScrollPaneIfNeeded(messageComponent2))));
        }
        textPanel.add((Component)this.mySouthPanel, "South");
        this.createSouthPanel();
        Insets insets = buttonInsets = this.myButtons.size() > 0 ? this.myButtons.get(0).getInsets() : new Insets(0, 0, 0, 0);
        if (this.myCheckBoxDoNotShowDialog == null || !this.myCheckBoxDoNotShowDialog.isVisible()) {
            this.myButtonsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)(14 - JBUI.unscale((int)buttonInsets.top))));
        } else {
            this.myCheckBoxDoNotShowDialog.setFont((Font)JBFont.regular());
            wrapper2 = new Wrapper((JComponent)this.myCheckBoxDoNotShowDialog);
            int checkBoxLeftOffset = this.myCheckBoxDoNotShowDialog.getInsets().left;
            wrapper2.setBorder((Border)JBUI.Borders.emptyTop((int)4));
            for (Component child : UIUtil.uiChildren((Component)textPanel)) {
                if (Intrinsics.areEqual((Object)child, (Object)this.mySouthPanel)) continue;
                Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                ((JComponent)child).setBorder((Border)JBUI.Borders.emptyLeft((int)JBUI.unscale((int)checkBoxLeftOffset)));
            }
            LayoutManager layoutManager = dialogPanel.getLayout();
            Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
            object = (BorderLayout)layoutManager;
            ((BorderLayout)object).setHgap(((BorderLayout)object).getHgap() - checkBoxLeftOffset);
            LayoutManager layoutManager2 = this.mySouthPanel.getLayout();
            Intrinsics.checkNotNull((Object)layoutManager2, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
            ((BorderLayout)layoutManager2).setVgap(JBUI.scale((int)(22 - JBUI.unscale((int)buttonInsets.top))));
            this.mySouthPanel.add((Component)wrapper2, "North");
        }
        this.myButtonsPanel.setLayout((LayoutManager)new HorizontalLayout(JBUI.scale((int)(12 - JBUI.unscale((int)(buttonInsets.left - buttonInsets.right)))), 0, 2, null));
        Iterator<JButton> iterator = this.myButtons.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        wrapper2 = iterator;
        while (wrapper2.hasNext()) {
            Object e = wrapper2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            JButton button2 = (JButton)e;
            button2.getParent().remove(button2);
            this.myButtonsPanel.add((Component)button2, "RIGHT");
        }
        if (SystemInfoRt.isMac) {
            Object v10;
            JComponent jComponent;
            Collection collection;
            Collection collection2;
            block9: {
                Map map2 = this.getButtonMap();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getButtonMap(...)");
                Map buttonMap = map2;
                buttonMap.clear();
                Iterable $this$forEach$iv = this.myButtons;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    JButton it = (JButton)element$iv;
                    boolean bl = false;
                    buttonMap.put(it.getAction(), it);
                }
                object2 = this.myButtons;
                collection2 = this.myButtons;
                collection = null;
                jComponent = this.myButtonsPanel;
                Object object3 = object2;
                Iterator iterator2 = object3.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    JButton b = (JButton)t;
                    boolean bl = false;
                    if (!(b.getAction().getValue("DefaultAction") != null)) continue;
                    v10 = t;
                    break block9;
                }
                v10 = null;
            }
            Object var16_19 = v10;
            Touchbar.setButtonActions((JComponent)jComponent, collection, (Collection)collection2, (JButton)var16_19);
        }
        this.mySouthPanel.add(this.myButtonsPanel);
        singleSelectionHandler.start();
        return dialogPanel;
    }

    private final JComponent wrapToScrollPaneIfNeeded(JEditorPane messageComponent2) {
        int width450 = JBUI.scale((int)450);
        float size2D = messageComponent2.getFont().getSize2D();
        int maximumHeight = (int)((double)size2D * 9.45);
        Dimension dimension = messageComponent2.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        Dimension preferred = dimension;
        if (preferred.height < maximumHeight) {
            int columnLength = (int)(1.2 * (double)width450 / (double)size2D);
            if (messageComponent2.getDocument().getLength() < columnLength * 8) {
                return messageComponent2;
            }
        }
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)messageComponent2, (int)20, (int)30);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        JScrollPane scrollPane = jScrollPane;
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        int barWidth = UIUtil.getScrollBarWidth();
        scrollPane.setPreferredSize(new Dimension(RangesKt.coerceAtMost((int)preferred.width, (int)width450) + barWidth, maximumHeight + barWidth));
        return scrollPane;
    }

    private final wrapWithMinWidth.1 wrapWithMinWidth(JComponent scrollPane) {
        return new Wrapper(scrollPane){

            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, Math.min(width, JBUI.scale((int)450)), height);
            }
        };
    }

    private final JEditorPane createTextComponent(JEditorPane component2, String message) {
        String string;
        component2.putClientProperty("JEditorPane.honorDisplayProperties", true);
        component2.setContentType("text/html");
        component2.setEditable(false);
        component2.setOpaque(false);
        component2.setBorder((Border)JBUI.Borders.empty());
        HTMLEditorKit kit2 = new HTMLEditorKitBuilder().withWordWrapViewFactory().build();
        kit2.getStyleSheet().addRule("a {color: " + ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + "}");
        component2.setEditorKit(kit2);
        component2.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        if (BasicHTML.isHTMLString(message)) {
            String string2 = message;
            Intrinsics.checkNotNull((Object)string2);
            string = StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)string2, (String)" "));
        } else {
            string = message;
        }
        component2.putClientProperty("AccessibleName", string);
        component2.setText(message);
        component2.setEditable(false);
        if (component2.getCaret() != null) {
            component2.setCaretPosition(0);
        }
        return component2;
    }

    @NotNull
    protected Action[] createActions() {
        List actions = new ArrayList();
        int n = this.myOptions.length;
        for (int i2 = 0; i2 < n; ++i2) {
            String option2 = this.myOptions[i2];
            ExitActionType exitActionType = this.exitActionTypes.length > i2 ? this.exitActionTypes[i2] : ExitActionType.UNDEFINED;
            String string = UIUtil.replaceMnemonicAmpersand((String)option2);
            Action action2 = new AbstractAction(this, i2, exitActionType, string){
                final /* synthetic */ AlertDialog this$0;
                final /* synthetic */ int $i;
                final /* synthetic */ ExitActionType $exitActionType;
                {
                    this.this$0 = $receiver;
                    this.$i = $i;
                    this.$exitActionType = $exitActionType;
                    super($super_call_param$1);
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.close(this.$i, true, this.$exitActionType);
                }
            };
            if (i2 == this.myDefaultOptionIndex) {
                action2.putValue("DefaultAction", true);
            }
            if (i2 == this.myFocusedOptionIndex) {
                action2.putValue("FocusedAction", true);
            }
            UIUtil.assignMnemonic((String)option2, (Action)action2);
            actions.add(action2);
        }
        if (this.getHelpId() != null) {
            Action action3 = this.getHelpAction();
            Intrinsics.checkNotNullExpressionValue((Object)action3, (String)"getHelpAction(...)");
            actions.add(action3);
        }
        Collection $this$toTypedArray$iv = actions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Action[0]);
    }

    @NotNull
    protected JButton createJButtonForAction(@NotNull Action action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        JButton button2 = super.createJButtonForAction(action2);
        Dimension size2 = button2.getPreferredSize();
        Insets insets = button2.getInsets();
        int width = JBUI.scale((int)72) + insets.left + insets.right;
        if (size2.width < width) {
            size2.width = width;
        } else {
            int diffWidth = JBUI.scale((int)20) - UIUtil.getButtonTextHorizontalOffset((AbstractButton)button2, (Dimension)size2, null);
            if (diffWidth > 0) {
                size2.width += 2 * diffWidth;
            }
        }
        int height = JBUI.scale((int)24) + insets.top + insets.bottom;
        if (size2.height < height) {
            size2.height = height;
        }
        button2.setPreferredSize(size2);
        this.myButtons.add(button2);
        Intrinsics.checkNotNull((Object)button2);
        return button2;
    }

    @Nullable
    protected JComponent createDoNotAskCheckbox() {
        return null;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!SystemInfoRt.isMac) {
            return null;
        }
        if (this.myPreferredFocusedComponent != null) {
            return this.myPreferredFocusedComponent;
        }
        int size2 = this.myButtons.size();
        if (size2 > 0) {
            ArrayList<JButton> arrayList;
            if (SystemInfoRt.isMac) {
                ArrayList arrayList2;
                ArrayList it = arrayList2 = new ArrayList(this.myButtons);
                boolean bl = false;
                CollectionsKt.reverse((List)it);
                arrayList = arrayList2;
            } else {
                arrayList = this.myButtons;
            }
            ArrayList<JButton> buttons = arrayList;
            String cancelButton = Messages.getCancelButton();
            Iterator iterator = ((Iterable)buttons).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                JButton button2 = (JButton)iterator.next();
                if (index == this.myDefaultOptionIndex || size2 >= 3 && Intrinsics.areEqual((Object)cancelButton, (Object)button2.getText())) continue;
                return button2;
            }
        }
        return null;
    }

    public void doCancelAction() {
        this.close(-1, false, ExitActionType.CANCEL);
    }

    @NotNull
    protected JButton createHelpButton(@NotNull Insets insets) {
        JButton helpButton;
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        JButton jButton = super.createHelpButton(insets);
        Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"createHelpButton(...)");
        this.myHelpButton = helpButton = jButton;
        return helpButton;
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    public boolean toBeShown() {
        return super.toBeShown();
    }

    private static final void _init_$lambda$0(AlertDialog this$0, ActionEvent it) {
        this$0.doCancelAction();
    }

    private static final Point _init_$lambda$1(AlertDialog this$0) {
        JRootPane rootPane;
        JRootPane jRootPane = SwingUtilities.getRootPane(this$0.getWindow().getParent());
        if (jRootPane == null) {
            jRootPane = SwingUtilities.getRootPane(this$0.getWindow().getOwner());
        }
        if ((rootPane = jRootPane) == null || !rootPane.isShowing()) {
            return null;
        }
        Point location = rootPane.getLocationOnScreen();
        return new Point(location.x + (rootPane.getWidth() - this$0.getWindow().getWidth()) / 2, (int)((double)location.y + (double)rootPane.getHeight() * 0.25));
    }

    private static final Unit _init_$lambda$2(JBColor $alertBackground, Component it) {
        if (JBColor.PanelBackground.equals(it.getBackground())) {
            it.setBackground((Color)$alertBackground);
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ui/messages/AlertDialog$RootLayout;", "Ljava/awt/BorderLayout;", "<init>", "(Lcom/intellij/ui/messages/AlertDialog;)V", "myParent", "Ljava/awt/Container;", "getWidthWithoutMessageComponent", "", "addAdditionalComponent", "", "component", "Ljava/awt/Component;", "addLayoutComponent", "name", "", "comp", "layoutContainer", "target", "intellij.platform.ide.impl"})
    private final class RootLayout
    extends BorderLayout {
        @Nullable
        private Container myParent;

        public final int getWidthWithoutMessageComponent() {
            Container container = this.myParent;
            Intrinsics.checkNotNull((Object)container);
            Insets insets = container.getInsets();
            LayoutManager layoutManager = AlertDialog.this.myIconComponent.getParent().getParent().getLayout();
            Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
            BorderLayout layout2 = (BorderLayout)layoutManager;
            return insets.left + ((AlertDialog)AlertDialog.this).myIconComponent.getPreferredSize().width + layout2.getHgap() + insets.right;
        }

        public final void addAdditionalComponent(@NotNull Component component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Container container = this.myParent;
            Intrinsics.checkNotNull((Object)container);
            container.add(component2, 0);
        }

        @Override
        public void addLayoutComponent(@Nullable String name2, @NotNull Component comp) {
            Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
            if (this.myParent == null) {
                this.myParent = comp.getParent();
            }
            if (!Intrinsics.areEqual((Object)comp, (Object)AlertDialog.this.myCloseButton) && !Intrinsics.areEqual((Object)comp, (Object)AlertDialog.this.myHelpButton)) {
                super.addLayoutComponent(name2, comp);
            }
        }

        @Override
        public void layoutContainer(@NotNull Container target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super.layoutContainer(target);
            if (AlertDialog.this.myCloseButton != null) {
                int offset = JBUI.scale((int)24);
                Dimension size2 = AlertDialog.this.myCloseButton.getPreferredSize();
                AlertDialog.this.myCloseButton.setBounds(target.getWidth() - offset, offset - size2.height, size2.width, size2.height);
            }
            if (AlertDialog.this.myHelpButton != null) {
                JButton jButton = AlertDialog.this.myHelpButton;
                Intrinsics.checkNotNull((Object)jButton);
                JButton helpButton = jButton;
                Object e = AlertDialog.this.myButtons.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                JButton firstButton = (JButton)e;
                Point iconPoint = SwingUtilities.convertPoint(AlertDialog.this.myIconComponent, 0, 0, target);
                Dimension iconSize = AlertDialog.this.myIconComponent.getPreferredSize();
                Dimension helpSize = helpButton.getPreferredSize();
                Dimension buttonSize = firstButton.getPreferredSize();
                helpButton.setBounds(iconPoint.x + (iconSize.width - helpSize.width) / 2, target.getHeight() - target.getInsets().bottom - (buttonSize.height + helpSize.height) / 2, helpSize.width, helpSize.height);
            }
        }
    }
}

