/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.diagnostic.LoadingState;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.ExitActionType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.AppIcon;
import com.intellij.ui.messages.AlertDialog;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u008b\u0001\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ui/messages/AlertMessagesManager;", "", "<init>", "()V", "showMessageDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "message", "", "title", "options", "", "defaultOptionIndex", "focusedOptionIndex", "icon", "Ljavax/swing/Icon;", "doNotAskOption", "Lcom/intellij/openapi/ui/DoNotAskOption;", "helpId", "invocationPlace", "exitActionTypes", "Lcom/intellij/openapi/ui/ExitActionType;", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;IILjavax/swing/Icon;Lcom/intellij/openapi/ui/DoNotAskOption;Ljava/lang/String;Ljava/lang/String;[Lcom/intellij/openapi/ui/ExitActionType;)I", "getIcon", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class AlertMessagesManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int showMessageDialog(@Nullable Project project2, @Nullable Component parentComponent, @NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle @Nullable String title2, @NotNull String[] options2, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon2, @Nullable DoNotAskOption doNotAskOption, @Nullable String helpId, @Nullable String invocationPlace, @NotNull ExitActionType[] exitActionTypes) {
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Intrinsics.checkNotNullParameter((Object)exitActionTypes, (String)"exitActionTypes");
        AlertDialog dialog2 = new AlertDialog(project2, parentComponent, message, title2, options2, defaultOptionIndex, focusedOptionIndex, this.getIcon(icon2), doNotAskOption, helpId, invocationPlace, exitActionTypes);
        AppIcon.getInstance().requestAttention(project2, true);
        dialog2.show();
        return dialog2.getExitCode();
    }

    private final Icon getIcon(Icon icon2) {
        if (Intrinsics.areEqual((Object)icon2, (Object)UIUtil.getInformationIcon()) || icon2 == null) {
            Icon icon3 = AllIcons.General.InformationDialog;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"InformationDialog");
            return icon3;
        }
        if (Intrinsics.areEqual((Object)icon2, (Object)UIUtil.getQuestionIcon())) {
            Icon icon4 = AllIcons.General.QuestionDialog;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"QuestionDialog");
            return icon4;
        }
        if (Intrinsics.areEqual((Object)icon2, (Object)UIUtil.getWarningIcon())) {
            Icon icon5 = AllIcons.General.WarningDialog;
            Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"WarningDialog");
            return icon5;
        }
        if (Intrinsics.areEqual((Object)icon2, (Object)UIUtil.getErrorIcon())) {
            Icon icon6 = AllIcons.General.ErrorDialog;
            Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"ErrorDialog");
            return icon6;
        }
        return icon2;
    }

    @JvmStatic
    @Nullable
    public static final AlertMessagesManager getInstanceIfPossible() {
        return Companion.getInstanceIfPossible();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ui/messages/AlertMessagesManager$Companion;", "", "<init>", "()V", "getInstanceIfPossible", "Lcom/intellij/ui/messages/AlertMessagesManager;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nAlertMessagesManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertMessagesManager.kt\ncom/intellij/ui/messages/AlertMessagesManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,581:1\n30#2,2:582\n*S KotlinDebug\n*F\n+ 1 AlertMessagesManager.kt\ncom/intellij/ui/messages/AlertMessagesManager$Companion\n*L\n54#1:582,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final AlertMessagesManager getInstanceIfPossible() {
            AlertMessagesManager alertMessagesManager;
            if (LoadingState.COMPONENTS_LOADED.isOccurred() && RegistryManager.Companion.getInstance().is("ide.message.dialogs.as.swing.alert")) {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
                ComponentManager $this$service$iv = (ComponentManager)application;
                boolean $i$f$service = false;
                Class<AlertMessagesManager> serviceClass$iv = AlertMessagesManager.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                alertMessagesManager = (AlertMessagesManager)object;
            } else {
                alertMessagesManager = null;
            }
            return alertMessagesManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

