/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutineSupport;
import com.intellij.openapi.application.impl.InternalUICustomization;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.MethodHandleUtil;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NSScrollerHelper;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.ScopeHandle;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonlessScrollBarUI
extends BasicScrollBarUI {
    private static final Logger LOG = Logger.getInstance(ButtonlessScrollBarUI.class);
    private final AdjustmentListener myAdjustmentListener;
    private final MouseMotionAdapter myMouseMotionListener;
    private final MouseAdapter myMouseListener;
    private final HierarchyListener myHierarchyListener;
    private final AWTEventListener myAWTMouseListener;
    private final AWTEventListener myWeakListener;
    private final NSScrollerHelper.ScrollbarStyleListener myNSScrollerListener;
    private boolean myGlobalListenersAdded;
    private static final int DELAY_FRAMES = 4;
    private static final int FRAMES_COUNT = 14;
    private Animator thumbFadeAnimator;
    private int myThumbFadeColorShift;
    private boolean myMouseIsOverThumb;
    private boolean mouseOverScrollbar;
    private double mouseOverScrollbarExpandLevel;
    private NSScrollerHelper.Style myMacScrollerStyle;
    private Animator mouseOverScrollbarExpandAnimator;
    private SingleEdtTaskScheduler macScrollbarFadeTimer;
    private Animator macScrollbarFadeAnimator;
    private double macScrollbarFadeLevel;
    private boolean macScrollbarHidden;
    private RegionPainter<Float> thumbPainter;
    private ScrollbarRepaintCallback myRepaintCallback;
    private final ScopeHandle scopeHandle = new ScopeHandle();
    private static final SynchronizedClearableLazy<@Nullable MethodHandle> setValueFrom = new SynchronizedClearableLazy(() -> {
        try {
            return MethodHandleUtil.getPrivateMethod(BasicScrollBarUI.TrackListener.class, "setValueFrom", MethodType.methodType(Void.TYPE, MouseEvent.class));
        }
        catch (Throwable e) {
            LOG.error("Cannot get TrackListener.setValueFrom method", e);
            return null;
        }
    });

    private JBColor getTrackBackground() {
        return this.jbColor(LightColors.SLIGHTLY_GRAY, UIUtil.getListBackground());
    }

    private JBColor getTrackBorderColor() {
        return this.jbColor((Color)Gray._230, UIUtil.getListBackground());
    }

    private JBColor jbColor(@NotNull Color regular, @NotNull Color dark) {
        if (regular == null) {
            ButtonlessScrollBarUI.$$$reportNull$$$0(0);
        }
        if (dark == null) {
            ButtonlessScrollBarUI.$$$reportNull$$$0(1);
        }
        return JBColor.lazy(() -> this.isDark() ? dark : regular);
    }

    private int getAnimationColorShift() {
        return this.isDark() ? 20 : 40;
    }

    protected ButtonlessScrollBarUI() {
        this.myAdjustmentListener = new AdjustmentListener(){
            Point oldViewportPosition;
            Dimension oldViewportDimension;

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                JViewport viewport;
                JScrollPane scrollpane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, ButtonlessScrollBarUI.this.scrollbar);
                JViewport jViewport = viewport = scrollpane == null ? null : scrollpane.getViewport();
                if (viewport == null) {
                    this.oldViewportPosition = null;
                    return;
                }
                boolean vertical = ButtonlessScrollBarUI.this.isVertical();
                Point position = viewport.getViewPosition();
                Dimension dimension = scrollpane.getSize();
                boolean scrolled = false;
                if (this.oldViewportPosition != null) {
                    int scrollH = position.x - this.oldViewportPosition.x;
                    int scrollV = position.y - this.oldViewportPosition.y;
                    scrolled = vertical && scrollH == 0 && scrollV != 0 || !vertical && scrollV == 0 && scrollH != 0;
                }
                this.oldViewportPosition = position;
                boolean resized = false;
                if (this.oldViewportDimension != null) {
                    int resizedH = dimension.width - this.oldViewportDimension.width;
                    int resizedV = dimension.height - this.oldViewportDimension.height;
                    resized = vertical ? resizedV != 0 : resizedH != 0;
                }
                this.oldViewportDimension = dimension;
                if (scrolled) {
                    ScrollBarUI otherUI;
                    JScrollBar other = vertical ? scrollpane.getHorizontalScrollBar() : scrollpane.getVerticalScrollBar();
                    ScrollBarUI scrollBarUI = otherUI = other == null ? null : other.getUI();
                    if (otherUI instanceof ButtonlessScrollBarUI) {
                        ((ButtonlessScrollBarUI)otherUI).startMacScrollbarFadeout(true);
                    }
                    ButtonlessScrollBarUI.this.restart();
                } else if (resized) {
                    ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
                }
            }
        };
        this.myMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean inside = ButtonlessScrollBarUI.this.isOverThumb(e.getPoint());
                if (inside != ButtonlessScrollBarUI.this.myMouseIsOverThumb) {
                    ButtonlessScrollBarUI.this.myMouseIsOverThumb = inside;
                    ButtonlessScrollBarUI.this.startRegularThumbAnimator();
                }
            }
        };
        this.myMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ButtonlessScrollBarUI.this.macScrollbarFadeLevel == 0.0) {
                    ButtonlessScrollBarUI.this.mouseOverScrollbar = true;
                    ButtonlessScrollBarUI.this.startMacScrollbarExpandAnimator();
                    ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (ButtonlessScrollBarUI.this.myMouseIsOverThumb) {
                    ButtonlessScrollBarUI.this.myMouseIsOverThumb = false;
                    ButtonlessScrollBarUI.this.startRegularThumbAnimator();
                }
                if (ButtonlessScrollBarUI.this.mouseOverScrollbar) {
                    ButtonlessScrollBarUI.this.mouseOverScrollbar = false;
                    ButtonlessScrollBarUI.this.startMacScrollbarExpandAnimator();
                    ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
                }
            }
        };
        this.myHierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (e.getChanged() == ButtonlessScrollBarUI.this.scrollbar && (2L & e.getChangeFlags()) != 0L) {
                    ButtonlessScrollBarUI.this.updateGlobalListeners(false);
                }
                if (e.getChanged() == ButtonlessScrollBarUI.this.scrollbar.getParent() && (4L & e.getChangeFlags()) != 0L) {
                    ButtonlessScrollBarUI.this.restart();
                }
            }
        };
        this.myAWTMouseListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                Container scrollpane;
                if (event.getID() == 503 && !ButtonlessScrollBarUI.this.macScrollbarHidden && ButtonlessScrollBarUI.this.macScrollbarFadeLevel == 0.0 && (scrollpane = SwingUtilities.getAncestorOfClass(JScrollPane.class, ButtonlessScrollBarUI.this.scrollbar)) != null) {
                    Point loc = ((MouseEvent)event).getLocationOnScreen();
                    SwingUtilities.convertPointFromScreen(loc, scrollpane);
                    if (scrollpane.contains(loc)) {
                        ButtonlessScrollBarUI.this.startMacScrollbarFadeout();
                    }
                }
            }
        };
        this.myWeakListener = new WeakListener(this.myAWTMouseListener);
        this.myNSScrollerListener = new NSScrollerHelper.ScrollbarStyleListener(){

            public void styleChanged() {
                ButtonlessScrollBarUI.this.updateMacScrollbarStyle();
            }
        };
    }

    @Override
    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return new BasicScrollBarUI.ArrowButtonListener(this){

            @Override
            public void mousePressed(MouseEvent event) {
            }

            @Override
            public void mouseReleased(MouseEvent event) {
            }
        };
    }

    protected boolean isMacOverlayScrollbar() {
        return this.myMacScrollerStyle == NSScrollerHelper.Style.Overlay && ButtonlessScrollBarUI.isMacOverlayScrollbarSupported();
    }

    public static boolean isMacOverlayScrollbarSupported() {
        InternalUICustomization customization = InternalUICustomization.getInstance();
        return SystemInfo.isMac && !Registry.is((String)"ide.mac.disableMacScrollbars") || customization != null && customization.isMacScrollBar();
    }

    private void updateMacScrollbarStyle() {
        NSScrollerHelper.Style style = NSScrollerHelper.getScrollerStyle();
        if (style != this.myMacScrollerStyle && this.scrollbar != null) {
            this.myMacScrollerStyle = style;
            this.updateStyleDefaults();
            this.restart();
            JScrollPane pane2 = ComponentUtil.getScrollPane((JScrollBar)this.scrollbar);
            if (pane2 != null) {
                pane2.revalidate();
            }
        }
    }

    public boolean alwaysShowTrack() {
        return !this.isMacOverlayScrollbar();
    }

    @Override
    public void layoutContainer(Container scrollbarContainer) {
        try {
            super.layoutContainer(scrollbarContainer);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    protected void setThumbBounds(int x, int y, int width, int height) {
        int h;
        int w;
        if (width > 0 && height > 0 && UIManager.getBoolean("ScrollBar.alwaysShowThumb") && !this.alwaysShowTrack() && ((w = this.trackRect.width) > (h = this.trackRect.height) && w == width || w < h && h == height)) {
            height = 0;
            width = 0;
            y = 0;
            x = 0;
        }
        if (this.myRepaintCallback != null) {
            this.scrollbar.repaint(this.trackRect);
        }
        super.setThumbBounds(x, y, width, height);
    }

    @Override
    protected BasicScrollBarUI.ModelListener createModelListener() {
        return new BasicScrollBarUI.ModelListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    super.stateChanged(e);
                }
            }
        };
    }

    public int getDecrementButtonHeight() {
        return Math.max(0, this.decrButton.getHeight());
    }

    public int getIncrementButtonHeight() {
        return Math.max(0, this.incrButton.getHeight());
    }

    private void startRegularThumbAnimator() {
        if (this.scopeHandle.isDisposed() || this.isMacOverlayScrollbar()) {
            return;
        }
        this.thumbFadeAnimator.reset();
        if (this.scrollbar != null && this.scrollbar.getValueIsAdjusting() || this.myMouseIsOverThumb || Registry.is((String)"ui.simplified")) {
            this.thumbFadeAnimator.suspend();
            this.myThumbFadeColorShift = this.getAnimationColorShift();
        } else {
            this.thumbFadeAnimator.resume();
        }
    }

    private void startMacScrollbarExpandAnimator() {
        if (this.scopeHandle.isDisposed() || !this.isMacOverlayScrollbar()) {
            return;
        }
        if (this.mouseOverScrollbarExpandLevel == 0.0) {
            this.mouseOverScrollbarExpandAnimator.reset();
            this.mouseOverScrollbarExpandAnimator.suspend();
            if (this.mouseOverScrollbar) {
                this.mouseOverScrollbarExpandAnimator.resume();
            }
        }
    }

    private void startMacScrollbarFadeout() {
        this.startMacScrollbarFadeout(false);
    }

    private void startMacScrollbarFadeout(boolean now) {
        if (this.scopeHandle.isDisposed() || !this.isMacOverlayScrollbar()) {
            return;
        }
        this.macScrollbarFadeTimer.cancel();
        if (now) {
            if (!this.macScrollbarHidden && !this.macScrollbarFadeAnimator.isRunning()) {
                this.macScrollbarFadeAnimator.resume();
            }
            return;
        }
        this.macScrollbarFadeAnimator.suspend();
        this.macScrollbarFadeAnimator.reset();
        this.macScrollbarHidden = false;
        this.macScrollbarFadeLevel = 0.0;
        JScrollBar sb = this.scrollbar;
        if (sb != null) {
            sb.repaint();
            Application application = ApplicationManager.getApplication();
            if (!(this.mouseOverScrollbar || sb.getValueIsAdjusting() || application != null && application.isUnitTestMode())) {
                this.macScrollbarFadeTimer.request(700L, () -> this.macScrollbarFadeAnimator.resume());
            }
        }
    }

    @Override
    protected void installDefaults() {
        int incGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        int decGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        try {
            UIManager.put("ScrollBar.incrementButtonGap", 0);
            UIManager.put("ScrollBar.decrementButtonGap", 0);
            super.installDefaults();
        }
        finally {
            UIManager.put("ScrollBar.incrementButtonGap", incGap);
            UIManager.put("ScrollBar.decrementButtonGap", decGap);
        }
        this.myMacScrollerStyle = NSScrollerHelper.getScrollerStyle();
        this.scrollbar.setFocusable(false);
        this.updateStyleDefaults();
    }

    private void updateStyleDefaults() {
        this.scrollbar.setOpaque(this.alwaysShowTrack());
    }

    @Override
    protected void installListeners() {
        CoroutineScope coroutineScope = this.scopeHandle.install();
        this.thumbPainter = JBScrollPane.getThumbPainter(() -> this.scrollbar, (CoroutineScope)coroutineScope);
        this.initRegularThumbAnimator(coroutineScope);
        this.initMacScrollbarAnimators(coroutineScope);
        super.installListeners();
        this.scrollbar.addAdjustmentListener(this.myAdjustmentListener);
        this.scrollbar.addMouseListener(this.myMouseListener);
        this.scrollbar.addMouseMotionListener(this.myMouseMotionListener);
        this.scrollbar.addHierarchyListener(this.myHierarchyListener);
        this.updateGlobalListeners(false);
        this.restart();
    }

    private void restart() {
        this.startRegularThumbAnimator();
        this.startMacScrollbarFadeout();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new BasicScrollBarUI.TrackListener(){

            @Override
            public void mousePressed(MouseEvent event) {
                MethodHandle setValueFrom;
                if (ButtonlessScrollBarUI.this.scrollbar.isEnabled() && SwingUtilities.isLeftMouseButton(event) && NSScrollerHelper.getClickBehavior() == NSScrollerHelper.ClickBehavior.JumpToSpot && !ButtonlessScrollBarUI.this.getThumbBounds().contains(event.getPoint()) && (setValueFrom = (MethodHandle)ButtonlessScrollBarUI.setValueFrom.getValue()) != null) {
                    switch (ButtonlessScrollBarUI.this.scrollbar.getOrientation()) {
                        case 1: {
                            this.offset = ButtonlessScrollBarUI.this.getThumbBounds().height / 2;
                            break;
                        }
                        case 0: {
                            this.offset = ButtonlessScrollBarUI.this.getThumbBounds().width / 2;
                        }
                    }
                    ButtonlessScrollBarUI.this.isDragging = true;
                    try {
                        setValueFrom.invoke(this, event);
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                    return;
                }
                super.mousePressed(event);
            }
        };
    }

    private void updateGlobalListeners(boolean forceRemove) {
        boolean shouldAdd = this.scrollbar.isDisplayable();
        if (this.myGlobalListenersAdded && (!shouldAdd || forceRemove)) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myWeakListener);
            NSScrollerHelper.removeScrollbarStyleListener((NSScrollerHelper.ScrollbarStyleListener)this.myNSScrollerListener);
            this.myGlobalListenersAdded = false;
        }
        if (!this.myGlobalListenersAdded && shouldAdd && !forceRemove) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myWeakListener, 32L);
            NSScrollerHelper.addScrollbarStyleListener((NSScrollerHelper.ScrollbarStyleListener)this.myNSScrollerListener);
            this.myGlobalListenersAdded = true;
        }
    }

    private void initRegularThumbAnimator(@NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            ButtonlessScrollBarUI.$$$reportNull$$$0(2);
        }
        if (this.scopeHandle.isDisposed()) {
            return;
        }
        this.thumbFadeAnimator = new Animator("Regular scrollbar thumb animator", 14, 700, false, true, coroutineScope){

            public void paintNow(int frame, int totalFrames, int cycle) {
                ButtonlessScrollBarUI.this.myThumbFadeColorShift = ButtonlessScrollBarUI.this.getAnimationColorShift();
                if (frame > 4) {
                    ButtonlessScrollBarUI.this.myThumbFadeColorShift = (int)((double)ButtonlessScrollBarUI.this.myThumbFadeColorShift * (1.0 - (double)(frame - 4) / (double)(totalFrames - 4)));
                }
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    ButtonlessScrollBarUI.this.scrollbar.repaint(((ButtonlessScrollBarUI)ButtonlessScrollBarUI.this.scrollbar.getUI()).getThumbBounds());
                }
            }

            @NotNull
            protected CoroutineSupport.UiDispatcherKind uiKind() {
                CoroutineSupport.UiDispatcherKind uiDispatcherKind = CoroutineSupport.UiDispatcherKind.RELAX;
                if (uiDispatcherKind == null) {
                    10.$$$reportNull$$$0(0);
                }
                return uiDispatcherKind;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ButtonlessScrollBarUI$10", "uiKind"));
            }
        };
    }

    private void initMacScrollbarAnimators(@NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            ButtonlessScrollBarUI.$$$reportNull$$$0(3);
        }
        if (this.scopeHandle.isDisposed()) {
            return;
        }
        this.mouseOverScrollbarExpandAnimator = new Animator("Mac scrollbar mouse over animator", 10, 200, false, true, coroutineScope){

            protected void paintCycleEnd() {
                ButtonlessScrollBarUI.this.mouseOverScrollbarExpandLevel = 1.0;
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    ButtonlessScrollBarUI.this.scrollbar.repaint();
                }
            }

            public void paintNow(int frame, int totalFrames, int cycle) {
                int delay = totalFrames / 2;
                int frameAfterDelay = frame - delay;
                if (frameAfterDelay > 0) {
                    ButtonlessScrollBarUI.this.mouseOverScrollbarExpandLevel = (float)frameAfterDelay / (float)(totalFrames - delay);
                    if (ButtonlessScrollBarUI.this.scrollbar != null) {
                        ButtonlessScrollBarUI.this.scrollbar.repaint();
                    }
                }
            }
        };
        this.macScrollbarFadeTimer = SingleEdtTaskScheduler.createSingleEdtTaskScheduler((CoroutineSupport.UiDispatcherKind)CoroutineSupport.UiDispatcherKind.RELAX);
        this.macScrollbarFadeAnimator = new Animator("Mac scrollbar fade animator", 30, 300, false){

            protected void paintCycleEnd() {
                ButtonlessScrollBarUI.this.macScrollbarHidden = true;
                ButtonlessScrollBarUI.this.mouseOverScrollbar = false;
                ButtonlessScrollBarUI.this.mouseOverScrollbarExpandLevel = 0.0;
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    ButtonlessScrollBarUI.this.scrollbar.repaint();
                }
            }

            public void paintNow(int frame, int totalFrames, int cycle) {
                ButtonlessScrollBarUI.this.macScrollbarFadeLevel = (float)frame / (float)totalFrames;
                if (ButtonlessScrollBarUI.this.scrollbar != null) {
                    ButtonlessScrollBarUI.this.scrollbar.repaint();
                }
            }
        };
    }

    private boolean isOverThumb(Point p) {
        Rectangle bounds = this.getThumbBounds();
        return bounds != null && bounds.contains(p);
    }

    @Override
    public Rectangle getThumbBounds() {
        return super.getThumbBounds();
    }

    @Override
    protected void uninstallListeners() {
        this.scopeHandle.uninstall();
        this.thumbPainter = null;
        if (this.scrollTimer != null) {
            super.uninstallListeners();
        }
        this.scrollbar.removeAdjustmentListener(this.myAdjustmentListener);
        this.scrollbar.removeMouseListener(this.myMouseListener);
        this.scrollbar.removeMouseMotionListener(this.myMouseMotionListener);
        this.scrollbar.removeHierarchyListener(this.myHierarchyListener);
        this.updateGlobalListeners(true);
        if (this.thumbFadeAnimator != null) {
            this.thumbFadeAnimator = null;
        }
        this.mouseOverScrollbarExpandAnimator = null;
        if (this.macScrollbarFadeTimer != null) {
            this.macScrollbarFadeTimer.cancel();
        }
        if (this.macScrollbarFadeAnimator != null) {
            this.macScrollbarFadeAnimator.dispose();
        }
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        int thickness = this.getThickness();
        return this.isVertical() ? new Dimension(thickness, thickness * 2) : new Dimension(thickness * 2, thickness);
    }

    protected int getThickness() {
        int i2 = this.isMacOverlayScrollbar() ? 15 : 13;
        return JBUIScale.scale((int)i2);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        int thickness = this.getThickness();
        return new Dimension(thickness, thickness);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMaximumSize(c);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        if (this.isMacOverlayScrollbar() && !this.alwaysShowTrack() && !this.alwaysPaintThumb() && this.macScrollbarHidden) {
            return false;
        }
        return super.contains(c, x, y);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        RegionPainter painter;
        if (this.alwaysShowTrack() || this.mouseOverScrollbarExpandLevel > 0.0) {
            this.doPaintTrack(g, c, trackBounds);
        }
        if ((painter = (RegionPainter)ClientProperty.get((Component)c, (Key)JBScrollBar.TRACK)) != null) {
            painter.paint((Graphics2D)g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, null);
        }
    }

    protected void doPaintTrack(Graphics g, JComponent c, Rectangle bounds) {
        if (this.isMacOverlayScrollbar() && !this.alwaysShowTrack()) {
            bounds = this.getMacScrollBarBounds(bounds, false);
            boolean vertical = this.isVertical();
            Color start2 = this.adjustColor(ColorUtil.darker((Color)this.getTrackBackground(), (int)1));
            Color end = this.adjustColor(this.getTrackBackground().brighter());
            Paint paint = vertical ? UIUtil.getGradientPaint((float)(bounds.x + 1), (float)bounds.y, (Color)start2, (float)(bounds.width + 1), (float)bounds.y, (Color)end) : UIUtil.getGradientPaint((float)bounds.x, (float)(bounds.y + 1), (Color)start2, (float)bounds.x, (float)(bounds.height + 1), (Color)end);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(paint);
            g2d.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setColor(this.adjustColor(start2.darker()));
        } else {
            g.setColor((Color)this.getTrackBackground());
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setColor((Color)this.getTrackBorderColor());
        }
        if (this.isVertical()) {
            int x = this.scrollbar.getComponentOrientation().isLeftToRight() ? bounds.x : bounds.x + bounds.width - 1;
            g.drawLine(x, bounds.y, x, bounds.y + bounds.height);
        } else {
            g.drawLine(bounds.x, bounds.y, bounds.x + bounds.width, bounds.y);
        }
        if (this.myRepaintCallback != null) {
            this.myRepaintCallback.call(g);
        }
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        this.doPaintThumb(g, thumbBounds);
    }

    private void doPaintThumb(Graphics g, Rectangle thumbBounds) {
        if (thumbBounds.isEmpty() || !this.scrollbar.isEnabled()) {
            return;
        }
        if (this.isMacOverlayScrollbar()) {
            this.paintMacThumb(g, thumbBounds);
        } else {
            Rectangle bounds = new Rectangle(thumbBounds);
            if (this.isThumbTranslucent()) {
                JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get((JComponent)this.scrollbar);
                if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                    offset = this.getThumbOffset(bounds.width);
                    if (offset > 0) {
                        bounds.width -= offset;
                        if (alignment == JBScrollPane.Alignment.RIGHT) {
                            bounds.x += offset;
                        }
                    }
                } else {
                    offset = this.getThumbOffset(bounds.height);
                    if (offset > 0) {
                        bounds.height -= offset;
                        if (alignment == JBScrollPane.Alignment.BOTTOM) {
                            bounds.y += offset;
                        }
                    }
                }
            } else if (SystemInfo.isMac) {
                boolean vertical = this.scrollbar == null || 1 == this.scrollbar.getOrientation();
                bounds.x = bounds.x + (vertical ? 1 : 0);
                bounds.y = bounds.y + (vertical ? 0 : 1);
                bounds.width = bounds.width - (vertical ? 1 : 0);
                bounds.height = bounds.height - (vertical ? 0 : 1);
            } else {
                ++bounds.x;
                ++bounds.y;
                bounds.width -= 2;
                bounds.height -= 2;
            }
            if (SystemInfo.isMac) {
                int max = JBUIScale.scale((int)12);
                if (max < bounds.width && bounds.width < bounds.height) {
                    bounds.x += (bounds.width - max) / 2;
                    bounds.width = max;
                } else if (max < bounds.height && bounds.height < bounds.width) {
                    bounds.y += (bounds.height - max) / 2;
                    bounds.height = max;
                }
                float value = ButtonlessScrollBarUI.fixAnimationValue((float)this.myThumbFadeColorShift / (float)this.getAnimationColorShift());
                this.thumbPainter.paint((Graphics2D)g, bounds.x, bounds.y, bounds.width, bounds.height, (Object)Float.valueOf(value));
            } else {
                float value = ButtonlessScrollBarUI.fixAnimationValue((float)this.myThumbFadeColorShift / (float)this.getAnimationColorShift());
                this.thumbPainter.paint((Graphics2D)g, bounds.x, bounds.y, bounds.width, bounds.height, (Object)Float.valueOf(value));
            }
        }
    }

    private static float fixAnimationValue(float value) {
        if (value < 0.0f || Double.isNaN(value)) {
            LOG.debug("unexpected animation value: ", new Object[]{Float.valueOf(value)});
            return 0.0f;
        }
        if (value > 1.0f) {
            LOG.debug("animation value is too big: ", new Object[]{Float.valueOf(value)});
            return 1.0f;
        }
        return value;
    }

    @Deprecated
    @ApiStatus.Internal
    protected boolean isThumbTranslucent() {
        return this.scrollbar == null || !this.scrollbar.isOpaque();
    }

    @Deprecated
    @ApiStatus.Internal
    protected int getThumbOffset(int value) {
        float multiplier = switch (UIUtil.getComponentStyle((Component)this.scrollbar)) {
            default -> throw new MatchException(null, null);
            case UIUtil.ComponentStyle.LARGE -> 1.15f;
            case UIUtil.ComponentStyle.SMALL -> 0.857f;
            case UIUtil.ComponentStyle.MINI -> 0.714f;
            case UIUtil.ComponentStyle.REGULAR -> 1.0f;
        };
        float scale = (float)JBUIScale.scale((int)10) * multiplier;
        return value - (int)scale;
    }

    private void paintMacThumb(Graphics g, Rectangle thumbBounds) {
        if (this.isMacScrollbarHiddenAndXcodeLikeScrollbar()) {
            return;
        }
        if (!this.macScrollbarHidden || this.alwaysPaintThumb()) {
            thumbBounds = this.getMacScrollBarBounds(thumbBounds, true);
            Graphics2D g2d = (Graphics2D)g;
            float value = ButtonlessScrollBarUI.fixAnimationValue((float)(1.0 - this.macScrollbarFadeLevel));
            this.thumbPainter.paint(g2d, thumbBounds.x - 2, thumbBounds.y - 2, thumbBounds.width + 4, thumbBounds.height + 4, (Object)Float.valueOf(value));
        }
    }

    protected boolean isDark() {
        return StartupUiUtil.isUnderDarcula();
    }

    protected boolean alwaysPaintThumb() {
        return this.alwaysShowTrack();
    }

    protected Rectangle getMacScrollBarBounds(Rectangle baseBounds, boolean thumb) {
        int height;
        int width;
        boolean vertical = this.isVertical();
        int borderSize = 2;
        int baseSize = vertical ? baseBounds.width : baseBounds.height;
        int maxSize = baseSize - (thumb ? borderSize * 2 : 0);
        int minSize = Math.min(baseSize / 2, JBUIScale.scale((int)7)) + (thumb ? 0 : borderSize * 2);
        int currentSize = minSize + (int)(this.mouseOverScrollbarExpandLevel * (double)(maxSize - minSize));
        int currentBolderSize = thumb ? borderSize : 0;
        int x = baseBounds.x;
        int y = baseBounds.y;
        if (vertical) {
            x += baseBounds.width - currentSize - currentBolderSize;
            y += currentBolderSize;
            width = currentSize;
            height = baseBounds.height - currentBolderSize * 2;
        } else {
            x += currentBolderSize;
            y += baseBounds.height - currentSize - currentBolderSize;
            width = baseBounds.width - currentBolderSize * 2;
            height = currentSize;
        }
        width = Math.max(width, currentSize);
        height = Math.max(height, currentSize);
        return new Rectangle(x, y, width, height);
    }

    @Override
    public boolean getSupportsAbsolutePositioning() {
        return true;
    }

    protected Color adjustColor(Color c) {
        if (this.isMacOverlayScrollbar()) {
            int alpha = (int)((120.0 + this.mouseOverScrollbarExpandLevel * 20.0) * (1.0 - this.macScrollbarFadeLevel));
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        }
        if (this.myThumbFadeColorShift == 0) {
            return c;
        }
        int sign = this.isDark() ? -1 : 1;
        return Gray.get((int)Math.max(0, Math.min(255, c.getRed() - sign * this.myThumbFadeColorShift)));
    }

    protected boolean isVertical() {
        return this.scrollbar.getOrientation() == 1;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return new EmptyButton();
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return new EmptyButton();
    }

    protected boolean isMacScrollbarHiddenAndXcodeLikeScrollbar() {
        return this.macScrollbarHidden && ButtonlessScrollBarUI.isMacOverlayScrollbarSupported() && ButtonlessScrollBarUI.xcodeLikeScrollbar();
    }

    protected static boolean xcodeLikeScrollbar() {
        return Registry.is((String)"editor.xcode.like.scrollbar");
    }

    public void registerRepaintCallback(ScrollbarRepaintCallback callback) {
        this.myRepaintCallback = callback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regular";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dark";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/ButtonlessScrollBarUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "jbColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initRegularThumbAnimator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "initMacScrollbarAnimators";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WeakListener
    implements AWTEventListener {
        private final WeakReference<AWTEventListener> myReference;

        private WeakListener(AWTEventListener listener2) {
            this.myReference = new WeakReference<AWTEventListener>(listener2);
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            AWTEventListener listener2 = (AWTEventListener)this.myReference.get();
            if (listener2 != null) {
                listener2.eventDispatched(event);
            } else {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            }
        }
    }

    public static interface ScrollbarRepaintCallback {
        public void call(Graphics var1);
    }

    private static final class EmptyButton
    extends JButton {
        private EmptyButton() {
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
        }

        @Override
        public Dimension getMaximumSize() {
            return JBUI.emptySize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMaximumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getMaximumSize();
        }
    }

    public static class Transparent
    extends ButtonlessScrollBarUI {
        @Override
        public boolean alwaysShowTrack() {
            return false;
        }
    }
}

