/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.DynamicBundle;
import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.ImportOldConfigsUsagesCollector;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComponentUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.system.OS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.zip.ZipFile;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportOldConfigsPanel
extends JDialog {
    private JPanel myRootPanel;
    private JRadioButton myRbImportAuto;
    private JRadioButton myRbImport;
    private TextFieldWithBrowseButton myPrevInstallation;
    private JRadioButton myRbDoNotImport;
    private JButton myOkButton;
    private ComboBox<Path> myComboBoxOldPaths;
    private final List<Path> myGuessedOldConfigDirs;
    private final Function<Path, Pair<Path, Path>> myValidator;
    private final String myProductName;
    private Path myLastSelection;
    private Pair<Path, Path> myResult;

    public ImportOldConfigsPanel(@NotNull List<Path> guessedOldConfigDirs, @NotNull Function<Path, Pair<Path, Path>> validator) {
        if (guessedOldConfigDirs == null) {
            ImportOldConfigsPanel.$$$reportNull$$$0(0);
        }
        if (validator == null) {
            ImportOldConfigsPanel.$$$reportNull$$$0(1);
        }
        super((Dialog)null, true);
        this.myLastSelection = null;
        this.$$$setupUI$$$();
        ComponentUtil.decorateWindowHeader((JRootPane)this.rootPane);
        this.myGuessedOldConfigDirs = guessedOldConfigDirs;
        this.myValidator = validator;
        this.myProductName = ApplicationNamesInfo.getInstance().getFullProductName();
        this.setTitle(BootstrapBundle.message((String)"import.settings.title", (Object[])new Object[]{this.myProductName}));
        this.init();
    }

    private void init() {
        String programFiles;
        MnemonicHelper.init((Component)this.getContentPane());
        ButtonGroup group = new ButtonGroup();
        group.add(this.myRbImportAuto);
        group.add(this.myRbImport);
        group.add(this.myRbDoNotImport);
        this.myRbDoNotImport.setSelected(true);
        if (this.myGuessedOldConfigDirs.isEmpty()) {
            this.myRbImportAuto.setVisible(false);
            this.myComboBoxOldPaths.setVisible(false);
        } else {
            this.myComboBoxOldPaths.setModel((ComboBoxModel)new CollectionComboBoxModel(this.myGuessedOldConfigDirs));
            this.myComboBoxOldPaths.setSelectedItem((Object)this.myGuessedOldConfigDirs.getFirst());
            this.myRbImportAuto.setSelected(true);
        }
        Enumeration<AbstractButton> e2 = group.getElements();
        while (e2.hasMoreElements()) {
            e2.nextElement().addChangeListener(event -> this.update());
        }
        if (OS.CURRENT == OS.macOS) {
            this.myLastSelection = Path.of("/Applications", new String[0]);
        } else if (OS.CURRENT == OS.Windows && (programFiles = System.getenv("ProgramFiles")) != null) {
            Path candidate = Path.of(programFiles, "JetBrains");
            this.myLastSelection = Files.isDirectory(candidate, new LinkOption[0]) ? candidate : Path.of(programFiles, new String[0]);
        }
        this.myPrevInstallation.setTextFieldPreferredWidth(50);
        this.myPrevInstallation.addActionListener(e -> {
            FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.singleFile().withHideIgnored(false);
            ConfigImportHelper.setSettingsFilter(chooserDescriptor);
            Ref fileRef = Ref.create();
            PathChooserDialog chooser = FileChooserFactoryImpl.createNativePathChooserIfEnabled((FileChooserDescriptor)chooserDescriptor, null, (Component)this.myRootPanel);
            if (chooser != null) {
                CoreLocalVirtualFile vf = this.myLastSelection != null ? new CoreLocalVirtualFile(new CoreLocalFileSystem(), this.myLastSelection) : null;
                chooser.choose((VirtualFile)vf, files -> fileRef.set((Object)Path.of(((VirtualFile)files.getFirst()).getPresentableUrl(), new String[0])));
            } else {
                File file;
                File directory = this.myLastSelection != null ? this.myLastSelection.getParent().toFile() : null;
                File selectedFile = this.myLastSelection != null ? this.myLastSelection.toFile() : null;
                JFileChooser fc = new JFileChooser();
                fc.setCurrentDirectory(directory);
                fc.setSelectedFile(selectedFile);
                fc.setFileSelectionMode(2);
                fc.setFileHidingEnabled(OS.CURRENT == OS.Windows || OS.CURRENT == OS.macOS);
                fc.setFileFilter(new FileNameExtensionFilter(BootstrapBundle.message((String)"import.settings.filter", (Object[])new Object[0]), "zip", "jar"));
                int returnVal = fc.showOpenDialog(this);
                if (returnVal == 0 && (file = fc.getSelectedFile()) != null) {
                    fileRef.set((Object)file.toPath());
                    this.myPrevInstallation.setText(file.getAbsolutePath());
                }
            }
            if (!fileRef.isNull()) {
                this.myLastSelection = (Path)fileRef.get();
                this.myPrevInstallation.setText(((Path)fileRef.get()).toString());
            }
        });
        this.myOkButton.addActionListener(e -> this.close());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.myRootPanel);
        this.getRootPane().setDefaultButton(this.myOkButton);
        this.update();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setMinimumSize(this.getSize());
    }

    private void update() {
        this.myComboBoxOldPaths.setEnabled(this.myRbImportAuto.isSelected());
        this.myPrevInstallation.setEnabled(this.myRbImport.isSelected());
    }

    private void close() {
        if (this.myRbImport.isSelected()) {
            String text = this.myPrevInstallation.getText().trim();
            if (text.isEmpty()) {
                this.showError(BootstrapBundle.message((String)"import.chooser.error.empty", (Object[])new Object[]{this.myProductName}));
                return;
            }
            Path selectedDir = Path.of(text, new String[0]).toAbsolutePath().normalize();
            if (Files.isRegularFile(selectedDir, new LinkOption[0])) {
                if (!ImportOldConfigsPanel.isValidSettingsFile(selectedDir)) {
                    this.showError(BootstrapBundle.message((String)"import.chooser.error.invalid", (Object[])new Object[]{selectedDir}));
                    return;
                }
                this.myResult = new Pair((Object)selectedDir, null);
            } else {
                if (selectedDir.equals(PathManager.getHomeDir()) || selectedDir.equals(PathManager.getConfigDir())) {
                    this.showError(BootstrapBundle.message((String)"import.chooser.error.current", (Object[])new Object[]{this.myProductName}));
                    return;
                }
                Pair<Path, Path> result = this.myValidator.apply(selectedDir);
                if (result == null) {
                    this.showError(BootstrapBundle.message((String)"import.chooser.error.unrecognized", (Object[])new Object[]{selectedDir, this.myProductName}));
                    return;
                }
                this.myResult = result;
            }
        }
        this.dispose();
    }

    private void showError(@NlsContexts.DialogMessage String message) {
        String title = BootstrapBundle.message((String)"import.chooser.error.title", (Object[])new Object[0]);
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    private static boolean isValidSettingsFile(Path file) {
        boolean bl;
        ZipFile zip = new ZipFile(file.toFile());
        try {
            bl = zip.getEntry("IntelliJ IDEA Global Settings") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored) {
                return false;
            }
        }
        zip.close();
        return bl;
    }

    @Nullable
    public Pair<Path, Path> getSelectedFile() {
        ImportOldConfigsUsagesCollector.INSTANCE.saveImportOldConfigType(this.myRbImportAuto, this.myRbImport, this.myRbDoNotImport, this.myResult != null);
        if (this.myRbImportAuto.isSelected()) {
            return new Pair((Object)this.myGuessedOldConfigDirs.get(Math.max(this.myComboBoxOldPaths.getSelectedIndex(), 0)), null);
        }
        if (this.myRbImport.isSelected()) {
            return this.myResult;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "guessedOldConfigDirs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "validator";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/ImportOldConfigsPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        ComboBox comboBox;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRbImportAuto = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/BootstrapBundle", ImportOldConfigsPanel.class).getString("import.chooser.rb.previous"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRbImport = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/BootstrapBundle", ImportOldConfigsPanel.class).getString("import.chooser.rb.choose"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myPrevInstallation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 0, 1, 3, 0, 1, 3, 0, null, null, null, 2));
        this.myRbDoNotImport = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/BootstrapBundle", ImportOldConfigsPanel.class).getString("import.chooser.rb.skip"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myComboBoxOldPaths = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myOkButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/BootstrapBundle", ImportOldConfigsPanel.class).getString("import.chooser.ok"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, new Dimension(80, -1), null, null, 5));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

