/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.BootstrapBundle;
import com.intellij.ide.ConfigImportOptions;
import com.intellij.ide.ConfigImportSettings;
import com.intellij.ide.ImportOldConfigsPanel;
import com.intellij.ide.ImportOldConfigsUsagesCollector;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.plugins.BrokenPluginFileKt;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginDescriptorLoadingResult;
import com.intellij.ide.plugins.PluginInitializationContext;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginMainDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.ProductPluginInitContext;
import com.intellij.ide.plugins.marketplace.MarketplaceRequests;
import com.intellij.ide.plugins.newui.PluginUiModel;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.ide.ui.laf.LookAndFeelThemeAdapterKt;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigBackup;
import com.intellij.openapi.application.ConfigImportProgressDialog;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PluginMigrationOptions;
import com.intellij.openapi.application.RestoreDefaultConfigCustomizer;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.migrations.BigDataToolsMigration253;
import com.intellij.openapi.application.migrations.Localization242;
import com.intellij.openapi.application.migrations.NotebooksMigration242;
import com.intellij.openapi.application.migrations.SpaceMigration252;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.impl.P3SupportKt;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.platform.ide.bootstrap.SplashManagerKt;
import com.intellij.platform.ide.bootstrap.StartupErrorReporter;
import com.intellij.ui.AppUIUtilKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Restarter;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.system.OS;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.IoErrorText;
import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class ConfigImportHelper {
    public static final String IMPORT_FROM_ENV_VAR = "JB_IMPORT_SETTINGS_FROM";
    public static final Pattern SELECTOR_PATTERN = Pattern.compile("\\.?(\\D+)(\\d+(?:\\.\\d+)*)");
    public static final String CONFIG_IMPORTED_FROM_PATH = "intellij.config.imported.from";
    private static final String SHOW_IMPORT_CONFIG_DIALOG_PROPERTY = "idea.initially.ask.config";
    private static final String UPDATE_ONLY_INCOMPATIBLE_PLUGINS_PROPERTY = "idea.config.import.update.incompatible.plugins.only";
    private static final String CONFIG = "config";
    private static final String BIN = "bin";
    private static final String CONTENTS = "Contents";
    private static final String PLIST = "Info.plist";
    private static final String PLUGINS = "plugins";
    private static final String SYSTEM = "system";
    private static final Set<String> SESSION_FILES = Set.of(".lock", "port.lock", "token", "user.web.token", "migrate.config");
    private static final String[] OPTIONS = new String[]{"options/other.xml", "options/ide.general.xml", "options/options.xml"};
    private static final long PLUGIN_UPDATES_TIMEOUT_MS = 7000L;
    private static final long BROKEN_PLUGINS_TIMEOUT_MS = 3000L;
    @VisibleForTesting
    @Nullable
    public static @Nullable Function<Path, @Nullable Map<PluginId, Set<String>>> testBrokenPluginsFetcherStub = null;
    @VisibleForTesting
    @Nullable
    public static @Nullable Function<Set<PluginId>, @Nullable Map<PluginId, PluginNode>> testLastCompatiblePluginUpdatesFetcher = null;

    private ConfigImportHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void importConfigsTo(boolean veryFirstStartOnThisComputer, @NotNull Path newConfigDir, @NotNull List<String> args, @NotNull Logger log) {
        boolean vmOptionFileChanged;
        ConfigImportSettings importSettings;
        block52: {
            if (newConfigDir == null) {
                ConfigImportHelper.$$$reportNull$$$0(0);
            }
            if (args == null) {
                ConfigImportHelper.$$$reportNull$$$0(1);
            }
            if (log == null) {
                ConfigImportHelper.$$$reportNull$$$0(2);
            }
            log.info("Importing configs to '" + String.valueOf(newConfigDir) + "'; veryFirstStart=" + veryFirstStartOnThisComputer);
            System.setProperty("intellij.first.ide.session", Boolean.TRUE.toString());
            CustomConfigMigrationOption migrationOption = CustomConfigMigrationOption.readCustomConfigMigrationOptionAndRemoveMarkerFile((Path)newConfigDir);
            log.info("Custom migration option: " + String.valueOf(migrationOption));
            importSettings = ConfigImportHelper.findCustomConfigImportSettings();
            log.info("Custom import settings: " + String.valueOf(importSettings));
            if (migrationOption instanceof CustomConfigMigrationOption.SetProperties) {
                CustomConfigMigrationOption.SetProperties sp = (CustomConfigMigrationOption.SetProperties)migrationOption;
                List properties = sp.getProperties();
                log.info("Enabling system properties after restart: " + String.valueOf(properties));
                Iterator iterator = properties.iterator();
                while (iterator.hasNext()) {
                    String property = (String)iterator.next();
                    System.setProperty(property, Boolean.TRUE.toString());
                }
                return;
            }
            if (migrationOption instanceof CustomConfigMigrationOption.MigratePluginsFromCustomPlace) {
                CustomConfigMigrationOption.MigratePluginsFromCustomPlace migratePluginsOption = (CustomConfigMigrationOption.MigratePluginsFromCustomPlace)migrationOption;
                Path oldConfigDir = migratePluginsOption.getConfigLocation();
                if (!ConfigImportHelper.isConfigDirectory(oldConfigDir)) {
                    ConfigImportHelper.logRejectedConfigDirectory(log, "Custom plugins location", oldConfigDir);
                    return;
                }
                Path oldPluginsDir = ConfigImportHelper.computeOldPluginsDir(oldConfigDir, null);
                Path newPluginsDir = newConfigDir.getFileSystem().getPath(PathManager.getPluginsDir().toString(), new String[0]);
                ConfigImportOptions importOptions = ConfigImportHelper.createConfigImportOptions(importSettings, migrationOption, log);
                try {
                    ConfigImportHelper.migratePlugins(oldPluginsDir, oldConfigDir, newPluginsDir, newConfigDir, importOptions, Predicates.alwaysFalse());
                    return;
                }
                catch (IOException e) {
                    log.warn((Throwable)e);
                    return;
                }
            }
            Path tempBackup = null;
            vmOptionFileChanged = false;
            try {
                Path oldConfigDir;
                ImportOldConfigsUsagesCollector.InitialImportScenario importScenarioStatistics;
                List<String> currentlyDisabledPlugins;
                List<String> vmOptionsLines;
                Pair<Path, Path> oldConfigDirAndOldIdePath;
                block51: {
                    oldConfigDirAndOldIdePath = null;
                    vmOptionsLines = null;
                    currentlyDisabledPlugins = null;
                    importScenarioStatistics = null;
                    boolean wizardEnabled = InitialConfigImportState.isStartupWizardEnabled();
                    if (migrationOption instanceof CustomConfigMigrationOption.MigrateFromCustomPlace || migrationOption instanceof CustomConfigMigrationOption.StartWithCleanConfig) {
                        vmOptionFileChanged = ConfigImportHelper.doesVmOptionsFileExist(newConfigDir);
                        try {
                            if (migrationOption instanceof CustomConfigMigrationOption.MigrateFromCustomPlace) {
                                CustomConfigMigrationOption.MigrateFromCustomPlace mcp = (CustomConfigMigrationOption.MigrateFromCustomPlace)migrationOption;
                                oldConfigDirAndOldIdePath = ConfigImportHelper.findConfigDirectoryByPath(mcp.getLocation());
                                if (oldConfigDirAndOldIdePath == null) {
                                    ConfigImportHelper.logRejectedConfigDirectory(log, "Custom location", mcp.getLocation());
                                } else {
                                    String disabledPluginsFileName;
                                    if (ConfigImportHelper.doesVmOptionsFileExist(newConfigDir) && !ConfigImportHelper.vmOptionsRequiresMerge((Path)oldConfigDirAndOldIdePath.first, newConfigDir, log)) {
                                        vmOptionsLines = Files.readAllLines(newConfigDir.resolve(VMOptions.getFileName()), VMOptions.getFileCharset());
                                        vmOptionFileChanged = false;
                                    }
                                    if (Files.isRegularFile(newConfigDir.resolve(disabledPluginsFileName = P3SupportKt.processPerProjectSupport().getDisabledPluginsFileName()), new LinkOption[0])) {
                                        currentlyDisabledPlugins = Files.readAllLines(newConfigDir.resolve(disabledPluginsFileName));
                                    } else if (!"disabled_plugins.txt".equals(disabledPluginsFileName) && Files.isRegularFile(newConfigDir.resolve("disabled_plugins.txt"), new LinkOption[0])) {
                                        currentlyDisabledPlugins = Files.readAllLines(newConfigDir.resolve("disabled_plugins.txt"));
                                    }
                                }
                                tempBackup = ConfigImportHelper.backupAndDeleteCurrentConfig(newConfigDir, log, importSettings);
                                importScenarioStatistics = ImportOldConfigsUsagesCollector.InitialImportScenario.IMPORT_SETTINGS_ACTION;
                                break block51;
                            }
                            tempBackup = ConfigImportHelper.backupAndDeleteCurrentConfig(newConfigDir, log, importSettings);
                            importScenarioStatistics = ImportOldConfigsUsagesCollector.InitialImportScenario.RESTORE_DEFAULT_ACTION;
                        }
                        catch (IOException e) {
                            log.error("Couldn't backup current config or delete current config directory", (Throwable)e);
                        }
                    } else if (wizardEnabled && (System.getProperty("idea.config.path") != null || PluginManagerCore.isRunningFromSources())) {
                        log.info("skipping import because of non-standard config directory");
                    } else {
                        ConfigDirsSearchResult candidateDirectories = ConfigImportHelper.findInheritedDirectory(newConfigDir, System.getenv(IMPORT_FROM_ENV_VAR), importSettings, args, log);
                        if (candidateDirectories == null) {
                            candidateDirectories = ConfigImportHelper.findConfigDirectories(newConfigDir, importSettings, args);
                            log.info("candidates: " + String.valueOf(candidateDirectories.directories));
                        }
                        Pair<Path, FileTime> bestCandidate = candidateDirectories.directories.isEmpty() ? null : candidateDirectories.directories.getFirst();
                        String showImportDialog = System.getProperty(SHOW_IMPORT_CONFIG_DIALOG_PROPERTY);
                        if (Boolean.parseBoolean(showImportDialog) && !wizardEnabled) {
                            log.info("import dialog requested explicitly");
                            oldConfigDirAndOldIdePath = ConfigImportHelper.showDialogAndGetOldConfigPath(candidateDirectories.getPaths());
                            importScenarioStatistics = ImportOldConfigsUsagesCollector.InitialImportScenario.SHOW_DIALOG_REQUESTED_BY_PROPERTY;
                        } else if (bestCandidate != null && !ConfigImportHelper.isConfigOld((FileTime)bestCandidate.second)) {
                            oldConfigDirAndOldIdePath = new Pair<Path, Path>((Object)((Path)bestCandidate.first), null);
                            log.info("auto-import");
                        } else {
                            log.info("no suitable configs found");
                            if (!(veryFirstStartOnThisComputer || wizardEnabled || "never".equals(showImportDialog) || AppMode.isRemoteDevHost())) {
                                oldConfigDirAndOldIdePath = ConfigImportHelper.showDialogAndGetOldConfigPath(candidateDirectories.getPaths());
                                importScenarioStatistics = ImportOldConfigsUsagesCollector.InitialImportScenario.SHOW_DIALOG_NO_CONFIGS_FOUND;
                            }
                        }
                    }
                }
                if (oldConfigDirAndOldIdePath != null) {
                    oldConfigDir = (Path)oldConfigDirAndOldIdePath.first;
                    Path oldIdeHome = (Path)oldConfigDirAndOldIdePath.second;
                    ConfigImportOptions configImportOptions = ConfigImportHelper.createConfigImportOptions(importSettings, migrationOption, log);
                    if (importScenarioStatistics == null) {
                        importScenarioStatistics = ImportOldConfigsUsagesCollector.InitialImportScenario.IMPORTED_FROM_PREVIOUS_VERSION;
                    }
                    System.setProperty(CONFIG_IMPORTED_FROM_PATH, oldConfigDir.toString());
                    ConfigImportHelper.doImport(oldConfigDir, newConfigDir, oldIdeHome, log, configImportOptions);
                    System.setProperty("intellij.config.imported.in.current.session", Boolean.TRUE.toString());
                    if (currentlyDisabledPlugins != null) {
                        try {
                            Path newDisablePluginsFile = newConfigDir.resolve(P3SupportKt.processPerProjectSupport().getDisabledPluginsFileName());
                            LinkedHashSet<String> newDisabledPlugins = new LinkedHashSet<String>();
                            if (Files.isRegularFile(newDisablePluginsFile, new LinkOption[0])) {
                                newDisabledPlugins.addAll(Files.readAllLines(newDisablePluginsFile, CharsetToolkit.getPlatformCharset()));
                            }
                            newDisabledPlugins.addAll(currentlyDisabledPlugins);
                            Files.write(newDisablePluginsFile, newDisabledPlugins, CharsetToolkit.getPlatformCharset(), new OpenOption[0]);
                            log.info("Disabled plugins file updated with " + newDisabledPlugins.size() + " plugins");
                        }
                        catch (IOException e) {
                            log.warn("Couldn't write disabled plugins file", (Throwable)e);
                        }
                    }
                } else {
                    log.info("No configs imported, starting with clean configs at " + String.valueOf(newConfigDir));
                    if (importScenarioStatistics == null) {
                        importScenarioStatistics = ImportOldConfigsUsagesCollector.InitialImportScenario.CLEAN_CONFIGS;
                    }
                }
                if (importSettings != null) {
                    oldConfigDir = oldConfigDirAndOldIdePath != null ? (Path)oldConfigDirAndOldIdePath.first : null;
                    importSettings.importFinished(newConfigDir, oldConfigDir);
                }
                ImportOldConfigsUsagesCollector.INSTANCE.reportImportScenario(importScenarioStatistics);
                if (vmOptionsLines != null) {
                    Path vmOptionsFile = newConfigDir.resolve(VMOptions.getFileName());
                    try {
                        Files.write(vmOptionsFile, vmOptionsLines, VMOptions.getFileCharset(), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    vmOptionFileChanged |= ConfigImportHelper.doesVmOptionsFileExist(newConfigDir);
                }
                if (tempBackup == null) break block52;
            }
            catch (Throwable throwable) {
                if (tempBackup == null) throw throwable;
                try {
                    new ConfigBackup(newConfigDir).moveToBackup(tempBackup);
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn(String.format("Couldn't move the backup of current config from temp dir [%s] to backup dir", tempBackup), (Throwable)e);
                }
                throw throwable;
            }
            try {
                new ConfigBackup(newConfigDir).moveToBackup(tempBackup);
            }
            catch (IOException e) {
                log.warn(String.format("Couldn't move the backup of current config from temp dir [%s] to backup dir", tempBackup), (Throwable)e);
            }
        }
        if (!vmOptionFileChanged) return;
        if (AppMode.isRemoteDevHost()) {
            log.warn("The vmoptions file has changed, but the backend process wasn't restarted; custom vmoptions will be used on the next run only");
            return;
        }
        if (importSettings != null && !importSettings.shouldRestartAfterVmOptionsChange()) {
            log.info("The vmoptions file has changed, but restart is switched off by " + String.valueOf(importSettings));
            return;
        }
        log.info("The vmoptions file has changed, restarting...");
        try {
            InitialConfigImportState.writeOptionsForRestart((Path)newConfigDir);
        }
        catch (IOException e) {
            log.error("cannot write config migration marker file to " + String.valueOf(newConfigDir), (Throwable)e);
        }
        ConfigImportHelper.restart(args);
    }

    private static ConfigImportOptions createConfigImportOptions(@Nullable ConfigImportSettings settings, @Nullable CustomConfigMigrationOption customMigrationOption, Logger log) {
        ConfigImportOptions configImportOptions = new ConfigImportOptions(log);
        configImportOptions.importSettings = settings;
        configImportOptions.mergeVmOptions = customMigrationOption instanceof CustomConfigMigrationOption.MergeConfigs;
        configImportOptions.headless = AppMode.isRemoteDevHost();
        return configImportOptions;
    }

    private static void logRejectedConfigDirectory(Logger log, String description, Path path) {
        StringBuilder builder = new StringBuilder().append(description).append(" was detected but not accepted: ").append(path).append(". Content:\n");
        if (Files.isDirectory(path, new LinkOption[0])) {
            for (Path child : NioFiles.list((Path)path)) {
                builder.append(" ").append(child.getFileName()).append("\n");
                for (Path grandChild : NioFiles.list((Path)child)) {
                    builder.append(" |- ").append(grandChild.getFileName()).append("\n");
                }
            }
        } else {
            builder.append("not a directory");
        }
        log.info(builder.toString());
    }

    @Nullable
    public static ConfigImportSettings findCustomConfigImportSettings() {
        block4: {
            try {
                String customProviderName = "com.intellij.openapi.application." + PlatformUtils.getPlatformPrefix() + "ConfigImportSettings";
                Class<?> customProviderClass = Class.forName(customProviderName);
                if (!ConfigImportSettings.class.isAssignableFrom(customProviderClass)) break block4;
                Constructor<?> constructor = customProviderClass.getDeclaredConstructor(new Class[0]);
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return (ConfigImportSettings)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isConfigOld(FileTime time) {
        return ChronoUnit.DAYS.between(time.toInstant(), Instant.now()) >= 180L;
    }

    private static boolean doesVmOptionsFileExist(Path configDir) {
        return Files.isRegularFile(configDir.resolve(VMOptions.getFileName()), new LinkOption[0]);
    }

    private static void restart(List<String> args) {
        if (Restarter.isSupported()) {
            try {
                Restarter.setMainAppArgs(args);
                Restarter.scheduleRestart((boolean)false, (List[])new List[0]);
            }
            catch (IOException e) {
                StartupErrorReporter.showError((String)BootstrapBundle.message((String)"restart.failed.title", (Object[])new Object[0]), (Throwable)e);
            }
            System.exit(0);
        } else {
            String title = BootstrapBundle.message((String)"import.settings.title", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
            String message = BootstrapBundle.message((String)"import.settings.restart", (Object[])new Object[0]);
            String yes = BootstrapBundle.message((String)"import.settings.restart.now", (Object[])new Object[0]);
            String no = BootstrapBundle.message((String)"import.settings.restart.later", (Object[])new Object[0]);
            LookAndFeelThemeAdapterKt.setEarlyUiLaF();
            if (Messages.showYesNoDialog((String)message, (String)title, (String)yes, (String)no, (Icon)Messages.getQuestionIcon()) == 0) {
                System.exit(0);
            }
        }
    }

    private static Path backupAndDeleteCurrentConfig(Path currentConfig, Logger log, @Nullable ConfigImportSettings settings) throws IOException {
        Path tempDir = Files.createDirectories(currentConfig.getFileSystem().getPath(System.getProperty("java.io.tmpdir"), new String[0]), new FileAttribute[0]);
        Path tempBackupDir = Files.createTempDirectory(tempDir, String.valueOf(currentConfig.getFileName()) + "-backup-" + String.valueOf(UUID.randomUUID()), new FileAttribute[0]);
        log.info("Backup config from " + String.valueOf(currentConfig) + " to " + String.valueOf(tempBackupDir));
        NioFiles.copyRecursively((Path)currentConfig, (Path)tempBackupDir, file -> !ConfigImportHelper.shouldSkipFileDuringImport(file, settings));
        ConfigImportHelper.deleteCurrentConfigDir(currentConfig, log);
        Path pluginDir = currentConfig.getFileSystem().getPath(PathManager.getPluginsDir().toString(), new String[0]);
        if (Files.exists(pluginDir, new LinkOption[0]) && !pluginDir.startsWith(currentConfig)) {
            Path pluginBackup = tempBackupDir.resolve(PLUGINS);
            log.info("Backup plugins dir separately from " + String.valueOf(pluginDir) + " to " + String.valueOf(pluginBackup));
            NioFiles.createDirectories((Path)pluginBackup);
            NioFiles.copyRecursively((Path)pluginDir, (Path)pluginBackup);
            NioFiles.deleteRecursively((Path)pluginDir);
        }
        return tempBackupDir;
    }

    private static void deleteCurrentConfigDir(Path currentConfig, Logger log) throws IOException {
        log.debug("Removing current config directory");
        boolean removedViaCustomizer = false;
        try {
            Iterator<RestoreDefaultConfigCustomizer> iterator = ServiceLoader.load(RestoreDefaultConfigCustomizer.class).iterator();
            if (iterator.hasNext()) {
                RestoreDefaultConfigCustomizer customizer = iterator.next();
                log.debug("Found " + String.valueOf(customizer));
                customizer.removeCurrentConfigDir(currentConfig);
                removedViaCustomizer = true;
            }
        }
        catch (Exception e) {
            log.warn("Couldn't remove current config dir using the customizer", (Throwable)e);
        }
        if (!removedViaCustomizer) {
            log.debug("RestoreDefaultConfigCustomizer not found, removing config directory manually...");
            NioFiles.deleteRecursively((Path)currentConfig);
        }
    }

    @Nullable
    private static Pair<Path, Path> showDialogAndGetOldConfigPath(List<Path> guessedOldConfigDirs) {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode()) {
            throw new UnsupportedOperationException("Unit test mode");
        }
        LookAndFeelThemeAdapterKt.setEarlyUiLaF();
        ImportOldConfigsPanel dialog = new ImportOldConfigsPanel(guessedOldConfigDirs, ConfigImportHelper::findConfigDirectoryByPath);
        dialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        AppUIUtilKt.updateAppWindowIcon((Window)dialog);
        SplashManagerKt.hideSplash();
        dialog.setVisible(true);
        Pair<Path, Path> result = dialog.getSelectedFile();
        dialog.dispose();
        return result;
    }

    public static void setSettingsFilter(@NotNull FileChooserDescriptor descriptor) {
        if (descriptor == null) {
            ConfigImportHelper.$$$reportNull$$$0(3);
        }
        descriptor.withFileFilter(file -> FileTypeRegistry.getInstance().isFileOfType(file, (FileType)ArchiveFileType.INSTANCE)).withExtensionFilter(BootstrapBundle.message((String)"import.settings.filter", (Object[])new Object[0]), new String[]{"zip", "jar"});
    }

    public static boolean isConfigDirectory(@NotNull Path candidate) {
        if (candidate == null) {
            ConfigImportHelper.$$$reportNull$$$0(4);
        }
        for (String t : OPTIONS) {
            if (!Files.exists(candidate.resolve(t), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static FileTime getConfigLastModifiedTime(@NotNull Path configDir) {
        if (configDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(5);
        }
        FileTime max = null;
        for (String name : OPTIONS) {
            try {
                FileTime cur = Files.getLastModifiedTime(configDir.resolve(name), new LinkOption[0]);
                if (max != null && cur.compareTo(max) <= 0) continue;
                max = cur;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return max;
    }

    @Nullable
    public static ConfigDirsSearchResult findInheritedDirectory(@NotNull Path newConfigDir, @Nullable String inheritedPath, @Nullable ConfigImportSettings settings, @NotNull List<String> args, @NotNull Logger log) {
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(6);
        }
        if (args == null) {
            ConfigImportHelper.$$$reportNull$$$0(7);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(8);
        }
        log.info("JB_IMPORT_SETTINGS_FROM=" + inheritedPath);
        if (inheritedPath != null) {
            try {
                Path configDir = newConfigDir.getFileSystem().getPath(inheritedPath, new String[0]).toAbsolutePath().normalize();
                if (configDir.equals(newConfigDir)) {
                    log.warn("  ... points to the current settings directory");
                } else if (!Files.isDirectory(configDir, new LinkOption[0])) {
                    log.warn("  ... points to a non-existing directory");
                } else {
                    if (settings == null || settings.shouldBeSeenAsImportCandidate(configDir, ConfigImportHelper.getPrefixFromSelector(ConfigImportHelper.getNameWithVersion(configDir)), settings.getProductsToImportFrom(args))) {
                        Pair pair = new Pair((Object)configDir, (Object)FileTime.from(Instant.now()));
                        return new ConfigDirsSearchResult(List.of(pair));
                    }
                    log.info("  ... rejected by " + String.valueOf(settings));
                }
            }
            catch (Exception e) {
                log.warn("  ... is not a valid path", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    public static ConfigDirsSearchResult findConfigDirectories(@NotNull Path newConfigDir, @Nullable ConfigImportSettings settings, @NotNull List<String> args) {
        ArrayList<Path> candidates;
        String productName;
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(9);
        }
        if (args == null) {
            ConfigImportHelper.$$$reportNull$$$0(10);
        }
        List<Object> otherEditionPrefixes = settings != null ? settings.getEditionsToImportFrom() : List.of();
        List<String> otherProductPrefixes = settings != null ? settings.getProductsToImportFrom(args) : List.of();
        HashSet<Path> homes = new HashSet<Path>();
        homes.add(newConfigDir.getParent());
        homes.add(newConfigDir.getFileSystem().getPath(PathManager.getDefaultConfigPathFor((String)"X"), new String[0]).getParent());
        Path historic = newConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultConfigPath("X2019.3"), new String[0]);
        Path historicHome = OS.CURRENT == OS.macOS ? historic.getParent() : historic.getParent().getParent();
        homes.add(historicHome);
        String prefix = ConfigImportHelper.getPrefixFromSelector(PathManager.getPathsSelector());
        if (prefix == null) {
            prefix = ConfigImportHelper.getPrefixFromSelector(ConfigImportHelper.getNameWithVersion(newConfigDir));
        }
        if (prefix == null && (productName = ApplicationNamesInfo.getInstance().getFullProductName()) != null) {
            prefix = productName.replace(" ", "");
        }
        if (prefix == null) {
            prefix = PlatformUtils.getPlatformPrefix();
        }
        ArrayList<Path> exactCandidates = new ArrayList<Path>();
        ArrayList<Path> otherProductCandidates = new ArrayList<Path>();
        for (Path home : homes) {
            if (home == null || !Files.isDirectory(home, new LinkOption[0])) continue;
            boolean dotted = OS.CURRENT != OS.macOS && home == historicHome;
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(home);
                try {
                    for (Path path : stream) {
                        if (path.equals(newConfigDir) || !Files.isDirectory(path, new LinkOption[0])) continue;
                        String name = path.getFileName().toString();
                        String pathPrefix = ConfigImportHelper.getPrefixFromSelector(ConfigImportHelper.getNameWithVersion(path));
                        if (ConfigImportHelper.nameMatchesPrefixStrictly(name, prefix, dotted)) {
                            if (settings != null && !settings.shouldBeSeenAsImportCandidate(path, pathPrefix, otherProductPrefixes)) continue;
                            exactCandidates.add(path);
                            continue;
                        }
                        if (ContainerUtil.exists(otherEditionPrefixes, other -> ConfigImportHelper.nameMatchesPrefixStrictly(name, other, dotted))) {
                            if (settings != null && !settings.shouldBeSeenAsImportCandidate(path, pathPrefix, otherProductPrefixes)) continue;
                            exactCandidates.add(path);
                            continue;
                        }
                        if (!ContainerUtil.exists(otherProductPrefixes, other -> ConfigImportHelper.nameMatchesPrefixStrictly(name, other, dotted)) || settings != null && !settings.shouldBeSeenAsImportCandidate(path, pathPrefix, otherProductPrefixes)) continue;
                        otherProductCandidates.add(path);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException stream) {}
        }
        if (!exactCandidates.isEmpty()) {
            candidates = exactCandidates;
        } else if (!otherProductCandidates.isEmpty()) {
            candidates = otherProductCandidates;
        } else {
            return new ConfigDirsSearchResult(List.of());
        }
        ArrayList<Pair> candidatesSorted = new ArrayList<Pair>();
        for (Path child : candidates) {
            Path config = child.resolve(CONFIG);
            Path candidate = Files.isDirectory(config, new LinkOption[0]) ? config : child;
            FileTime max = ConfigImportHelper.getConfigLastModifiedTime(candidate);
            candidatesSorted.add(new Pair((Object)candidate, (Object)(max != null ? max : FileTime.fromMillis(0L))));
        }
        candidatesSorted.sort((o1, o2) -> {
            int diff = ((FileTime)o2.second).compareTo((FileTime)o1.second);
            if (diff == 0) {
                diff = NaturalComparator.INSTANCE.compare(((Path)o2.first).toString(), ((Path)o1.first).toString());
            }
            return diff;
        });
        return new ConfigDirsSearchResult(candidatesSorted);
    }

    private static boolean nameMatchesPrefixStrictly(String name, String prefix, boolean dotted) {
        Object strictPrefix = dotted ? "." + prefix : prefix;
        return StringUtil.startsWithIgnoreCase((String)name, (String)strictPrefix) && name.length() > ((String)strictPrefix).length() && Character.isDigit(name.charAt(((String)strictPrefix).length()));
    }

    private static String getNameWithVersion(Path configDir) {
        String name = configDir.getFileName().toString();
        if (CONFIG.equals(name)) {
            name = Strings.trimStart((String)configDir.getParent().getFileName().toString(), (String)".");
        }
        return name;
    }

    @Nullable
    private static String parseVersionFromConfig(Path configDir) {
        String nameWithVersion = ConfigImportHelper.getNameWithVersion(configDir);
        Matcher m = ConfigImportHelper.matchNameWithVersion(nameWithVersion);
        return m.matches() ? m.group(1) : null;
    }

    @Nullable
    private static String getPrefixFromSelector(@Nullable String nameWithSelector) {
        Matcher m;
        if (nameWithSelector != null && (m = SELECTOR_PATTERN.matcher(nameWithSelector)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    public static @Nullable Pair<@NotNull Path, @Nullable Path> findConfigDirectoryByPath(Path selectedDir) {
        Path configDir;
        if (ConfigImportHelper.isConfigDirectory(selectedDir)) {
            return new Pair((Object)selectedDir, null);
        }
        Path config = selectedDir.resolve(CONFIG);
        if (ConfigImportHelper.isConfigDirectory(config)) {
            return new Pair((Object)config, null);
        }
        if (Files.isDirectory(selectedDir.resolve(OS.CURRENT == OS.macOS ? CONTENTS : BIN), new LinkOption[0]) && (configDir = ConfigImportHelper.getSettingsPath(selectedDir, "idea.config.path", ConfigImportHelper::defaultConfigPath)) != null && ConfigImportHelper.isConfigDirectory(configDir)) {
            return new Pair((Object)configDir, (Object)selectedDir);
        }
        return null;
    }

    @Nullable
    private static Path getSettingsPath(Path ideHome, String propertyName, Function<String, String> pathBySelector) {
        Path candidate;
        ArrayList<Path> files = new ArrayList<Path>();
        if (OS.CURRENT == OS.macOS) {
            files.add(ideHome.resolve("Contents/bin/idea.properties"));
            files.add(ideHome.resolve("Contents/Info.plist"));
        } else {
            files.add(ideHome.resolve("bin/idea.properties"));
            String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
            files.add(ideHome.resolve("bin/" + scriptName + ".bat"));
            files.add(ideHome.resolve("bin/" + scriptName + ".sh"));
        }
        for (Path file : files) {
            String candidatePath;
            if (!Files.isRegularFile(file, new LinkOption[0]) || (candidatePath = PathManager.substituteVars((String)ConfigImportHelper.getPropertyFromFile(file, propertyName), (String)ideHome.toString())) == null || !Files.isDirectory(candidate = ideHome.getFileSystem().getPath(candidatePath, new String[0]), new LinkOption[0])) continue;
            return candidate.toAbsolutePath();
        }
        for (Path file : files) {
            String selector;
            if (!Files.isRegularFile(file, new LinkOption[0]) || (selector = ConfigImportHelper.getPropertyFromFile(file, "idea.paths.selector")) == null || !Files.isDirectory(candidate = ideHome.getFileSystem().getPath(pathBySelector.apply(selector), new String[0]), new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static String getPropertyFromFile(Path file, String propertyName) {
        try {
            String propertyValue;
            String fileContent = Files.readString(file);
            String fileName = file.getFileName().toString();
            if (fileName.endsWith(".properties")) {
                PropertyResourceBundle bundle = new PropertyResourceBundle(new StringReader(fileContent));
                return bundle.containsKey(propertyName) ? bundle.getString(propertyName) : null;
            }
            if (fileName.endsWith(".plist") && !Strings.isEmpty((String)(propertyValue = ConfigImportHelper.findPListKey(propertyName, fileContent)))) {
                return propertyValue;
            }
            propertyValue = ConfigImportHelper.findProperty(propertyName, fileContent);
            if (!Strings.isEmpty((String)propertyValue)) {
                return propertyValue;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String findPListKey(String propertyName, String fileContent) {
        String key = "<key>" + propertyName + "</key>";
        int idx = fileContent.indexOf(key);
        if (idx > 0 && (idx = fileContent.indexOf("<string>", idx + key.length())) != -1) {
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)));
        }
        return null;
    }

    @Nullable
    private static String findProperty(String propertyName, String fileContent) {
        String prefix = propertyName + "=";
        int idx = fileContent.indexOf(prefix);
        if (idx >= 0) {
            StringBuilder configDir = new StringBuilder();
            if (fileContent.length() > (idx += prefix.length())) {
                boolean quoted;
                boolean bl = quoted = fileContent.charAt(idx) == '\"';
                if (quoted) {
                    ++idx;
                }
                while (fileContent.length() > idx && (quoted ? fileContent.charAt(idx) != '\"' : fileContent.charAt(idx) != ' ' && fileContent.charAt(idx) != '\t') && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir.append(fileContent.charAt(idx));
                    ++idx;
                }
            }
            if (!configDir.isEmpty()) {
                return Path.of(ConfigImportHelper.fixDirName(configDir.toString()), new String[0]).toString();
            }
        }
        return null;
    }

    private static String fixDirName(String dir) {
        return OSAgnosticPathUtil.expandUserHome((String)StringUtil.unquoteString((String)dir, (char)'\"'));
    }

    @VisibleForTesting
    public static void doImport(@NotNull Path oldConfigDir, @NotNull Path newConfigDir, @Nullable Path oldIdeHome, @NotNull Logger log, @NotNull ConfigImportOptions importOptions) {
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(11);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(12);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(13);
        }
        if (importOptions == null) {
            ConfigImportHelper.$$$reportNull$$$0(14);
        }
        if (oldConfigDir.equals(newConfigDir)) {
            log.info("New config directory is the same as the old one, no import needed.");
            return;
        }
        Path oldPluginsDir = ConfigImportHelper.computeOldPluginsDir(oldConfigDir, oldIdeHome);
        Path newPluginsDir = newConfigDir.getFileSystem().getPath(PathManager.getPluginsDir().toString(), new String[0]);
        try {
            log.info(String.format("Importing configs: oldConfigDir=[%s], newConfigDir=[%s], oldIdeHome=[%s], oldPluginsDir=[%s], newPluginsDir=[%s]", oldConfigDir, newConfigDir, oldIdeHome, oldPluginsDir, newPluginsDir));
            ConfigImportHelper.doImport(oldConfigDir, newConfigDir, oldIdeHome, oldPluginsDir, newPluginsDir, importOptions);
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            String message = BootstrapBundle.message((String)"import.settings.failed", (Object[])new Object[]{IoErrorText.message((Throwable)e)});
            StartupErrorReporter.showWarning((String)BootstrapBundle.message((String)"import.settings.failed.title", (Object[])new Object[0]), (String)message);
        }
    }

    private static Path computeOldPluginsDir(Path oldConfigDir, @Nullable Path oldIdeHome) {
        Path oldPluginsDir = oldConfigDir.resolve(PLUGINS);
        if (!Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            oldPluginsDir = null;
            if (oldIdeHome != null) {
                oldPluginsDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.plugins.path", ConfigImportHelper::defaultPluginsPath);
            }
            if (oldPluginsDir == null) {
                oldPluginsDir = oldConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultPluginsPath(ConfigImportHelper.getNameWithVersion(oldConfigDir)), new String[0]);
            }
        }
        return oldPluginsDir;
    }

    @VisibleForTesting
    public static void doImport(final @NotNull Path oldConfigDir, final @NotNull Path newConfigDir, @Nullable Path oldIdeHome, final @NotNull Path oldPluginsDir, @NotNull Path newPluginsDir, final @NotNull ConfigImportOptions options) throws IOException {
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(15);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(16);
        }
        if (oldPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(17);
        }
        if (newPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(18);
        }
        if (options == null) {
            ConfigImportHelper.$$$reportNull$$$0(19);
        }
        Logger log = options.log;
        if (Files.isRegularFile(oldConfigDir, new LinkOption[0])) {
            new Decompressor.Zip(oldConfigDir).extract(newConfigDir);
            return;
        }
        Files.walkFileTree(oldConfigDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                boolean blocked = ConfigImportHelper.blockImport(dir, oldConfigDir, newConfigDir, oldPluginsDir, options.importSettings);
                return blocked ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path target = newConfigDir.resolve(oldConfigDir.relativize(file));
                if (options.mergeVmOptions && file.getFileName().toString().equals(VMOptions.getFileName()) && Files.exists(target, new LinkOption[0])) {
                    ConfigImportHelper.mergeVmOptions(file, target, options.log);
                } else if (!ConfigImportHelper.blockImport(file, oldConfigDir, newConfigDir, oldPluginsDir, options.importSettings)) {
                    NioFiles.createDirectories((Path)target.getParent());
                    Files.copy(file, target, LinkOption.NOFOLLOW_LINKS);
                } else if (ConfigImportHelper.overwriteOnImport(file)) {
                    NioFiles.createDirectories((Path)target.getParent());
                    Files.copy(file, target, LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        String disabledPluginsFileName = P3SupportKt.processPerProjectSupport().getDisabledPluginsFileName();
        if (!disabledPluginsFileName.equals("disabled_plugins.txt") && Files.exists(oldConfigDir.resolve("disabled_plugins.txt"), new LinkOption[0]) && !Files.exists(newConfigDir.resolve(disabledPluginsFileName), new LinkOption[0])) {
            Files.copy(oldConfigDir.resolve("disabled_plugins.txt"), newConfigDir.resolve(disabledPluginsFileName), new CopyOption[0]);
        }
        List<StartupActionScriptManager.ActionCommand> actionCommands = ConfigImportHelper.loadStartupActionScript(oldConfigDir, oldIdeHome, oldPluginsDir);
        if (!ConfigImportHelper.isEmptyDirectory(newPluginsDir)) {
            log.info("non-empty plugins directory: " + String.valueOf(newPluginsDir));
        } else {
            Predicate<IdeaPluginDescriptor> hasPendingUpdate = Files.isDirectory(oldPluginsDir, new LinkOption[0]) ? ConfigImportHelper.collectPendingPluginUpdates(actionCommands, oldPluginsDir.getFileSystem(), options.log) : __ -> false;
            ConfigImportHelper.migratePlugins(oldPluginsDir, oldConfigDir, newPluginsDir, newConfigDir, options, hasPendingUpdate);
        }
        ConfigImportHelper.migrateLocalization(oldConfigDir, oldPluginsDir);
        if (OS.CURRENT == OS.macOS && (PlatformUtils.isIntelliJ() || "AndroidStudio".equals(PlatformUtils.getPlatformPrefix()))) {
            ConfigImportHelper.setKeymapIfNeeded(oldConfigDir, newConfigDir, log);
        }
        StartupActionScriptManager.executeActionScriptCommands(actionCommands, (Path)oldPluginsDir, (Path)newPluginsDir);
        ConfigImportHelper.updateVMOptions(newConfigDir, oldConfigDir, log);
    }

    public static void migrateLocalization(@NotNull Path oldConfigDir, @NotNull Path oldPluginsDir) {
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(20);
        }
        if (oldPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(21);
        }
        Localization242.INSTANCE.enableL10nIfPluginInstalled(ConfigImportHelper.parseVersionFromConfig(oldConfigDir), oldPluginsDir);
    }

    private static List<StartupActionScriptManager.ActionCommand> loadStartupActionScript(Path oldConfigDir, @Nullable Path oldIdeHome, Path oldPluginsDir) throws IOException {
        if (Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            Path script;
            Path oldSystemDir = oldConfigDir.getParent().resolve(SYSTEM);
            if (!Files.isDirectory(oldSystemDir, new LinkOption[0])) {
                oldSystemDir = null;
                if (oldIdeHome != null) {
                    oldSystemDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.system.path", ConfigImportHelper::defaultSystemPath);
                }
                if (oldSystemDir == null) {
                    oldSystemDir = oldConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultSystemPath(ConfigImportHelper.getNameWithVersion(oldConfigDir)), new String[0]);
                }
            }
            if (Files.isRegularFile(script = oldSystemDir.resolve("plugins/action.script"), new LinkOption[0])) {
                return StartupActionScriptManager.loadActionScript((Path)script);
            }
        }
        return List.of();
    }

    public static void migratePlugins(@NotNull Path oldPluginsDir, @NotNull Path oldConfigDir, @NotNull Path newPluginsDir, @NotNull Path newConfigDir, @NotNull ConfigImportOptions options, @NotNull Predicate<IdeaPluginDescriptor> hasPendingUpdate) throws IOException {
        Path oldFrontendPlugins;
        if (oldPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(22);
        }
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(23);
        }
        if (newPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(24);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(25);
        }
        if (options == null) {
            ConfigImportHelper.$$$reportNull$$$0(26);
        }
        if (hasPendingUpdate == null) {
            ConfigImportHelper.$$$reportNull$$$0(27);
        }
        Logger log = options.log;
        ArrayList<IdeaPluginDescriptor> pluginsToMigrate = new ArrayList<IdeaPluginDescriptor>();
        ArrayList<IdeaPluginDescriptor> pluginsToDownload = new ArrayList<IdeaPluginDescriptor>();
        Map<PluginId, Set<String>> brokenPluginVersions = ConfigImportHelper.fetchBrokenPluginsFromMarketplace(options, newConfigDir);
        if (!ConfigImportHelper.collectPluginsToMigrate(oldPluginsDir, options, brokenPluginVersions, pluginsToMigrate, pluginsToDownload)) {
            log.info("Error loading list of plugins from old dir, migrating entire plugin directory");
            NioFiles.copyRecursively((Path)oldPluginsDir, (Path)newPluginsDir);
            return;
        }
        if (options.importSettings != null) {
            options.importSettings.processPluginsToMigrate(newConfigDir, oldConfigDir, oldPluginsDir, options, brokenPluginVersions, pluginsToMigrate, pluginsToDownload);
        }
        if (!PlatformUtils.isJetBrainsClient() && Files.isDirectory(oldFrontendPlugins = oldPluginsDir.resolve("frontend"), new LinkOption[0])) {
            NioFiles.copyRecursively((Path)oldFrontendPlugins, (Path)newPluginsDir.resolve("frontend-to-migrate"));
        }
        ConfigImportHelper.migrateGlobalPlugins(newConfigDir, oldConfigDir, pluginsToMigrate, pluginsToDownload, options.log);
        pluginsToMigrate.removeIf(hasPendingUpdate);
        if (!pluginsToMigrate.isEmpty()) {
            ConfigImportHelper.migratePlugins(newPluginsDir, pluginsToMigrate, log);
        }
        pluginsToDownload.removeIf(hasPendingUpdate);
        if (!pluginsToDownload.isEmpty()) {
            ConfigImportHelper.downloadUpdatesForPlugins(newPluginsDir, options, pluginsToDownload, brokenPluginVersions);
            ConfigImportHelper.migratePlugins(newPluginsDir, pluginsToDownload, log);
        }
    }

    public static boolean collectPluginsToMigrate(@NotNull Path oldPluginsDir, @NotNull ConfigImportOptions options, @Nullable Map<PluginId, Set<String>> brokenPluginVersions, @NotNull List<IdeaPluginDescriptor> pluginsToMigrate, @NotNull List<IdeaPluginDescriptor> pluginsToDownload) {
        if (oldPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(28);
        }
        if (options == null) {
            ConfigImportHelper.$$$reportNull$$$0(29);
        }
        if (pluginsToMigrate == null) {
            ConfigImportHelper.$$$reportNull$$$0(30);
        }
        if (pluginsToDownload == null) {
            ConfigImportHelper.$$$reportNull$$$0(31);
        }
        PluginLoadingResult oldIdeLoadingResult = null;
        try {
            PluginDescriptorLoadingResult pluginLists = PluginDescriptorLoader.loadDescriptorsFromOtherIde((Path)oldPluginsDir, (Path)options.bundledPluginPath, (BuildNumber)options.compatibleBuildNumber);
            ProductPluginInitContext initContext = new ProductPluginInitContext(options.compatibleBuildNumber, Collections.emptySet(), Collections.emptySet(), brokenPluginVersions);
            oldIdeLoadingResult = new PluginLoadingResult();
            oldIdeLoadingResult.initAndAddAll(pluginLists, (PluginInitializationContext)initContext);
        }
        catch (InterruptedException | ExecutionException e) {
            return false;
        }
        catch (IOException e) {
            options.log.info("Non-existing plugins directory: " + String.valueOf(oldPluginsDir), (Throwable)e);
        }
        if (oldIdeLoadingResult != null) {
            if (Boolean.getBoolean(UPDATE_ONLY_INCOMPATIBLE_PLUGINS_PROPERTY)) {
                ConfigImportHelper.partitionNonBundled(oldIdeLoadingResult.getIdMap().values(), pluginsToDownload, pluginsToMigrate, descriptor -> {
                    Set brokenVersions = brokenPluginVersions != null ? (Set)brokenPluginVersions.get(descriptor.getPluginId()) : null;
                    return brokenVersions != null && brokenVersions.contains(descriptor.getVersion());
                });
                ConfigImportHelper.partitionNonBundled(oldIdeLoadingResult.getIncompleteIdMap().values(), pluginsToDownload, pluginsToMigrate, __ -> true);
            } else {
                ArrayList<IdeaPluginDescriptor> nonBundledPlugins = new ArrayList<IdeaPluginDescriptor>();
                ConfigImportHelper.partitionNonBundled(oldIdeLoadingResult.getIdMap().values(), nonBundledPlugins, pluginsToMigrate, __ -> true);
                ConfigImportHelper.partitionNonBundled(oldIdeLoadingResult.getIncompleteIdMap().values(), nonBundledPlugins, pluginsToMigrate, __ -> true);
                Map<PluginId, PluginNode> updates = ConfigImportHelper.fetchPluginUpdatesFromMarketplace(options, ContainerUtil.map2Set(nonBundledPlugins, d -> d.getPluginId()));
                ConfigImportHelper.partitionNonBundled(oldIdeLoadingResult.getIdMap().values(), pluginsToDownload, pluginsToMigrate, d -> {
                    if (updates != null && updates.containsKey(d.getPluginId()) && !((PluginNode)updates.get(d.getPluginId())).getVersion().equals(d.getVersion())) {
                        return true;
                    }
                    Set brokenVersions = brokenPluginVersions != null ? (Set)brokenPluginVersions.get(d.getPluginId()) : null;
                    return brokenVersions != null && brokenVersions.contains(d.getVersion());
                });
                ConfigImportHelper.partitionNonBundled(oldIdeLoadingResult.getIncompleteIdMap().values(), pluginsToDownload, pluginsToMigrate, __ -> true);
            }
        }
        return true;
    }

    private static void performMigrations(PluginMigrationOptions options) {
        new NotebooksMigration242().migratePlugins(options);
        new SpaceMigration252().migratePlugins(options);
        new BigDataToolsMigration253().migratePlugins(options);
    }

    private static void migrateGlobalPlugins(Path newConfigDir, Path oldConfigDir, List<IdeaPluginDescriptor> toMigrate, List<IdeaPluginDescriptor> toDownload, Logger log) {
        String currentProductVersion = PluginManagerCore.getBuildNumber().asStringWithoutProductCode();
        String previousVersion = ConfigImportHelper.parseVersionFromConfig(oldConfigDir);
        PluginMigrationOptions options = new PluginMigrationOptions(previousVersion, currentProductVersion, newConfigDir, oldConfigDir, toMigrate, toDownload, log);
        ConfigImportHelper.performMigrations(options);
        String downloadIds = toDownload.stream().map(descriptor -> descriptor.getPluginId().getIdString()).collect(Collectors.joining("\n"));
        Path resultFile = newConfigDir.resolve("migration_installed_plugins.txt");
        try {
            Files.writeString(resultFile, (CharSequence)downloadIds, new OpenOption[0]);
        }
        catch (IOException e) {
            options.getLog().error("Unable to write auto install result", (Throwable)e);
        }
    }

    private static void partitionNonBundled(Collection<? extends IdeaPluginDescriptor> descriptors, List<IdeaPluginDescriptor> firstAccumulator, List<IdeaPluginDescriptor> secondAccumulator, Predicate<IdeaPluginDescriptor> predicate) {
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptors) {
            if (ideaPluginDescriptor.isBundled()) continue;
            (predicate.test(ideaPluginDescriptor) ? firstAccumulator : secondAccumulator).add(ideaPluginDescriptor);
        }
    }

    private static Predicate<IdeaPluginDescriptor> collectPendingPluginUpdates(List<StartupActionScriptManager.ActionCommand> actionCommands, FileSystem fs, Logger log) {
        LinkedHashSet<PluginId> result = new LinkedHashSet<PluginId>();
        for (StartupActionScriptManager.ActionCommand command : actionCommands) {
            String source;
            StartupActionScriptManager.ActionCommand actionCommand;
            Objects.requireNonNull(command);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StartupActionScriptManager.CopyCommand.class, StartupActionScriptManager.UnzipCommand.class}, (Object)actionCommand, n)) {
                case 0: {
                    StartupActionScriptManager.CopyCommand cc = (StartupActionScriptManager.CopyCommand)actionCommand;
                    String string = cc.getSource();
                    break;
                }
                case 1: {
                    StartupActionScriptManager.UnzipCommand uzc = (StartupActionScriptManager.UnzipCommand)actionCommand;
                    String string = uzc.getSource();
                    break;
                }
                default: {
                    String string = source = null;
                }
            }
            if (source == null) continue;
            try {
                PluginMainDescriptor descriptor2 = PluginDescriptorLoader.loadDescriptorFromArtifact((Path)fs.getPath(source, new String[0]), null);
                if (descriptor2 != null) {
                    result.add(descriptor2.getPluginId());
                    continue;
                }
                log.info("No plugin descriptor in pending update: " + source);
            }
            catch (IOException e) {
                log.info("Failed to load plugin descriptor from pending update: " + source);
            }
        }
        return descriptor -> {
            PluginId pluginId = descriptor.getPluginId();
            if (result.contains(pluginId)) {
                log.info("Plugin '" + String.valueOf(pluginId) + "' skipped due to a pending update");
                return true;
            }
            return false;
        };
    }

    public static void migratePlugins(Path newPluginsDir, List<IdeaPluginDescriptor> descriptors, Logger log) throws IOException {
        for (IdeaPluginDescriptor descriptor : descriptors) {
            Path pluginPath = descriptor.getPluginPath();
            PluginId pluginId = descriptor.getPluginId();
            if (pluginPath == null) {
                log.info("Skipping migration of plugin '" + String.valueOf(pluginId) + "', because it is officially homeless");
                continue;
            }
            log.info("Migrating plugin '" + String.valueOf(pluginId) + "' version: " + descriptor.getVersion());
            Path target = newPluginsDir.resolve(pluginPath.getFileName());
            if (Files.isDirectory(pluginPath, new LinkOption[0])) {
                NioFiles.copyRecursively((Path)pluginPath, (Path)target);
                continue;
            }
            Files.createDirectories(newPluginsDir, new FileAttribute[0]);
            Files.copy(pluginPath, target, new CopyOption[0]);
        }
    }

    private static void downloadUpdatesForPlugins(Path newPluginsDir, ConfigImportOptions options, List<IdeaPluginDescriptor> plugins, Map<PluginId, Set<String>> brokenPluginVersions) {
        if (options.headless) {
            ConfigImportHelper.runSynchronouslyInBackground(() -> {
                EmptyProgressIndicator indicator = options.headlessProgressIndicator == null ? new EmptyProgressIndicator(ModalityState.nonModal()) : options.headlessProgressIndicator;
                ConfigImportHelper.downloadUpdatesForPlugins(newPluginsDir, options, plugins, brokenPluginVersions, (ProgressIndicator)indicator);
            });
        } else {
            ThreadingAssertions.assertEventDispatchThread();
            ConfigImportProgressDialog dialog = new ConfigImportProgressDialog();
            dialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
            AppUIUtilKt.updateAppWindowIcon((Window)dialog);
            SplashManagerKt.hideSplash();
            ConfigImportHelper.runSynchronouslyInBackground(() -> {
                try {
                    ConfigImportHelper.downloadUpdatesForPlugins(newPluginsDir, options, plugins, brokenPluginVersions, (ProgressIndicator)dialog.getIndicator());
                }
                catch (Throwable e) {
                    options.log.info("Failed to download updates for plugins", e);
                }
                SwingUtilities.invokeLater(() -> dialog.setVisible(false));
            });
            dialog.setVisible(true);
        }
    }

    private static void downloadUpdatesForPlugins(Path newPluginsDir, ConfigImportOptions options, List<IdeaPluginDescriptor> plugins, Map<PluginId, Set<String>> brokenPluginVersions, ProgressIndicator indicator) {
        ThreadingAssertions.assertBackgroundThread();
        Logger log = options.log;
        Iterator<IdeaPluginDescriptor> iterator = plugins.iterator();
        while (iterator.hasNext()) {
            IdeaPluginDescriptor descriptor = iterator.next();
            PluginId pluginId = descriptor.getPluginId();
            try {
                PluginDownloader downloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor).withErrorsConsumer(__ -> {}).withDownloadService(options.downloadService);
                if (downloader.prepareToInstall(indicator)) {
                    PluginInstaller.unpackPlugin((Path)downloader.getFilePath(), (Path)newPluginsDir);
                    log.info("Downloaded and unpacked compatible version of plugin '" + String.valueOf(pluginId) + "'");
                    iterator.remove();
                    continue;
                }
                if (!ConfigImportHelper.isBrokenPlugin(descriptor, brokenPluginVersions)) continue;
                iterator.remove();
            }
            catch (ProcessCanceledException ignored) {
                log.info("Plugin download cancelled");
                break;
            }
            catch (IOException e) {
                log.info("Failed to download and install compatible version of '" + String.valueOf(pluginId) + "': " + e.getMessage());
            }
        }
    }

    @Nullable
    private static Map<PluginId, PluginNode> fetchPluginUpdatesFromMarketplace(ConfigImportOptions options, Set<PluginId> pluginIds) {
        if (testLastCompatiblePluginUpdatesFetcher != null) {
            return testLastCompatiblePluginUpdatesFetcher.apply(pluginIds);
        }
        try {
            long start = System.nanoTime();
            List updates = ConfigImportHelper.runSynchronouslyInBackgroundWithTimeout(() -> MarketplaceRequests.loadLastCompatiblePluginModels((Set)pluginIds, (BuildNumber)options.compatibleBuildNumber).stream().map(PluginUiModel::getDescriptor).filter(PluginNode.class::isInstance).toList(), 7000L);
            options.log.info("Fetched " + updates.size() + " latest compatible plugin updates in " + (System.nanoTime() - start) / 1000000L + " ms");
            HashMap<PluginId, PluginNode> updatesMap = new HashMap<PluginId, PluginNode>();
            for (IdeaPluginDescriptor update : updates) {
                updatesMap.put(update.getPluginId(), (PluginNode)update);
            }
            return updatesMap;
        }
        catch (TimeoutException e) {
            options.log.warn("Failed to fetch updates for plugins: time-out");
            return null;
        }
        catch (Throwable e) {
            options.log.warn("Failed to fetch updates for plugins", e);
            return null;
        }
    }

    private static boolean isBrokenPlugin(IdeaPluginDescriptor descriptor, @Nullable Map<PluginId, Set<String>> brokenPluginVersions) {
        if (brokenPluginVersions == null) {
            return BrokenPluginFileKt.isBrokenPlugin((IdeaPluginDescriptor)descriptor);
        }
        Set<String> versions = brokenPluginVersions.get(descriptor.getPluginId());
        return versions != null && versions.contains(descriptor.getVersion());
    }

    @Nullable
    private static Map<PluginId, Set<String>> fetchBrokenPluginsFromMarketplace(ConfigImportOptions options, Path newConfigDir) {
        if (testBrokenPluginsFetcherStub != null) {
            return testBrokenPluginsFetcherStub.apply(newConfigDir);
        }
        try {
            BuildNumber buildNumber = options.compatibleBuildNumber != null ? options.compatibleBuildNumber : ApplicationInfoImpl.getShadowInstance().getBuild();
            long start = System.nanoTime();
            Map brokenPlugins = ConfigImportHelper.runSynchronouslyInBackgroundWithTimeout(() -> MarketplaceRequests.Companion.getBrokenPlugins(buildNumber), 3000L);
            options.log.info("Fetched broken plugins in " + (System.nanoTime() - start) / 1000000L + " ms");
            if (brokenPlugins != null && !brokenPlugins.isEmpty()) {
                try {
                    Files.createDirectories(newConfigDir, new FileAttribute[0]);
                    BrokenPluginFileKt.writeBrokenPlugins((Map)brokenPlugins, (Path)newConfigDir);
                    BrokenPluginFileKt.dropInMemoryBrokenPluginsCache();
                }
                catch (Exception e) {
                    options.log.error("Failed to write broken plugins", (Throwable)e);
                }
            }
            return brokenPlugins;
        }
        catch (TimeoutException e) {
            options.log.warn("Failed to fetch broken plugins: timed out");
            return null;
        }
        catch (Throwable e) {
            options.log.warn("Failed to fetch broken plugins", e);
            return null;
        }
    }

    private static void runSynchronouslyInBackground(Runnable runnable) {
        try {
            Thread thread = new Thread(runnable, "Plugin downloader");
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T runSynchronouslyInBackgroundWithTimeout(final Supplier<T> computation, long timeoutMs) throws TimeoutException {
        try {
            final AtomicReference result = new AtomicReference();
            Thread thread = new Thread("Plugin downloader"){

                @Override
                public void run() {
                    result.set(computation.get());
                }
            };
            thread.start();
            thread.join(timeoutMs);
            if (thread.isAlive()) {
                thread.interrupt();
                throw new TimeoutException();
            }
            return (T)result.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEmptyDirectory(Path newPluginsDir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(newPluginsDir);){
            Path path;
            boolean hidden;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return true;
                path = iterator.next();
            } while (hidden = OS.CURRENT == OS.Windows ? Files.readAttributes(path, DosFileAttributes.class, new LinkOption[0]).isHidden() : path.getFileName().startsWith("."));
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @VisibleForTesting
    public static void setKeymapIfNeeded(@NotNull Path oldConfigDir, @NotNull Path newConfigDir, @NotNull Logger log) {
        Path keymapOptionFile;
        String keymapFileSpec;
        String nameWithVersion;
        Matcher m;
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(32);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(33);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(34);
        }
        if ((m = ConfigImportHelper.matchNameWithVersion(nameWithVersion = ConfigImportHelper.getNameWithVersion(oldConfigDir))).matches() && VersionComparatorUtil.compare((String)"2019.1", (String)m.group(1)) >= 0 && (keymapFileSpec = StoreUtilKt.getDefaultStoragePathSpec(KeymapManagerImpl.class)) != null && !Files.exists(keymapOptionFile = newConfigDir.resolve("options").resolve(keymapFileSpec), new LinkOption[0])) {
            try {
                Files.createDirectories(keymapOptionFile.getParent(), new FileAttribute[0]);
                Files.writeString(keymapOptionFile, (CharSequence)"<application>\n  <component name=\"KeymapManager\">\n    <active_keymap name=\"Mac OS X\" />\n  </component>\n</application>", new OpenOption[0]);
            }
            catch (IOException e) {
                log.error("Cannot set keymap", (Throwable)e);
            }
        }
    }

    private static Matcher matchNameWithVersion(String nameWithVersion) {
        return Pattern.compile("\\.?\\D+(\\d+\\.\\d+)?").matcher(nameWithVersion);
    }

    public static void mergeVmOptions(Path importFile, Path currentFile, Logger log) {
        try {
            Charset cs = VMOptions.getFileCharset();
            List<String> importLines = Files.readAllLines(importFile, cs);
            List<String> currentLines = Files.readAllLines(currentFile, cs);
            List<String> result = ConfigImportHelper.mergeVmOptionsLines(importLines, currentLines);
            Files.write(currentFile, result, cs, new OpenOption[0]);
        }
        catch (IOException e) {
            log.warn("Failed to merge VM option files " + String.valueOf(importFile) + " and " + String.valueOf(currentFile), (Throwable)e);
        }
    }

    private static boolean vmOptionsRequiresMerge(@Nullable Path oldConfigDir, Path newConfigDir, Logger log) {
        if (oldConfigDir == null) {
            return false;
        }
        Path importFile = oldConfigDir.resolve(VMOptions.getFileName());
        if (!Files.isRegularFile(importFile, new LinkOption[0])) {
            return false;
        }
        if (newConfigDir == null) {
            return true;
        }
        Path currentFile = newConfigDir.resolve(VMOptions.getFileName());
        if (!Files.isRegularFile(currentFile, new LinkOption[0])) {
            return true;
        }
        try {
            Charset cs = VMOptions.getFileCharset();
            List<String> importLines = Files.readAllLines(importFile, cs);
            List<String> currentLines = Files.readAllLines(currentFile, cs);
            currentLines.sort(String::compareTo);
            List<String> result = ConfigImportHelper.mergeVmOptionsLines(importLines, currentLines);
            ConfigImportHelper.updateVMOptionsLines(newConfigDir, oldConfigDir, result, log);
            result.sort(String::compareTo);
            return !currentLines.equals(result);
        }
        catch (IOException e) {
            log.warn("Failed to merge VM option files " + String.valueOf(importFile) + " and " + String.valueOf(currentFile), (Throwable)e);
            return true;
        }
    }

    private static List<String> mergeVmOptionsLines(List<String> importLines, List<String> currentLines) {
        ArrayList<String> result = new ArrayList<String>(importLines.size() + currentLines.size());
        boolean preferCurrentXmx = false;
        block0: for (String line : importLines) {
            if (line.startsWith("-D")) {
                int p = line.indexOf(61);
                if (p > 0) {
                    String prefix = line.substring(0, p + 1);
                    for (String l : currentLines) {
                        if (!l.startsWith(prefix)) continue;
                        continue block0;
                    }
                }
            } else if (line.startsWith("-Xmx") && ConfigImportHelper.isLowerValue("-Xmx", line.substring(4), currentLines)) {
                preferCurrentXmx = true;
                continue;
            }
            result.add(line);
        }
        for (String line : currentLines) {
            if (!preferCurrentXmx && line.startsWith("-Xmx")) continue;
            result.add(line);
        }
        return result;
    }

    public static void updateVMOptions(@NotNull Path newConfigDir, @NotNull Path oldConfigDir, @NotNull Logger log) {
        Path vmOptionsFile;
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(35);
        }
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(36);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(37);
        }
        if (Files.exists(vmOptionsFile = newConfigDir.resolve(VMOptions.getFileName()), new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(vmOptionsFile, VMOptions.getFileCharset());
                boolean updated = ConfigImportHelper.updateVMOptionsLines(newConfigDir, oldConfigDir, lines, log);
                if (updated) {
                    Files.write(vmOptionsFile, lines, VMOptions.getFileCharset(), new OpenOption[0]);
                }
            }
            catch (IOException e) {
                log.warn("Failed to update custom VM options file " + String.valueOf(vmOptionsFile), (Throwable)e);
            }
        }
    }

    private static boolean updateVMOptionsLines(Path newConfigDir, Path oldConfigDir, List<String> lines, Logger log) {
        Path platformVmOptionsFile = newConfigDir.getFileSystem().getPath(VMOptions.getPlatformOptionsFile().toString(), new String[0]);
        LinkedHashSet<String> platformLines = new LinkedHashSet<String>(ConfigImportHelper.readPlatformOptions(platformVmOptionsFile, log));
        String oldConfigName = oldConfigDir.getFileName().toString();
        boolean fromCE = oldConfigName.startsWith("IdeaIC") || oldConfigName.startsWith("PyCharmCE");
        boolean updated = false;
        ListIterator<String> i = lines.listIterator();
        while (i.hasNext()) {
            String line = i.next().trim();
            if (line.equals("-XX:MaxJavaStackTraceDepth=-1")) {
                i.set("-XX:MaxJavaStackTraceDepth=10000");
                updated = true;
                continue;
            }
            if (!("-XX:+UseConcMarkSweepGC".equals(line) || "-Xverify:none".equals(line) || "-noverify".equals(line) || "-XX:+UseCompressedOops".equals(line) || line.startsWith("-agentlib:yjpagent") || line.startsWith("-agentpath:") && line.contains("yjpagent") || "-Dsun.io.useCanonPrefixCache=false".equals(line) || "-Dfile.encoding=UTF-8".equals(line) && OS.CURRENT == OS.macOS || line.startsWith("-DJETBRAINS_LICENSE_SERVER") && fromCE || line.startsWith("-Dide.do.not.disable.paid.plugins.on.startup")) && !ConfigImportHelper.isDuplicateOrLowerValue(line, platformLines)) continue;
            i.remove();
            updated = true;
        }
        return updated;
    }

    @VisibleForTesting
    static List<String> readPlatformOptions(Path platformVmOptionsFile, Logger log) {
        try {
            return Files.readAllLines(platformVmOptionsFile, VMOptions.getFileCharset());
        }
        catch (IOException e) {
            log.warn("Cannot read platform VM options file " + String.valueOf(platformVmOptionsFile), (Throwable)e);
            return List.of();
        }
    }

    private static boolean isDuplicateOrLowerValue(String line, Collection<String> platformLines) {
        int p;
        if (platformLines.isEmpty()) {
            return false;
        }
        if (platformLines.contains(line)) {
            return true;
        }
        if (line.startsWith("-Xms") || line.startsWith("-Xmx") || line.startsWith("-Xss")) {
            return ConfigImportHelper.isLowerValue(line.substring(0, 4), line.substring(4), platformLines);
        }
        if (line.startsWith("-XX:") && (p = line.indexOf(61, 4)) > 0) {
            return ConfigImportHelper.isLowerValue(line.substring(0, p + 1), line.substring(p + 1), platformLines);
        }
        return false;
    }

    private static boolean isLowerValue(String prefix, String userValue, Collection<String> platformLines) {
        for (String line : platformLines) {
            if (!line.startsWith(prefix)) continue;
            try {
                return VMOptions.parseMemoryOption((String)userValue) <= VMOptions.parseMemoryOption((String)line.substring(prefix.length()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    private static boolean blockImport(Path path, Path oldConfig, Path newConfig, Path oldPluginsDir, @Nullable ConfigImportSettings settings) {
        Path fileName = path.getFileName();
        Path parent = path.getParent();
        if (oldConfig.equals(parent)) {
            return ConfigImportHelper.shouldSkipFileDuringImport(path, settings) || Files.exists(newConfig.resolve(fileName), new LinkOption[0]) || path.startsWith(oldPluginsDir);
        }
        if (parent.getFileName().toString().equals("options") && oldConfig.equals(parent.getParent()) && fileName.toString().equals("p3-dynamic-plugins.xml")) {
            return true;
        }
        return settings != null && settings.shouldSkipPath(path);
    }

    private static boolean shouldSkipFileDuringImport(Path path, @Nullable ConfigImportSettings settings) {
        String fileName = path.getFileName().toString();
        return SESSION_FILES.contains(fileName) || fileName.equals("bundled_plugins.txt") || fileName.equals("app-internal-state.db") || fileName.equals("expired_plugins.txt") || fileName.startsWith("chrome-user-data") || fileName.endsWith(".jdk") && fileName.startsWith(String.valueOf(ApplicationNamesInfo.getInstance().getScriptName())) || settings != null && settings.shouldSkipPath(path);
    }

    private static boolean overwriteOnImport(Path path) {
        return path.endsWith("early-access-registry.txt");
    }

    private static String defaultConfigPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultConfigPathFor((String)selector) : (OS.CURRENT == OS.macOS ? SystemProperties.getUserHome() + "/Library/Preferences/" + selector : SystemProperties.getUserHome() + "/." + selector + "/config");
    }

    private static String defaultPluginsPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultPluginPathFor((String)selector) : (OS.CURRENT == OS.macOS ? SystemProperties.getUserHome() + "/Library/Application Support/" + selector : SystemProperties.getUserHome() + "/." + selector + "/config/plugins");
    }

    private static String defaultSystemPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultSystemPathFor((String)selector) : (OS.CURRENT == OS.macOS ? SystemProperties.getUserHome() + "/Library/Caches/" + selector : SystemProperties.getUserHome() + "/." + selector + "/system");
    }

    private static String defaultLogsPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultLogPathFor((String)selector) : (OS.CURRENT == OS.macOS ? SystemProperties.getUserHome() + "/Library/Logs/" + selector : SystemProperties.getUserHome() + "/." + selector + "/system/logs");
    }

    private static boolean newOrUnknown(String selector) {
        Matcher m = SELECTOR_PATTERN.matcher(selector);
        return !m.matches() || "2020.1".compareTo(m.group(2)) <= 0;
    }

    private static List<Path> getRelatedDirectories(Path config, boolean forAutoClean) {
        Path logs;
        Path plugins;
        List files;
        Path commonParent;
        String selector = ConfigImportHelper.getNameWithVersion(config);
        FileSystem fs = config.getFileSystem();
        Path system = fs.getPath(ConfigImportHelper.defaultSystemPath(selector), new String[0]);
        if (!forAutoClean && (commonParent = config.getParent()).equals(system.getParent()) && ((files = NioFiles.list((Path)commonParent)).size() == 1 || files.size() == 2 && files.containsAll(List.of(config, system)))) {
            return List.of(commonParent);
        }
        ArrayList<Path> result = new ArrayList<Path>();
        if (!forAutoClean) {
            result.add(config);
        }
        if (Files.exists(system, new LinkOption[0])) {
            result.add(system);
        }
        if (!forAutoClean && !(plugins = fs.getPath(ConfigImportHelper.defaultPluginsPath(selector), new String[0])).startsWith(config) && Files.exists(plugins, new LinkOption[0])) {
            result.add(plugins);
        }
        if (!(logs = fs.getPath(ConfigImportHelper.defaultLogsPath(selector), new String[0])).startsWith(system) && Files.exists(logs, new LinkOption[0])) {
            result.add(logs);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfigDir";
                break;
            }
            case 1: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 11: 
            case 15: 
            case 20: 
            case 23: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConfigDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importOptions";
                break;
            }
            case 17: 
            case 21: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPluginsDir";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPluginsDir";
                break;
            }
            case 19: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasPendingUpdate";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToMigrate";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginsToDownload";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/application/ConfigImportHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "importConfigsTo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSettingsFilter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigDirectory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigLastModifiedTime";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findInheritedDirectory";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findConfigDirectories";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "doImport";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "migrateLocalization";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "migratePlugins";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "collectPluginsToMigrate";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "setKeymapIfNeeded";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "updateVMOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ConfigDirsSearchResult {
        private final List<? extends Pair<Path, FileTime>> directories;

        private ConfigDirsSearchResult(List<? extends Pair<Path, FileTime>> directories) {
            this.directories = directories;
        }

        public @Unmodifiable @NotNull List<Path> getPaths() {
            List list = ContainerUtil.map(this.directories, it -> (Path)it.first);
            if (list == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        @NlsSafe
        public String getNameAndVersion(@NotNull Path config) {
            if (config == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(1);
            }
            String string = ConfigImportHelper.getNameWithVersion(config);
            if (string == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public List<Path> findRelatedDirectories(@NotNull Path config, boolean forAutoClean) {
            if (config == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(3);
            }
            List<Path> list = ConfigImportHelper.getRelatedDirectories(config, forAutoClean);
            if (list == null) {
                ConfigDirsSearchResult.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/application/ConfigImportHelper$ConfigDirsSearchResult";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = ConfigImportHelper.CONFIG;
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPaths";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/application/ConfigImportHelper$ConfigDirsSearchResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameAndVersion";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findRelatedDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getNameAndVersion";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findRelatedDirectories";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

