/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.intellij.ide.ConfigImportSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.Formats;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.system.OS;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.IoErrorText;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@ApiStatus.Internal
public final class OldDirectoryCleaner {
    private final Logger myLogger = Logger.getInstance(OldDirectoryCleaner.class);
    private final long myBestBefore;

    public OldDirectoryCleaner(long bestBefore) {
        this.myBestBefore = bestBefore;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    public void seekAndDestroy(@Nullable Project project, @Nullable ProgressIndicator progressIndicator) {
        void indicator;
        ThreadingAssertions.assertBackgroundThread();
        ConfigImportSettings settings = ConfigImportHelper.findCustomConfigImportSettings();
        ConfigImportHelper.ConfigDirsSearchResult result = ConfigImportHelper.findConfigDirectories(PathManager.getConfigDir(), settings, List.of());
        List<DirectoryGroup> groups = this.collectDirectoryData(result, (ProgressIndicator)indicator);
        if (this.myLogger.isDebugEnabled()) {
            this.myLogger.debug("configs: " + String.valueOf(result.getPaths()));
            this.myLogger.debug("groups: " + String.valueOf(groups));
        }
        if (this.myBestBefore != 0L) {
            this.deleteCowardly(groups);
            Stats.completed(groups.size(), groups.stream().mapToLong(g -> g.size).sum());
        } else if (!groups.isEmpty()) {
            NotificationGroupManager.getInstance().getNotificationGroup("leftover.ide.directories").createNotification(IdeBundle.message((String)"old.dirs.notification.text", (Object[])new Object[0]), NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createSimpleExpiring((String)IdeBundle.message((String)"old.dirs.notification.action", (Object[])new Object[0]), () -> this.lambda$seekAndDestroy$1((Project)project, groups))).notify((Project)project);
        } else {
            NotificationGroupManager.getInstance().getNotificationGroup("leftover.ide.directories").createNotification(IdeBundle.message((String)"old.dirs.not.found.notification.text", (Object[])new Object[0]), NotificationType.INFORMATION).notify((Project)project);
        }
    }

    private List<DirectoryGroup> collectDirectoryData(ConfigImportHelper.ConfigDirsSearchResult result, @Nullable ProgressIndicator indicator) {
        List<Path> configPaths = result.getPaths();
        ArrayList<DirectoryGroup> groups = new ArrayList<DirectoryGroup>(configPaths.size());
        String productInfoFileName = OS.CURRENT == OS.macOS ? "Resources/product-info.json" : "product-info.json";
        for (Path configPath : configPaths) {
            List<Path> directories = result.findRelatedDirectories(configPath, this.myBestBefore != 0L);
            if (directories.isEmpty()) continue;
            String nameAndVersion = result.getNameAndVersion(configPath);
            long lastUpdated = 0L;
            long size = 0L;
            int entriesToDelete = 0;
            boolean isInstalled = false;
            for (Path directory : directories) {
                StatsCollectingVisitor visitor;
                block19: {
                    visitor = new StatsCollectingVisitor(indicator);
                    try {
                        Files.walkFileTree(directory, (FileVisitor<? super Path>)((Object)visitor));
                        Path homeDir = Path.of(Files.readString(directory.resolve(".home")), new String[0]);
                        if (!Files.exists(homeDir, new LinkOption[0])) break block19;
                        try (BufferedReader reader = Files.newBufferedReader(homeDir.resolve(productInfoFileName));
                             JsonParser parser = new JsonFactory().createParser((Reader)reader);){
                            if (nameAndVersion.equals(OldDirectoryCleaner.readDataDirectoryName(parser))) {
                                isInstalled = true;
                            }
                        }
                        catch (NoSuchFileException e) {
                            this.myLogger.debug((Throwable)e);
                            isInstalled = true;
                        }
                    }
                    catch (IOException | InvalidPathException e) {
                        this.myLogger.debug((Throwable)e);
                    }
                }
                lastUpdated = Math.max(lastUpdated, visitor.lastUpdated);
                size += visitor.size;
                entriesToDelete += visitor.entriesToDelete;
            }
            if (this.myBestBefore != 0L && lastUpdated > this.myBestBefore) continue;
            groups.add(new DirectoryGroup(nameAndVersion, directories, lastUpdated, size, entriesToDelete, isInstalled));
        }
        return groups;
    }

    @Nullable
    private static String readDataDirectoryName(JsonParser parser) throws IOException {
        if (parser.nextToken() == JsonToken.START_OBJECT) {
            while (parser.nextToken() != null) {
                if ("dataDirectoryName".equals(parser.currentName())) {
                    parser.nextToken();
                    return parser.getText();
                }
                parser.skipChildren();
            }
        }
        return null;
    }

    private void deleteCowardly(List<DirectoryGroup> groups) {
        for (DirectoryGroup group : groups) {
            for (Path directory : group.directories) {
                this.myLogger.info("deleting " + String.valueOf(directory));
                try {
                    NioFiles.deleteRecursively((Path)directory);
                }
                catch (IOException e) {
                    this.myLogger.info((Throwable)e);
                }
            }
        }
    }

    private void confirmAndDelete(final Project project, List<DirectoryGroup> groups) {
        List<DirectoryGroup> selectedGroups;
        MenuDialog dialog = new MenuDialog(project, groups);
        if (dialog.showAndGet() && !(selectedGroups = dialog.getSelectedGroups()).isEmpty()) {
            new Task.Backgroundable(project, IdeBundle.message((String)"old.dirs.delete.progress", (Object[])new Object[0])){
                private Path currentRoot;
                private int progress;
                {
                    super(arg0, arg1);
                    this.progress = 0;
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    indicator.setIndeterminate(false);
                    int total = selectedGroups.stream().mapToInt(g -> g.entriesToDelete).sum();
                    ArrayList<CallSite> errors = new ArrayList<CallSite>();
                    for (DirectoryGroup group : selectedGroups) {
                        for (Path directory : group.directories) {
                            indicator.checkCanceled();
                            indicator.setText(directory.toString());
                            if (OldDirectoryCleaner.this.myLogger.isDebugEnabled()) {
                                OldDirectoryCleaner.this.myLogger.debug("deleting " + String.valueOf(directory));
                            }
                            this.currentRoot = directory;
                            try {
                                NioFiles.deleteRecursively((Path)directory, p -> {
                                    indicator.checkCanceled();
                                    indicator.setFraction((double)this.progress++ / (double)total);
                                    indicator.setText2(this.currentRoot.relativize((Path)p).toString());
                                });
                            }
                            catch (IOException e) {
                                OldDirectoryCleaner.this.myLogger.info((Throwable)e);
                                errors.add((CallSite)((Object)(String.valueOf(directory) + " (" + IoErrorText.message((Throwable)e) + ")")));
                            }
                        }
                    }
                    if (!errors.isEmpty()) {
                        String content = String.join((CharSequence)"<br>", errors);
                        NotificationGroupManager.getInstance().getNotificationGroup("leftover.ide.directories").createNotification(IdeBundle.message((String)"old.dirs.delete.error", (Object[])new Object[0]), content, NotificationType.WARNING).addAction((AnAction)ShowLogAction.notificationAction()).notify(project);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/OldDirectoryCleaner$1", "run"));
                }
            }.queue();
        }
    }

    private /* synthetic */ void lambda$seekAndDestroy$1(Project project, List groups) {
        this.confirmAndDelete(project, groups);
    }

    @ApiStatus.Internal
    public static final class Stats
    extends CounterUsagesCollector {
        private static final EventLogGroup GROUP = new EventLogGroup("leftover.dirs", 1);
        private static final EventId SCHEDULED = GROUP.registerEvent("scan.scheduled");
        private static final EventId1<Integer> STARTED = GROUP.registerEvent("scan.started", (EventField)EventFields.Int((String)"delay_days"));
        private static final EventId2<Integer, Long> COMPLETE = GROUP.registerEvent("cleanup.complete", (EventField)EventFields.Int((String)"groups"), (EventField)EventFields.Long((String)"total_mb"));

        public EventLogGroup getGroup() {
            return GROUP;
        }

        public static void scheduled() {
            SCHEDULED.log();
        }

        public static void started(int actualDelayDays) {
            STARTED.log((Object)actualDelayDays);
        }

        public static void completed(int groups, long totalBytes) {
            COMPLETE.log((Object)groups, (Object)((totalBytes + 500000L) / 1000000L));
        }
    }

    private static final class StatsCollectingVisitor
    extends NioFiles.StatsCollectingVisitor {
        @Nullable
        private final ProgressIndicator indicator;
        long lastUpdated = 0L;
        long size = 0L;
        int entriesToDelete = 0;

        StatsCollectingVisitor(@Nullable ProgressIndicator indicator) {
            this.indicator = indicator;
        }

        protected void countDirectory(Path dir, BasicFileAttributes attrs) {
            if (this.indicator != null) {
                this.indicator.checkCanceled();
            }
            this.lastUpdated = Math.max(this.lastUpdated, attrs.lastModifiedTime().toMillis());
            ++this.entriesToDelete;
        }

        protected void countFile(Path file, BasicFileAttributes attrs) {
            if (this.indicator != null) {
                this.indicator.checkCanceled();
            }
            this.lastUpdated = Math.max(this.lastUpdated, attrs.lastModifiedTime().toMillis());
            this.size += attrs.size();
            ++this.entriesToDelete;
        }
    }

    private record DirectoryGroup(@NlsSafe String name, List<Path> directories, long lastUpdated, long size, int entriesToDelete, boolean isInstalled) {
        @Override
        public String toString() {
            return "{" + String.valueOf(this.directories) + " " + this.lastUpdated + "}";
        }
    }

    private static final class MenuDialog
    extends DialogWrapper {
        private final MenuTableModel myModel;

        MenuDialog(Project project, List<DirectoryGroup> groups) {
            super(project, false);
            this.myModel = new MenuTableModel(groups);
            this.setTitle(IdeBundle.message((String)"old.dirs.dialog.title", (Object[])new Object[0]));
            this.updateOkButton();
            this.init();
        }

        List<DirectoryGroup> getSelectedGroups() {
            return this.myModel.getSelectedGroups();
        }

        protected JComponent createCenterPanel() {
            JBTable table = new JBTable((TableModel)this.myModel);
            table.setShowGrid(false);
            table.getColumnModel().getColumn(0).setPreferredWidth(JBUI.scale((int)30));
            table.getColumnModel().getColumn(1).setPreferredWidth(JBUI.scale((int)300));
            table.getColumnModel().getColumn(2).setPreferredWidth(JBUI.scale((int)120));
            table.getColumnModel().getColumn(3).setPreferredWidth(JBUI.scale((int)120));
            final JBEmptyBorder border = JBUI.Borders.empty((int)0, (int)5);
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int col) {
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, selected, focused, row, col);
                    label.setBorder((Border)border);
                    label.setHorizontalAlignment(col == 1 ? 2 : 4);
                    if (row >= 0) {
                        DirectoryGroup group = myModel.myGroups.get(row);
                        if (col == 1) {
                            String paths = group.directories.stream().map(Path::toString).collect(Collectors.joining("<br>", "<html>", "</html>"));
                            label.setToolTipText(paths);
                        } else if (col == 2) {
                            String isoDate = FileTime.fromMillis(group.lastUpdated).toString();
                            label.setToolTipText(isoDate);
                        }
                    }
                    return label;
                }
            };
            table.getColumnModel().getColumn(1).setHeaderRenderer(renderer);
            table.getColumnModel().getColumn(1).setCellRenderer(renderer);
            table.getColumnModel().getColumn(2).setHeaderRenderer(renderer);
            table.getColumnModel().getColumn(2).setCellRenderer(renderer);
            table.getColumnModel().getColumn(3).setHeaderRenderer(renderer);
            table.getColumnModel().getColumn(3).setCellRenderer(renderer);
            this.myModel.addTableModelListener(e -> this.updateOkButton());
            JPanel panel = new JPanel(new BorderLayout(0, JBUI.scale((int)5)));
            panel.add((Component)new JBLabel(IdeBundle.message((String)"old.dirs.dialog.text", (Object[])new Object[0])), "North");
            JBScrollPane tableScroll = new JBScrollPane((Component)table);
            table.setFillsViewportHeight(true);
            panel.add((Component)tableScroll, "Center");
            return panel;
        }

        private void updateOkButton() {
            int n = this.myModel.mySelected.cardinality();
            this.setOKButtonText(IdeBundle.message((String)"old.dirs.dialog.delete.button", (Object[])new Object[]{n}));
            this.setOKActionEnabled(n > 0);
        }

        private static final class MenuTableModel
        extends AbstractTableModel {
            private final List<DirectoryGroup> myGroups;
            private final BitSet mySelected = new BitSet();
            @PropertyKey(resourceBundle="messages.IdeBundle")
            private final @PropertyKey(resourceBundle="messages.IdeBundle") String[] myColumnNames = new String[]{"old.dirs.column.name", "old.dirs.column.updated", "old.dirs.column.size"};
            private final long myNow = System.currentTimeMillis();

            MenuTableModel(List<DirectoryGroup> groups) {
                this.myGroups = groups;
                for (int i = 0; i < groups.size(); ++i) {
                    this.mySelected.set(i, !groups.get((int)i).isInstalled);
                }
            }

            List<DirectoryGroup> getSelectedGroups() {
                return IntStream.range(0, this.myGroups.size()).filter(this.mySelected::get).mapToObj(this.myGroups::get).collect(Collectors.toList());
            }

            @Override
            public int getRowCount() {
                return this.myGroups.size();
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public String getColumnName(int column) {
                return column == 0 ? "" : IdeBundle.message((String)this.myColumnNames[column - 1], (Object[])new Object[0]);
            }

            @Override
            public Class<?> getColumnClass(int column) {
                return column == 0 ? Boolean.class : String.class;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return switch (column) {
                    case 0 -> this.mySelected.get(row);
                    case 1 -> this.myGroups.get((int)row).name;
                    case 2 -> DateFormatUtil.formatBetweenDates((long)this.myGroups.get((int)row).lastUpdated, (long)this.myNow);
                    case 3 -> Formats.formatFileSize((long)this.myGroups.get((int)row).size);
                    default -> null;
                };
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                this.mySelected.set(row, (Boolean)value);
                this.fireTableCellUpdated(row, column);
            }
        }
    }
}

