/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.intellij.ide.ui.search.PorterStemmerUtil;
import com.intellij.util.text.NameUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0016B?\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0010\u001a\u00020\bJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/internal/ml/WordsSplitter;", "", "skipLess", "", "ignoreStopWords", "", "stopWords", "", "", "maxWords", "withStemming", "toLowerCase", "<init>", "(IZLjava/util/Set;IZZ)V", "split", "", "name", "wordsFromName", "", "normalize", "word", "shouldInclude", "Builder", "intellij.platform.ide.internal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWordsSplitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WordsSplitter.kt\ncom/intellij/internal/ml/WordsSplitter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,94:1\n774#2:95\n865#2,2:96\n1563#2:98\n1634#2,3:99\n1#3:102\n1069#4,2:103\n*S KotlinDebug\n*F\n+ 1 WordsSplitter.kt\ncom/intellij/internal/ml/WordsSplitter\n*L\n18#1:95\n18#1:96,2\n20#1:98\n20#1:99,3\n44#1:103,2\n*E\n"})
public final class WordsSplitter {
    private final int skipLess;
    private final boolean ignoreStopWords;
    @NotNull
    private final Set<String> stopWords;
    private final int maxWords;
    private final boolean withStemming;
    private final boolean toLowerCase;

    private WordsSplitter(int skipLess, boolean ignoreStopWords, Set<String> stopWords, int maxWords, boolean withStemming, boolean toLowerCase) {
        this.skipLess = skipLess;
        this.ignoreStopWords = ignoreStopWords;
        this.stopWords = stopWords;
        this.maxWords = maxWords;
        this.withStemming = withStemming;
        this.toLowerCase = toLowerCase;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> split(@NotNull String name) {
        void $this$mapTo$iv$iv;
        String p0;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable<String> $this$filter$iv = this.wordsFromName(name);
        boolean $i$f$filter = false;
        Iterable<String> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            p0 = (String)element$iv$iv;
            boolean bl = false;
            if (!this.shouldInclude(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)this.maxWords);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.normalize(p0));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final Iterable<String> wordsFromName(String name) {
        return new Iterable<String>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            public Iterator<String> iterator() {
                return new Iterator<String>(this.$name){
                    private int start;
                    final /* synthetic */ String $name;
                    {
                        this.$name = $name;
                    }

                    public final int getStart() {
                        return this.start;
                    }

                    public final void setStart(int n) {
                        this.start = n;
                    }

                    public boolean hasNext() {
                        return this.start < this.$name.length();
                    }

                    public String next() {
                        int next = NameUtilCore.nextWord((String)this.$name, (int)this.start);
                        String string = this.$name.substring(this.start, next);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String word = string;
                        this.start = next;
                        return word;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final String normalize(String word) {
        String string;
        String string2;
        String it = word;
        boolean bl = false;
        if (this.toLowerCase) {
            String string3 = it;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string4 = string3.toLowerCase(locale);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        } else {
            string2 = it;
        }
        it = string2;
        boolean bl2 = false;
        if (this.withStemming) {
            string = PorterStemmerUtil.stem((String)it);
            if (string == null) {
                string = it;
            }
        } else {
            void var2_2;
            string = var2_2;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldInclude(String word) {
        if (StringsKt.isBlank((CharSequence)word)) return false;
        boolean bl = true;
        if (!bl) return false;
        CharSequence $this$all$iv = word;
        boolean $i$f$all = false;
        for (int i = 0; i < $this$all$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(i);
            boolean bl2 = false;
            if (Character.isLetter(it)) continue;
            return false;
        }
        boolean bl3 = true;
        if (!bl3) return false;
        if (word.length() < this.skipLess) return false;
        if (!this.ignoreStopWords) return true;
        if (this.stopWords.contains(word)) return false;
        return true;
    }

    public /* synthetic */ WordsSplitter(int skipLess, boolean ignoreStopWords, Set stopWords, int maxWords, boolean withStemming, boolean toLowerCase, DefaultConstructorMarker $constructor_marker) {
        this(skipLess, ignoreStopWords, stopWords, maxWords, withStemming, toLowerCase);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0007\u001a\u00020\u00002\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0006\u001a\u00020\u0000J\u0006\u0010\u0004\u001a\u00020\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/ml/WordsSplitter$Builder;", "", "<init>", "()V", "toLowerCase", "", "withStemming", "ignoreStopWords", "stopWords", "", "", "skipLess", "", "maxWords", "build", "Lcom/intellij/internal/ml/WordsSplitter;", "", "skipShort", "count", "Companion", "intellij.platform.ide.internal"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean toLowerCase;
        private boolean withStemming;
        private boolean ignoreStopWords;
        @NotNull
        private Set<String> stopWords = DEFAULT_STOP_WORDS;
        private int skipLess;
        private int maxWords = Integer.MAX_VALUE;
        @NotNull
        private static final Set<String> DEFAULT_STOP_WORDS;
        private static final int DEFAULT_MAX_WORDS_COUNT = 7;
        private static final int DEFAULT_MIN_WORD_LENGTH = 3;

        @NotNull
        public final WordsSplitter build() {
            return new WordsSplitter(this.skipLess, this.ignoreStopWords, this.stopWords, this.maxWords, this.withStemming, this.toLowerCase, null);
        }

        @NotNull
        public final Builder ignoreStopWords(@Nullable Iterable<String> stopWords) {
            Builder builder;
            Builder $this$ignoreStopWords_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$ignoreStopWords_u24lambda_u240.ignoreStopWords = true;
            if (stopWords != null) {
                $this$ignoreStopWords_u24lambda_u240.stopWords = CollectionsKt.toSet(stopWords);
            }
            return builder;
        }

        public static /* synthetic */ Builder ignoreStopWords$default(Builder builder, Iterable iterable, int n, Object object) {
            if ((n & 1) != 0) {
                iterable = null;
            }
            return builder.ignoreStopWords(iterable);
        }

        @NotNull
        public final Builder skipShort(int skipLess) {
            Builder builder;
            Builder $this$skipShort_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$skipShort_u24lambda_u240.skipLess = skipLess;
            return builder;
        }

        public static /* synthetic */ Builder skipShort$default(Builder builder, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 3;
            }
            return builder.skipShort(n);
        }

        @NotNull
        public final Builder maxWords(int count) {
            Builder builder;
            Builder $this$maxWords_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$maxWords_u24lambda_u240.maxWords = count;
            return builder;
        }

        public static /* synthetic */ Builder maxWords$default(Builder builder, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 7;
            }
            return builder.maxWords(n);
        }

        @NotNull
        public final Builder withStemming() {
            Builder builder;
            Builder $this$withStemming_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$withStemming_u24lambda_u240.withStemming = true;
            return builder;
        }

        @NotNull
        public final Builder toLowerCase() {
            Builder builder;
            Builder $this$toLowerCase_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$toLowerCase_u24lambda_u240.toLowerCase = true;
            return builder;
        }

        static {
            Object[] objectArray = new String[]{"set", "get", "is"};
            DEFAULT_STOP_WORDS = SetsKt.setOf((Object[])objectArray);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/ml/WordsSplitter$Builder$Companion;", "", "<init>", "()V", "DEFAULT_STOP_WORDS", "", "", "DEFAULT_MAX_WORDS_COUNT", "", "DEFAULT_MIN_WORD_LENGTH", "identifiers", "Lcom/intellij/internal/ml/WordsSplitter$Builder;", "intellij.platform.ide.internal"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Builder identifiers() {
                return new Builder().skipShort(3).ignoreStopWords(DEFAULT_STOP_WORDS).maxWords(7).toLowerCase();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

