/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.cases;

import com.intellij.internal.jcef.test.cases.CefProcess;
import com.intellij.internal.jcef.test.cases.PlotlyChart;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u00a8\u0006\u0002"}, d2={"showCpuUsage", "", "intellij.platform.ide.internal"})
public final class CpuUsageKt {
    public static final void showCpuUsage() {
        SwingUtilities.invokeLater(CpuUsageKt::showCpuUsage$lambda$0);
    }

    private static final void showCpuUsage$lambda$0() {
        JFrame frame = new JFrame("JCEF CPU Usage");
        PlotlyChart chart = new PlotlyChart();
        frame.add(chart.getComponent());
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
        frame.setSize(800, 600);
        frame.addWindowListener(new WindowAdapter(chart){
            final /* synthetic */ PlotlyChart $chart;
            {
                this.$chart = $chart;
            }

            public void windowClosing(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Disposer.dispose((Disposable)this.$chart);
            }
        });
        CefProcess cefProcesses = new CefProcess();
        Map traceIndexes = new LinkedHashMap();
        Ref.IntRef nextTraceIndex = new Ref.IntRef();
        nextTraceIndex.element = 1;
        long startTime = System.currentTimeMillis();
        PlotlyChart.newPlot$default(chart, "[\n  {\n    x: [],\n    y: [],\n    mode: 'lines',\n    name: 'Total',\n    line: { color: 'rgba(255, 99, 132, 1)' },\n  }\n]", "        {\n          title: 'CPU Usage',\n          xaxis: { title: 'Time, s' },\n          yaxis: { title: 'CPU usage, %' },\n          showlegend: true,\n          legend: {\n            orientation: 'h',\n            y: -0.2,\n            x: 0.5,\n            xanchor: 'center',\n          },\n          dragmode: 'pan',\n        }", null, 4, null);
        Timer timer = new Timer(1000, arg_0 -> CpuUsageKt.showCpuUsage$lambda$0$0(cefProcesses, startTime, traceIndexes, nextTraceIndex, chart, arg_0));
        timer.setRepeats(true);
        timer.start();
    }

    private static final void showCpuUsage$lambda$0$0(CefProcess $cefProcesses, long $startTime, Map $traceIndexes, Ref.IntRef $nextTraceIndex, PlotlyChart $chart, ActionEvent it) {
        List<CefProcess.ProcessInfo> processes = $cefProcesses.getProcesses();
        double total = 0.0;
        double timeNow = (double)(System.currentTimeMillis() - $startTime) / 1000.0;
        for (CefProcess.ProcessInfo process : processes) {
            if (process.getCpuUsage() == null) continue;
            total += process.getCpuUsage().doubleValue();
            if (!$traceIndexes.containsKey(process.getPid())) {
                Map map = $traceIndexes;
                Long l = process.getPid();
                int n = $nextTraceIndex.element;
                $nextTraceIndex.element = n + 1;
                Integer n2 = n;
                map.put(l, n2);
                $chart.addTraces(StringsKt.trimIndent((String)("\n              {\n                x: [" + timeNow + "],\n                y: [" + process.getCpuUsage() + "],\n                mode: 'lines',\n                name: '" + process.getProcessType() + "(" + process.getPid() + ")'\n              }\n            ")));
                continue;
            }
            $chart.extendTraces(StringsKt.trimIndent((String)("\n              {\n                x: [[" + timeNow + "]],\n                y: [[" + process.getCpuUsage() + "]]\n              }\n          ")), "[" + $traceIndexes.get(process.getPid()) + "]");
        }
        $chart.extendTraces(StringsKt.trimIndent((String)("\n          {\n            x: [[" + timeNow + "]],\n            y: [[" + total + "]]\n          }\n        ")), "[0]");
    }
}

