/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class EditorColorSchemesUsagesCollector
extends ApplicationUsagesCollector {
    private static final int CURR_VERSION = 8;
    public static final String SCHEME_NAME_OTHER = "Other";
    public static final String[] KNOWN_NAMES = new String[]{"Default", "Darcula Contrast", "Darcula", "Obsidian", "Visual Studio", "Solarized", "Wombat", "Monokai", "XCode", "Sublime", "Oblivion", "Zenburn", "Cobalt", "Netbeans", "Eclipse", "Aptana", "Flash Builder", "IdeaLight", "High contrast", "ReSharper", "Rider", "IntelliJ Light", "Light", "Dark", "Other"};
    private static final EventLogGroup GROUP = new EventLogGroup("ui.editor.color.schemes", 8);
    private static final EventId2<String, Boolean> COLOR_SCHEME = GROUP.registerEvent("enabled.color.scheme", (EventField)EventFields.String((String)"scheme", List.of(KNOWN_NAMES)), (EventField)EventFields.Boolean((String)"is_dark"));

    EditorColorSchemesUsagesCollector() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        EditorColorsScheme currentScheme = EditorColorsManager.getInstance().getGlobalScheme();
        HashSet<MetricEvent> usages = new HashSet<MetricEvent>();
        if (currentScheme instanceof AbstractColorsScheme) {
            AbstractColorsScheme original;
            String schemeName = currentScheme.getName();
            if (schemeName.startsWith("_@user_") && (original = ((AbstractColorsScheme)currentScheme).getOriginal()) != null) {
                schemeName = original.getName();
            }
            String scheme = EditorColorSchemesUsagesCollector.getKnownSchemeName(schemeName);
            boolean isDark = ColorUtil.isDark((Color)currentScheme.getDefaultBackground());
            usages.add(COLOR_SCHEME.metric((Object)scheme, (Object)isDark));
        }
        HashSet<MetricEvent> hashSet = usages;
        if (hashSet == null) {
            EditorColorSchemesUsagesCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    private static String getKnownSchemeName(@NonNls @NotNull String schemeName) {
        if (schemeName == null) {
            EditorColorSchemesUsagesCollector.$$$reportNull$$$0(1);
        }
        for (String knownName : KNOWN_NAMES) {
            if (!StringUtil.toUpperCase((String)schemeName).contains(StringUtil.toUpperCase((String)knownName))) continue;
            String string = knownName;
            if (string == null) {
                EditorColorSchemesUsagesCollector.$$$reportNull$$$0(2);
            }
            return string;
        }
        return SCHEME_NAME_OTHER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/ui/EditorColorSchemesUsagesCollector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/ui/EditorColorSchemesUsagesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownSchemeName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getKnownSchemeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

