/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.GotItComponentBuilder;
import com.intellij.ui.GotItTextBuilder;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.WebAnimationUtils;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextAreaKt;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/ui/ShowGotItDemoAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "GotItConfigurationDialog", "intellij.platform.ide.internal"})
final class ShowGotItDemoAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        Object object = e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent component = (JComponent)object;
        new GotItConfigurationDialog(project2, component).showAndGet();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getProject() != null && e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) instanceof JComponent);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010*\u001a\u00020\u0005H\u0014J\b\u0010+\u001a\u00020,H\u0014J\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00062"}, d2={"Lcom/intellij/internal/ui/ShowGotItDemoAction$GotItConfigurationDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "component", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/JComponent;)V", "text", "", "addInlineLinks", "", "showImageOrLottie", "showImage", "imageWidth", "", "imageHeight", "showLottieAnimation", "lottieJsonPath", "withImageBorder", "showIconOrStep", "showIcon", "showStepNumber", "stepText", "showHeader", "headerText", "showLink", "actionLink", "actionLinkText", "browserLink", "browserLinkText", "showButton", "showSecondaryButton", "secondaryButtonText", "useContrastColors", "useContrastButton", "positionsModel", "Ljavax/swing/ComboBoxModel;", "Lcom/intellij/openapi/ui/popup/Balloon$Position;", "position", "getPosition", "()Lcom/intellij/openapi/ui/popup/Balloon$Position;", "createCenterPanel", "doOKAction", "", "buildGotItTooltip", "Lcom/intellij/ui/GotItTooltip;", "createTestImage", "Ljavax/swing/Icon;", "Companion", "intellij.platform.ide.internal"})
    private static final class GotItConfigurationDialog
    extends DialogWrapper {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Project project;
        @NotNull
        private final JComponent component;
        @NotNull
        private String text;
        private boolean addInlineLinks;
        private boolean showImageOrLottie;
        private boolean showImage;
        private int imageWidth;
        private int imageHeight;
        private boolean showLottieAnimation;
        @NotNull
        private String lottieJsonPath;
        private boolean withImageBorder;
        private boolean showIconOrStep;
        private boolean showIcon;
        private boolean showStepNumber;
        @NotNull
        private String stepText;
        private boolean showHeader;
        @NotNull
        private String headerText;
        private boolean showLink;
        private boolean actionLink;
        @NotNull
        private String actionLinkText;
        private boolean browserLink;
        @NotNull
        private String browserLinkText;
        private boolean showButton;
        private boolean showSecondaryButton;
        @NotNull
        private String secondaryButtonText;
        private boolean useContrastColors;
        private boolean useContrastButton;
        @NotNull
        private final ComboBoxModel<Balloon.Position> positionsModel;
        @NotNull
        private static final String LAST_OPENED_LOTTIE_FILE = "LAST_OPENED_LOTTIE_FILE";

        public GotItConfigurationDialog(@NotNull Project project, @NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            super(project, false);
            this.project = project;
            this.component = component;
            this.text = "This is the Debug tool window. Code element example: <code>cLodlpe ja</code>.\nHere, you can use various actions like <shortcut actionId=\"GotoAction\"/>,\n<b>Resume</b> <icon src=\"AllIcons.Actions.Resume\"/>, \nand <b>Stop</b> <icon src=\"AllIcons.Actions.Suspend\"/>.";
            this.addInlineLinks = true;
            this.showImage = true;
            this.imageWidth = JBUI.scale((int)248);
            this.imageHeight = JBUI.scale((int)132);
            String string = PropertiesComponent.getInstance().getValue(LAST_OPENED_LOTTIE_FILE, "");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            this.lottieJsonPath = string;
            this.withImageBorder = true;
            this.showIconOrStep = true;
            this.showIcon = true;
            this.stepText = "01";
            this.showHeader = true;
            this.headerText = "Some GotIt tooltip header";
            this.actionLink = true;
            this.actionLinkText = "Open Project tool window";
            this.browserLinkText = "Open IDE web help";
            this.showButton = true;
            this.secondaryButtonText = "Skip All";
            this.positionsModel = new DefaultComboBoxModel<Balloon.Position>(Balloon.Position.values());
            this.setTitle("GotIt Configuration");
            this.init();
        }

        private final Balloon.Position getPosition() {
            Object object = this.positionsModel.getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.openapi.ui.popup.Balloon.Position");
            return (Balloon.Position)object;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)BuilderKt.panel(arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0(this, arg_0));
        }

        protected void doOKAction() {
            super.doOKAction();
            GotItTooltip gotIt = this.buildGotItTooltip();
            Function2 point = switch (WhenMappings.$EnumSwitchMapping$0[this.getPosition().ordinal()]) {
                case 1 -> GotItTooltip.BOTTOM_MIDDLE;
                case 2 -> GotItTooltip.TOP_MIDDLE;
                case 3 -> GotItTooltip.LEFT_MIDDLE;
                case 4 -> GotItTooltip.RIGHT_MIDDLE;
                default -> throw new NoWhenBranchMatchedException();
            };
            gotIt.show(this.component, point);
        }

        private final GotItTooltip buildGotItTooltip() {
            Object htmlPage;
            Icon icon = AllIcons.General.BalloonInformation;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BalloonInformation");
            Icon icon2 = icon;
            Icon image = this.createTestImage();
            Function1 textSupplier = arg_0 -> GotItConfigurationDialog.buildGotItTooltip$lambda$0(this, arg_0);
            GotItComponentBuilder gotItBuilder = new GotItComponentBuilder(textSupplier);
            if (this.showImageOrLottie && this.showImage) {
                gotItBuilder.withImage(image, this.withImageBorder);
            }
            if (this.showImageOrLottie && this.showLottieAnimation && ((CharSequence)this.lottieJsonPath).length() > 0) {
                String lottieJson = FilesKt.readText$default((File)new File(this.lottieJsonPath), null, (int)1, null);
                Color color = JBUI.CurrentTheme.GotItTooltip.animationBackground((boolean)false);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"animationBackground(...)");
                htmlPage = WebAnimationUtils.INSTANCE.createLottieAnimationPage(lottieJson, null, color);
                Dimension size = WebAnimationUtils.INSTANCE.getLottieImageSize(lottieJson);
                gotItBuilder.withBrowserPage((String)htmlPage, size, this.withImageBorder);
                PropertiesComponent.getInstance().setValue(LAST_OPENED_LOTTIE_FILE, this.lottieJsonPath);
            }
            if (this.showIconOrStep && this.showIcon) {
                gotItBuilder.withIcon(icon2);
            }
            if (this.showIconOrStep && this.showStepNumber) {
                gotItBuilder.withStepNumber(this.stepText);
            }
            if (this.showHeader) {
                gotItBuilder.withHeader(this.headerText);
            }
            if (this.showLink && this.actionLink) {
                gotItBuilder.withLink(this.actionLinkText, () -> GotItConfigurationDialog.buildGotItTooltip$lambda$1(this));
            }
            if (this.showLink && this.browserLink) {
                gotItBuilder.withBrowserLink(this.browserLinkText, new URL("https://www.jetbrains.com/help/idea/getting-started.html"));
            }
            gotItBuilder.showButton(this.showButton);
            if (this.showButton && this.showSecondaryButton) {
                gotItBuilder.withSecondaryButton(this.secondaryButtonText, GotItConfigurationDialog::buildGotItTooltip$lambda$2);
            }
            gotItBuilder.withContrastColors(this.useContrastColors).withContrastButton(this.useContrastButton);
            htmlPage = RandomKt.Random((long)System.currentTimeMillis()).nextBytes(32);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            String randomId = new String((byte[])htmlPage, charset2);
            GotItTooltip gotIt = new GotItTooltip(randomId, gotItBuilder, Disposer.newDisposable());
            gotIt.withPosition(this.getPosition());
            return gotIt;
        }

        private final Icon createTestImage() {
            return new Icon(this){
                final /* synthetic */ GotItConfigurationDialog this$0;
                {
                    this.this$0 = $receiver;
                }

                public int getIconWidth() {
                    return GotItConfigurationDialog.access$getImageWidth$p(this.this$0);
                }

                public int getIconHeight() {
                    return GotItConfigurationDialog.access$getImageHeight$p(this.this$0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Graphics graphics = g.create();
                    Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    Graphics2D g2d = (Graphics2D)graphics;
                    try {
                        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        float arcSize = JBUIScale.scale((int)8);
                        RoundRectangle2D.Float rect = new RoundRectangle2D.Float(x, y, this.getIconWidth(), this.getIconHeight(), arcSize, arcSize);
                        g2d.setColor(Color.lightGray);
                        g2d.draw(rect);
                        LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)0.0, (double)this.getIconWidth(), (double)this.getIconHeight());
                        LinePainter2D.paint((Graphics2D)g2d, (double)this.getIconWidth(), (double)0.0, (double)0.0, (double)this.getIconHeight());
                    }
                    finally {
                        g2d.dispose();
                    }
                }
            };
        }

        private static final Unit createCenterPanel$lambda$0(GotItConfigurationDialog this$0, Panel $this$panel) {
            Cell cell;
            Cell cell2;
            Cell cell3;
            Cell cell4;
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            Panel.row$default((Panel)$this$panel, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$0(this$0, arg_0), (int)1, null);
            Ref.ObjectRef contrastColorsCheckbox = new Ref.ObjectRef();
            Panel.row$default((Panel)$this$panel, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$1(contrastColorsCheckbox, this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$2(this$0, contrastColorsCheckbox, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$3(this$0, contrastColorsCheckbox, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$4(this$0, arg_0), (int)1, null);
            Ref.ObjectRef imageOrLottieCheckbox = new Ref.ObjectRef();
            Panel.row$default((Panel)$this$panel, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$5(imageOrLottieCheckbox, this$0, arg_0), (int)1, null);
            ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)true, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$6(this$0, imageOrLottieCheckbox, arg_0), (int)1, null);
            if (imageOrLottieCheckbox.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageOrLottieCheckbox");
                cell4 = null;
            } else {
                cell4 = (Cell)imageOrLottieCheckbox.element;
            }
            buttonsGroup.enabledIf(ButtonKt.getSelected((Cell)cell4));
            Ref.ObjectRef iconOrStepCheckbox = new Ref.ObjectRef();
            Panel.row$default((Panel)$this$panel, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$7(iconOrStepCheckbox, this$0, arg_0), (int)1, null);
            ButtonsGroup buttonsGroup2 = Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)true, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$8(this$0, arg_0), (int)1, null);
            if (iconOrStepCheckbox.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"iconOrStepCheckbox");
                cell3 = null;
            } else {
                cell3 = (Cell)iconOrStepCheckbox.element;
            }
            buttonsGroup2.enabledIf(ButtonKt.getSelected((Cell)cell3));
            Ref.ObjectRef linkCheckbox = new Ref.ObjectRef();
            Panel.row$default((Panel)$this$panel, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$9(linkCheckbox, this$0, arg_0), (int)1, null);
            ButtonsGroup buttonsGroup3 = Panel.buttonsGroup$default((Panel)$this$panel, null, (boolean)true, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$10(this$0, arg_0), (int)1, null);
            if (linkCheckbox.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"linkCheckbox");
                cell2 = null;
            } else {
                cell2 = (Cell)linkCheckbox.element;
            }
            buttonsGroup3.enabledIf(ButtonKt.getSelected((Cell)cell2));
            Ref.ObjectRef buttonCheckbox = new Ref.ObjectRef();
            Panel.row$default((Panel)$this$panel, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$11(buttonCheckbox, this$0, arg_0), (int)1, null);
            Row row = Panel.row$default((Panel)$this$panel, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$12(this$0, arg_0), (int)1, null);
            if (buttonCheckbox.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buttonCheckbox");
                cell = null;
            } else {
                cell = (Cell)buttonCheckbox.element;
            }
            row.enabledIf(ButtonKt.getSelected((Cell)cell));
            $this$panel.row("Position:", arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$13(this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$0(GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            TextFieldKt.bindText((Cell)TextAreaKt.columns((Cell)Cell.label$default((Cell)$this$row.textArea(), (String)"Text:", null, (int)2, null), (int)36), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getText$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setText$p((GotItConfigurationDialog)((Object)this.receiver), (String)value);
                }
            })).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$1(Ref.ObjectRef $contrastColorsCheckbox, GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $contrastColorsCheckbox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox("Use contrast colors"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getUseContrastColors$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setUseContrastColors$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$2(GotItConfigurationDialog this$0, Ref.ObjectRef $contrastColorsCheckbox, Row $this$row) {
            Cell cell;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell cell2 = ButtonKt.bindSelected((Cell)$this$row.checkBox("Use contrast button"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getUseContrastButton$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setUseContrastButton$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            if ($contrastColorsCheckbox.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contrastColorsCheckbox");
                cell = null;
            } else {
                cell = (Cell)$contrastColorsCheckbox.element;
            }
            cell2.enabledIf(ComponentPredicateKt.not((ComponentPredicate)ButtonKt.getSelected((Cell)cell)));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$3(GotItConfigurationDialog this$0, Ref.ObjectRef $contrastColorsCheckbox, Row $this$row) {
            Cell cell;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell cell2 = ButtonKt.bindSelected((Cell)$this$row.checkBox("Add inline links to text"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getAddInlineLinks$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setAddInlineLinks$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            if ($contrastColorsCheckbox.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contrastColorsCheckbox");
                cell = null;
            } else {
                cell = (Cell)$contrastColorsCheckbox.element;
            }
            cell2.enabledIf(ComponentPredicateKt.not((ComponentPredicate)ButtonKt.getSelected((Cell)cell)));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$4(GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell checkbox2 = ButtonKt.bindSelected((Cell)$this$row.checkBox("Header:"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getShowHeader$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setShowHeader$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getHeaderText$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setHeaderText$p((GotItConfigurationDialog)((Object)this.receiver), (String)value);
                }
            })).enabledIf(ButtonKt.getSelected((Cell)checkbox2)).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$5(Ref.ObjectRef $imageOrLottieCheckbox, GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $imageOrLottieCheckbox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox("Image or Lottie animation:"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getShowImageOrLottie$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setShowImageOrLottie$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$6(GotItConfigurationDialog this$0, Ref.ObjectRef $imageOrLottieCheckbox, Panel $this$buttonsGroup) {
            Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$6$0(this$0, $imageOrLottieCheckbox, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$6$1(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$6$2(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$6$0(GotItConfigurationDialog this$0, Ref.ObjectRef $imageOrLottieCheckbox, Row $this$row) {
            Cell cell;
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell cell2 = ButtonKt.bindSelected((Cell)$this$row.checkBox("With border"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getWithImageBorder$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setWithImageBorder$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            if ($imageOrLottieCheckbox.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageOrLottieCheckbox");
                cell = null;
            } else {
                cell = (Cell)$imageOrLottieCheckbox.element;
            }
            cell2.enabledIf(ButtonKt.getSelected((Cell)cell));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$6$1(GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell button2 = ButtonKt.bindSelected((Cell)Row.radioButton$default((Row)$this$row, (String)"Image", null, (int)2, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getShowImage$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setShowImage$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            TextFieldKt.bindIntText((Cell)Cell.label$default((Cell)Row.intTextField$default((Row)$this$row, (IntRange)new IntRange(JBUI.scale((int)100), JBUI.scale((int)500)), null, (int)2, null), (String)"Width:", null, (int)2, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getImageWidth$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setImageWidth$p((GotItConfigurationDialog)((Object)this.receiver), ((Number)value).intValue());
                }
            })).enabledIf(ButtonKt.getSelected((Cell)button2));
            TextFieldKt.bindIntText((Cell)Cell.label$default((Cell)Row.intTextField$default((Row)$this$row, (IntRange)new IntRange(JBUI.scale((int)50), JBUI.scale((int)300)), null, (int)2, null), (String)"Height:", null, (int)2, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getImageHeight$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setImageHeight$p((GotItConfigurationDialog)((Object)this.receiver), ((Number)value).intValue());
                }
            })).enabledIf(ButtonKt.getSelected((Cell)button2));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$6$2(GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell button2 = ButtonKt.bindSelected((Cell)Row.radioButton$default((Row)$this$row, (String)"Lottie", null, (int)2, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getShowLottieAnimation$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setShowLottieAnimation$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            Project project = this$0.project;
            FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"json");
            Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFileDescriptor(...)");
            FileChooserDescriptor fileChooserDescriptor2 = fileChooserDescriptor;
            TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)fileChooserDescriptor2, (Project)project, null, (int)4, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getLottieJsonPath$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setLottieJsonPath$p((GotItConfigurationDialog)((Object)this.receiver), (String)value);
                }
            })).align((Align)AlignX.FILL.INSTANCE).enabledIf(ButtonKt.getSelected((Cell)button2));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$7(Ref.ObjectRef $iconOrStepCheckbox, GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $iconOrStepCheckbox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox("Icon or Step Number:"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getShowIconOrStep$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setShowIconOrStep$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$8(GotItConfigurationDialog this$0, Panel $this$buttonsGroup) {
            Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$8$0(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$8$1(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$8$0(GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell button2 = ButtonKt.bindSelected((Cell)Row.radioButton$default((Row)$this$row, (String)"Step number:", null, (int)2, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getShowStepNumber$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setShowStepNumber$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getStepText$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setStepText$p((GotItConfigurationDialog)((Object)this.receiver), (String)value);
                }
            })).enabledIf(ButtonKt.getSelected((Cell)button2));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$8$1(GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            ButtonKt.bindSelected((Cell)Row.radioButton$default((Row)$this$row, (String)"Icon", null, (int)2, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getShowIcon$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setShowIcon$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$9(Ref.ObjectRef $linkCheckbox, GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $linkCheckbox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox("Link:"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getShowLink$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setShowLink$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$10(GotItConfigurationDialog this$0, Panel $this$buttonsGroup) {
            Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$10$0(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> GotItConfigurationDialog.createCenterPanel$lambda$0$10$1(this$0, arg_0), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final void createCenterPanel$lambda$0$10$radioButtonWithTextField(Row $this$createCenterPanel_u24lambda_u240_u2410_u24radioButtonWithTextField, String name, KMutableProperty0<Boolean> showProperty, KMutableProperty0<String> textProperty) {
            Cell button2 = ButtonKt.bindSelected((Cell)Row.radioButton$default((Row)$this$createCenterPanel_u24lambda_u240_u2410_u24radioButtonWithTextField, (String)name, null, (int)2, null), showProperty);
            TextFieldKt.bindText((Cell)$this$createCenterPanel_u24lambda_u240_u2410_u24radioButtonWithTextField.textField(), textProperty).enabledIf(ButtonKt.getSelected((Cell)button2)).align((Align)AlignX.FILL.INSTANCE);
        }

        private static final Unit createCenterPanel$lambda$0$10$0(GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            GotItConfigurationDialog.createCenterPanel$lambda$0$10$radioButtonWithTextField($this$row, "Action:", (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getActionLink$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setActionLink$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }), (KMutableProperty0<String>)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getActionLinkText$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setActionLinkText$p((GotItConfigurationDialog)((Object)this.receiver), (String)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$10$1(GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            GotItConfigurationDialog.createCenterPanel$lambda$0$10$radioButtonWithTextField($this$row, "Browser:", (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getBrowserLink$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setBrowserLink$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }), (KMutableProperty0<String>)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getBrowserLinkText$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setBrowserLinkText$p((GotItConfigurationDialog)((Object)this.receiver), (String)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$11(Ref.ObjectRef $buttonCheckbox, GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $buttonCheckbox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox("GotIt button"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getShowButton$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setShowButton$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$12(GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell checkbox2 = ButtonKt.bindSelected((Cell)$this$row.checkBox("Secondary button:"), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getShowSecondaryButton$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setShowSecondaryButton$p((GotItConfigurationDialog)((Object)this.receiver), (Boolean)value);
                }
            }));
            TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

                public Object get() {
                    return GotItConfigurationDialog.access$getSecondaryButtonText$p((GotItConfigurationDialog)((Object)this.receiver));
                }

                public void set(Object value) {
                    GotItConfigurationDialog.access$setSecondaryButtonText$p((GotItConfigurationDialog)((Object)this.receiver), (String)value);
                }
            })).enabledIf(ButtonKt.getSelected((Cell)checkbox2)).align((Align)AlignX.FILL.INSTANCE);
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$0$13(GotItConfigurationDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Row.comboBox$default((Row)$this$row, this$0.positionsModel, null, (int)2, null);
            return Unit.INSTANCE;
        }

        private static final String buildGotItTooltip$lambda$0(GotItConfigurationDialog this$0, GotItTextBuilder gotItTextBuilder) {
            String string;
            Intrinsics.checkNotNullParameter((Object)gotItTextBuilder, (String)"<this>");
            if (this$0.addInlineLinks && !this$0.useContrastColors) {
                StringBuilder stringBuilder;
                StringBuilder $this$buildGotItTooltip_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                $this$buildGotItTooltip_u24lambda_u240_u240.append(this$0.text);
                $this$buildGotItTooltip_u24lambda_u240_u240.append(" ");
                $this$buildGotItTooltip_u24lambda_u240_u240.append(gotItTextBuilder.link("Click", () -> GotItConfigurationDialog.buildGotItTooltip$lambda$0$0$0(this$0)));
                $this$buildGotItTooltip_u24lambda_u240_u240.append(" to open the Project tool window, or ");
                $this$buildGotItTooltip_u24lambda_u240_u240.append(gotItTextBuilder.browserLink("open", new URL("https://www.jetbrains.com/help/idea/getting-started.html")));
                $this$buildGotItTooltip_u24lambda_u240_u240.append(" IDE help.");
                string = stringBuilder.toString();
            } else {
                string = this$0.text;
            }
            return string;
        }

        private static final Unit buildGotItTooltip$lambda$0$0$0(GotItConfigurationDialog this$0) {
            block0: {
                ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("Project");
                if (toolWindow == null) break block0;
                toolWindow.show();
            }
            return Unit.INSTANCE;
        }

        private static final Unit buildGotItTooltip$lambda$1(GotItConfigurationDialog this$0) {
            block0: {
                ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("Project");
                if (toolWindow == null) break block0;
                toolWindow.show();
            }
            return Unit.INSTANCE;
        }

        private static final Unit buildGotItTooltip$lambda$2() {
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ int access$getImageWidth$p(GotItConfigurationDialog $this) {
            return $this.imageWidth;
        }

        public static final /* synthetic */ int access$getImageHeight$p(GotItConfigurationDialog $this) {
            return $this.imageHeight;
        }

        public static final /* synthetic */ String access$getText$p(GotItConfigurationDialog $this) {
            return $this.text;
        }

        public static final /* synthetic */ void access$setText$p(GotItConfigurationDialog $this, String string) {
            $this.text = string;
        }

        public static final /* synthetic */ boolean access$getUseContrastColors$p(GotItConfigurationDialog $this) {
            return $this.useContrastColors;
        }

        public static final /* synthetic */ void access$setUseContrastColors$p(GotItConfigurationDialog $this, boolean bl) {
            $this.useContrastColors = bl;
        }

        public static final /* synthetic */ boolean access$getUseContrastButton$p(GotItConfigurationDialog $this) {
            return $this.useContrastButton;
        }

        public static final /* synthetic */ void access$setUseContrastButton$p(GotItConfigurationDialog $this, boolean bl) {
            $this.useContrastButton = bl;
        }

        public static final /* synthetic */ boolean access$getAddInlineLinks$p(GotItConfigurationDialog $this) {
            return $this.addInlineLinks;
        }

        public static final /* synthetic */ void access$setAddInlineLinks$p(GotItConfigurationDialog $this, boolean bl) {
            $this.addInlineLinks = bl;
        }

        public static final /* synthetic */ boolean access$getShowHeader$p(GotItConfigurationDialog $this) {
            return $this.showHeader;
        }

        public static final /* synthetic */ void access$setShowHeader$p(GotItConfigurationDialog $this, boolean bl) {
            $this.showHeader = bl;
        }

        public static final /* synthetic */ String access$getHeaderText$p(GotItConfigurationDialog $this) {
            return $this.headerText;
        }

        public static final /* synthetic */ void access$setHeaderText$p(GotItConfigurationDialog $this, String string) {
            $this.headerText = string;
        }

        public static final /* synthetic */ boolean access$getShowImageOrLottie$p(GotItConfigurationDialog $this) {
            return $this.showImageOrLottie;
        }

        public static final /* synthetic */ void access$setShowImageOrLottie$p(GotItConfigurationDialog $this, boolean bl) {
            $this.showImageOrLottie = bl;
        }

        public static final /* synthetic */ boolean access$getWithImageBorder$p(GotItConfigurationDialog $this) {
            return $this.withImageBorder;
        }

        public static final /* synthetic */ void access$setWithImageBorder$p(GotItConfigurationDialog $this, boolean bl) {
            $this.withImageBorder = bl;
        }

        public static final /* synthetic */ boolean access$getShowImage$p(GotItConfigurationDialog $this) {
            return $this.showImage;
        }

        public static final /* synthetic */ void access$setShowImage$p(GotItConfigurationDialog $this, boolean bl) {
            $this.showImage = bl;
        }

        public static final /* synthetic */ void access$setImageWidth$p(GotItConfigurationDialog $this, int n) {
            $this.imageWidth = n;
        }

        public static final /* synthetic */ void access$setImageHeight$p(GotItConfigurationDialog $this, int n) {
            $this.imageHeight = n;
        }

        public static final /* synthetic */ boolean access$getShowLottieAnimation$p(GotItConfigurationDialog $this) {
            return $this.showLottieAnimation;
        }

        public static final /* synthetic */ void access$setShowLottieAnimation$p(GotItConfigurationDialog $this, boolean bl) {
            $this.showLottieAnimation = bl;
        }

        public static final /* synthetic */ String access$getLottieJsonPath$p(GotItConfigurationDialog $this) {
            return $this.lottieJsonPath;
        }

        public static final /* synthetic */ void access$setLottieJsonPath$p(GotItConfigurationDialog $this, String string) {
            $this.lottieJsonPath = string;
        }

        public static final /* synthetic */ boolean access$getShowIconOrStep$p(GotItConfigurationDialog $this) {
            return $this.showIconOrStep;
        }

        public static final /* synthetic */ void access$setShowIconOrStep$p(GotItConfigurationDialog $this, boolean bl) {
            $this.showIconOrStep = bl;
        }

        public static final /* synthetic */ boolean access$getShowStepNumber$p(GotItConfigurationDialog $this) {
            return $this.showStepNumber;
        }

        public static final /* synthetic */ void access$setShowStepNumber$p(GotItConfigurationDialog $this, boolean bl) {
            $this.showStepNumber = bl;
        }

        public static final /* synthetic */ String access$getStepText$p(GotItConfigurationDialog $this) {
            return $this.stepText;
        }

        public static final /* synthetic */ void access$setStepText$p(GotItConfigurationDialog $this, String string) {
            $this.stepText = string;
        }

        public static final /* synthetic */ boolean access$getShowIcon$p(GotItConfigurationDialog $this) {
            return $this.showIcon;
        }

        public static final /* synthetic */ void access$setShowIcon$p(GotItConfigurationDialog $this, boolean bl) {
            $this.showIcon = bl;
        }

        public static final /* synthetic */ boolean access$getShowLink$p(GotItConfigurationDialog $this) {
            return $this.showLink;
        }

        public static final /* synthetic */ void access$setShowLink$p(GotItConfigurationDialog $this, boolean bl) {
            $this.showLink = bl;
        }

        public static final /* synthetic */ boolean access$getActionLink$p(GotItConfigurationDialog $this) {
            return $this.actionLink;
        }

        public static final /* synthetic */ void access$setActionLink$p(GotItConfigurationDialog $this, boolean bl) {
            $this.actionLink = bl;
        }

        public static final /* synthetic */ String access$getActionLinkText$p(GotItConfigurationDialog $this) {
            return $this.actionLinkText;
        }

        public static final /* synthetic */ void access$setActionLinkText$p(GotItConfigurationDialog $this, String string) {
            $this.actionLinkText = string;
        }

        public static final /* synthetic */ boolean access$getBrowserLink$p(GotItConfigurationDialog $this) {
            return $this.browserLink;
        }

        public static final /* synthetic */ void access$setBrowserLink$p(GotItConfigurationDialog $this, boolean bl) {
            $this.browserLink = bl;
        }

        public static final /* synthetic */ String access$getBrowserLinkText$p(GotItConfigurationDialog $this) {
            return $this.browserLinkText;
        }

        public static final /* synthetic */ void access$setBrowserLinkText$p(GotItConfigurationDialog $this, String string) {
            $this.browserLinkText = string;
        }

        public static final /* synthetic */ boolean access$getShowButton$p(GotItConfigurationDialog $this) {
            return $this.showButton;
        }

        public static final /* synthetic */ void access$setShowButton$p(GotItConfigurationDialog $this, boolean bl) {
            $this.showButton = bl;
        }

        public static final /* synthetic */ boolean access$getShowSecondaryButton$p(GotItConfigurationDialog $this) {
            return $this.showSecondaryButton;
        }

        public static final /* synthetic */ void access$setShowSecondaryButton$p(GotItConfigurationDialog $this, boolean bl) {
            $this.showSecondaryButton = bl;
        }

        public static final /* synthetic */ String access$getSecondaryButtonText$p(GotItConfigurationDialog $this) {
            return $this.secondaryButtonText;
        }

        public static final /* synthetic */ void access$setSecondaryButtonText$p(GotItConfigurationDialog $this, String string) {
            $this.secondaryButtonText = string;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/internal/ui/ShowGotItDemoAction$GotItConfigurationDialog$Companion;", "", "<init>", "()V", "LAST_OPENED_LOTTIE_FILE", "", "intellij.platform.ide.internal"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Balloon.Position.values().length];
                try {
                    nArray[Balloon.Position.below.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Balloon.Position.above.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Balloon.Position.atLeft.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Balloon.Position.atRight.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

