/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingUndoUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/ShowUpdateInfoDialogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "MyDialog", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nShowUpdateInfoDialogAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowUpdateInfoDialogAction.kt\ncom/intellij/internal/ShowUpdateInfoDialogAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
final class ShowUpdateInfoDialogAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        MyDialog dialog2 = new MyDialog(project2);
        if (dialog2.showAndGet()) {
            try {
                Path path;
                UpdateChecker updateChecker = UpdateChecker.INSTANCE;
                Project project3 = project2;
                String string = dialog2.updateXmlText();
                String string2 = dialog2.patchFilePath();
                if (string2 != null) {
                    void it;
                    String string3 = string2;
                    String string4 = string;
                    Project project4 = project3;
                    UpdateChecker updateChecker2 = updateChecker;
                    boolean bl = false;
                    Path path2 = Path.of(FileUtil.toSystemDependentName((String)it), new String[0]);
                    updateChecker = updateChecker2;
                    project3 = project4;
                    string = string4;
                    path = path2;
                } else {
                    path = null;
                }
                updateChecker.testPlatformUpdate(project3, string, path, dialog2.forceUpdate());
            }
            catch (Exception ex) {
                Messages.showErrorDialog((Project)project2, (String)(ex.getClass().getName() + ": " + ex.getMessage()), (String)"Something Went Wrong");
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0014J\u001d\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f0\u0010\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u00120\u000fH\u0014\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u001c\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\b\u0010\u001f\u001a\u00020\u001aH\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001aH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/internal/ShowUpdateInfoDialogAction$MyDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "textArea", "Ljavax/swing/JTextArea;", "fileField", "Lcom/intellij/openapi/fileChooser/FileTextField;", "forceUpdate", "", "createCenterPanel", "Ljavax/swing/JComponent;", "createActions", "", "Ljavax/swing/Action;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "()[Ljavax/swing/Action;", "validateAndDoOkAction", "", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getPreferredFocusedComponent", "getDimensionServiceKey", "", "updateXmlText", "patchFilePath", "completeUpdateInfoXml", "text", "getXmlText", "xmlTextForPatchUpdate", "path", "intellij.platform.ide.internal"})
    @SourceDebugExtension(value={"SMAP\nShowUpdateInfoDialogAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowUpdateInfoDialogAction.kt\ncom/intellij/internal/ShowUpdateInfoDialogAction$MyDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
    private static final class MyDialog
    extends DialogWrapper {
        @Nullable
        private final Project project;
        private JTextArea textArea;
        private FileTextField fileField;
        private boolean forceUpdate;

        public MyDialog(@Nullable Project project) {
            super(project, true);
            this.project = project;
            this.setTitle("Test update dialog");
            this.init();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        protected JComponent createCenterPanel() {
            void $this$createCenterPanel_u24lambda_u240;
            JLabel jLabel;
            this.textArea = new JTextArea(30, 80);
            JTextArea jTextArea = this.textArea;
            if (jTextArea == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textArea");
                jTextArea = null;
            }
            SwingUndoUtil.addUndoRedoActions((JTextComponent)jTextArea);
            JTextArea jTextArea2 = this.textArea;
            if (jTextArea2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textArea");
                jTextArea2 = null;
            }
            jTextArea2.setWrapStyleWord(true);
            JTextArea jTextArea3 = this.textArea;
            if (jTextArea3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textArea");
                jTextArea3 = null;
            }
            jTextArea3.setLineWrap(true);
            FileTextField fileTextField = FileChooserFactory.getInstance().createFileTextField(FileChooserDescriptorFactory.singleFile(), this.getDisposable());
            Intrinsics.checkNotNullExpressionValue((Object)fileTextField, (String)"createFileTextField(...)");
            this.fileField = fileTextField;
            FileTextField fileTextField2 = this.fileField;
            if (fileTextField2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fileField");
                fileTextField2 = null;
            }
            TextFieldWithBrowseButton fileCombo = new TextFieldWithBrowseButton(fileTextField2.getField());
            fileCombo.addBrowseFolderListener(this.project, FileChooserDescriptorFactory.singleFile().withTitle("Patch File").withDescription("Patch file"));
            JPanel panel2 = new JPanel(new BorderLayout(0, JBUI.scale((int)10)));
            JPanel labelsPanel = new JPanel(new BorderLayout(0, JBUI.scale((int)5)));
            JLabel jLabel2 = jLabel = new JLabel("Add updates.xml content or choose a patch file");
            JPanel jPanel = labelsPanel;
            boolean bl = false;
            $this$createCenterPanel_u24lambda_u240.setFont((Font)JBUI.Fonts.label().asBold());
            jPanel.add((Component)jLabel, "North");
            labelsPanel.add((Component)new JLabel("Updates.xml <channel> text:"), "South");
            panel2.add((Component)labelsPanel, "North");
            JTextArea jTextArea4 = this.textArea;
            if (jTextArea4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textArea");
                jTextArea4 = null;
            }
            panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)jTextArea4), "Center");
            panel2.add((Component)LabeledComponent.create((JComponent)((JComponent)fileCombo), (String)"Patch file:"), "South");
            panel2.setMinimumSize((Dimension)JBUI.size((int)200, (int)200));
            return panel2;
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{new AbstractAction(this){
                final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = $receiver;
                    super("&Check Updates");
                }

                public void actionPerformed(ActionEvent e) {
                    MyDialog.access$setForceUpdate$p(this.this$0, false);
                    MyDialog.access$validateAndDoOkAction(this.this$0);
                }
            }, new AbstractAction(this){
                final /* synthetic */ MyDialog this$0;
                {
                    this.this$0 = $receiver;
                    super("&Show Dialog");
                }

                public void actionPerformed(ActionEvent e) {
                    MyDialog.access$setForceUpdate$p(this.this$0, true);
                    MyDialog.access$validateAndDoOkAction(this.this$0);
                }
            }, this.getCancelAction()};
            return actionArray;
        }

        private final void validateAndDoOkAction() {
            ValidationInfo info = this.doValidate();
            if (info != null) {
                IdeFocusManager ideFocusManager = IdeFocusManager.getInstance(null);
                JTextArea jTextArea = this.textArea;
                if (jTextArea == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"textArea");
                    jTextArea = null;
                }
                ideFocusManager.requestFocus((Component)jTextArea, true);
                this.updateErrorInfo(CollectionsKt.listOf((Object)info));
                this.startTrackingValidation();
            } else {
                this.doOKAction();
            }
        }

        @Nullable
        protected ValidationInfo doValidate() {
            String text = this.getXmlText();
            if (((CharSequence)text).length() == 0) {
                JTextArea jTextArea = this.textArea;
                if (jTextArea == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"textArea");
                    jTextArea = null;
                }
                return new ValidationInfo("Please paste something here or choose a patch file", (JComponent)jTextArea);
            }
            try {
                JDOMUtil.load((CharSequence)this.completeUpdateInfoXml(text));
            }
            catch (Exception e) {
                JTextArea jTextArea;
                Object object = e.getMessage();
                if (object == null) {
                    object = "Error: " + e.getClass().getName();
                }
                if ((jTextArea = this.textArea) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"textArea");
                    jTextArea = null;
                }
                return new ValidationInfo((String)object, (JComponent)jTextArea);
            }
            return super.doValidate();
        }

        @NotNull
        public JTextArea getPreferredFocusedComponent() {
            JTextArea jTextArea = this.textArea;
            if (jTextArea == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textArea");
                jTextArea = null;
            }
            return jTextArea;
        }

        @NotNull
        protected String getDimensionServiceKey() {
            return "TEST_UPDATE_INFO_DIALOG";
        }

        @NotNull
        public final String updateXmlText() {
            return this.completeUpdateInfoXml(this.getXmlText());
        }

        public final boolean forceUpdate() {
            return this.forceUpdate;
        }

        @Nullable
        public final String patchFilePath() {
            FileTextField fileTextField = this.fileField;
            if (fileTextField == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"fileField");
                fileTextField = null;
            }
            return StringKt.nullize((String)fileTextField.getField().getText(), (boolean)true);
        }

        private final String completeUpdateInfoXml(String text) {
            Object object;
            String string = JDOMUtil.load((CharSequence)text).getName();
            if (Intrinsics.areEqual((Object)string, (Object)"products")) {
                object = text;
            } else if (Intrinsics.areEqual((Object)string, (Object)"channel")) {
                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                String string2 = ApplicationInfo.getInstance().getBuild().getProductCode();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProductCode(...)");
                String productCode = string2;
                object = "<products><product name=\"" + productName + "\"><code>" + productCode + "</code>" + text + "</product></products>";
            } else {
                throw new IllegalArgumentException("Unknown root element");
            }
            return object;
        }

        private final String getXmlText() {
            String patchFile;
            String text;
            JTextArea jTextArea = this.textArea;
            if (jTextArea == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textArea");
                jTextArea = null;
            }
            String string = jTextArea.getText();
            String string2 = text = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
            boolean bl = string2 != null ? !StringsKt.isBlank((CharSequence)string2) : false;
            if (bl) {
                return text;
            }
            String string3 = patchFile = this.patchFilePath();
            boolean bl2 = string3 != null ? !StringsKt.isBlank((CharSequence)string3) : false;
            if (bl2) {
                return this.xmlTextForPatchUpdate(patchFile);
            }
            return "";
        }

        private final String xmlTextForPatchUpdate(String path) {
            return StringsKt.trimIndent((String)("\n      <channel id=\"\">\n        <build number=\"1\" version=\"fake version\">\n          <message><![CDATA[Test text for the update dialog<br><br>Selected patch path:<br>" + path + "]]></message>\n        </build>\n      </channel>"));
        }

        public static final /* synthetic */ void access$setForceUpdate$p(MyDialog $this, boolean bl) {
            $this.forceUpdate = bl;
        }

        public static final /* synthetic */ void access$validateAndDoOkAction(MyDialog $this) {
            $this.validateAndDoOkAction();
        }
    }
}

