/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.PotemkinOverlayProgress;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.Component;
import java.awt.Window;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TestWriteActionUnderProgress
extends DumbAwareAction {
    TestWriteActionUnderProgress() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TestWriteActionUnderProgress.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            TestWriteActionUnderProgress.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Component component = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
        EdtExecutorService.getScheduledExecutorInstance().schedule(() -> TestWriteActionUnderProgress.runProgresses(project, component), 2L, TimeUnit.SECONDS);
    }

    private static void runProgresses(@Nullable Project project, @Nullable Component component) {
        JComponent comp = (JComponent)ObjectUtils.tryCast((Object)component, JComponent.class);
        ApplicationImpl app = (ApplicationImpl)ApplicationManager.getApplication();
        boolean success = app.runWriteActionWithNonCancellableProgressInDispatchThread("Progress", project, comp, TestWriteActionUnderProgress::runIndeterminateProgress);
        assert (success);
        app.runWriteActionWithCancellableProgressInDispatchThread("Cancellable progress", project, comp, TestWriteActionUnderProgress::runDeterminateProgress);
        app.runWriteAction(() -> {
            Window window = ProgressWindow.calcParentWindow((Component)component, (Project)project);
            PotemkinOverlayProgress progress = new PotemkinOverlayProgress((Component)window);
            progress.setDelayInMillis(0);
            ProgressManager.getInstance().runProcess(() -> TestWriteActionUnderProgress.runIndeterminateProgress((ProgressIndicator)progress), (ProgressIndicator)progress);
        });
    }

    private static void runDeterminateProgress(ProgressIndicator indicator) {
        indicator.setIndeterminate(false);
        int iterations = 3000;
        indicator.setText("In background thread");
        for (int i = 0; i < iterations; ++i) {
            TimeoutUtil.sleep((long)1L);
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            indicator.setFraction(((double)i + 1.0) / (double)iterations);
            indicator.setText2(String.valueOf(i));
            ProgressManager.checkCanceled();
        }
    }

    private static void runIndeterminateProgress(ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        indicator.setText("In Event Dispatch thread");
        for (int i = 0; i < 1000; ++i) {
            TimeoutUtil.sleep((long)5L);
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            indicator.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/TestWriteActionUnderProgress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/TestWriteActionUnderProgress";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

