/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class FacetTypeUsageCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("module.facets", 6);
    private static final EventField<String> FACET_TYPE = EventFields.StringValidatedByCustomRule((String)"facet", FacetTypeUtilValidator.class);
    private static final VarargEventId MODULE = GROUP.registerVarargEvent("module.with.facet", new EventField[]{FACET_TYPE, EventFields.PluginInfo});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public @Unmodifiable @NotNull Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            FacetTypeUsageCollector.$$$reportNull$$$0(0);
        }
        HashSet<String> facets = new HashSet<String>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (Facet facet2 : FacetManager.getInstance((Module)module).getAllFacets()) {
                facets.add(facet2.getType().getStringId());
            }
        }
        Set set = ContainerUtil.map2Set(facets, facet -> MODULE.metric(new EventPair[]{FACET_TYPE.with(facet)}));
        if (set == null) {
            FacetTypeUsageCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static final class FacetTypeUtilValidator
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return "facets_type";
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            if (data == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(1);
            }
            if ("invalid".equals(data) || FacetTypeUtilValidator.isThirdPartyValue((String)data)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    FacetTypeUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            FacetType facet = FacetTypeUtilValidator.findFacetById(data);
            if (facet == null) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    FacetTypeUtilValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            PluginInfo info = PluginInfoDetectorKt.getPluginInfo(facet.getClass());
            context.setPayload(PLUGIN_INFO, (Object)info);
            ValidationResultType validationResultType = info.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        @Nullable
        private static FacetType findFacetById(@NotNull String data) {
            FacetType[] facets;
            if (data == null) {
                FacetTypeUtilValidator.$$$reportNull$$$0(5);
            }
            for (FacetType facet : facets = (FacetType[])FacetType.EP_NAME.getExtensions()) {
                if (!StringUtil.equals((CharSequence)facet.getStringId(), (CharSequence)data)) continue;
                return facet;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector$FacetTypeUtilValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/FacetTypeUsageCollector$FacetTypeUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findFacetById";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

