/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileExtensionCounter;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileExtensionValidationRule;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeSchemaValidator;
import com.intellij.internal.statistic.collectors.fus.fileTypes.OriginalFileTypeCounter;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectListEventField;
import com.intellij.internal.statistic.eventLog.events.RoundedIntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FileTypeUsagesCollector
extends ProjectUsagesCollector {
    private static final String DEFAULT_ID = "third.party";
    private static final StringEventField FILE_EXTENSION = EventFields.StringValidatedByCustomRule((String)"file_extension", FileExtensionValidationRule.class);
    private final RoundedIntEventField COUNT = EventFields.RoundedInt((String)"count");
    public static final EventField<String> SCHEMA = EventFields.StringValidatedByCustomRule((String)"schema", FileTypeSchemaValidator.class);
    public static final IntEventField PERCENT = EventFields.Int((String)"percent");
    private final ObjectListEventField FILE_SCHEME_PERCENT = new ObjectListEventField("file_schema", new EventField[]{SCHEMA, PERCENT});
    public static final EventField<FileType> TYPE_BY_EXTENSION = EventFields.FileType;
    public static final IntEventField TYPE_BY_EXTENSION_PERCENT = EventFields.Int((String)"percent");
    private final ObjectListEventField FILE_TYPE_BY_EXTENSION_PERCENT = new ObjectListEventField("original_file_type", new EventField[]{TYPE_BY_EXTENSION, TYPE_BY_EXTENSION_PERCENT});
    private static final IntEventField FILE_EXTENSION_BY_PERCENT = EventFields.Int((String)"file_extension_percent");
    private final EventLogGroup GROUP = new EventLogGroup("file.types", 10);
    private final VarargEventId FILE_TYPE_IN_PROJECT = this.GROUP.registerVarargEvent("file.type.in.project", new EventField[]{EventFields.PluginInfoFromInstance, EventFields.FileType, this.COUNT, this.FILE_TYPE_BY_EXTENSION_PERCENT, this.FILE_SCHEME_PERCENT});
    private final VarargEventId FILE_EXTENSION_IN_PROJECT = this.GROUP.registerVarargEvent("file.extension.in.project", new EventField[]{FILE_EXTENSION, this.COUNT, FILE_EXTENSION_BY_PERCENT});

    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        if (project.isDisposed()) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                FileTypeUsagesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        IProjectStore stateStore = ProjectKt.getStateStore((Project)project);
        ObjectIntHashMap filesByTypeCount = new ObjectIntHashMap();
        OriginalFileTypeCounter fileTypeMappingsCounter = new OriginalFileTypeCounter();
        FileExtensionCounter fileExtensionCounter = new FileExtensionCounter();
        projectFileIndex.iterateContent(arg_0 -> FileTypeUsagesCollector.lambda$getMetrics$0((ObjectIntMap)filesByTypeCount, fileTypeMappingsCounter, fileExtensionCounter, arg_0), file -> !file.isDirectory() && !stateStore.isProjectFile(file));
        HashSet<MetricEvent> events = new HashSet<MetricEvent>();
        for (FileType fileType : filesByTypeCount.keySet()) {
            ArrayList<EventPair> eventPairs = new ArrayList<EventPair>(4);
            eventPairs.add(EventFields.PluginInfoFromInstance.with((Object)fileType));
            eventPairs.add(EventFields.FileType.with((Object)fileType));
            eventPairs.add(this.COUNT.with((Object)filesByTypeCount.get((Object)fileType)));
            eventPairs.add(this.FILE_TYPE_BY_EXTENSION_PERCENT.with(fileTypeMappingsCounter.getFileTypeSchemaUsagePercentage(fileType)));
            events.add(this.FILE_TYPE_IN_PROJECT.metric(eventPairs));
        }
        for (String extension : fileExtensionCounter.getFileExtensionsList()) {
            int extensionCount = fileExtensionCounter.getFileExtensionCount(extension);
            ArrayList<EventPair> eventPairs = new ArrayList<EventPair>(3);
            eventPairs.add(FILE_EXTENSION.with((Object)extension));
            eventPairs.add(this.COUNT.with((Object)extensionCount));
            eventPairs.add(FILE_EXTENSION_BY_PERCENT.with((Object)fileExtensionCounter.getFileExtensionUsagePercentage(extension)));
            events.add(this.FILE_EXTENSION_IN_PROJECT.metric(eventPairs));
        }
        HashSet<MetricEvent> hashSet = events;
        if (hashSet == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public static String getSafeFileTypeName(@NotNull FileType fileType) {
        PluginInfo info;
        if (fileType == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(3);
        }
        return (info = PluginInfoDetectorKt.getPluginInfo((Class)fileType.getClass())).isDevelopedByJetBrains() ? fileType.getName() : DEFAULT_ID;
    }

    private static /* synthetic */ boolean lambda$getMetrics$0(ObjectIntMap filesByTypeCount, OriginalFileTypeCounter fileTypeMappingsCounter, FileExtensionCounter fileExtensionCounter, VirtualFile file) {
        FileType type = file.getFileType();
        filesByTypeCount.put((Object)type, filesByTypeCount.getOrDefault((Object)type, 0) + 1);
        String fileExtension = file.getExtension();
        if (fileExtension == null) {
            fileTypeMappingsCounter.recordOriginalFileType(type, null);
            return true;
        }
        FileType fileTypeByExtension = FileTypeManager.getInstance().getFileTypeByExtension(fileExtension);
        fileTypeMappingsCounter.recordOriginalFileType(type, fileTypeByExtension);
        fileExtensionCounter.recordOriginalFileType(fileExtension);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSafeFileTypeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static final class ValidationRule
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return "file_type";
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            if (data == null) {
                ValidationRule.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ValidationRule.$$$reportNull$$$0(1);
            }
            if (ValidationRule.isThirdPartyValue((String)data)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    ValidationRule.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            FileType fileType = FileTypeManager.getInstance().findFileTypeByName(data);
            if (fileType == null || !StringUtil.equals((CharSequence)fileType.getName(), (CharSequence)data)) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    ValidationRule.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            boolean isDevelopedByJB = PluginInfoDetectorKt.getPluginInfo((Class)fileType.getClass()).isDevelopedByJetBrains();
            ValidationResultType validationResultType = isDevelopedByJB ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                ValidationRule.$$$reportNull$$$0(4);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector$ValidationRule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector$ValidationRule";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

