/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef;

import com.intellij.internal.jcef.CookieManagerDialog;
import com.intellij.internal.jcef.MyOkCancelDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.handler.CefAppStateHandler;
import org.cef.handler.CefLoadHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JBCefBrowserDemo
extends AnAction
implements DumbAware {
    private static final String URL = "https://maps.google.com";
    private static final String myCookieManagerText = "Cookie Manager";

    JBCefBrowserDemo() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            JBCefBrowserDemo.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Window activeFrame;
        if (e == null) {
            JBCefBrowserDemo.$$$reportNull$$$0(1);
        }
        if ((activeFrame = IdeFrameImpl.getActiveFrame()) == null) {
            return;
        }
        if (!JBCefApp.isSupported()) {
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)new JTextArea("Set the reg key to enable JCEF:\n\"ide.browser.jcef.enabled=true\""), null).setTitle("JCEF Web Browser Is not Supported").createPopup().showInCenterOf((Component)activeFrame);
            return;
        }
        JBCefBrowserDemo.showBrowser(JBCefApp.isOffScreenRenderingModeEnabled());
    }

    private static void showBrowser(boolean isOffScreenRendering) {
        Window activeFrame = IdeFrameImpl.getActiveFrame();
        if (activeFrame == null) {
            return;
        }
        Rectangle bounds = activeFrame.getGraphicsConfiguration().getBounds();
        IdeFrameImpl frame = new IdeFrameImpl();
        frame.setTitle("Web Browser" + (isOffScreenRendering ? " (OSR) " : " ") + "- JCEF");
        frame.setDefaultCloseOperation(2);
        frame.setBounds(bounds.width / 4, bounds.height / 4, bounds.width / 2, bounds.height / 2);
        frame.setLayout(new BorderLayout());
        final JBCefBrowser myJBCefBrowser = JBCefBrowser.createBuilder().setOffScreenRendering(isOffScreenRendering).setUrl(URL).setEnableOpenDevToolsMenuItem(true).build();
        myJBCefBrowser.setErrorPage(new JBCefBrowserBase.ErrorPage(){

            @Nullable
            public String create(@NotNull CefLoadHandler.ErrorCode errorCode, @NotNull String errorText, @NotNull String failedUrl) {
                if (errorCode == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (errorText == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (failedUrl == null) {
                    1.$$$reportNull$$$0(2);
                }
                return errorCode == CefLoadHandler.ErrorCode.ERR_ABORTED ? null : JBCefBrowserBase.ErrorPage.DEFAULT.create(errorCode, errorText, failedUrl);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "errorCode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "errorText";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "failedUrl";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/internal/jcef/JBCefBrowserDemo$1";
                objectArray[2] = "create";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        myJBCefBrowser.setProperty("JBCefBrowser.focusOnShow", (Object)Boolean.TRUE);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                Disposer.dispose((Disposable)myJBCefBrowser);
            }
        });
        frame.add((Component)myJBCefBrowser.getComponent(), "Center");
        JTextField myUrlBar = new JTextField(URL);
        myUrlBar.addActionListener(event -> myJBCefBrowser.loadURL(myUrlBar.getText()));
        frame.add((Component)myUrlBar, "North");
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        CefApp.getInstance().onInitialization(new CefAppStateHandler(){
            final /* synthetic */ JFrame val$frame;
            final /* synthetic */ JBCefBrowser val$myJBCefBrowser;
            final /* synthetic */ JPanel val$controlPanel;
            {
                this.val$frame = jFrame;
                this.val$myJBCefBrowser = jBCefBrowser;
                this.val$controlPanel = jPanel;
            }

            public void stateHasChanged(CefApp.CefAppState state) {
                if (state == CefApp.CefAppState.INITIALIZED) {
                    SwingUtilities.invokeLater(() -> {
                        final CookieManagerDialog myCookieManagerDialog = new CookieManagerDialog((Frame)this.val$frame, this.val$myJBCefBrowser);
                        myCookieManagerDialog.setVisible(false);
                        JButton myShowCookieManagerButton = new JButton(JBCefBrowserDemo.myCookieManagerText);
                        myShowCookieManagerButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                myCookieManagerDialog.setVisible(true);
                                List cookies = val$myJBCefBrowser.getJBCefCookieManager().getCookies();
                                myCookieManagerDialog.update(cookies);
                            }
                        });
                        this.val$controlPanel.add(myShowCookieManagerButton);
                    });
                }
            }
        });
        frame.add((Component)controlPanel, "South");
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu menu = new JMenu("Tools");
        menu.setMnemonic('t');
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Load HTML with URL", 104);
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){
            final /* synthetic */ JFrame val$frame;
            final /* synthetic */ JTextField val$myUrlBar;
            final /* synthetic */ JBCefBrowser val$myJBCefBrowser;
            {
                this.val$frame = jFrame;
                this.val$myUrlBar = jTextField;
                this.val$myJBCefBrowser = jBCefBrowser;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MyOkCancelDialog<JPanel> dialog2 = new MyOkCancelDialog<JPanel>(this.val$frame, "Load HTML with URL");
                JPanel panel2 = new JPanel();
                panel2.setLayout(new BorderLayout());
                JTextField url = new JTextField("file://foo/bar");
                JTextArea html = new JTextArea("<html>\n<body>\n\u0421\u044a\u0435\u0448\u044c \u0415\u0449\u0435 \u042d\u0442\u0438\u0445 \u041c\u044f\u0433\u043a\u0438\u0445 \u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0438\u0445 \u0411\u0443\u043b\u043e\u043a &#129366;&#129366;\n</body>\n</html>");
                panel2.add((Component)url, "North");
                panel2.add((Component)html, "Center");
                dialog2.setComponent(panel2);
                dialog2.setOkAction(() -> {
                    this.val$myUrlBar.setText(url.getText());
                    SwingUtilities.invokeLater(() -> this.val$myJBCefBrowser.loadHTML(html.getText(), url.getText()));
                }, "Load");
                dialog2.show();
            }
        });
        menuItem = new JMenuItem("Set background color", 99);
        menu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){
            final /* synthetic */ JFrame val$frame;
            final /* synthetic */ JBCefBrowser val$myJBCefBrowser;
            {
                this.val$frame = jFrame;
                this.val$myJBCefBrowser = jBCefBrowser;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MyOkCancelDialog<JTextField> dialog2 = new MyOkCancelDialog<JTextField>(this.val$frame, "Background Color");
                JTextField color = dialog2.setComponent(new JTextField("lightgreen"));
                dialog2.setOkAction(() -> this.val$myJBCefBrowser.setPageBackgroundColor(color.getText()), "Apply");
                dialog2.show();
            }
        });
        final JMenuItem menuItemFocus = new JMenuItem("Set focus on navigation", 102);
        menu.add(menuItemFocus);
        menuItemFocus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean value = Boolean.TRUE.equals(myJBCefBrowser.getProperty("JBCefBrowser.focusOnNavigation"));
                myJBCefBrowser.setProperty("JBCefBrowser.focusOnNavigation", (Object)(!value ? 1 : 0));
                menuItemFocus.setText(value ? "Set focus on navigation" : "Unset focus on navigation");
            }
        });
        final JMenuItem menuItemContext = new JMenuItem("Disable context menu", 109);
        menu.add(menuItemContext);
        menuItemContext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean value = Boolean.TRUE.equals(myJBCefBrowser.getProperty("JBCefBrowserBase.noContextMenu"));
                myJBCefBrowser.setProperty("JBCefBrowserBase.noContextMenu", (Object)(!value ? 1 : 0));
                menuItemContext.setText(value ? "Disable context menu" : "Enable context menu");
            }
        });
        if (JBCefApp.isOffScreenRenderingModeEnabled()) {
            JMenuItem menuItemWindowedMode = new JMenuItem("Create jcef browser in Windowed-mode");
            menu.add(menuItemWindowedMode);
            menuItemWindowedMode.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JBCefBrowserDemo.showBrowser(false);
                }
            });
        }
        frame.setVisible(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/jcef/JBCefBrowserDemo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/jcef/JBCefBrowserDemo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

