/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.rulerguide;

import com.intellij.internal.rulerguide.ComponentBounds;
import com.intellij.internal.rulerguide.SneakyGraphics2D;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

final class ComponentBoundsFinder {
    private BufferedImage image;
    private Result lastResult;

    ComponentBoundsFinder() {
    }

    public void update(Component component, Point point) {
        if (this.image == null || this.image.getWidth() < component.getWidth() || this.image.getHeight() < component.getHeight()) {
            this.image = new BufferedImage(component.getWidth(), component.getHeight(), 2);
        }
        SneakyGraphics2D g2d = new SneakyGraphics2D((Graphics2D)this.image.getGraphics());
        component.paint((Graphics)((Object)g2d));
        g2d.dispose();
        this.lastResult = new Result(g2d.getPOI(), component, point);
    }

    public Result getLastResult() {
        return this.lastResult;
    }

    public void dispose() {
        this.image = null;
        this.lastResult = null;
    }

    public static final class Result {
        private final List<ComponentBounds> bounds = new ArrayList<ComponentBounds>();
        private final Component component;
        private final Point point;

        public Result(Collection<ComponentBounds> bounds, Component component, Point point) {
            this.bounds.addAll(bounds);
            this.bounds.sort(Comparator.comparingInt(b -> b.width * b.height));
            this.component = component;
            this.point = point;
        }

        public Collection<ComponentBounds> getBounds() {
            return this.bounds;
        }

        public Component getComponent() {
            return this.component;
        }

        public Point getPoint() {
            return this.point;
        }
    }
}

