/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui.gridLayoutTestAction;

import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.dsl.gridLayout.Constraints;
import com.intellij.ui.dsl.gridLayout.Grid;
import com.intellij.ui.dsl.gridLayout.GridLayout;
import com.intellij.ui.dsl.gridLayout.HorizontalAlign;
import com.intellij.ui.dsl.gridLayout.VerticalAlign;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\f"}, d2={"gridToHtmlString", "", "grid", "Lcom/intellij/ui/dsl/gridLayout/Grid;", "createTabPanel", "Ljavax/swing/JPanel;", "title", "content", "Ljavax/swing/JComponent;", "createControls", "", "container", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nGridLayoutTestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridLayoutTestAction.kt\ncom/intellij/internal/ui/gridLayoutTestAction/GridLayoutTestActionKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,491:1\n4225#2,11:492\n1869#3,2:503\n1869#3,2:505\n*S KotlinDebug\n*F\n+ 1 GridLayoutTestAction.kt\ncom/intellij/internal/ui/gridLayoutTestAction/GridLayoutTestActionKt\n*L\n446#1:492,11\n471#1:503,2\n475#1:505,2\n*E\n"})
public final class GridLayoutTestActionKt {
    private static final String gridToHtmlString(Grid grid) {
        List result = new ArrayList();
        if (!((Collection)grid.getResizableColumns()).isEmpty()) {
            result.add("resizableColumns = " + CollectionsKt.joinToString$default((Iterable)grid.getResizableColumns(), null, null, null, (int)0, null, null, (int)63, null));
        }
        if (!((Collection)grid.getResizableRows()).isEmpty()) {
            result.add("resizableRows = " + CollectionsKt.joinToString$default((Iterable)grid.getResizableRows(), null, null, null, (int)0, null, null, (int)63, null));
        }
        if (!((Collection)grid.getColumnsGaps()).isEmpty()) {
            result.add("<br>columnsGaps = " + CollectionsKt.joinToString$default((Iterable)grid.getColumnsGaps(), null, null, null, (int)0, null, null, (int)63, null));
        }
        if (!((Collection)grid.getRowsGaps()).isEmpty()) {
            result.add("<br>rowsGaps = " + CollectionsKt.joinToString$default((Iterable)grid.getRowsGaps(), null, null, null, (int)0, null, null, (int)63, null));
        }
        return CollectionsKt.joinToString$default((Iterable)result, null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public static final JPanel createTabPanel(@NotNull String title, @NotNull JComponent content) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        GridLayout layoutManager = new GridLayout();
        Grid rootGrid = layoutManager.getRootGrid();
        JPanel result = new JPanel((LayoutManager)layoutManager);
        rootGrid.getResizableColumns().add(0);
        rootGrid.getResizableRows().add(1);
        LayoutManager layoutManager2 = content.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager2, (String)"null cannot be cast to non-null type com.intellij.ui.dsl.gridLayout.GridLayout");
        JLabel label = new JLabel("<html>" + title + "<br>" + GridLayoutTestActionKt.gridToHtmlString(((GridLayout)layoutManager2).getRootGrid()));
        label.setBackground((Color)JBColor.LIGHT_GRAY);
        label.setOpaque(true);
        result.add((Component)label, new Constraints(rootGrid, 0, 0, 2, 0, HorizontalAlign.FILL, null, false, null, null, null, null, 4048, null));
        VerticalAlign verticalAlign = VerticalAlign.FILL;
        HorizontalAlign horizontalAlign = HorizontalAlign.FILL;
        result.add((Component)content, new Constraints(rootGrid, 0, 1, 0, 0, horizontalAlign, verticalAlign, false, null, null, null, null, 3992, null));
        Grid controlGrid = layoutManager.addLayoutSubGrid(new Constraints(rootGrid, 1, 1, 0, 0, null, VerticalAlign.FILL, false, null, null, null, null, 4024, null));
        GridLayoutTestActionKt.createControls(result, content, controlGrid);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final void createControls(JComponent container, JComponent content, Grid grid) {
        void $this$filterIsInstanceTo$iv$iv;
        JCheckBox cbHighlight = new JCheckBox("Highlight components");
        cbHighlight.addActionListener(arg_0 -> GridLayoutTestActionKt.createControls$lambda$0(content, cbHighlight, arg_0));
        cbHighlight.doClick();
        Component[] componentArray = content.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$filterIsInstance$iv = componentArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof JLabel)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        JBList list = new JBList(collection);
        JButton btnHide = new JButton("Hide");
        JButton btnShow = new JButton("Show");
        list.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type javax.swing.JLabel");
                JLabel label = (JLabel)value;
                Component component = super.getListCellRendererComponent(list, label.getText(), index, isSelected, cellHasFocus);
                Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.DefaultListCellRenderer");
                DefaultListCellRenderer result = (DefaultListCellRenderer)component;
                result.setForeground(label.isVisible() ? (Color)JBColor.BLACK : (Color)JBColor.LIGHT_GRAY);
                return result;
            }
        });
        btnHide.addActionListener(arg_0 -> GridLayoutTestActionKt.createControls$lambda$1(list, arg_0));
        btnShow.addActionListener(arg_0 -> GridLayoutTestActionKt.createControls$lambda$2(list, arg_0));
        CollectionsKt.addAll((Collection)grid.getResizableColumns(), (Iterable)((Iterable)new IntRange(0, 1)));
        grid.getResizableRows().add(0);
        container.add((Component)new JScrollPane((Component)list), new Constraints(grid, 0, 0, 2, 0, HorizontalAlign.FILL, VerticalAlign.FILL, false, null, null, null, null, 3984, null));
        container.add((Component)btnHide, new Constraints(grid, 0, 1, 0, 0, HorizontalAlign.CENTER, null, false, null, null, null, null, 4056, null));
        container.add((Component)btnShow, new Constraints(grid, 1, 1, 0, 0, HorizontalAlign.CENTER, null, false, null, null, null, null, 4056, null));
        container.add((Component)cbHighlight, new Constraints(grid, 0, 2, 2, 0, null, null, false, null, null, null, null, 4080, null));
    }

    private static final void createControls$lambda$0(JComponent $content, JCheckBox $cbHighlight, ActionEvent it) {
        Component[] componentArray = $content.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component component : componentArray) {
            if (!(component instanceof JLabel)) continue;
            ((JLabel)component).setBackground($cbHighlight.isSelected() ? new Color(Random.Default.nextInt()) : null);
            ((JLabel)component).setOpaque($cbHighlight.isSelected());
        }
    }

    private static final void createControls$lambda$1(JBList $list, ActionEvent it) {
        List list = $list.getSelectedValuesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedValuesList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JLabel it2 = (JLabel)element$iv;
            boolean bl = false;
            it2.setVisible(false);
        }
        $list.updateUI();
    }

    private static final void createControls$lambda$2(JBList $list, ActionEvent it) {
        List list = $list.getSelectedValuesList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedValuesList(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JLabel it2 = (JLabel)element$iv;
            boolean bl = false;
            it2.setVisible(true);
        }
        $list.updateUI();
    }
}

