/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefFpsMeter;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import org.jetbrains.annotations.NotNull;

final class JBCefOsrBrowserMeasureFpsAction
extends DumbAwareAction {
    @NotNull
    private static final String FPS_METER_ID = RegistryManager.getInstance().get("ide.browser.jcef.osr.measureFPS.id").asString();

    JBCefOsrBrowserMeasureFpsAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            JBCefOsrBrowserMeasureFpsAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Component focusOwner;
        if (e == null) {
            JBCefOsrBrowserMeasureFpsAction.$$$reportNull$$$0(1);
        }
        if ((focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null || !focusOwner.getClass().getName().contains("JBCefOsrComponent")) {
            throw new IllegalStateException("No JCEF OSR browser is in focus");
        }
        Notification notification = JBCefApp.getNotificationGroup().createNotification(IdeBundle.message((String)"notification.title.jcef.measureFPS", (Object[])new Object[0]), IdeBundle.message((String)"notification.content.jcef.measureFPS", (Object[])new Object[0]), NotificationType.INFORMATION);
        notification.notify(null);
        final JBCefFpsMeter fpsMeter = JBCefFpsMeter.get((String)FPS_METER_ID);
        if (fpsMeter == null) {
            return;
        }
        focusOwner.addKeyListener(new KeyAdapter(this){

            @Override
            public void keyPressed(KeyEvent e1) {
                focusOwner.removeKeyListener(this);
                fpsMeter.setActive(false);
            }
        });
        focusOwner.addFocusListener(new FocusAdapter(this){

            @Override
            public void focusLost(FocusEvent e1) {
                focusOwner.removeFocusListener(this);
                fpsMeter.setActive(false);
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Robot robot;
            try {
                robot = new Robot();
            }
            catch (AWTException ex) {
                ex.printStackTrace();
                return;
            }
            fpsMeter.setActive(true);
            boolean scroll = RegistryManager.getInstance().is("ide.browser.jcef.osr.measureFPS.scroll");
            while (fpsMeter.isActive()) {
                if (scroll) {
                    robot.mouseWheel(SystemInfo.isMac ? -1 : 1);
                }
                robot.delay(scroll ? 15 : 1000);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/jcef/JBCefOsrBrowserMeasureFpsAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/jcef/JBCefOsrBrowserMeasureFpsAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

