/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.jcef.test.cases;

import com.intellij.openapi.util.SystemInfo;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cef.CefApp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0003\n\u000b\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/jcef/test/cases/CefProcess;", "", "<init>", "()V", "knowProcess", "", "", "Lcom/intellij/internal/jcef/test/cases/CefProcess$ProcessInfo;", "getProcesses", "", "ProcessInfo", "ProcessType", "Companion", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nCpuUsage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuUsage.kt\ncom/intellij/internal/jcef/test/cases/CefProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n777#2:267\n873#2,2:268\n1586#2:270\n1661#2,2:271\n1663#2:274\n1#3:273\n*S KotlinDebug\n*F\n+ 1 CpuUsage.kt\ncom/intellij/internal/jcef/test/cases/CefProcess\n*L\n37#1:267\n37#1:268,2\n38#1:270\n38#1:271,2\n38#1:274\n*E\n"})
final class CefProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Long, ProcessInfo> knowProcess = new LinkedHashMap();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProcessInfo> getProcesses() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ProcessHandle it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ProcessHandle processHandle = ProcessHandle.current();
        Intrinsics.checkNotNullExpressionValue((Object)processHandle, (String)"current(...)");
        List<ProcessHandle> allCefProcesses = Companion.getAllSubprocessesRecursively(processHandle).toList();
        Intrinsics.checkNotNull(allCefProcesses);
        Map<Long, Long> cpuTime = Companion.getProcessCpuTime(allCefProcesses);
        Iterable iterable = allCefProcesses;
        boolean $i$f$filter = false;
        void var6_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProcessHandle)element$iv$iv;
            boolean bl = false;
            Optional<String> optional = it.info().command();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"command(...)");
            Object object = OptionalsKt.getOrDefault(optional, (Object)"");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
            if (!CefProcess.Companion.isCefProcess((String)object)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ProcessInfo processInfo;
            Object object;
            Object commandLine;
            void process;
            it = (ProcessHandle)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long pid = process.pid();
            ProcessInfo knownProcess = this.knowProcess.get(pid);
            Object object2 = knownProcess;
            if (object2 == null || (object2 = ((ProcessInfo)object2).getCommandLine()) == null) {
                Intrinsics.checkNotNull((Object)process);
                object2 = commandLine = CefProcess.Companion.getCommandLine((ProcessHandle)process);
            }
            if ((object = knownProcess) == null || (object = object.getProcessType()) == null) {
                object = !StringsKt.contains$default((CharSequence)((CharSequence)commandLine), (CharSequence)"--type=", (boolean)false, (int)2, null) ? ProcessType.MAIN : (StringsKt.contains$default((CharSequence)((CharSequence)commandLine), (CharSequence)"--type=renderer", (boolean)false, (int)2, null) ? ProcessType.RENDERER : (StringsKt.contains$default((CharSequence)((CharSequence)commandLine), (CharSequence)"--type=gpu-process", (boolean)false, (int)2, null) ? ProcessType.GPU : (StringsKt.contains$default((CharSequence)((CharSequence)commandLine), (CharSequence)"--utility-sub-type=network.mojom.NetworkService", (boolean)false, (int)2, null) ? ProcessType.NETWORK : (StringsKt.contains$default((CharSequence)((CharSequence)commandLine), (CharSequence)"--utility-sub-type=storage.mojom.StorageService", (boolean)false, (int)2, null) ? ProcessType.STORAGE : (StringsKt.contains$default((CharSequence)((CharSequence)commandLine), (CharSequence)"--type=utility", (boolean)false, (int)2, null) ? ProcessType.UTILITY_OTHER : (StringsKt.contains$default((CharSequence)((CharSequence)commandLine), (CharSequence)"--type=zygote", (boolean)false, (int)2, null) ? ProcessType.ZYGOTE : ProcessType.UNKNOWN))))));
            }
            Object type = object;
            Long l = cpuTime.get(pid);
            if (l == null) {
                processInfo = null;
            } else {
                ProcessInfo processInfo2;
                Double d;
                ProcessInfo it2;
                long cpuTimeNowMs = l;
                long timeNowMs = System.currentTimeMillis();
                ProcessInfo processInfo3 = knownProcess;
                if (processInfo3 != null) {
                    it2 = processInfo3;
                    boolean bl2 = false;
                    d = (double)(cpuTimeNowMs - it2.getLastCpuTimeMs()) * 100.0 / (double)(timeNowMs - it2.getLastTimeMs());
                } else {
                    d = null;
                }
                Double cpuUsage = d;
                it2 = processInfo2 = new ProcessInfo((ProcessType)((Object)type), pid, (String)commandLine, cpuUsage, timeNowMs, cpuTimeNowMs);
                boolean bl3 = false;
                this.knowProcess.put(pid, it2);
                processInfo = processInfo2;
            }
            collection.add(processInfo);
        }
        List processes = CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        return processes;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nJ \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/jcef/test/cases/CefProcess$Companion;", "", "<init>", "()V", "isCefProcess", "", "commandLine", "", "getAllSubprocessesRecursively", "Ljava/util/stream/Stream;", "Ljava/lang/ProcessHandle;", "process", "getProcessCpuTime", "", "", "processes", "", "getCommandLine", "processHandle", "parseTime", "time", "intellij.platform.ide.internal"})
    @SourceDebugExtension(value={"SMAP\nCpuUsage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CpuUsage.kt\ncom/intellij/internal/jcef/test/cases/CefProcess$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1586#2:267\n1661#2,3:268\n1586#2:272\n1661#2,3:273\n1586#2:276\n1661#2,2:277\n777#2:279\n873#2,2:280\n1663#2:282\n1205#2,2:283\n1282#2,4:285\n1205#2,2:289\n1282#2,4:291\n1205#2,2:295\n1282#2,4:297\n777#2:301\n873#2,2:302\n1#3:271\n*S KotlinDebug\n*F\n+ 1 CpuUsage.kt\ncom/intellij/internal/jcef/test/cases/CefProcess$Companion\n*L\n95#1:267\n95#1:268,3\n99#1:272\n99#1:273,3\n100#1:276\n100#1:277,2\n100#1:279\n100#1:280,2\n100#1:282\n101#1:283,2\n101#1:285,4\n104#1:289,2\n104#1:291,4\n107#1:295,2\n107#1:297,4\n138#1:301\n138#1:302,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isCefProcess(String commandLine) {
            return CefApp.isRemoteEnabled() ? StringsKt.contains$default((CharSequence)commandLine, (CharSequence)"cef_server", (boolean)false, (int)2, null) : (SystemInfo.isMac ? StringsKt.contains$default((CharSequence)commandLine, (CharSequence)"jcef Helper", (boolean)false, (int)2, null) : (SystemInfo.isWindows ? StringsKt.contains$default((CharSequence)commandLine, (CharSequence)"jcef_helper.exe", (boolean)false, (int)2, null) : (SystemInfo.isLinux ? StringsKt.contains$default((CharSequence)commandLine, (CharSequence)"jcef_helper", (boolean)false, (int)2, null) : false)));
        }

        @NotNull
        public final Stream<ProcessHandle> getAllSubprocessesRecursively(@NotNull ProcessHandle process) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Stream<ProcessHandle> stream = Stream.concat(process.children(), process.children().flatMap(arg_0 -> Companion.getAllSubprocessesRecursively$lambda$1(Companion::getAllSubprocessesRecursively$lambda$0, arg_0)));
            Intrinsics.checkNotNullExpressionValue(stream, (String)"concat(...)");
            return stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Map<Long, Long> getProcessCpuTime(@NotNull List<? extends ProcessHandle> processes) {
            Map map;
            Intrinsics.checkNotNullParameter(processes, (String)"processes");
            if (SystemInfo.isMac) {
                void $this$associateTo$iv$iv;
                String p0;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Object it;
                Object it2;
                Collection<Long> collection2;
                void $this$mapTo$iv$iv2;
                Reader $this$map$iv;
                Object object = new String[5];
                object[0] = "ps";
                object[1] = "-p";
                Iterable iterable = processes;
                int n = 2;
                String[] stringArray = object;
                int $i$f$map = 0;
                void var6_18 = $this$map$iv;
                Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    ProcessHandle processHandle = (ProcessHandle)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(it2.pid());
                }
                collection2 = (List)((Object)destination$iv$iv);
                stringArray[n] = CollectionsKt.joinToString$default((Iterable)collection2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                object[3] = "-o";
                object[4] = "pid=,time=";
                String[] stringArray2 = object;
                InputStream inputStream = new ProcessBuilder(stringArray2).start().getInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                Closeable closeable = inputStream;
                object = Charsets.UTF_8;
                $this$map$iv = new InputStreamReader((InputStream)closeable, (Charset)object);
                $i$f$map = 8192;
                closeable = $this$map$iv instanceof BufferedReader ? (BufferedReader)$this$map$iv : new BufferedReader($this$map$iv, $i$f$map);
                object = null;
                try {
                    it = (BufferedReader)closeable;
                    boolean bl = false;
                    it = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)((Reader)it)))).toString();
                }
                catch (Throwable bl) {
                    object = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
                Iterable $this$map$iv2 = StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                boolean $i$f$map2 = false;
                it = $this$map$iv2;
                Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)p0)).toString());
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                $i$f$map2 = false;
                $this$mapTo$iv$iv = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    void it3;
                    p0 = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    it2 = (CharSequence)it3;
                    Regex bl2 = new Regex("\\s+");
                    int n2 = 0;
                    it2 = bl2.split((CharSequence)it2, n2);
                    boolean $i$f$filter = false;
                    void var13_55 = $this$filter$iv;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it4 = (String)element$iv$iv;
                        boolean bl3 = false;
                        if (!(!(((CharSequence)it4).length() == 0))) continue;
                        destination$iv$iv3.add(element$iv$iv);
                    }
                    collection.add((List)destination$iv$iv3);
                }
                Iterable $this$associate$iv = (List)destination$iv$iv2;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv2 = $this$associate$iv;
                Map destination$iv$iv4 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv4;
                    it2 = (List)element$iv$iv;
                    boolean bl = false;
                    it2 = TuplesKt.to((Object)Long.parseLong((String)it2.get(0)), (Object)Companion.parseTime((String)it2.get(1)));
                    map2.put(it2.getFirst(), it2.getSecond());
                }
                map = destination$iv$iv4;
            } else if (SystemInfo.isWindows) {
                Iterable $this$associate$iv = processes;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable $this$associateTo$iv$iv = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map3 = destination$iv$iv;
                    ProcessHandle it = (ProcessHandle)element$iv$iv;
                    boolean bl = false;
                    Long l = it.pid();
                    Optional<Duration> optional = it.info().totalCpuDuration();
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"totalCpuDuration(...)");
                    Duration duration = (Duration)OptionalsKt.getOrNull(optional);
                    it = new Pair((Object)l, (Object)(duration != null ? duration.toMillis() : 0L));
                    map3.put(it.getFirst(), it.getSecond());
                }
                map = destination$iv$iv;
            } else if (SystemInfo.isLinux) {
                Iterable $this$associate$iv = processes;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable $this$associateTo$iv$iv = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map4 = destination$iv$iv;
                    ProcessHandle it = (ProcessHandle)element$iv$iv;
                    boolean bl = false;
                    Long l = it.pid();
                    Optional<Duration> optional = it.info().totalCpuDuration();
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"totalCpuDuration(...)");
                    Duration duration = (Duration)OptionalsKt.getOrNull(optional);
                    Pair pair = new Pair((Object)l, (Object)(duration != null ? duration.toMillis() : 0L));
                    map4.put(pair.getFirst(), pair.getSecond());
                }
                map = destination$iv$iv;
            } else {
                map = MapsKt.emptyMap();
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final String getCommandLine(ProcessHandle processHandle) {
            if (SystemInfo.isMac) {
                Optional<String> optional = processHandle.info().commandLine();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"commandLine(...)");
                Object object = OptionalsKt.getOrDefault(optional, (Object)"");
                Optional<String[]> optional2 = processHandle.info().arguments();
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"arguments(...)");
                Object[] objectArray = (String[])OptionalsKt.getOrDefault(optional2, (Object)new String[0]);
                return object + (objectArray != null ? ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) : null);
            }
            if (SystemInfo.isWindows) {
                try {
                    Object object = new String[]{"powershell", "-Command", "Get-CimInstance Win32_Process -Filter \"ProcessId=" + processHandle.pid() + "\" | Select-Object -ExpandProperty CommandLine"};
                    InputStream inputStream = new ProcessBuilder((String)object).start().getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    Closeable closeable = inputStream;
                    object = Charsets.UTF_8;
                    Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
                    int n = 8192;
                    closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                    object = null;
                    try {
                        BufferedReader reader2 = (BufferedReader)closeable;
                        boolean bl = false;
                        String string = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)reader2))).toString();
                        return string;
                    }
                    catch (Throwable bl) {
                        object = bl;
                        throw bl;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                }
                catch (Exception exception) {
                    return "";
                }
            }
            if (SystemInfo.isLinux) {
                try {
                    void $this$filterTo$iv$iv;
                    String[] exception = new String[]{String.valueOf(processHandle.pid()), "cmdline"};
                    List<String> list = Files.readAllLines(Path.of("/proc", exception));
                    Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                    char[] cArray = new char[]{'\u0000'};
                    Iterable $this$filter$iv = StringsKt.split$default((CharSequence)CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$filter = false;
                    Iterable reader2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)it).length() > 0;
                        if (!bl2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                }
                catch (Exception exception) {
                    return "";
                }
            }
            return "";
        }

        public final long parseTime(@NotNull String time) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            if (StringsKt.contains$default((CharSequence)time, (CharSequence)"-", (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{"-"};
                List list = StringsKt.split$default((CharSequence)time, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String days = (String)list.get(0);
                String rest = (String)list.get(1);
                return Long.parseLong(days) * (long)24 * (long)3600 * (long)1000 + this.parseTime(rest);
            }
            String[] days = new String[]{":"};
            List values = StringsKt.split$default((CharSequence)time, (String[])days, (boolean)false, (int)0, (int)6, null);
            long result = 0L;
            for (String value : values) {
                result *= (long)60;
                result += (long)(Double.parseDouble(value) * (double)1000);
            }
            return result;
        }

        private static final Stream getAllSubprocessesRecursively$lambda$0(ProcessHandle it) {
            Intrinsics.checkNotNull((Object)it);
            return Companion.getAllSubprocessesRecursively(it);
        }

        private static final Stream getAllSubprocessesRecursively$lambda$1(Function1 $tmp0, Object p0) {
            return (Stream)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003JL\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010 J\u0014\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010$\u001a\u00020%H\u00d6\u0081\u0004J\n\u0010&\u001a\u00020\u0007H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011\u00a8\u0006'"}, d2={"Lcom/intellij/internal/jcef/test/cases/CefProcess$ProcessInfo;", "", "processType", "Lcom/intellij/internal/jcef/test/cases/CefProcess$ProcessType;", "pid", "", "commandLine", "", "cpuUsage", "", "lastTimeMs", "lastCpuTimeMs", "<init>", "(Lcom/intellij/internal/jcef/test/cases/CefProcess$ProcessType;JLjava/lang/String;Ljava/lang/Double;JJ)V", "getProcessType", "()Lcom/intellij/internal/jcef/test/cases/CefProcess$ProcessType;", "getPid", "()J", "getCommandLine", "()Ljava/lang/String;", "getCpuUsage", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getLastTimeMs", "getLastCpuTimeMs", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Lcom/intellij/internal/jcef/test/cases/CefProcess$ProcessType;JLjava/lang/String;Ljava/lang/Double;JJ)Lcom/intellij/internal/jcef/test/cases/CefProcess$ProcessInfo;", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.internal"})
    public static final class ProcessInfo {
        @NotNull
        private final ProcessType processType;
        private final long pid;
        @NotNull
        private final String commandLine;
        @Nullable
        private final Double cpuUsage;
        private final long lastTimeMs;
        private final long lastCpuTimeMs;

        public ProcessInfo(@NotNull ProcessType processType, long pid, @NotNull String commandLine, @Nullable Double cpuUsage, long lastTimeMs, long lastCpuTimeMs) {
            Intrinsics.checkNotNullParameter((Object)((Object)processType), (String)"processType");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            this.processType = processType;
            this.pid = pid;
            this.commandLine = commandLine;
            this.cpuUsage = cpuUsage;
            this.lastTimeMs = lastTimeMs;
            this.lastCpuTimeMs = lastCpuTimeMs;
        }

        @NotNull
        public final ProcessType getProcessType() {
            return this.processType;
        }

        public final long getPid() {
            return this.pid;
        }

        @NotNull
        public final String getCommandLine() {
            return this.commandLine;
        }

        @Nullable
        public final Double getCpuUsage() {
            return this.cpuUsage;
        }

        public final long getLastTimeMs() {
            return this.lastTimeMs;
        }

        public final long getLastCpuTimeMs() {
            return this.lastCpuTimeMs;
        }

        @NotNull
        public final ProcessType component1() {
            return this.processType;
        }

        public final long component2() {
            return this.pid;
        }

        @NotNull
        public final String component3() {
            return this.commandLine;
        }

        @Nullable
        public final Double component4() {
            return this.cpuUsage;
        }

        public final long component5() {
            return this.lastTimeMs;
        }

        public final long component6() {
            return this.lastCpuTimeMs;
        }

        @NotNull
        public final ProcessInfo copy(@NotNull ProcessType processType, long pid, @NotNull String commandLine, @Nullable Double cpuUsage, long lastTimeMs, long lastCpuTimeMs) {
            Intrinsics.checkNotNullParameter((Object)((Object)processType), (String)"processType");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            return new ProcessInfo(processType, pid, commandLine, cpuUsage, lastTimeMs, lastCpuTimeMs);
        }

        public static /* synthetic */ ProcessInfo copy$default(ProcessInfo processInfo, ProcessType processType, long l, String string, Double d, long l2, long l3, int n, Object object) {
            if ((n & 1) != 0) {
                processType = processInfo.processType;
            }
            if ((n & 2) != 0) {
                l = processInfo.pid;
            }
            if ((n & 4) != 0) {
                string = processInfo.commandLine;
            }
            if ((n & 8) != 0) {
                d = processInfo.cpuUsage;
            }
            if ((n & 0x10) != 0) {
                l2 = processInfo.lastTimeMs;
            }
            if ((n & 0x20) != 0) {
                l3 = processInfo.lastCpuTimeMs;
            }
            return processInfo.copy(processType, l, string, d, l2, l3);
        }

        @NotNull
        public String toString() {
            return "ProcessInfo(processType=" + this.processType + ", pid=" + this.pid + ", commandLine=" + this.commandLine + ", cpuUsage=" + this.cpuUsage + ", lastTimeMs=" + this.lastTimeMs + ", lastCpuTimeMs=" + this.lastCpuTimeMs + ")";
        }

        public int hashCode() {
            int result = this.processType.hashCode();
            result = result * 31 + Long.hashCode(this.pid);
            result = result * 31 + this.commandLine.hashCode();
            result = result * 31 + (this.cpuUsage == null ? 0 : ((Object)this.cpuUsage).hashCode());
            result = result * 31 + Long.hashCode(this.lastTimeMs);
            result = result * 31 + Long.hashCode(this.lastCpuTimeMs);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProcessInfo)) {
                return false;
            }
            ProcessInfo processInfo = (ProcessInfo)other;
            if (this.processType != processInfo.processType) {
                return false;
            }
            if (this.pid != processInfo.pid) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.commandLine, (Object)processInfo.commandLine)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cpuUsage, (Object)processInfo.cpuUsage)) {
                return false;
            }
            if (this.lastTimeMs != processInfo.lastTimeMs) {
                return false;
            }
            return this.lastCpuTimeMs == processInfo.lastCpuTimeMs;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/jcef/test/cases/CefProcess$ProcessType;", "", "<init>", "(Ljava/lang/String;I)V", "MAIN", "RENDERER", "GPU", "NETWORK", "STORAGE", "UTILITY_OTHER", "ZYGOTE", "UNKNOWN", "intellij.platform.ide.internal"})
    public static final class ProcessType
    extends Enum<ProcessType> {
        public static final /* enum */ ProcessType MAIN = new ProcessType();
        public static final /* enum */ ProcessType RENDERER = new ProcessType();
        public static final /* enum */ ProcessType GPU = new ProcessType();
        public static final /* enum */ ProcessType NETWORK = new ProcessType();
        public static final /* enum */ ProcessType STORAGE = new ProcessType();
        public static final /* enum */ ProcessType UTILITY_OTHER = new ProcessType();
        public static final /* enum */ ProcessType ZYGOTE = new ProcessType();
        public static final /* enum */ ProcessType UNKNOWN = new ProcessType();
        private static final /* synthetic */ ProcessType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ProcessType[] values() {
            return (ProcessType[])$VALUES.clone();
        }

        public static ProcessType valueOf(String value) {
            return Enum.valueOf(ProcessType.class, value);
        }

        @NotNull
        public static EnumEntries<ProcessType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = processTypeArray = new ProcessType[]{ProcessType.MAIN, ProcessType.RENDERER, ProcessType.GPU, ProcessType.NETWORK, ProcessType.STORAGE, ProcessType.UTILITY_OTHER, ProcessType.ZYGOTE, ProcessType.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

