/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.KeymapFlagsStorage;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class KeymapChangesCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("keymap.changes", 5);
    private static final BooleanEventField IMPORTED = EventFields.Boolean((String)"imported");
    private static final VarargEventId KEYMAP_CHANGE = GROUP.registerVarargEvent("keymap.change", new EventField[]{ActionsEventLogGroup.ACTION_ID, IMPORTED});

    KeymapChangesCollector() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager == null) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                KeymapChangesCollector.$$$reportNull$$$0(0);
            }
            return set;
        }
        Keymap keymap = keymapManager.getActiveKeymap();
        if (!keymap.canModify()) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                KeymapChangesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        HashSet<MetricEvent> data = new HashSet<MetricEvent>();
        KeymapFlagsStorage keymapFlagsStorage = (KeymapFlagsStorage)ApplicationManager.getApplication().getService(KeymapFlagsStorage.class);
        for (String action_id : keymap.getActionIds()) {
            if (!ActionsTree.isShortcutCustomized((String)action_id, (Keymap)keymap)) continue;
            if (keymapFlagsStorage.hasFlag(keymap, action_id, "MIGRATED_SHORTCUT")) {
                data.add(KEYMAP_CHANGE.metric(new EventPair[]{ActionsEventLogGroup.ACTION_ID.with((Object)action_id), IMPORTED.with((Object)true)}));
                continue;
            }
            data.add(KEYMAP_CHANGE.metric(new EventPair[]{ActionsEventLogGroup.ACTION_ID.with((Object)action_id)}));
        }
        HashSet<MetricEvent> hashSet = data;
        if (hashSet == null) {
            KeymapChangesCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/fus/KeymapChangesCollector", "getMetrics"));
    }
}

