/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.build;

import com.intellij.internal.statistic.collectors.fus.build.BazelProjectDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"PROPERTY_ID", "", "updateBazelProjectDetectorState", "", "project", "Lcom/intellij/openapi/project/Project;", "hasBazelFile", "", "DOT_BAZEL_FILE", "DOT_BZL_FILE", "BAZEL_BUILD_FILE", "BAZEL_MODULE_FILE", "BAZEL_WORKSPACE_FILE", "isBazelBuildFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isBazelModuleFile", "isBazelWorkspaceFile", "isBazelSuffixed", "lowercaseName", "intellij.platform.ide.internal"})
public final class BazelFilesTypeUsageSchemaDescriptorKt {
    @NotNull
    private static final String PROPERTY_ID = "bazel.project.detector.is.bazel.project";
    @NotNull
    private static final String DOT_BAZEL_FILE = ".bazel";
    @NotNull
    private static final String DOT_BZL_FILE = ".bzl";
    @NotNull
    private static final String BAZEL_BUILD_FILE = "BUILD";
    @NotNull
    private static final String BAZEL_MODULE_FILE = "MODULE.bazel";
    @NotNull
    private static final String BAZEL_WORKSPACE_FILE = "WORKSPACE";

    private static final void updateBazelProjectDetectorState(Project project, boolean hasBazelFile) {
        if (hasBazelFile && !BazelProjectDetector.INSTANCE.hasBazelFiles(project)) {
            BazelProjectDetector.INSTANCE.setHasBazelFiles(project, true);
        }
    }

    private static final boolean isBazelBuildFile(VirtualFile file) {
        return Intrinsics.areEqual((Object)FileUtil.getNameWithoutExtension((String)file.getName()), (Object)BAZEL_BUILD_FILE);
    }

    private static final boolean isBazelModuleFile(VirtualFile file) {
        return Intrinsics.areEqual((Object)file.getName(), (Object)BAZEL_MODULE_FILE);
    }

    private static final boolean isBazelWorkspaceFile(VirtualFile file) {
        return Intrinsics.areEqual((Object)FileUtil.getNameWithoutExtension((String)file.getName()), (Object)BAZEL_WORKSPACE_FILE);
    }

    private static final boolean isBazelSuffixed(VirtualFile file, String lowercaseName) {
        return (StringsKt.endsWith$default((String)lowercaseName, (String)DOT_BAZEL_FILE, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)lowercaseName, (String)DOT_BZL_FILE, (boolean)false, (int)2, null)) && !BazelFilesTypeUsageSchemaDescriptorKt.isBazelBuildFile(file) && !BazelFilesTypeUsageSchemaDescriptorKt.isBazelWorkspaceFile(file) && !BazelFilesTypeUsageSchemaDescriptorKt.isBazelModuleFile(file);
    }

    public static final /* synthetic */ boolean access$isBazelSuffixed(VirtualFile file, String lowercaseName) {
        return BazelFilesTypeUsageSchemaDescriptorKt.isBazelSuffixed(file, lowercaseName);
    }

    public static final /* synthetic */ void access$updateBazelProjectDetectorState(Project project, boolean hasBazelFile) {
        BazelFilesTypeUsageSchemaDescriptorKt.updateBazelProjectDetectorState(project, hasBazelFile);
    }

    public static final /* synthetic */ boolean access$isBazelBuildFile(VirtualFile file) {
        return BazelFilesTypeUsageSchemaDescriptorKt.isBazelBuildFile(file);
    }

    public static final /* synthetic */ boolean access$isBazelWorkspaceFile(VirtualFile file) {
        return BazelFilesTypeUsageSchemaDescriptorKt.isBazelWorkspaceFile(file);
    }

    public static final /* synthetic */ boolean access$isBazelModuleFile(VirtualFile file) {
        return BazelFilesTypeUsageSchemaDescriptorKt.isBazelModuleFile(file);
    }
}

