/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.environment;

import com.intellij.internal.statistic.collectors.fus.environment.EditorsCollectorKt;
import com.intellij.internal.statistic.collectors.fus.environment.ExternalEditorCollectionDataProvider;
import com.intellij.internal.statistic.collectors.fus.environment.VSCodeCollectionDataProviderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJ\r\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\rJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/collectors/fus/environment/VSCodeCollectionDataProvider;", "Lcom/intellij/internal/statistic/collectors/fus/environment/ExternalEditorCollectionDataProvider;", "<init>", "()V", "vsCodeHomePath", "Ljava/nio/file/Path;", "pluginsDirectoryPath", "pluginsConfigPath", "databasePath", "maxTimeSinceLastModificationToBeRecent", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "isVSCodeDetected", "", "isVSCodeUsedRecently", "()Ljava/lang/Boolean;", "isVSCodePluginsProcessingPossible", "getVSCodePluginsIds", "", "", "getWindowsVSCodeHomePath", "intellij.platform.ide.internal"})
@SourceDebugExtension(value={"SMAP\nVSCodeCollectionDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSCodeCollectionDataProvider.kt\ncom/intellij/internal/statistic/collectors/fus/environment/VSCodeCollectionDataProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,169:1\n60#2,5:170\n60#2,5:175\n60#2,5:180\n60#2,5:185\n60#2,5:190\n60#2,5:195\n60#2,5:200\n60#2,5:205\n60#2,5:210\n60#2,5:215\n60#2,5:220\n*S KotlinDebug\n*F\n+ 1 VSCodeCollectionDataProvider.kt\ncom/intellij/internal/statistic/collectors/fus/environment/VSCodeCollectionDataProvider\n*L\n53#1:170,5\n54#1:175,5\n55#1:180,5\n56#1:185,5\n63#1:190,5\n71#1:195,5\n85#1:200,5\n89#1:205,5\n110#1:210,5\n154#1:215,5\n161#1:220,5\n*E\n"})
public final class VSCodeCollectionDataProvider
extends ExternalEditorCollectionDataProvider {
    @Nullable
    private final Path vsCodeHomePath;
    @Nullable
    private final Path pluginsDirectoryPath;
    @Nullable
    private final Path pluginsConfigPath;
    @Nullable
    private final Path databasePath;
    private final Duration maxTimeSinceLastModificationToBeRecent;

    public VSCodeCollectionDataProvider() {
        Logger logger;
        Path path;
        Path path2;
        Path path3;
        String[] stringArray;
        if (SystemInfo.isMac) {
            Path path4 = this.getHomeDirectory();
            if (path4 != null) {
                stringArray = new String[]{"Application Support", "Code"};
                path3 = path4.resolve(Paths.get("Library", stringArray));
            } else {
                path3 = null;
            }
        } else if (SystemInfo.isWindows) {
            path3 = this.getWindowsVSCodeHomePath();
        } else {
            Path path5 = this.getHomeDirectory();
            if (path5 != null) {
                stringArray = new String[]{"Code"};
                path3 = path5.resolve(Paths.get(".config", stringArray));
            } else {
                path3 = null;
            }
        }
        this.vsCodeHomePath = path3;
        Path path6 = this.getHomeDirectory();
        if (path6 != null) {
            stringArray = new String[]{"extensions"};
            path2 = path6.resolve(Paths.get(".vscode", stringArray));
        } else {
            path2 = null;
        }
        Path path7 = this.pluginsDirectoryPath = path2;
        this.pluginsConfigPath = path7 != null ? path7.resolve("extensions.json") : null;
        Path path8 = this.vsCodeHomePath;
        if (path8 != null) {
            stringArray = new String[]{"globalStorage", "state.vscdb"};
            path = path8.resolve(Paths.get("User", stringArray));
        } else {
            path = null;
        }
        this.databasePath = path;
        Logger $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("VSCode home path: " + this.vsCodeHomePath, t$iv);
        }
        $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("VSCode plugins directory path: " + this.pluginsDirectoryPath, t$iv);
        }
        $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("VSCode plugins config path: " + this.pluginsConfigPath, t$iv);
        }
        $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("VSCode database path: " + this.databasePath, t$iv);
        }
        this.maxTimeSinceLastModificationToBeRecent = Duration.ofHours(720L);
    }

    public final boolean isVSCodeDetected() {
        boolean bl;
        if (this.getHomeDirectory() == null) {
            Logger $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("VSCode is not detected - home directory is null", t$iv);
            }
            return false;
        }
        Path vsCodeConfigDir = this.getHomeDirectory().resolve(".vscode");
        try {
            boolean isVsCodeConfigDirValid = Files.isDirectory(vsCodeConfigDir, new LinkOption[0]);
            Logger $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl3 = false;
                logger.debug("Is " + vsCodeConfigDir + " a valid directory: " + isVsCodeConfigDirValid, t$iv);
            }
        }
        catch (SecurityException e) {
            VSCodeCollectionDataProviderKt.access$getLogger$p().debug((Throwable)e);
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final Boolean isVSCodeUsedRecently() {
        Object var1_2;
        try {
            boolean bl;
            Path path = this.databasePath;
            if (path != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl = Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            } else {
                bl = false;
            }
            if (bl) {
                FileTime time = Files.getLastModifiedTime(this.databasePath, new LinkOption[0]);
                boolean isVSCodeUsedRecently = time.toInstant().compareTo(Instant.now().minus(this.maxTimeSinceLastModificationToBeRecent)) > 0;
                Logger $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("Is VSCode used recently: " + isVSCodeUsedRecently, t$iv);
                }
                return isVSCodeUsedRecently;
            }
            Logger $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl3 = false;
                logger.debug("VSCode is not used recently - database path doesn't exist", t$iv);
            }
            var1_2 = null;
        }
        catch (IOException e) {
            VSCodeCollectionDataProviderKt.access$getLogger$p().debug((Throwable)e);
            var1_2 = null;
        }
        catch (SecurityException e) {
            VSCodeCollectionDataProviderKt.access$getLogger$p().debug((Throwable)e);
            var1_2 = null;
        }
        return var1_2;
    }

    public final boolean isVSCodePluginsProcessingPossible() {
        boolean bl;
        try {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            Path path = this.pluginsDirectoryPath;
            if (path != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl5 = Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            } else {
                bl5 = false;
            }
            boolean isVSCodePluginDirExists = bl5;
            Path path2 = this.pluginsDirectoryPath;
            if (path2 != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl4 = Files.isDirectory(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            } else {
                bl4 = false;
            }
            boolean isVSCodeConfigDirValid = bl4;
            Path path3 = this.pluginsConfigPath;
            if (path3 != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl3 = Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            } else {
                bl3 = false;
            }
            boolean isVSCodeConfigFilePathExists = bl3;
            Path path4 = this.pluginsConfigPath;
            if (path4 != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl2 = Files.isRegularFile(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            } else {
                bl2 = false;
            }
            boolean isVSCodeConfigFilePathValid = bl2;
            Path path5 = this.pluginsConfigPath;
            boolean isVSCodeConfigFilePathReadable = path5 != null ? Files.isReadable(path5) : false;
            Logger $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl6 = false;
                logger.debug("isVSCodePluginDirExists = " + isVSCodePluginDirExists + "\nisVSCodeConfigDirValid = " + isVSCodeConfigDirValid + "\nisVSCodeConfigFilePathExists = " + isVSCodeConfigFilePathExists + "\nisVSCodeConfigFilePathValid = " + isVSCodeConfigFilePathValid + "\nisVSCodeConfigFilePathReadable = " + isVSCodeConfigFilePathReadable, t$iv);
            }
            bl = isVSCodePluginDirExists && isVSCodeConfigDirValid && isVSCodeConfigFilePathExists && isVSCodeConfigFilePathValid && isVSCodeConfigFilePathReadable;
        }
        catch (SecurityException e) {
            VSCodeCollectionDataProviderKt.access$getLogger$p().debug((Throwable)e);
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<String> getVSCodePluginsIds() {
        JsonElement jsonElement;
        Object object = this.pluginsConfigPath;
        if (object == null || (object = PathsKt.readText$default((Path)object, null, (int)1, null)) == null) {
            return CollectionsKt.emptyList();
        }
        Object pluginsConfigData = object;
        try {
            jsonElement = Json.Default.parseToJsonElement((String)pluginsConfigData);
        }
        catch (SerializationException e) {
            VSCodeCollectionDataProviderKt.access$getLogger$p().debug((Throwable)e);
            return CollectionsKt.emptyList();
        }
        JsonElement parsedJson = jsonElement;
        List pluginIdsList = new ArrayList();
        try {
            for (JsonElement pluginElement : JsonElementKt.getJsonArray((JsonElement)parsedJson)) {
                JsonObject pluginInfoObject = JsonElementKt.getJsonObject((JsonElement)pluginElement);
                JsonElement jsonElement2 = (JsonElement)pluginInfoObject.get((Object)"identifier");
                if (jsonElement2 == null || (jsonElement2 = JsonElementKt.getJsonObject((JsonElement)jsonElement2)) == null || (jsonElement2 = (JsonElement)jsonElement2.get((Object)"id")) == null) continue;
                JsonElement it = jsonElement2;
                boolean bl = false;
                pluginIdsList.add(JsonElementKt.getJsonPrimitive((JsonElement)it).getContent());
            }
        }
        catch (IllegalArgumentException e) {
            VSCodeCollectionDataProviderKt.access$getLogger$p().debug((Throwable)e);
            return pluginIdsList;
        }
        Logger $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Detected VSCode plugins: " + CollectionsKt.joinToString$default((Iterable)pluginIdsList, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "}", t$iv);
        }
        return pluginIdsList;
    }

    private final Path getWindowsVSCodeHomePath() {
        Path path;
        try {
            String[] stringArray = new String[]{"Code"};
            Path appDataValue = Paths.get(EditorsCollectorKt.getWindowsEnvVariableValue("APPDATA"), stringArray);
            Logger $this$debug_u24default$iv = VSCodeCollectionDataProviderKt.access$getLogger$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Detected APPDATA env var value: " + appDataValue, t$iv);
            }
        }
        catch (InvalidPathException e) {
            VSCodeCollectionDataProviderKt.access$getLogger$p().debug((Throwable)e);
            path = null;
        }
        return path;
    }
}

