/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.os;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.X11UiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class LinuxWindowManagerUsageCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("os.linux.wm", 7);
    private static final Map<String, String> GNOME_WINDOW_MANAGERS = new LinkedHashMap<String, String>();
    private static final Map<String, String> WINDOW_MANAGERS = new LinkedHashMap<String, String>();
    private static final List<String> ALL_NAMES = new ArrayList<String>();
    private static final Map<String, String> SESSION_TYPES = new LinkedHashMap<String, String>();
    private static final List<String> ALL_SESSION_NAMES = new ArrayList<String>();
    @VisibleForTesting
    public static final String EMPTY_THEME = "empty";
    @VisibleForTesting
    public static final String UNKNOWN_THEME = "unknown";
    private static final List<String> GNOME_THEME_NAMES = Arrays.asList("Adwaita", "Adwaita-dark", "Breeze", "Breeze-dark", "HighContrast", "HighContrastInverse", "Yaru", "Yaru-dark");
    private static final List<String> GNOME_THEME_FAMILIES = Arrays.asList("Yaru-");
    private static final List<String> KDE_THEME_NAMES = Arrays.asList("org.kde.breezedark.desktop", "org.kde.breezetwilight.desktop", "org.kde.breeze.desktop");
    @VisibleForTesting
    public static final List<String> ALL_THEME_NAMES = new ArrayList<String>();
    private static final EventId1<String> CURRENT_DESKTOP;
    private static final EventId1<String> SESSION_TYPE;
    private static final EventId1<String> THEME;
    private static final EventId1<String> ICON_THEME;

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        if (SystemInfo.isLinux) {
            HashSet<MetricEvent> result = new HashSet<MetricEvent>();
            result.add(CURRENT_DESKTOP.metric((Object)LinuxWindowManagerUsageCollector.toReportedName(System.getenv("XDG_CURRENT_DESKTOP"))));
            result.add(SESSION_TYPE.metric((Object)LinuxWindowManagerUsageCollector.toReportedSessionName(System.getenv("XDG_SESSION_TYPE"))));
            result.add(THEME.metric((Object)LinuxWindowManagerUsageCollector.toReportedTheme(X11UiUtil.getTheme())));
            result.add(ICON_THEME.metric((Object)LinuxWindowManagerUsageCollector.toReportedTheme(X11UiUtil.getIconTheme())));
            HashSet<MetricEvent> hashSet = result;
            if (hashSet == null) {
                LinuxWindowManagerUsageCollector.$$$reportNull$$$0(0);
            }
            return hashSet;
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @VisibleForTesting
    @NotNull
    public static String toReportedSessionName(@Nullable String sessionType) {
        if (sessionType == null) {
            return EMPTY_THEME;
        }
        String string = SESSION_TYPES.getOrDefault(sessionType, "Unknown");
        if (string == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(2);
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static String toReportedTheme(@Nullable String theme) {
        if (theme == null) {
            return EMPTY_THEME;
        }
        String result = LinuxWindowManagerUsageCollector.find(GNOME_THEME_NAMES, s -> s.equalsIgnoreCase(theme));
        if (result != null) {
            String string = result;
            if (string == null) {
                LinuxWindowManagerUsageCollector.$$$reportNull$$$0(3);
            }
            return string;
        }
        result = LinuxWindowManagerUsageCollector.find(KDE_THEME_NAMES, s -> s.equalsIgnoreCase(theme));
        if (result != null) {
            String string = result;
            if (string == null) {
                LinuxWindowManagerUsageCollector.$$$reportNull$$$0(4);
            }
            return string;
        }
        result = LinuxWindowManagerUsageCollector.find(GNOME_THEME_FAMILIES, s -> theme.startsWith((String)s));
        Object object = result == null ? UNKNOWN_THEME : result + "*";
        if (object == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(5);
        }
        return object;
    }

    @VisibleForTesting
    @NotNull
    public static String toReportedName(@Nullable String windowManger) {
        if (windowManger == null) {
            return EMPTY_THEME;
        }
        boolean isGnome = (windowManger = StringUtil.toLowerCase((String)windowManger)).contains("gnome");
        return isGnome ? LinuxWindowManagerUsageCollector.findReportedName(windowManger, GNOME_WINDOW_MANAGERS) : LinuxWindowManagerUsageCollector.findReportedName(windowManger, WINDOW_MANAGERS);
    }

    @Nullable
    private static String find(@NotNull List<String> list, @NotNull Predicate<String> predicate) {
        if (list == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(6);
        }
        if (predicate == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(7);
        }
        return list.stream().filter(predicate).findFirst().orElse(null);
    }

    @NotNull
    private static String findReportedName(@NotNull String original, @NotNull Map<String, String> keywordToName) {
        if (original == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(8);
        }
        if (keywordToName == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(9);
        }
        for (Map.Entry<String, String> entry : keywordToName.entrySet()) {
            if (!original.contains(entry.getKey())) continue;
            String string = entry.getValue();
            if (string == null) {
                LinuxWindowManagerUsageCollector.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = original;
        if (string == null) {
            LinuxWindowManagerUsageCollector.$$$reportNull$$$0(11);
        }
        return string;
    }

    static {
        GNOME_WINDOW_MANAGERS.put("shell", "Gnome Shell");
        GNOME_WINDOW_MANAGERS.put("ubuntu", "Ubuntu Gnome");
        GNOME_WINDOW_MANAGERS.put("budgie", "Budgie Gnome");
        GNOME_WINDOW_MANAGERS.put("classic", "Gnome Classic");
        GNOME_WINDOW_MANAGERS.put("flashback:unity", "GNOME Flashback Unity");
        GNOME_WINDOW_MANAGERS.put("flashback_unity", "GNOME Flashback Unity");
        GNOME_WINDOW_MANAGERS.put("flashback:gnome", "GNOME Flashback Gnome");
        GNOME_WINDOW_MANAGERS.put("flashback_gnome", "GNOME Flashback Gnome");
        GNOME_WINDOW_MANAGERS.put("flashback", "GNOME Flashback");
        GNOME_WINDOW_MANAGERS.put("pop", "pop_GNOME");
        GNOME_WINDOW_MANAGERS.put("awesome", "Awesome_GNOME");
        GNOME_WINDOW_MANAGERS.put("gnome", "Gnome");
        WINDOW_MANAGERS.put("unity7", "Unity7");
        WINDOW_MANAGERS.put("x-cinnamon", "X-Cinnamon");
        WINDOW_MANAGERS.put("xfce", "XFCE");
        WINDOW_MANAGERS.put("deepin", "Deepin");
        WINDOW_MANAGERS.put("unity", "Unity");
        WINDOW_MANAGERS.put("pantheon", "Pantheon");
        WINDOW_MANAGERS.put("i3", "i3");
        WINDOW_MANAGERS.put("kde", "KDE");
        WINDOW_MANAGERS.put("lxde", "LXDE");
        WINDOW_MANAGERS.put("mate", "MATE");
        WINDOW_MANAGERS.put("lxqt", "LXQt");
        WINDOW_MANAGERS.put("x-generic", "X-Generic");
        WINDOW_MANAGERS.put("icewm", "ICEWM");
        WINDOW_MANAGERS.put("ukui", "UKUI");
        WINDOW_MANAGERS.put("fluxbox", "Fluxbox");
        WINDOW_MANAGERS.put("lg3d", "LG3D");
        WINDOW_MANAGERS.put("enlightenment", "Enlightenment");
        WINDOW_MANAGERS.put("hyprland", "Hyprland");
        WINDOW_MANAGERS.put("default.desktop", "default.desktop");
        ALL_NAMES.addAll(GNOME_WINDOW_MANAGERS.values());
        ALL_NAMES.addAll(WINDOW_MANAGERS.values());
        SESSION_TYPES.put("tty", "Terminal");
        SESSION_TYPES.put("x11", "X11");
        SESSION_TYPES.put("wayland", "Wayland");
        ALL_SESSION_NAMES.addAll(SESSION_TYPES.values());
        ALL_SESSION_NAMES.add(EMPTY_THEME);
        ALL_SESSION_NAMES.add("Unknown");
        ALL_THEME_NAMES.add(EMPTY_THEME);
        ALL_THEME_NAMES.add(UNKNOWN_THEME);
        ALL_THEME_NAMES.addAll(GNOME_THEME_NAMES);
        for (String family : GNOME_THEME_FAMILIES) {
            ALL_THEME_NAMES.add(family + "*");
        }
        ALL_THEME_NAMES.addAll(KDE_THEME_NAMES);
        CURRENT_DESKTOP = GROUP.registerEvent("xdg.current.desktop", (EventField)EventFields.String((String)"value", ALL_NAMES));
        SESSION_TYPE = GROUP.registerEvent("xdg.session.type", (EventField)EventFields.String((String)"value", ALL_SESSION_NAMES));
        THEME = GROUP.registerEvent("theme", (EventField)EventFields.String((String)"value", ALL_THEME_NAMES));
        ICON_THEME = GROUP.registerEvent("iconTheme", (EventField)EventFields.String((String)"value", ALL_THEME_NAMES));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/os/LinuxWindowManagerUsageCollector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordToName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toReportedSessionName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toReportedTheme";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/os/LinuxWindowManagerUsageCollector";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findReportedName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findReportedName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

