/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.notification;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.ide.StatisticsNotificationManager;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutImpl;
import java.awt.Window;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class StatisticsNotificationManagerImpl
implements StatisticsNotificationManager {
    StatisticsNotificationManagerImpl() {
    }

    public void showNotificationIfNeeded() {
        if (!StatisticsNotificationManagerImpl.isShouldShowNotification()) {
            return;
        }
        NotificationsConfigurationImpl.remove((String[])new String[]{"SendUsagesStatistics"});
        final Disposable disposable = Disposer.newDisposable();
        ApplicationManager.getApplication().getMessageBus().connect(disposable).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StatisticsNotificationManagerImpl.isEmpty(WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow())) {
                    Disposer.dispose((Disposable)disposable);
                    ApplicationManager.getApplication().invokeLater(() -> StatisticsNotificationManagerImpl.showNotification());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/internal/statistic/notification/StatisticsNotificationManagerImpl$1", "applicationActivated"));
            }
        });
    }

    private static boolean isShouldShowNotification() {
        return UsageStatisticsPersistenceComponent.getInstance().isShowNotification() && System.currentTimeMillis() - 604800000L > ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFirstRunTime();
    }

    private static void showNotification() {
        if (AppUIUtil.INSTANCE.showConsentsAgreementIfNeeded(Logger.getInstance(StatisticsNotificationManagerImpl.class), ConsentOptions.condUsageStatsConsent())) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> StatisticsUploadAssistant.getEventLogStatisticsService((String)"FUS").send());
            UsageStatisticsPersistenceComponent.getInstance().setShowNotification(false);
        }
    }

    private static boolean isEmpty(@Nullable Window window) {
        BalloonLayout layout;
        ProjectFrameHelper frameHelper = ProjectFrameHelper.getFrameHelper((Window)window);
        if (frameHelper != null && (layout = frameHelper.getBalloonLayout()) instanceof BalloonLayoutImpl) {
            return ((BalloonLayoutImpl)layout).isEmpty();
        }
        return false;
    }
}

