/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.intellij.internal.ui.RoundedIconTestAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.ui.Gray;
import com.intellij.ui.RoundedIcon;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/ui/RoundedIconTestAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "topHalf", "", "randomColor", "Ljava/awt/Color;", "createRandomImage", "Ljava/awt/image/BufferedImage;", "width", "", "height", "intellij.platform.ide.internal"})
public final class RoundedIconTestAction
extends DumbAwareAction {
    public RoundedIconTestAction() {
        super("Show Rounded Icon");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        DialogWrapper.IdeModalityType ideModalityType = DialogWrapper.IdeModalityType.IDE;
        new DialogWrapper(this, project, ideModalityType){
            private final JBLabel label;
            private final JCheckBox iconChooser;
            private final JCheckBox formChooser;
            private final JSlider slider;
            private final Lazy splashIcon$delegate;
            private final Lazy generatedIcon$delegate;
            {
                void $this$slider_u24lambda_u243;
                Object $this$formChooser_u24lambda_u242;
                Object $this$iconChooser_u24lambda_u241;
                Object $this$label_u24lambda_u240;
                Object object;
                JBLabel jBLabel = object = new JBLabel("Some text");
                actionPerformed.1 var7_6 = this;
                boolean bl = false;
                $this$label_u24lambda_u240.setHorizontalAlignment(0);
                $this$label_u24lambda_u240.setHorizontalTextPosition(2);
                var7_6.label = object;
                $this$label_u24lambda_u240 = object = new JCheckBox("Splash", true);
                var7_6 = this;
                boolean bl2 = false;
                $this$iconChooser_u24lambda_u241.setOpaque(false);
                var7_6.iconChooser = object;
                $this$iconChooser_u24lambda_u241 = object = new JCheckBox("Superellipse", true);
                var7_6 = this;
                boolean bl3 = false;
                $this$formChooser_u24lambda_u242.setOpaque(false);
                var7_6.formChooser = object;
                $this$formChooser_u24lambda_u242 = object = new JSlider(0, 100);
                var7_6 = this;
                boolean bl4 = false;
                $this$slider_u24lambda_u243.setValue(33);
                $this$slider_u24lambda_u243.setPaintLabels(true);
                $this$slider_u24lambda_u243.setPaintTicks(true);
                $this$slider_u24lambda_u243.setMinorTickSpacing(1);
                $this$slider_u24lambda_u243.setMajorTickSpacing(10);
                $this$slider_u24lambda_u243.setOpaque(false);
                var7_6.slider = object;
                this.splashIcon$delegate = LazyKt.lazy(actionPerformed.1::splashIcon_delegate$lambda$4);
                this.generatedIcon$delegate = LazyKt.lazy(() -> actionPerformed.1.generatedIcon_delegate$lambda$5($receiver, this));
                this.setTitle("Rounded Icon Demo");
                this.setResizable(false);
                this.init();
                this.slider.addChangeListener(arg_0 -> actionPerformed.1._init_$lambda$6(this, arg_0));
                this.updateIcon();
            }

            public final JSlider getSlider() {
                return this.slider;
            }

            public final Icon getSplashIcon() {
                Lazy lazy = this.splashIcon$delegate;
                return (Icon)lazy.getValue();
            }

            public final Icon getGeneratedIcon() {
                Lazy lazy = this.generatedIcon$delegate;
                return (Icon)lazy.getValue();
            }

            protected DialogWrapper.DialogStyle getStyle() {
                return DialogWrapper.DialogStyle.COMPACT;
            }

            protected JComponent createCenterPanel() {
                BorderLayoutPanel borderLayoutPanel;
                BorderLayoutPanel $this$createCenterPanel_u24lambda_u247 = borderLayoutPanel = new BorderLayoutPanel(){

                    protected void paintComponent(Graphics g) {
                        super.paintComponent(g);
                        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                        GraphicsUtil.setupAAPainting((Graphics)((Graphics2D)g));
                        ((Graphics2D)g).setPaint(new GradientPaint(0.0f, 0.0f, UIUtil.getLabelDisabledForeground(), 0.0f, this.getHeight(), Gray.TRANSPARENT));
                        for (int x = -this.getHeight(); x < this.getWidth() + this.getHeight(); x += 10) {
                            ((Graphics2D)g).drawLine(x, 0, x + this.getHeight(), this.getHeight());
                            ((Graphics2D)g).drawLine(x, 0, x - this.getHeight(), this.getHeight());
                        }
                    }
                };
                boolean bl = false;
                $this$createCenterPanel_u24lambda_u247.setBorder(DialogWrapper.createDefaultBorder());
                BorderLayoutPanel panel2 = borderLayoutPanel;
                ActionListener actionListener = arg_0 -> actionPerformed.1.createCenterPanel$lambda$8(this, arg_0);
                this.iconChooser.addActionListener(actionListener);
                this.formChooser.addActionListener(actionListener);
                panel2.add((Component)this.label, (Object)"Center");
                NonOpaquePanel southPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                NonOpaquePanel chooserPanel = new NonOpaquePanel((LayoutManager)new GridLayout(2, 1));
                chooserPanel.add((Component)this.iconChooser);
                chooserPanel.add((Component)this.formChooser);
                southPanel.add((Component)chooserPanel, (Object)"West");
                southPanel.add((Component)this.slider, (Object)"Center");
                panel2.add((Component)southPanel, (Object)"South");
                return (JComponent)panel2;
            }

            public final void updateIcon() {
                this.label.setIcon((Icon)new RoundedIcon(this.iconChooser.isSelected() ? this.getSplashIcon() : this.getGeneratedIcon(), (double)this.slider.getValue() * 0.01, this.formChooser.isSelected()));
            }

            protected Action[] createActions() {
                return new Action[0];
            }

            private static final Icon splashIcon_delegate$lambda$4() {
                String string = ApplicationInfoImpl.getShadowInstanceImpl().getSplashImageUrl();
                Intrinsics.checkNotNull((Object)string);
                ClassLoader classLoader = ApplicationInfo.class.getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                Icon icon = IconLoaderKt.findIconUsingNewImplementation$default((String)string, (ClassLoader)classLoader, null, (int)4, null);
                Intrinsics.checkNotNull((Object)icon);
                return icon;
            }

            private static final JBImageIcon generatedIcon_delegate$lambda$5(RoundedIconTestAction this$0, actionPerformed.1 this$1) {
                BufferedImage bufferedImage = RoundedIconTestAction.access$createRandomImage(this$0, this$1.getSplashIcon().getIconWidth(), this$1.getSplashIcon().getIconHeight());
                Intrinsics.checkNotNull((Object)bufferedImage, (String)"null cannot be cast to non-null type java.awt.Image");
                return IconUtil.createImageIcon((Image)bufferedImage);
            }

            private static final void _init_$lambda$6(actionPerformed.1 this$0, ChangeEvent it) {
                this$0.updateIcon();
            }

            private static final void createCenterPanel$lambda$8(actionPerformed.1 this$0, ActionEvent it) {
                this$0.updateIcon();
            }
        }.show();
    }

    private final float topHalf() {
        return (float)(0.5 + Math.random() / (double)2);
    }

    private final Color randomColor() {
        return new Color(this.topHalf(), this.topHalf(), this.topHalf(), this.topHalf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BufferedImage createRandomImage(int width, int height) {
        BufferedImage bufferedImage = ImageUtil.createImage((int)width, (int)height, (int)3);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage image = bufferedImage;
        Graphics graphics = image.getGraphics();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g = (Graphics2D)graphics;
        try {
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.randomColor());
            RectanglePainter.FILL.paint(g, 0, 0, width, height, null);
            for (int i = 0; i < 100; ++i) {
                g.setColor(this.randomColor());
                double r = Math.random() * (double)Math.min(width, height) / Math.PI;
                g.fill(new Ellipse2D.Double(Math.random() * (double)width, Math.random() * (double)height, r, r));
            }
            g.setColor(new Color(0, 0, 0, 85));
            g.fill(new Ellipse2D.Double(width / 2 - 2, height / 2 - 2, 4.0, 4.0));
        }
        finally {
            g.dispose();
        }
        return image;
    }

    public static final /* synthetic */ BufferedImage access$createRandomImage(RoundedIconTestAction $this, int width, int height) {
        return $this.createRandomImage(width, height);
    }
}

