/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ml;

import com.intellij.internal.ml.BinaryFeature;
import com.intellij.internal.ml.CategoricalFeature;
import com.intellij.internal.ml.Feature;
import com.intellij.internal.ml.FeatureMapper;
import com.intellij.internal.ml.FloatFeature;
import com.intellij.internal.ml.InconsistentMetadataException;
import com.intellij.internal.ml.ModelMetadata;
import com.intellij.internal.ml.ModelMetadataReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBW\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/ml/FeaturesInfo;", "Lcom/intellij/internal/ml/ModelMetadata;", "knownFeatures", "", "", "binaryFeatures", "", "Lcom/intellij/internal/ml/BinaryFeature;", "floatFeatures", "Lcom/intellij/internal/ml/FloatFeature;", "categoricalFeatures", "Lcom/intellij/internal/ml/CategoricalFeature;", "featuresOrder", "", "Lcom/intellij/internal/ml/FeatureMapper;", "version", "<init>", "(Ljava/util/Set;Ljava/util/List;Ljava/util/List;Ljava/util/List;[Lcom/intellij/internal/ml/FeatureMapper;Ljava/lang/String;)V", "getKnownFeatures", "()Ljava/util/Set;", "getBinaryFeatures", "()Ljava/util/List;", "getFloatFeatures", "getCategoricalFeatures", "getFeaturesOrder", "()[Lcom/intellij/internal/ml/FeatureMapper;", "[Lcom/intellij/internal/ml/FeatureMapper;", "getVersion", "()Ljava/lang/String;", "Companion", "intellij.platform.ide.internal"})
@ApiStatus.Internal
public final class FeaturesInfo
implements ModelMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> knownFeatures;
    @NotNull
    private final List<BinaryFeature> binaryFeatures;
    @NotNull
    private final List<FloatFeature> floatFeatures;
    @NotNull
    private final List<CategoricalFeature> categoricalFeatures;
    @NotNull
    private final FeatureMapper[] featuresOrder;
    @Nullable
    private final String version;
    @NotNull
    private static final String DEFAULT = "default";
    @NotNull
    private static final String USE_UNDEFINED = "use_undefined";

    public FeaturesInfo(@NotNull Set<String> knownFeatures, @NotNull List<BinaryFeature> binaryFeatures, @NotNull List<FloatFeature> floatFeatures, @NotNull List<CategoricalFeature> categoricalFeatures, @NotNull FeatureMapper[] featuresOrder, @Nullable String version) {
        Intrinsics.checkNotNullParameter(knownFeatures, (String)"knownFeatures");
        Intrinsics.checkNotNullParameter(binaryFeatures, (String)"binaryFeatures");
        Intrinsics.checkNotNullParameter(floatFeatures, (String)"floatFeatures");
        Intrinsics.checkNotNullParameter(categoricalFeatures, (String)"categoricalFeatures");
        Intrinsics.checkNotNullParameter((Object)featuresOrder, (String)"featuresOrder");
        this.knownFeatures = knownFeatures;
        this.binaryFeatures = binaryFeatures;
        this.floatFeatures = floatFeatures;
        this.categoricalFeatures = categoricalFeatures;
        this.featuresOrder = featuresOrder;
        this.version = version;
    }

    @Override
    @NotNull
    public Set<String> getKnownFeatures() {
        return this.knownFeatures;
    }

    @Override
    @NotNull
    public List<BinaryFeature> getBinaryFeatures() {
        return this.binaryFeatures;
    }

    @Override
    @NotNull
    public List<FloatFeature> getFloatFeatures() {
        return this.floatFeatures;
    }

    @Override
    @NotNull
    public List<CategoricalFeature> getCategoricalFeatures() {
        return this.categoricalFeatures;
    }

    @Override
    @NotNull
    public FeatureMapper[] getFeaturesOrder() {
        return this.featuresOrder;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b*\b\u0012\u0004\u0012\u00020\u00050\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012J\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ7\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u00122\u001e\u0010\u001b\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u001a0\t0\u001c\"\b\u0012\u0004\u0012\u00020\u001a0\t\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0012H\u0002J$\u0010 \u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012H\u0002JH\u0010\"\u001a.\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0#j\u0002`$\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0#j\u0002`$0#2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J3\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001c2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u00122\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/internal/ml/FeaturesInfo$Companion;", "", "<init>", "()V", "DEFAULT", "", "USE_UNDEFINED", "withSafeWeighers", "", "", "buildInfo", "Lcom/intellij/internal/ml/FeaturesInfo;", "reader", "Lcom/intellij/internal/ml/ModelMetadataReader;", "binary", "Lcom/intellij/internal/ml/BinaryFeature;", "name", "description", "", "Lkotlinx/serialization/json/JsonElement;", "float", "Lcom/intellij/internal/ml/FloatFeature;", "categorical", "Lcom/intellij/internal/ml/CategoricalFeature;", "categories", "buildFeaturesIndex", "Lcom/intellij/internal/ml/Feature;", "featureGroups", "", "([Ljava/util/List;)Ljava/util/Map;", "allowUndefined", "", "extractDefaultValue", "", "extractBinaryValuesMappings", "Lkotlin/Pair;", "Lcom/intellij/internal/ml/ValueMapping;", "buildMappers", "Lcom/intellij/internal/ml/FeatureMapper;", "features", "order", "(Ljava/util/Map;Ljava/util/List;)[Lcom/intellij/internal/ml/FeatureMapper;", "intellij.platform.ide.internal"})
    @SourceDebugExtension(value={"SMAP\nFeaturesInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeaturesInfo.kt\ncom/intellij/internal/ml/FeaturesInfo$Companion\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,134:1\n222#2:135\n222#2:136\n222#2:141\n222#2:146\n129#3:137\n158#3,3:138\n129#3:142\n158#3,3:143\n129#3:147\n158#3,3:148\n1#4:151\n1021#5,2:152\n37#6,2:154\n*S KotlinDebug\n*F\n+ 1 FeaturesInfo.kt\ncom/intellij/internal/ml/FeaturesInfo$Companion\n*L\n34#1:135\n36#1:136\n38#1:141\n40#1:146\n37#1:137\n37#1:138,3\n39#1:142\n39#1:143,3\n41#1:147\n41#1:148,3\n117#1:152,2\n131#1:154,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Set<String> withSafeWeighers(List<String> $this$withSafeWeighers) {
            Set result = CollectionsKt.toMutableSet((Iterable)$this$withSafeWeighers);
            result.add("prox_directoryType");
            result.add("kt_prox_directoryType");
            result.add("kotlin.unwantedElement");
            return result;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FeaturesInfo buildInfo(@NotNull ModelMetadataReader reader) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map this_$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map this_$iv2;
            Collection collection;
            Object object;
            Object item$iv$iv;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Map this_$iv3;
            void this_$iv4;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Json json = (Json)Json.Default;
            String string$iv = reader.allKnown();
            boolean $i$f$decodeFromString = false;
            this_$iv4.getSerializersModule();
            Set<String> knownFeatures = this.withSafeWeighers((List)this_$iv4.decodeFromString((DeserializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), string$iv));
            string$iv = (Json)Json.Default;
            String string$iv2 = reader.binaryFeatures();
            boolean $i$f$decodeFromString22 = false;
            this_$iv3.getSerializersModule();
            this_$iv3 = (Map)this_$iv3.decodeFromString((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, JsonElement.Companion.serializer())), string$iv2);
            boolean $i$f$map22 = false;
            void $i$f$decodeFromString22 = $this$map$iv3;
            Collection destination$iv$iv = new ArrayList($this$map$iv3.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv3.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                object = item$iv$iv = iterator2.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.binary((String)it.getKey(), (Map)it.getValue()));
            }
            List binaryFactors = (List)destination$iv$iv;
            Json $i$f$map22 = (Json)Json.Default;
            String string$iv3 = reader.floatFeatures();
            boolean $i$f$decodeFromString32 = false;
            this_$iv2.getSerializersModule();
            this_$iv2 = (Map)this_$iv2.decodeFromString((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, JsonElement.Companion.serializer())), string$iv3);
            boolean $i$f$map32 = false;
            void $i$f$decodeFromString32 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            item$iv$iv = $this$mapTo$iv$iv2.entrySet().iterator();
            while (item$iv$iv.hasNext()) {
                void it;
                Map.Entry item$iv$iv2;
                Map.Entry bl = item$iv$iv2 = (Map.Entry)item$iv$iv.next();
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(Companion.float((String)it.getKey(), (Map)it.getValue()));
            }
            List doubleFactors = (List)destination$iv$iv2;
            Json $i$f$map32 = (Json)Json.Default;
            String string$iv4 = reader.categoricalFeatures();
            boolean $i$f$decodeFromString42 = false;
            this_$iv.getSerializersModule();
            this_$iv = (Map)this_$iv.decodeFromString((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)), string$iv4);
            boolean $i$f$map = false;
            void $i$f$decodeFromString42 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo3 = false;
            object = $this$mapTo$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                void it;
                Map.Entry item$iv$iv3;
                Map.Entry bl2 = item$iv$iv3 = (Map.Entry)object.next();
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(Companion.categorical((String)it.getKey(), (List)it.getValue()));
            }
            List categoricalFactors = (List)destination$iv$iv3;
            List<String> order = reader.featureOrderDirect();
            List[] listArray = new List[]{binaryFactors, doubleFactors, categoricalFactors};
            Map<String, Feature> featuresIndex = this.buildFeaturesIndex(listArray);
            return new FeaturesInfo(knownFeatures, binaryFactors, doubleFactors, categoricalFactors, this.buildMappers(featuresIndex, order), reader.extractVersion());
        }

        @NotNull
        public final BinaryFeature binary(@NotNull String name, @NotNull Map<String, ? extends JsonElement> description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            Pair<Pair<String, Double>, Pair<String, Double>> pair = this.extractBinaryValuesMappings(description);
            Pair first = (Pair)pair.component1();
            Pair second = (Pair)pair.component2();
            double d = this.extractDefaultValue(name, description);
            return new BinaryFeature(name, (Pair<String, Double>)first, (Pair<String, Double>)second, d, this.allowUndefined(description));
        }

        @NotNull
        public final FloatFeature float(@NotNull String name, @NotNull Map<String, ? extends JsonElement> description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            double d = this.extractDefaultValue(name, description);
            return new FloatFeature(name, d, this.allowUndefined(description));
        }

        @NotNull
        public final CategoricalFeature categorical(@NotNull String name, @NotNull List<String> categories) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(categories, (String)"categories");
            return new CategoricalFeature(name, CollectionsKt.toSet((Iterable)categories));
        }

        @NotNull
        public final Map<String, Feature> buildFeaturesIndex(List<? extends Feature> ... featureGroups) {
            Intrinsics.checkNotNullParameter(featureGroups, (String)"featureGroups");
            Map index = new LinkedHashMap();
            for (List<? extends Feature> features : featureGroups) {
                com.intellij.internal.ml.FeaturesInfo$Companion.buildFeaturesIndex$addFeatures(index, features);
            }
            return index;
        }

        private final boolean allowUndefined(Map<String, ? extends Object> description) {
            Object value = description.get(FeaturesInfo.USE_UNDEFINED);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return true;
        }

        private final double extractDefaultValue(String name, Map<String, ? extends JsonElement> description) {
            JsonElement jsonElement = description.get(FeaturesInfo.DEFAULT);
            if (jsonElement == null) {
                throw new InconsistentMetadataException("Default value not found. Feature name: " + name);
            }
            JsonElement value = jsonElement;
            try {
                return JsonElementKt.getDouble((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InconsistentMetadataException("Default value must be double(name=" + name + ", value=" + value);
            }
        }

        private final Pair<Pair<String, Double>, Pair<String, Double>> extractBinaryValuesMappings(Map<String, ? extends JsonElement> description) {
            boolean bl;
            List result = new ArrayList();
            for (Map.Entry<String, ? extends JsonElement> entry : description.entrySet()) {
                double d;
                String name = entry.getKey();
                JsonElement value = entry.getValue();
                if (Intrinsics.areEqual((Object)name, (Object)FeaturesInfo.DEFAULT) || Intrinsics.areEqual((Object)name, (Object)FeaturesInfo.USE_UNDEFINED)) continue;
                try {
                    d = JsonElementKt.getDouble((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)value));
                }
                catch (IllegalArgumentException e) {
                    throw new InconsistentMetadataException("Mapped value for binary feature should be double (value=" + value + ")");
                }
                double mappedValue = d;
                result.add(TuplesKt.to((Object)name, (Object)mappedValue));
            }
            boolean bl2 = bl = result.size() == 2;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-FeaturesInfo$Companion$extractBinaryValuesMappings$22 = false;
                String $i$a$-assert-FeaturesInfo$Companion$extractBinaryValuesMappings$22 = "Binary feature must contains 2 values, but found " + result;
                throw new AssertionError((Object)$i$a$-assert-FeaturesInfo$Companion$extractBinaryValuesMappings$22);
            }
            List $this$sortBy$iv = result;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
                    }
                });
            }
            return new Pair(result.get(0), result.get(1));
        }

        @NotNull
        public final FeatureMapper[] buildMappers(@NotNull Map<String, ? extends Feature> features, @NotNull List<String> order) {
            Intrinsics.checkNotNullParameter(features, (String)"features");
            Intrinsics.checkNotNullParameter(order, (String)"order");
            List mappers = new ArrayList();
            for (String arrayFeatureName : order) {
                String string;
                String name = StringsKt.substringBefore$default((String)arrayFeatureName, (char)'=', null, (int)2, null);
                int it = StringsKt.indexOf$default((CharSequence)arrayFeatureName, (char)'=', (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                if (it == -1) {
                    string = null;
                } else {
                    String string2 = arrayFeatureName.substring(it + 1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                }
                String suffix = string;
                Object object = features.get(name);
                if (object == null || (object = ((Feature)object).createMapper(suffix)) == null) {
                    throw new InconsistentMetadataException("Unexpected feature name in array: " + arrayFeatureName);
                }
                Object mapper = object;
                mappers.add(mapper);
            }
            Collection $this$toTypedArray$iv = mappers;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new FeatureMapper[0]);
        }

        private static final <T extends Feature> Map<String, Feature> buildFeaturesIndex$addFeatures(Map<String, Feature> $this$buildFeaturesIndex_u24addFeatures, List<? extends T> features) {
            for (Feature feature : features) {
                if ($this$buildFeaturesIndex_u24addFeatures.keySet().contains(feature.getName())) {
                    throw new InconsistentMetadataException("Ambiguous feature description '" + feature.getName() + "': " + feature + " and " + $this$buildFeaturesIndex_u24addFeatures.get(feature.getName()));
                }
                $this$buildFeaturesIndex_u24addFeatures.put(feature.getName(), feature);
            }
            return $this$buildFeaturesIndex_u24addFeatures;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

