/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.performance;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/intellij/internal/performance/LatencyRecord;", "", "<init>", "()V", "totalLatency", "", "getTotalLatency", "()J", "setTotalLatency", "(J)V", "maxLatency", "", "getMaxLatency", "()I", "setMaxLatency", "(I)V", "samples", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "getSamples", "()Lit/unimi/dsi/fastutil/ints/IntArrayList;", "samplesSorted", "", "update", "", "latencyInMS", "averageLatency", "getAverageLatency", "percentile", "n", "intellij.platform.ide.internal"})
public final class LatencyRecord {
    private long totalLatency;
    private int maxLatency;
    @NotNull
    private final IntArrayList samples = new IntArrayList();
    private boolean samplesSorted;

    public final long getTotalLatency() {
        return this.totalLatency;
    }

    public final void setTotalLatency(long l) {
        this.totalLatency = l;
    }

    public final int getMaxLatency() {
        return this.maxLatency;
    }

    public final void setMaxLatency(int n) {
        this.maxLatency = n;
    }

    @NotNull
    public final IntArrayList getSamples() {
        return this.samples;
    }

    public final void update(int latencyInMS) {
        this.samplesSorted = false;
        this.samples.add(latencyInMS);
        this.totalLatency += (long)latencyInMS;
        if (latencyInMS > this.maxLatency) {
            this.maxLatency = latencyInMS;
        }
    }

    public final long getAverageLatency() {
        return this.totalLatency / (long)this.samples.size();
    }

    public final int percentile(int n) {
        if (!this.samplesSorted) {
            CollectionsKt.sort((List)((List)this.samples));
            this.samplesSorted = true;
        }
        int index = RangesKt.coerceAtMost((int)(this.samples.size() * n / 100), (int)(this.samples.size() - 1));
        return this.samples.getInt(index);
    }
}

