/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.ui;

import com.intellij.internal.ui.ModelPath;
import com.intellij.internal.ui.MyTreeNodeDomainModel;
import com.intellij.internal.ui.TreeViewModelDemoActionKt;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.TreeNodeDomainModel;
import com.intellij.ui.treeStructure.TreeNodeViewModel;
import com.intellij.ui.treeStructure.TreeViewModelVisitor;
import java.awt.Component;
import java.nio.file.Path;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/ui/PathVisitor;", "Lcom/intellij/ui/treeStructure/TreeViewModelVisitor;", "path", "", "logTextArea", "Lcom/intellij/ui/components/JBTextArea;", "<init>", "(Ljava/lang/String;Lcom/intellij/ui/components/JBTextArea;)V", "Lcom/intellij/internal/ui/ModelPath;", "visit", "Lcom/intellij/ui/tree/TreeVisitor$Action;", "node", "Lcom/intellij/ui/treeStructure/TreeNodeViewModel;", "(Lcom/intellij/ui/treeStructure/TreeNodeViewModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "log", "", "message", "intellij.platform.ide.internal"})
final class PathVisitor
implements TreeViewModelVisitor {
    @NotNull
    private final JBTextArea logTextArea;
    @NotNull
    private final ModelPath path;

    public PathVisitor(@NotNull String path, @NotNull JBTextArea logTextArea) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)logTextArea, (String)"logTextArea");
        this.logTextArea = logTextArea;
        Path path2 = TreeViewModelDemoActionKt.access$getROOT().resolve(path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this.path = new ModelPath(path2);
    }

    @Nullable
    public Object visit(@NotNull TreeNodeViewModel node, @NotNull Continuation<? super TreeVisitor.Action> $completion) {
        TreeVisitor.Action action2;
        TreeNodeDomainModel treeNodeDomainModel = node.getDomainModel();
        Intrinsics.checkNotNull((Object)treeNodeDomainModel, (String)"null cannot be cast to non-null type com.intellij.internal.ui.MyTreeNodeDomainModel");
        ModelPath nodePath = ((MyTreeNodeDomainModel)treeNodeDomainModel).getPath();
        if (Intrinsics.areEqual((Object)nodePath, (Object)this.path)) {
            this.log("found: " + nodePath);
            action2 = TreeVisitor.Action.INTERRUPT;
        } else if (this.path.startsWith(nodePath)) {
            this.log("visit: " + nodePath);
            action2 = TreeVisitor.Action.CONTINUE;
        } else {
            this.log("no match: " + nodePath);
            action2 = TreeVisitor.Action.SKIP_CHILDREN;
        }
        return action2;
    }

    private final void log(String message) {
        this.logTextArea.append(message + "\n");
        JScrollPane scrollPane = ComponentUtil.getScrollPane((Component)((Component)this.logTextArea));
        if (scrollPane != null) {
            scrollPane.getVerticalScrollBar().setValue(scrollPane.getVerticalScrollBar().getMaximum());
        }
    }
}

